/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.world.gen.structure.DarkTempleStructure;

public class DarkTempleGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (DarkTempleGenerator.canGenerate(world) && Configs.isEnabled(EnvironmentalAccumulatorConfig.class) && DarkTempleGenerator.appliesAt(world, chunkX, chunkZ)) {
            int x = chunkX * 16 + random.nextInt(16) + 8;
            int y = 0;
            int z = chunkZ * 16 + random.nextInt(16) + 8;
            if (DarkTempleGenerator.isTooClose(world, chunkX, chunkZ) || !DarkTempleStructure.getInstance().generate(world, random, new BlockPos(x, y, z))) {
                EvilCraft.darkTempleData.addFailedLocation(world.field_73011_w.getDimension(), chunkX, chunkZ);
            }
        }
    }

    private static boolean isTooClose(World world, int chunkX, int chunkZ) {
        return DarkTempleGenerator.getClosest(world, chunkX, chunkZ, GeneralConfig.darkTempleMinimumChunkDistance, false, true) != null;
    }

    public static boolean canGenerate(World world) {
        int id = world.field_73011_w.getDimension();
        for (int i = 0; i < GeneralConfig.darkTempleDimensions.length; ++i) {
            if (id != GeneralConfig.darkTempleDimensions[i]) continue;
            return true;
        }
        return false;
    }

    protected static boolean appliesAt(World world, int chunkX, int chunkZ) {
        if (world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)).func_150561_m() == Biome.TempCategory.OCEAN) {
            return false;
        }
        int frequency = GeneralConfig.darkTempleFrequency;
        return ((long)(chunkX * chunkZ + chunkX - chunkZ) + world.func_72905_C()) % (long)frequency == 0L;
    }

    public static boolean hasTemple(World world, int chunkX, int chunkZ) {
        return DarkTempleGenerator.appliesAt(world, chunkX, chunkZ) && !EvilCraft.darkTempleData.isFailed(world.field_73011_w.getDimension(), chunkX, chunkZ);
    }

    @Nullable
    public static Pair<Integer, Integer> getClosest(World world, int chunkX, int chunkZ, int radius, boolean includeOrigin, boolean skipNonGeneratedChunks) {
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int maxSteps = (int)Math.pow(radius, 2.0);
        for (int r = 0; r < maxSteps; ++r) {
            if (-r / 2 <= x && x <= r / 2 && -r / 2 <= z && z <= r / 2 && (includeOrigin || x != 0 || z != 0) && (!skipNonGeneratedChunks || ((ChunkProviderServer)world.func_72863_F()).func_73149_a(chunkX + x, chunkZ + z)) && DarkTempleGenerator.hasTemple(world, chunkX + x, chunkZ + z)) {
                return Pair.of((Object)(chunkX + x), (Object)(chunkZ + z));
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                int t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
        return null;
    }

    @Nullable
    public static Pair<Integer, Integer> getClosest(World world, int chunkX, int chunkZ) {
        return DarkTempleGenerator.getClosest(world, chunkX, chunkZ, Math.min(500, GeneralConfig.darkTempleFrequency), true, false);
    }

    @Nullable
    public static BlockPos getClosestForCoords(World world, int x, int z) {
        Pair<Integer, Integer> closest = DarkTempleGenerator.getClosest(world, x / 16, z / 16);
        if (closest == null) {
            return null;
        }
        return new BlockPos((Integer)closest.getLeft() * 16, 0, (Integer)closest.getRight() * 16);
    }
}

