/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.gui.CCubesGuiHandler;
import chanceCubes.commands.CCubesServerCommands;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.hookins.ModHookUtil;
import chanceCubes.items.CCubesItems;
import chanceCubes.network.CCubesPacketHandler;
import chanceCubes.proxy.CommonProxy;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.registry.GiantCubeRegistry;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.CCubesAchievements;
import chanceCubes.util.CCubesRecipies;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="chancecubes", version="1.10.2-3.1.1.221", name="Chance Cubes", guiFactory="chanceCubes.config.ConfigGuiFactory", dependencies="required-after:Forge@[12.18.2.2099,)", acceptedMinecraftVersions="[1.10.2]")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static final String VERSION = "1.10.2-3.1.1.221";
    public static final String NAME = "Chance Cubes";
    public static final String gameVersion = "1.10.2";
    @Mod.Instance(value="chancecubes")
    public static CCubesCore instance;
    @SidedProxy(clientSide="chanceCubes.proxy.ClientProxy", serverSide="chanceCubes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs modTab;
    public static Logger logger;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CCubesRecipies.loadRecipies();
        CCubesSounds.loadSounds();
        if (event.getSide() == Side.CLIENT) {
            CCubesItems.registerItems();
            CCubesBlocks.registerBlocksItems();
        }
        proxy.registerRenderings();
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigLoader.loadConfigSettings(event.getSuggestedConfigurationFile());
        CCubesBlocks.loadBlocks();
        CCubesItems.loadItems();
        CCubesPacketHandler.init();
        CCubesAchievements.loadAchievements();
        proxy.registerEvents();
        if (CCubesSettings.chestLoot) {
            // empty if block
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CCubesGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CCubesSettings.backupNRB.add(RewardsUtil.getBlockStateFromBlockMeta(Block.func_149684_b((String)"minecraft:bedrock"), 0));
        CCubesSettings.backupNRB.add(RewardsUtil.getBlockStateFromBlockMeta(Block.func_149684_b((String)"minecraft:obsidian"), 0));
        ChanceCubeRegistry.loadDefaultRewards();
        GiantCubeRegistry.loadDefaultRewards();
        CustomRewardsLoader.instance.loadCustomRewards();
        CustomRewardsLoader.instance.fetchRemoteInfo();
        NonreplaceableBlockOverride.loadOverrides();
        ConfigLoader.config.save();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        ModHookUtil.loadCustomModRewards();
        ConfigLoader.config.save();
        event.registerServerCommand((ICommand)new CCubesServerCommands());
    }

    @Mod.EventHandler
    public void onIMCMessage(FMLInterModComms.IMCEvent e) {
        Logger logger = LogManager.getLogger((String)MODID);
        for (FMLInterModComms.IMCMessage message : e.getMessages()) {
            if (!message.key.equalsIgnoreCase("add-nonreplaceable") || !message.isItemStackMessage()) continue;
            ItemStack stack = message.getItemStackValue();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block != null) {
                IBlockState state = RewardsUtil.getBlockStateFromBlockMeta(block, stack.func_77952_i());
                CCubesSettings.nonReplaceableBlocksIMC.add(state);
                logger.info(message.getSender() + " has added the blockstate of \"" + state.toString() + "\" that Chance Cubes rewards will no longer replace.");
                continue;
            }
            logger.error("Chance Cubes recieved an item stack via IMC from " + message.getSender() + " with an item that cannot be converted to a block. Item: " + stack.func_77973_b().func_77658_a());
        }
    }

    static {
        modTab = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)CCubesBlocks.CHANCE_CUBE);
            }
        };
    }
}

