/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.CCubesCore;
import chanceCubes.client.gui.CustomExtendedList;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.rewards.rewardparts.ChestChanceItem;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class ConfigGui
extends GuiScreen {
    private ConfigEditState editState;
    private boolean isCreatingNew = false;
    private boolean isDeleting = false;
    private GuiButton buttonNew;
    private GuiButton buttonSave;
    private GuiButton buttonCancel;
    private GuiButton buttonback;
    private String buttonNewText = "New File";
    private String deleteWarnText = "WARNING YOU ARE DELETING EVERYTHING YOU CLICK!!";
    private GuiTextField textFieldNew;
    private String[] prevStage = new String[4];
    private String drawString = "";
    private CustomExtendedList entries;
    private JsonParser json = new JsonParser();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private GuiScreen parentScreen;

    public ConfigGui(GuiScreen screen) {
        this.parentScreen = screen;
    }

    public void func_73866_w_() {
        this.editState = ConfigEditState.Files;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonback = new GuiButton(0, this.field_146294_l / 2 - 175, this.field_146295_m - 55, 98, 20, "Back");
        this.field_146292_n.add(this.buttonback);
        this.buttonNew = new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m - 25, 100, 20, this.buttonNewText);
        this.field_146292_n.add(this.buttonNew);
        this.buttonCancel = new GuiButton(2, this.field_146294_l / 2 - 50, this.field_146295_m - 55, 100, 20, "Cancel");
        this.field_146292_n.add(this.buttonCancel);
        this.buttonSave = new GuiButton(3, this.field_146294_l / 2 - 50, this.field_146295_m - 25, 100, 20, "Save");
        this.field_146292_n.add(this.buttonSave);
        this.buttonCancel.field_146125_m = false;
        this.textFieldNew = new GuiTextField(4, this.field_146297_k.field_71466_p, this.field_146294_l - 250, this.field_146295_m - 40, 200, 20);
        this.entries = new CustomExtendedList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        this.loadFiles();
    }

    public void func_146281_b() {
        CustomRewardsLoader.instance.loadCustomRewards();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.entries.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.isCreatingNew) {
            this.textFieldNew.func_146194_f();
        }
        if (this.isDeleting) {
            this.field_146297_k.field_71466_p.func_78276_b(this.deleteWarnText, this.field_146294_l / 2 - (int)((double)this.deleteWarnText.length() * 2.5), this.field_146295_m / 2, 0xFF0000);
        }
        this.field_146297_k.field_71466_p.func_78276_b(this.drawString, this.field_146294_l / 2 - (int)((double)this.drawString.length() * 2.5), 10, 0xFFFFFF);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.prevEditStage();
            } else if (button.field_146127_k == 1) {
                if (this.isCreatingNew) {
                    this.buttonNew.field_146126_j = this.buttonNewText;
                    File file = null;
                    JsonObject fileJson = new JsonObject();
                    switch (this.editState) {
                        case Files: {
                            String fileName = this.textFieldNew.func_146179_b();
                            if (!fileName.contains(".json")) {
                                fileName = fileName + ".json";
                            }
                            file = new File(CustomRewardsLoader.instance.getFolderFile().getAbsolutePath() + "/" + fileName);
                            try {
                                file.createNewFile();
                                break;
                            }
                            catch (IOException e) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to create the new file for a custom reward!");
                                e.printStackTrace();
                                return;
                            }
                        }
                        case All_Rewards: {
                            String rewardName = this.textFieldNew.func_146179_b();
                            file = new File(CustomRewardsLoader.instance.getFolderFile().getAbsolutePath() + "/" + this.prevStage[0]);
                            if (!file.exists()) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to find the file to edit a reward");
                                return;
                            }
                            fileJson = this.json.parse(this.loadFileContents(file));
                            JsonObject newRewardJson = new JsonObject();
                            newRewardJson.addProperty("Chance", (Number)0);
                            fileJson.getAsJsonObject().add(rewardName, (JsonElement)newRewardJson);
                            break;
                        }
                        case Single_Reward: {
                            String rewardType = this.textFieldNew.func_146179_b();
                            file = new File(CustomRewardsLoader.instance.getFolderFile().getAbsolutePath() + "/" + this.prevStage[0]);
                            if (!file.exists()) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to find the file to edit a reward");
                                return;
                            }
                            fileJson = this.json.parse(this.loadFileContents(file));
                            JsonElement rewardJson = fileJson.getAsJsonObject().get(this.prevStage[1]);
                            if (rewardJson == null) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to find the reward with the given name of " + this.prevStage[1]);
                                return;
                            }
                            JsonArray rewardTypeArray = new JsonArray();
                            rewardJson.getAsJsonObject().add(rewardType, (JsonElement)rewardTypeArray);
                            break;
                        }
                        case Reward_Type: {
                            String defaultValue = this.textFieldNew.func_146179_b();
                            file = new File(CustomRewardsLoader.instance.getFolderFile().getAbsolutePath() + "/" + this.prevStage[0]);
                            if (!file.exists()) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to find the file to edit a reward");
                                return;
                            }
                            fileJson = this.json.parse(this.loadFileContents(file));
                            JsonElement rewardJson = fileJson.getAsJsonObject().get(this.prevStage[1]);
                            if (rewardJson == null) {
                                CCubesCore.logger.log(Level.ERROR, "Failed to find the reward with the given name of " + this.prevStage[1]);
                                return;
                            }
                            JsonArray rewardTypeArray = rewardJson.getAsJsonObject().get(this.prevStage[2]).getAsJsonArray();
                            JsonObject rewardInstance = new JsonObject();
                            rewardInstance.addProperty(this.prevStage[2].toLowerCase(), defaultValue);
                            rewardTypeArray.add((JsonElement)rewardInstance);
                            break;
                        }
                    }
                    try {
                        FileOutputStream outputStream = new FileOutputStream(file);
                        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                        writer.append(this.gson.toJson((JsonElement)fileJson));
                        writer.close();
                        outputStream.close();
                    }
                    catch (IOException e) {
                        CCubesCore.logger.log(Level.ERROR, "Failed to create the new file for a custom reward!");
                        e.printStackTrace();
                        return;
                    }
                    this.textFieldNew.func_146180_a("");
                    this.buttonCancel.field_146125_m = false;
                    this.buttonback.field_146124_l = true;
                    this.reloadStage();
                } else {
                    this.buttonNew.field_146126_j = "Create";
                    this.buttonCancel.field_146125_m = true;
                    this.buttonback.field_146124_l = false;
                }
                this.isCreatingNew = !this.isCreatingNew;
            } else if (button.field_146127_k == 2) {
                if (this.isCreatingNew) {
                    this.isCreatingNew = false;
                    this.buttonNew.field_146126_j = this.buttonNewText;
                    this.buttonCancel.field_146125_m = false;
                    this.buttonback.field_146124_l = true;
                } else if (this.isDeleting) {
                    this.isDeleting = false;
                    this.buttonCancel.field_146125_m = false;
                    this.buttonback.field_146124_l = true;
                    this.buttonNew.field_146124_l = true;
                }
            } else if (button.field_146127_k == 3) {
                File file = null;
                JsonObject fileJson = new JsonObject();
                file = new File(CustomRewardsLoader.instance.getFolderFile().getAbsolutePath() + "/" + this.prevStage[0]);
                if (!file.exists()) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to find the file to edit a reward");
                    return;
                }
                fileJson = this.json.parse(this.loadFileContents(file));
                JsonElement rewardJson = fileJson.getAsJsonObject().get(this.prevStage[1]);
                if (rewardJson == null) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to find the reward with the given name of " + this.prevStage[1]);
                    return;
                }
                if (this.entries.func_148180_b(0) instanceof CustomExtendedList.CustomTextEntry && ((CustomExtendedList.CustomTextEntry)this.entries.func_148180_b(0)).getLabel().equalsIgnoreCase("Chance:")) {
                    CustomExtendedList.CustomTextEntry textBox = (CustomExtendedList.CustomTextEntry)this.entries.func_148180_b(0);
                    try {
                        int chance = Integer.parseInt(textBox.getTextBox().func_146179_b());
                        if (chance < -100) {
                            chance = -100;
                        } else if (chance > 100) {
                            chance = 100;
                        }
                        rewardJson.getAsJsonObject().addProperty("Chance", (Number)chance);
                    }
                    catch (NumberFormatException e) {
                        CCubesCore.logger.log(Level.ERROR, "Failed to cast the chance value of the reward to an integer");
                        return;
                    }
                    try {
                        FileOutputStream outputStream = new FileOutputStream(file);
                        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                        writer.append(this.gson.toJson((JsonElement)fileJson));
                        writer.close();
                        outputStream.close();
                    }
                    catch (IOException e) {
                        CCubesCore.logger.log(Level.ERROR, "Failed to create the new file for a custom reward!");
                        e.printStackTrace();
                        return;
                    }
                }
                this.saveRewardPart(file, (JsonElement)fileJson, rewardJson);
                this.textFieldNew.func_146180_a("");
                this.buttonCancel.field_146125_m = false;
                this.buttonback.field_146124_l = true;
                this.reloadStage();
            } else if (button.field_146127_k == 4) {
                this.isDeleting = true;
                this.buttonCancel.field_146125_m = true;
                this.buttonback.field_146124_l = false;
                this.buttonNew.field_146124_l = false;
            }
        }
    }

    protected void func_73864_a(int x, int y, int mouseEvent) throws IOException {
        this.textFieldNew.func_146192_a(x, y, mouseEvent);
        this.entries.func_148179_a(x, y, mouseEvent);
        super.func_73864_a(x, y, mouseEvent);
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.textFieldNew.func_146201_a(p_73869_1_, p_73869_2_)) {
            this.entries.keyTyped(p_73869_1_, p_73869_2_);
        }
    }

    public void nextEditStage(int id, String name) {
        switch (this.editState) {
            case Files: {
                this.editState = ConfigEditState.All_Rewards;
                this.loadFileRewards(name);
                this.prevStage[0] = name;
                break;
            }
            case All_Rewards: {
                this.editState = ConfigEditState.Single_Reward;
                this.loadSingleReward(name);
                this.prevStage[1] = name;
                break;
            }
            case Single_Reward: {
                this.editState = ConfigEditState.Reward_Type;
                this.loadRewardType(name);
                this.prevStage[2] = name;
                break;
            }
            case Reward_Type: {
                this.editState = ConfigEditState.Edit_Reward_Type;
                this.loadSpecificRewardType(name, this.prevStage[2]);
                this.prevStage[3] = id + ":" + name;
                break;
            }
        }
    }

    public void prevEditStage() {
        switch (this.editState) {
            case Files: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                break;
            }
            case All_Rewards: {
                this.editState = ConfigEditState.Files;
                this.loadFiles();
                break;
            }
            case Single_Reward: {
                this.editState = ConfigEditState.All_Rewards;
                this.loadFileRewards(this.prevStage[0]);
                break;
            }
            case Reward_Type: {
                this.editState = ConfigEditState.Single_Reward;
                this.loadSingleReward(this.prevStage[1]);
                break;
            }
            case Edit_Reward_Type: {
                this.editState = ConfigEditState.Reward_Type;
                this.loadRewardType(this.prevStage[2]);
            }
        }
    }

    public void reloadStage() {
        switch (this.editState) {
            case Files: {
                this.loadFiles();
                break;
            }
            case All_Rewards: {
                this.loadFileRewards(this.prevStage[0]);
                break;
            }
            case Single_Reward: {
                this.loadSingleReward(this.prevStage[1]);
                break;
            }
            case Reward_Type: {
                this.loadRewardType(this.prevStage[2]);
                break;
            }
            case Edit_Reward_Type: {
                this.loadSpecificRewardType(this.prevStage[3].substring(this.prevStage[3].indexOf(":") + 1), this.prevStage[2]);
            }
        }
    }

    public void loadFiles() {
        this.buttonSave.field_146125_m = false;
        this.buttonNew.field_146125_m = true;
        this.entries.clearElements();
        this.buttonNew.field_146126_j = "New File";
        this.buttonNewText = "New File";
        this.drawString = "Select the file that you would like to load";
        for (String s : CustomRewardsLoader.instance.getRewardsFiles()) {
            this.entries.addButton(s);
        }
    }

    public void loadFileRewards(String file) {
        this.buttonSave.field_146125_m = false;
        this.buttonNew.field_146125_m = true;
        this.buttonNew.field_146126_j = "New Reward";
        this.buttonNewText = "New Reward";
        this.drawString = "Select the reward that you would like to edit";
        this.entries.clearElements();
        for (String s : CustomRewardsLoader.instance.getRewardsFromFile(file)) {
            this.entries.addButton(s);
        }
    }

    public void loadSingleReward(String reward) {
        this.buttonSave.field_146125_m = false;
        this.buttonNew.field_146125_m = true;
        this.buttonNew.field_146126_j = "New Part";
        this.buttonNewText = "New Part";
        this.drawString = "Select the reward type that you would like to edit";
        this.entries.clearElements();
        for (String s : CustomRewardsLoader.instance.getReward(this.prevStage[0], reward)) {
            this.entries.addButton(s);
        }
    }

    public void loadRewardType(String type) {
        this.buttonSave.field_146125_m = false;
        this.buttonNew.field_146125_m = true;
        this.buttonNew.field_146126_j = "New " + type;
        this.buttonNewText = "New " + type;
        this.drawString = "Select the specific reward part that you would like to edit";
        this.entries.clearElements();
        if (type.equalsIgnoreCase("Chance")) {
            this.buttonSave.field_146125_m = true;
            this.buttonNew.field_146125_m = false;
            this.entries.addTextEntry("Chance", CustomRewardsLoader.instance.getRewardType(this.prevStage[0], this.prevStage[1], type).get(0));
        } else {
            for (String s : CustomRewardsLoader.instance.getRewardType(this.prevStage[0], this.prevStage[1], type)) {
                this.entries.addButton(s);
            }
        }
    }

    public void loadSpecificRewardType(String rawJson, String type) {
        JsonObject convertedJson;
        this.buttonSave.field_146125_m = true;
        this.buttonNew.field_146125_m = false;
        this.drawString = "Edit your reward parts";
        this.entries.clearElements();
        try {
            convertedJson = this.json.parse(rawJson).getAsJsonObject();
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file ");
            return;
        }
        if (type.equalsIgnoreCase("Item")) {
            this.loadRewardPart(convertedJson, ItemPart.elements);
        } else if (type.equalsIgnoreCase("Block")) {
            this.loadRewardPart(convertedJson, OffsetBlock.elements);
        } else if (type.equalsIgnoreCase("Message")) {
            this.loadRewardPart(convertedJson, MessagePart.elements);
        } else if (type.equalsIgnoreCase("Command")) {
            this.loadRewardPart(convertedJson, CommandPart.elements);
        } else if (type.equalsIgnoreCase("Entity")) {
            this.loadRewardPart(convertedJson, EntityPart.elements);
        } else if (type.equalsIgnoreCase("Experience")) {
            this.loadRewardPart(convertedJson, ExpirencePart.elements);
        } else if (type.equalsIgnoreCase("Potion")) {
            this.loadRewardPart(convertedJson, PotionPart.elements);
        } else if (type.equalsIgnoreCase("Schematic")) {
            this.loadRewardPart(convertedJson, new String[]{"fileName:S", "delay:I"});
        } else if (type.equalsIgnoreCase("Sound")) {
            this.loadRewardPart(convertedJson, SoundPart.elements);
        } else if (type.equalsIgnoreCase("Chest")) {
            this.loadRewardPart(convertedJson, ChestChanceItem.elements);
        } else if (type.equalsIgnoreCase("Particle")) {
            this.loadRewardPart(convertedJson, ParticlePart.elements);
        }
    }

    public void loadRewardPart(JsonObject convertedJson, String[] parts) {
        for (String s : parts) {
            s = s.substring(0, s.length() - 2);
            String value = "";
            if (convertedJson.has(s)) {
                value = convertedJson.get(s).getAsString();
            }
            this.entries.addTextEntry(s, value);
        }
    }

    public void saveRewardPart(File file, JsonElement fileJson, JsonElement rewardJson) {
        JsonArray rewardTypeArray = rewardJson.getAsJsonObject().get(this.prevStage[2]).getAsJsonArray();
        JsonObject rewardInstance = rewardTypeArray.get(Integer.parseInt(this.prevStage[3].substring(0, this.prevStage[3].indexOf(":")))).getAsJsonObject();
        String[] rewardElements = this.getsElementsFromReward(this.prevStage[2]);
        for (int i = 0; i < this.entries.func_148127_b(); ++i) {
            GuiListExtended.IGuiListEntry entry = this.entries.func_148180_b(i);
            if (!(entry instanceof CustomExtendedList.CustomTextEntry)) continue;
            CustomExtendedList.CustomTextEntry textBox = (CustomExtendedList.CustomTextEntry)entry;
            try {
                for (String s : rewardElements) {
                    String s1 = s.substring(0, s.length() - 2);
                    String s2 = s.substring(s.length() - 1);
                    String label = textBox.getLabel().substring(0, textBox.getLabel().length() - 1);
                    String value = textBox.getTextBox().func_146179_b();
                    if (value.equalsIgnoreCase("") || !s1.equalsIgnoreCase(label)) continue;
                    if (s2.equalsIgnoreCase("I")) {
                        rewardInstance.addProperty(label, (Number)Integer.parseInt(value));
                    }
                    if (s2.equalsIgnoreCase("S")) {
                        rewardInstance.addProperty(label, value);
                    }
                    if (s2.equalsIgnoreCase("B")) {
                        rewardInstance.addProperty(label, Boolean.valueOf(Boolean.parseBoolean(value)));
                    }
                    if (!s2.equalsIgnoreCase("F")) continue;
                    rewardInstance.addProperty(label, (Number)Float.valueOf(Float.parseFloat(value)));
                }
                continue;
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "An error has occured while saving this reward! Please make sure all fields are correctly filled!");
            }
        }
        this.prevStage[3] = this.prevStage[3].substring(0, this.prevStage[3].indexOf(":") + 1) + rewardInstance.toString();
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            writer.append(this.gson.toJson(fileJson));
            writer.close();
            outputStream.close();
        }
        catch (IOException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to create the new file for a custom reward!");
            e.printStackTrace();
            return;
        }
    }

    public String[] getsElementsFromReward(String reward) {
        if (reward.equalsIgnoreCase("Item")) {
            return ItemPart.elements;
        }
        if (reward.equalsIgnoreCase("Block")) {
            return OffsetBlock.elements;
        }
        if (reward.equalsIgnoreCase("Message")) {
            return MessagePart.elements;
        }
        if (reward.equalsIgnoreCase("Command")) {
            return CommandPart.elements;
        }
        if (reward.equalsIgnoreCase("Entity")) {
            return EntityPart.elements;
        }
        if (reward.equalsIgnoreCase("Experience")) {
            return ExpirencePart.elements;
        }
        if (reward.equalsIgnoreCase("Potion")) {
            return PotionPart.elements;
        }
        if (reward.equalsIgnoreCase("Schematic")) {
            return new String[]{"fileName:S", "delay:I", "xOffSet:I", "yOffSet:I", "zOffSet:I", "falling:B", "relativeToPlayer:B", "includeAirBlocks:B", "spacingDelay:F"};
        }
        if (reward.equalsIgnoreCase("Sound")) {
            return SoundPart.elements;
        }
        if (reward.equalsIgnoreCase("Chest")) {
            return ChestChanceItem.elements;
        }
        return new String[0];
    }

    public String loadFileContents(File file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String result = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                result = result + line;
            }
            reader.close();
            return result;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static enum ConfigEditState {
        Files(0),
        All_Rewards(1),
        Single_Reward(2),
        Reward_Type(3),
        Edit_Reward_Type(4);

        private int posNum;

        private ConfigEditState(int pos) {
            this.posNum = pos;
        }

        public int getPosition() {
            return this.posNum;
        }
    }
}

