/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.client.gui.SchematicCreationGui;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.hookins.ModHookUtil;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.registry.GiantCubeRegistry;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.SchematicUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CCubesServerCommands
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();
    private List<String> tab;

    public CCubesServerCommands() {
        this.aliases.add("Chancecubes");
        this.aliases.add("chancecubes");
        this.aliases.add("ChanceCube");
        this.aliases.add("Chancecube");
        this.aliases.add("chancecube");
        this.aliases.add("CCubes");
        this.tab = new ArrayList<String>();
        this.tab.add("reload");
        this.tab.add("version");
        this.tab.add("handNBT");
        this.tab.add("handID");
        this.tab.add("disableReward");
        this.tab.add("enableReward");
        this.tab.add("schematic");
        this.tab.add("rewardsInfo");
        this.tab.add("testRewards");
        this.tab.add("testCustomRewards");
    }

    public String func_71517_b() {
        return "ChanceCubes";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/ChanceCubes <reload/version/handNBT/enableReward/disableReward>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reloading..."));
            ChanceCubeRegistry.INSTANCE.ClearRewards();
            GiantCubeRegistry.INSTANCE.ClearRewards();
            ChanceCubeRegistry.loadDefaultRewards();
            GiantCubeRegistry.loadDefaultRewards();
            CustomRewardsLoader.instance.loadCustomRewards();
            NonreplaceableBlockOverride.loadOverrides();
            CustomRewardsLoader.instance.fetchRemoteInfo();
            ChanceCubeRegistry.loadCustomUserRewards(server);
            ModHookUtil.loadCustomModRewards();
            sender.func_145747_a((ITextComponent)new TextComponentString("Chance Cubes Reloaded"));
        } else if (args.length > 0 && args[0].equalsIgnoreCase("version")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Chance Cubes Version 1.10.2-3.1.1.221"));
        } else if (args[0].equalsIgnoreCase("handNBT")) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                if (player.field_71071_by.func_70448_g() != null) {
                    NBTTagCompound nbt = player.field_71071_by.func_70448_g().func_77978_p();
                    if (nbt != null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(nbt.toString()));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("This item has no tag nbt data"));
                    }
                }
            }
        } else if (args[0].equalsIgnoreCase("handID")) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack != null) {
                    ResourceLocation res = stack.func_77973_b().getRegistryName();
                    sender.func_145747_a((ITextComponent)new TextComponentString(res.func_110624_b() + ":" + res.func_110623_a()));
                    sender.func_145747_a((ITextComponent)new TextComponentString("meta: " + stack.func_77952_i()));
                }
            }
        } else if (args[0].equalsIgnoreCase("disableReward")) {
            if (args.length > 1) {
                if (ChanceCubeRegistry.INSTANCE.unregisterReward(args[1])) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " Has been temporarily disabled."));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is either not currently enabled or is not a valid reward name."));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Try /chancecubes enableReward <Reward Name>"));
            }
        } else if (args[0].equalsIgnoreCase("enableReward")) {
            if (args.length > 1) {
                if (ChanceCubeRegistry.INSTANCE.enableReward(args[1])) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " Has been enabled."));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is either not currently disabled or is not a valid reward name."));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Try /chancecubes disableReward <Reward Name>"));
            }
        } else if (args[0].equalsIgnoreCase("schematic") && args.length == 2) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    if (player.field_71075_bZ.field_75098_d) {
                        if (args[1].equalsIgnoreCase("create")) {
                            if (RenderEvent.isCreatingSchematic()) {
                                if (SchematicUtil.selectionPoints[0] != null && SchematicUtil.selectionPoints[1] != null) {
                                    FMLCommonHandler.instance().showGuiScreen((Object)new SchematicCreationGui(player));
                                } else {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Please set both points before moving on!"));
                                }
                            } else {
                                RenderEvent.setCreatingSchematic(true);
                            }
                        } else if (args[1].equalsIgnoreCase("cancel")) {
                            RenderEvent.setCreatingSchematic(false);
                            SchematicUtil.selectionPoints[0] = null;
                            SchematicUtil.selectionPoints[1] = null;
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Sorry, you need to be in creative to use this command"));
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Sorry, but this command only works in single player"));
            }
        } else if (args[0].equalsIgnoreCase("rewardsInfo")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("There are currently " + ChanceCubeRegistry.INSTANCE.getNumberOfLoadedRewards() + " rewards loaded and " + ChanceCubeRegistry.INSTANCE.getNumberOfDisabledRewards() + " rewards disabled"));
        } else if (args[0].equalsIgnoreCase("testRewards")) {
            CCubesSettings.testRewards = !CCubesSettings.testRewards;
            CCubesSettings.testingRewardIndex = 0;
            if (CCubesSettings.testRewards) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now enabled for all rewards!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now disabled and normal randomness is back."));
            }
        } else if (args[0].equalsIgnoreCase("testCustomRewards")) {
            CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
            CCubesSettings.testingRewardIndex = 0;
            if (CCubesSettings.testCustomRewards) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now enabled for custom rewards!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reward testing is now disabled and normal randomness is back."));
            }
        } else if (!args[0].equalsIgnoreCase("test")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments for the Chance Cubes command"));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 0) {
            return this.tab;
        }
        return null;
    }
}

