/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BlockChanceCube;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.CustomSoundsLoader;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.registry.GiantCubeRegistry;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.rewardparts.ChestChanceItem;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.type.BlockRewardType;
import chanceCubes.rewards.type.ChestRewardType;
import chanceCubes.rewards.type.CommandRewardType;
import chanceCubes.rewards.type.EntityRewardType;
import chanceCubes.rewards.type.ExperienceRewardType;
import chanceCubes.rewards.type.IRewardType;
import chanceCubes.rewards.type.ItemRewardType;
import chanceCubes.rewards.type.MessageRewardType;
import chanceCubes.rewards.type.ParticleEffectRewardType;
import chanceCubes.rewards.type.PotionRewardType;
import chanceCubes.rewards.type.SchematicRewardType;
import chanceCubes.rewards.type.SoundRewardType;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.FileUtil;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class CustomRewardsLoader {
    public static CustomRewardsLoader instance;
    private File folder;
    private static JsonParser json;
    private boolean reSaveCurrentJson = false;

    public CustomRewardsLoader(File folder) {
        instance = this;
        this.folder = folder;
        json = new JsonParser();
        CustomSoundsLoader customSounds = new CustomSoundsLoader(folder, new File(folder.getAbsolutePath() + "/CustomSounds-Resourcepack"), "Chance Cubes Resource Pack");
        customSounds.addCustomSounds();
        customSounds.assemble();
    }

    public void loadCustomRewards() {
        for (File f : this.folder.listFiles()) {
            JsonElement fileJson;
            if (!f.isFile() || !f.getName().contains(".json") || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            try {
                CCubesCore.logger.log(Level.INFO, "Loading custom rewards file " + f.getName());
                fileJson = json.parse((Reader)new FileReader(f));
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + f.getName() + ". Skipping file loading.");
                CCubesCore.logger.log(Level.ERROR, "Parse Error: " + e.getMessage());
                continue;
            }
            for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
                CustomEntry<BasicReward, Boolean> parsedReward = this.parseReward(reward);
                BasicReward basicReward = parsedReward.getKey();
                if (basicReward == null) {
                    CCubesCore.logger.log(Level.ERROR, "Seems your reward is setup incorrectly, or is disabled for this version of minecraft with a depedency, and Chance Cubes was not able to parse the reward " + (String)reward.getKey() + " for the file " + f.getName());
                    continue;
                }
                if (parsedReward.getValue().booleanValue()) {
                    GiantCubeRegistry.INSTANCE.registerReward(basicReward);
                } else {
                    ChanceCubeRegistry.INSTANCE.registerReward(basicReward);
                }
                ChanceCubeRegistry.INSTANCE.addCustomReward(basicReward);
                if (!this.reSaveCurrentJson) continue;
                FileUtil.writeJsonToFile(f, fileJson);
            }
            CCubesCore.logger.log(Level.INFO, "Loaded custom rewards file " + f.getName());
        }
    }

    public void fetchRemoteInfo() {
        try {
            String today = new SimpleDateFormat("MM/dd").format(new Date());
            JsonObject json = HTTPUtil.getWebFile("POST", "https://api.theprogrammingturkey.com/chance_cubes/ChanceCubesAPI.php", new CustomEntry<String, String>("version", "1.10.2-3.1.1.221"), new CustomEntry<String, String>("date", today)).getAsJsonObject();
            this.loadDisabledRewards(json.get("Disabled Rewards").getAsJsonArray());
            this.loadHolidayRewards(json.get("Holiday Rewards"));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to fetch remote information for the mod!");
            e.printStackTrace();
            return;
        }
    }

    private void loadHolidayRewards(JsonElement json) {
        if (!CCubesSettings.holidayRewards || !json.isJsonObject()) {
            return;
        }
        JsonObject holidays = json.getAsJsonObject();
        if (holidays.has("Texture") && !(holidays.get("Texture") instanceof JsonNull)) {
            CCubesSettings.hasHolidayTexture = true;
            CCubesSettings.holidayTextureName = holidays.get("Texture").getAsString();
        } else {
            CCubesSettings.hasHolidayTexture = false;
            CCubesSettings.holidayTextureName = "default";
        }
        for (BlockChanceCube.EnumTexture t : BlockChanceCube.EnumTexture.values()) {
            if (!t.func_176610_l().equalsIgnoreCase(CCubesSettings.holidayTextureName)) continue;
            BlockChanceCube.textureToSet = t;
        }
        if (!CCubesSettings.holidayRewardTriggered && holidays.has("Holiday") && !(holidays.get("Holiday") instanceof JsonNull) && holidays.has("Reward") && !(holidays.get("Reward") instanceof JsonNull)) {
            String holidayName = holidays.get("Holiday").getAsString();
            BasicReward basicReward = this.parseReward(new CustomEntry<String, JsonElement>(holidayName, holidays.get("Reward"))).getKey();
            if (basicReward != null) {
                CCubesSettings.doesHolidayRewardTrigger = true;
                CCubesSettings.holidayReward = basicReward;
                CCubesCore.logger.log(Level.ERROR, "Custom holiday reward \"" + holidayName + "\" loaded!");
            } else {
                CCubesCore.logger.log(Level.ERROR, "Failed to load the Custom holiday reward \"" + holidayName + "\"!");
            }
        }
    }

    private void loadDisabledRewards(JsonArray disabledRewards) {
        if (CCubesSettings.disabledRewards) {
            for (JsonElement reward : disabledRewards) {
                boolean removed = ChanceCubeRegistry.INSTANCE.unregisterReward(reward.getAsString());
                if (!removed) {
                    removed = GiantCubeRegistry.INSTANCE.unregisterReward(reward.getAsString());
                }
                CCubesCore.logger.log(Level.WARN, "The reward " + reward.getAsString() + " has been disabled by the mod author due to a bug or some other reason.");
            }
        }
    }

    public CustomEntry<BasicReward, Boolean> parseReward(Map.Entry<String, JsonElement> reward) {
        ArrayList<IRewardType> rewards = new ArrayList<IRewardType>();
        JsonObject rewardElements = reward.getValue().getAsJsonObject();
        int chance = 0;
        boolean isGiantCubeReward = false;
        for (Map.Entry rewardElement : rewardElements.entrySet()) {
            if (((String)rewardElement.getKey()).equalsIgnoreCase("chance")) {
                chance = ((JsonElement)rewardElement.getValue()).getAsInt();
                continue;
            }
            if (((String)rewardElement.getKey()).equalsIgnoreCase("dependencies")) {
                boolean gameversion = false;
                boolean mcversionused = false;
                for (Map.Entry dependencies : ((JsonElement)rewardElement.getValue()).getAsJsonObject().entrySet()) {
                    String[] versionsToCheck;
                    if (((String)dependencies.getKey()).equalsIgnoreCase("mod")) {
                        if (Loader.isModLoaded((String)((JsonElement)dependencies.getValue()).getAsString())) continue;
                        return new CustomEntry<Object, Boolean>(null, false);
                    }
                    if (!((String)dependencies.getKey()).equalsIgnoreCase("mcVersion")) continue;
                    mcversionused = true;
                    for (String toCheckV : versionsToCheck = ((JsonElement)dependencies.getValue()).getAsString().split(",")) {
                        String currentMCV = "1.10.2";
                        if (toCheckV.contains("*")) {
                            currentMCV = currentMCV.substring(0, currentMCV.lastIndexOf("."));
                            toCheckV = toCheckV.substring(0, toCheckV.lastIndexOf("."));
                        }
                        if (!currentMCV.equalsIgnoreCase(toCheckV)) continue;
                        gameversion = true;
                    }
                }
                if (gameversion || !mcversionused) continue;
                return new CustomEntry<Object, Boolean>(null, false);
            }
            if (((String)rewardElement.getKey()).equalsIgnoreCase("isGiantCubeReward")) {
                isGiantCubeReward = ((JsonElement)rewardElement.getValue()).getAsBoolean();
            }
            try {
                JsonArray rewardTypes = ((JsonElement)rewardElement.getValue()).getAsJsonArray();
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Item")) {
                    this.loadItemReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Block")) {
                    this.loadBlockReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Message")) {
                    this.loadMessageReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Command")) {
                    this.loadCommandReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Entity")) {
                    this.loadEntityReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Experience")) {
                    this.loadExperienceReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Potion")) {
                    this.loadPotionReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Schematic")) {
                    this.loadSchematicReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Sound")) {
                    this.loadSoundReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Chest")) {
                    this.loadChestReward(rewardTypes, rewards);
                    continue;
                }
                if (!((String)rewardElement.getKey()).equalsIgnoreCase("Particle")) continue;
                this.loadParticleReward(rewardTypes, rewards);
            }
            catch (Exception ex) {
                CCubesCore.logger.log(Level.ERROR, "Failed to load a custom reward for some reason. I will try better next time.");
                ex.printStackTrace();
            }
        }
        return new CustomEntry<BasicReward, Boolean>(new BasicReward(reward.getKey(), chance, rewards.toArray(new IRewardType[rewards.size()])), isGiantCubeReward);
    }

    public List<IRewardType> loadItemReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ItemPart> items = new ArrayList<ItemPart>();
        for (JsonElement fullelement : rawReward) {
            ItemPart stack;
            JsonObject element = fullelement.getAsJsonObject().get("item").getAsJsonObject();
            try {
                String jsonEdited = this.removedKeyQuotes(element.toString());
                NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)jsonEdited);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to convert the JSON to NBT for: " + element.toString());
                    continue;
                }
                ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbtbase);
                if (itemstack == null) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to create an itemstack from the JSON of: " + jsonEdited + " and the NBT of: " + nbtbase.toString());
                    continue;
                }
                stack = new ItemPart(itemstack);
            }
            catch (NBTException e1) {
                CCubesCore.logger.log(Level.ERROR, e1.getMessage());
                continue;
            }
            if (fullelement.getAsJsonObject().has("delay")) {
                stack.setDelay(fullelement.getAsJsonObject().get("delay").getAsInt());
            }
            items.add(stack);
        }
        rewards.add(new ItemRewardType(items.toArray(new ItemPart[items.size()])));
        return rewards;
    }

    public List<IRewardType> loadBlockReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (JsonElement element : rawReward) {
            for (String s : new String[]{"XOffSet", "YOffSet", "ZOffSet", "RelativeToPlayer", "Block", "Falling"}) {
                if (!element.getAsJsonObject().has(s)) continue;
                this.reSaveCurrentJson = true;
                element.getAsJsonObject().add(s.substring(0, 1).toLowerCase() + s.substring(1), element.getAsJsonObject().get(s));
                element.getAsJsonObject().remove(s);
            }
            int x = element.getAsJsonObject().get("xOffSet").getAsInt();
            int y = element.getAsJsonObject().get("yOffSet").getAsInt();
            int z = element.getAsJsonObject().get("zOffSet").getAsInt();
            String[] blockDataParts = element.getAsJsonObject().get("block").getAsString().split(":");
            String mod = blockDataParts[0];
            String blockName = blockDataParts[1];
            Block block = RewardsUtil.getBlock(mod, blockName);
            boolean falling = element.getAsJsonObject().get("falling").getAsBoolean();
            OffsetBlock offBlock = new OffsetBlock(x, y, z, block, falling);
            if (element.getAsJsonObject().has("delay")) {
                offBlock.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("relativeToPlayer")) {
                offBlock.setRelativeToPlayer(element.getAsJsonObject().get("relativeToPlayer").getAsBoolean());
            }
            if (element.getAsJsonObject().has("removeUnbreakableBlocks")) {
                offBlock.setRemoveUnbreakableBlocks(element.getAsJsonObject().get("removeUnbreakableBlocks").getAsBoolean());
            }
            if (blockDataParts.length > 2) {
                offBlock.setBlockState(RewardsUtil.getBlockStateFromBlockMeta(block, Integer.parseInt(blockDataParts[2])));
            }
            blocks.add(offBlock);
        }
        rewards.add(new BlockRewardType(blocks.toArray(new OffsetBlock[blocks.size()])));
        return rewards;
    }

    public List<IRewardType> loadMessageReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<MessagePart> msgs = new ArrayList<MessagePart>();
        for (JsonElement element : rawReward) {
            MessagePart message = new MessagePart(element.getAsJsonObject().get("message").getAsString());
            if (element.getAsJsonObject().has("delay")) {
                message.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("serverWide")) {
                message.setServerWide(element.getAsJsonObject().get("serverWide").getAsBoolean());
            }
            if (element.getAsJsonObject().has("range")) {
                message.setRange(element.getAsJsonObject().get("range").getAsInt());
            }
            msgs.add(message);
        }
        rewards.add(new MessageRewardType(msgs.toArray(new MessagePart[msgs.size()])));
        return rewards;
    }

    public List<IRewardType> loadCommandReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<CommandPart> commands = new ArrayList<CommandPart>();
        for (JsonElement element : rawReward) {
            CommandPart command = new CommandPart(element.getAsJsonObject().get("command").getAsString());
            if (element.getAsJsonObject().has("delay")) {
                command.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            commands.add(command);
        }
        rewards.add(new CommandRewardType(commands.toArray(new CommandPart[commands.size()])));
        return rewards;
    }

    public List<IRewardType> loadEntityReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<EntityPart> entities = new ArrayList<EntityPart>();
        for (JsonElement element : rawReward) {
            EntityPart ent;
            try {
                String jsonEdited = this.removedKeyQuotes(element.getAsJsonObject().get("entity").getAsJsonObject().toString());
                NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)jsonEdited);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    CCubesCore.logger.log(Level.ERROR, "Failed to convert the JSON to NBT for: " + element.toString());
                    continue;
                }
                ent = new EntityPart(nbtbase);
            }
            catch (Exception e1) {
                CCubesCore.logger.log(Level.ERROR, "The Entiy loading failed for a custom reward!");
                CCubesCore.logger.log(Level.ERROR, "-------------------------------------------");
                e1.printStackTrace();
                continue;
            }
            if (element.getAsJsonObject().has("delay")) {
                ent.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            entities.add(ent);
        }
        rewards.add(new EntityRewardType(entities.toArray(new EntityPart[entities.size()])));
        return rewards;
    }

    public List<IRewardType> loadExperienceReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ExpirencePart> exp = new ArrayList<ExpirencePart>();
        for (JsonElement element : rawReward) {
            ExpirencePart exppart = new ExpirencePart(element.getAsJsonObject().get("experienceAmount").getAsInt());
            if (element.getAsJsonObject().has("delay")) {
                exppart.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("numberOfOrbs")) {
                exppart.setNumberofOrbs(element.getAsJsonObject().get("numberOfOrbs").getAsInt());
            }
            exp.add(exppart);
        }
        rewards.add(new ExperienceRewardType(exp.toArray(new ExpirencePart[exp.size()])));
        return rewards;
    }

    public List<IRewardType> loadPotionReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<PotionPart> potionEffects = new ArrayList<PotionPart>();
        for (JsonElement element : rawReward) {
            PotionPart exppart = new PotionPart(new PotionEffect(Potion.func_188412_a((int)element.getAsJsonObject().get("potionid").getAsInt()), element.getAsJsonObject().get("duration").getAsInt() * 20));
            if (element.getAsJsonObject().has("delay")) {
                exppart.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            potionEffects.add(exppart);
        }
        rewards.add(new PotionRewardType(potionEffects.toArray(new PotionPart[potionEffects.size()])));
        return rewards;
    }

    public List<IRewardType> loadSoundReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<SoundPart> sounds = new ArrayList<SoundPart>();
        for (JsonElement element : rawReward) {
            SoundPart sound = new SoundPart(CCubesSounds.registerSound(element.getAsJsonObject().get("sound").getAsString()));
            if (element.getAsJsonObject().has("delay")) {
                sound.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            if (element.getAsJsonObject().has("serverWide")) {
                sound.setServerWide(element.getAsJsonObject().get("serverWide").getAsBoolean());
            }
            if (element.getAsJsonObject().has("range")) {
                sound.setRange(element.getAsJsonObject().get("range").getAsInt());
            }
            if (element.getAsJsonObject().has("playAtPlayersLocation")) {
                sound.setAtPlayersLocation(element.getAsJsonObject().get("playAtPlayersLocation").getAsBoolean());
            }
            if (element.getAsJsonObject().has("volume")) {
                sound.setVolume(element.getAsJsonObject().get("volume").getAsInt());
            }
            if (element.getAsJsonObject().has("pitch")) {
                sound.setPitch(element.getAsJsonObject().get("pitch").getAsInt());
            }
            sounds.add(sound);
        }
        rewards.add(new SoundRewardType(sounds.toArray(new SoundPart[sounds.size()])));
        return rewards;
    }

    public List<IRewardType> loadChestReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList items = Lists.newArrayList();
        for (JsonElement element : rawReward) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("item") && obj.has("chance")) {
                int meta = 0;
                if (obj.has("meta")) {
                    meta = obj.get("meta").getAsInt();
                }
                int amountMin = 1;
                if (obj.has("amountMin")) {
                    amountMin = obj.get("amountMin").getAsInt();
                }
                int amountMax = 8;
                if (obj.has("amountMax")) {
                    amountMax = obj.get("amountMax").getAsInt();
                }
                items.add(new ChestChanceItem(obj.get("item").getAsString(), meta, obj.get("chance").getAsInt(), amountMin, amountMax));
                continue;
            }
            CCubesCore.logger.log(Level.ERROR, "A chest reward failed to load do to missing params");
        }
        rewards.add(new ChestRewardType(items.toArray(new ChestChanceItem[items.size()])));
        return rewards;
    }

    public List<IRewardType> loadParticleReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ParticlePart> particles = new ArrayList<ParticlePart>();
        for (JsonElement element : rawReward) {
            ParticlePart particle = new ParticlePart(element.getAsJsonObject().get("particle").getAsInt());
            if (element.getAsJsonObject().has("delay")) {
                particle.setDelay(element.getAsJsonObject().get("delay").getAsInt());
            }
            particles.add(particle);
        }
        rewards.add(new ParticleEffectRewardType(particles.toArray(new ParticlePart[particles.size()])));
        return rewards;
    }

    public List<IRewardType> loadSchematicReward(JsonArray rawReward, List<IRewardType> rewards) {
        for (JsonElement element : rawReward) {
            String fileName = element.getAsJsonObject().get("fileName").getAsString();
            int xoff = 0;
            int yoff = 0;
            int zoff = 0;
            int delay = 0;
            float spacingDelay = 0.0f;
            boolean falling = true;
            boolean relativeToPlayer = false;
            boolean includeAirBlocks = false;
            for (String s : new String[]{"XOffSet", "YOffSet", "ZOffSet", "RelativeToPlayer", "IncludeAirBlocks"}) {
                if (!element.getAsJsonObject().has(s)) continue;
                this.reSaveCurrentJson = true;
                element.getAsJsonObject().add(s.substring(0, 1).toLowerCase() + s.substring(1), element.getAsJsonObject().get(s));
                element.getAsJsonObject().remove(s);
            }
            if (element.getAsJsonObject().has("xOffSet")) {
                xoff = element.getAsJsonObject().get("xOffSet").getAsInt();
            }
            if (element.getAsJsonObject().has("yOffSet")) {
                yoff = element.getAsJsonObject().get("yOffSet").getAsInt();
            }
            if (element.getAsJsonObject().has("zOffSet")) {
                zoff = element.getAsJsonObject().get("zOffSet").getAsInt();
            }
            if (element.getAsJsonObject().has("delay")) {
                delay = element.getAsJsonObject().get("delay").getAsInt();
            }
            if (element.getAsJsonObject().has("falling")) {
                falling = element.getAsJsonObject().get("falling").getAsBoolean();
            }
            if (element.getAsJsonObject().has("relativeToPlayer")) {
                relativeToPlayer = element.getAsJsonObject().get("relativeToPlayer").getAsBoolean();
            }
            if (element.getAsJsonObject().has("includeAirBlocks")) {
                includeAirBlocks = element.getAsJsonObject().get("includeAirBlocks").getAsBoolean();
            }
            if (element.getAsJsonObject().has("spacingDelay")) {
                spacingDelay = element.getAsJsonObject().get("spacingDelay").getAsFloat();
            }
            CustomSchematic schematic = null;
            if (fileName.endsWith(".ccs")) {
                schematic = SchematicUtil.loadCustomSchematic(fileName, xoff, yoff, zoff, spacingDelay, falling, relativeToPlayer, includeAirBlocks, delay);
            } else if (fileName.endsWith(".schematic")) {
                schematic = SchematicUtil.loadLegacySchematic(fileName, xoff, yoff, zoff, spacingDelay, falling, relativeToPlayer, includeAirBlocks, delay);
            }
            if (schematic == null) {
                CCubesCore.logger.log(Level.ERROR, "Failed to load a schematic reward with the file name " + fileName);
                continue;
            }
            rewards.add(new SchematicRewardType(schematic));
        }
        return rewards;
    }

    public String removedKeyQuotes(String raw) {
        int secondQuote;
        StringBuilder sb = new StringBuilder(raw.toString());
        int index = 0;
        while ((index = sb.indexOf("\"", index)) != -1 && (secondQuote = sb.indexOf("\"", index + 1)) != -1) {
            if (sb.charAt(secondQuote + 1) == ':') {
                sb.deleteCharAt(index);
                sb.delete(secondQuote - 1, secondQuote);
                index = secondQuote;
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public List<String> getRewardsFiles() {
        ArrayList files = Lists.newArrayList();
        for (File f : this.folder.listFiles()) {
            if (!f.isFile() || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            files.add(f.getName());
        }
        return files;
    }

    public List<String> getRewardsFromFile(String file) {
        JsonElement fileJson;
        ArrayList rewards = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            rewards.add(reward.getKey());
        }
        return rewards;
    }

    public List<String> getReward(String file, String rewardName) {
        JsonElement fileJson;
        ArrayList rewardinfo = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            JsonObject rewardElements = ((JsonElement)reward.getValue()).getAsJsonObject();
            for (Map.Entry rewardElement : rewardElements.entrySet()) {
                rewardinfo.add(rewardElement.getKey());
            }
        }
        return rewardinfo;
    }

    public List<String> getRewardType(String file, String s, String type) {
        JsonElement fileJson;
        ArrayList rewardinfo = Lists.newArrayList();
        File rewardsFile = new File(this.folder.getPath() + "\\" + file);
        try {
            fileJson = json.parse((Reader)new FileReader(rewardsFile));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + rewardsFile.getName() + ". Skipping file loading.");
            return null;
        }
        for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
            JsonObject rewardElements = ((JsonElement)reward.getValue()).getAsJsonObject();
            for (Map.Entry rewardElement : rewardElements.entrySet()) {
                if (!((String)rewardElement.getKey()).equalsIgnoreCase(type)) continue;
                if (rewardElement.getValue() instanceof JsonArray) {
                    JsonArray rewardTypeArray = ((JsonElement)rewardElement.getValue()).getAsJsonArray();
                    for (int i = 0; i < rewardTypeArray.size(); ++i) {
                        rewardinfo.add(rewardTypeArray.get(i).toString());
                    }
                    continue;
                }
                rewardinfo.add(((JsonElement)rewardElement.getValue()).toString());
            }
        }
        return rewardinfo;
    }

    public File getFolderFile() {
        return this.folder;
    }
}

