/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.giantRewards.BioDomeReward;
import chanceCubes.rewards.giantRewards.ChunkFlipReward;
import chanceCubes.rewards.giantRewards.ChunkReverserReward;
import chanceCubes.rewards.giantRewards.FireworkShowReward;
import chanceCubes.rewards.giantRewards.FloorIsLavaReward;
import chanceCubes.rewards.giantRewards.FluidSphereReward;
import chanceCubes.rewards.giantRewards.MixedFluidSphereReward;
import chanceCubes.rewards.giantRewards.OrePillarReward;
import chanceCubes.rewards.giantRewards.OreSphereReward;
import chanceCubes.rewards.giantRewards.PotionsReward;
import chanceCubes.rewards.giantRewards.TNTSlingReward;
import chanceCubes.rewards.giantRewards.ThrowablesReward;
import chanceCubes.rewards.type.SchematicRewardType;
import chanceCubes.util.FileUtil;
import chanceCubes.util.SchematicUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class GiantCubeRegistry
implements IRewardRegistry {
    public static GiantCubeRegistry INSTANCE = new GiantCubeRegistry();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();

    public static void loadDefaultRewards() {
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Village", 0, new SchematicRewardType(SchematicUtil.loadCustomSchematic(FileUtil.JSON_PARSER.parse("{\"Blocks\":[\"0x54\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x67\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x67\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x75\",\"1\",\"2x3\",\"0x67\",\"1x9\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x76\",\"2x3\",\"0x47\",\"1x13\",\"0x16\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x16\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x16\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x16\",\"2x3\",\"0x53\",\"1\",\"0x5\",\"1\",\"0x4\",\"1x4\",\"0x8\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x4\",\"1x4\",\"0x8\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x4\",\"1x4\",\"0x8\",\"2x3\",\"0x47\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x4\",\"1x4\",\"0x8\",\"2x3\",\"0x47\",\"1x13\",\"0x4\",\"1x4\",\"0x8\",\"2x3\",\"0x41\",\"2x24\",\"0\",\"2x13\",\"0x41\",\"2x38\",\"0x41\",\"2x29\",\"0\",\"2x8\",\"0x33\",\"1x4\",\"0x4\",\"2x3\",\"0x12\",\"1x7\",\"0x6\",\"1x4\",\"0x38\",\"1x9\",\"2x3\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x6\",\"1x4\",\"0x38\",\"1x9\",\"0\",\"2x2\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x6\",\"1x4\",\"0x38\",\"1x9\",\"2x3\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x6\",\"1x4\",\"0x39\",\"1x4\",\"0x4\",\"2x3\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x6\",\"1x4\",\"0x47\",\"2x3\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x15\",\"2x3\",\"0x39\",\"2x3\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x15\",\"2x3\",\"1x5\",\"0x34\",\"2x2\",\"0\",\"1x7\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x15\",\"2x3\",\"1x5\",\"0x34\",\"2x2\",\"0\",\"1x7\",\"0x5\",\"1x7\",\"0x9\",\"1x6\",\"2x2\",\"0\",\"1x5\",\"0x34\",\"2x2\",\"0\",\"1x7\",\"0x21\",\"1x6\",\"2x3\",\"1x5\",\"0x34\",\"2x3\",\"1x7\",\"0x16\",\"1x11\",\"2x3\",\"1x5\",\"0x34\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x23\",\"1x7\",\"0x4\",\"1x5\",\"2x3\",\"0x8\",\"1x7\",\"0x8\",\"1x11\",\"2x3\",\"0x23\",\"1x7\",\"0x4\",\"1x5\",\"0\",\"2x2\",\"0x8\",\"1x7\",\"0x8\",\"1x11\",\"2x3\",\"1x5\",\"0x18\",\"1x7\",\"0x4\",\"1x5\",\"2x3\",\"0x8\",\"1x7\",\"0x19\",\"2x2\",\"0\",\"1x5\",\"0x18\",\"1x7\",\"0x4\",\"1x5\",\"2x3\",\"0x8\",\"1x7\",\"0x19\",\"2x3\",\"1x5\",\"0x18\",\"1x7\",\"0x9\",\"2x3\",\"0x8\",\"1x7\",\"0x19\",\"2x3\",\"1x5\",\"0x6\",\"1x8\",\"0x2\",\"1x9\",\"0x9\",\"2x3\",\"0x6\",\"1x9\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x11\",\"1x8\",\"0x2\",\"1x9\",\"0x9\",\"2x3\",\"0x6\",\"1x9\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x11\",\"1x8\",\"0x2\",\"1x5\",\"0x3\",\"1\",\"0x9\",\"2x3\",\"0x6\",\"1x5\",\"0x3\",\"1\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x11\",\"1x8\",\"0x2\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x9\",\"2x3\",\"0x6\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x11\",\"1x8\",\"0x2\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x9\",\"2x3\",\"0x6\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x11\",\"1x8\",\"0x2\",\"1x9\",\"0x8\",\"1x6\",\"0x4\",\"1x9\",\"0x8\",\"1x9\",\"0x2\",\"2x3\",\"0x12\",\"2x11\",\"0\",\"2x14\",\"1\",\"3x4\",\"1\",\"2x6\",\"0\",\"2x15\",\"0\",\"2x12\",\"0x11\",\"2x27\",\"1\",\"3\",\"4x2\",\"3\",\"1\",\"2x35\",\"0x11\",\"2x15\",\"0\",\"2x11\",\"1\",\"3\",\"4x2\",\"3\",\"1\",\"2x6\",\"0\",\"2x14\",\"0\",\"2x13\",\"0x12\",\"1x7\",\"0x5\",\"1x9\",\"0x5\",\"1\",\"3x4\",\"1\",\"0x4\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"0x12\",\"1\",\"0x5\",\"1\",\"0x5\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x5\",\"1x6\",\"0x4\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"0x12\",\"1\",\"0x5\",\"1\",\"0x5\",\"1x5\",\"0\",\"1\",\"0\",\"1\",\"0x6\",\"2x3\",\"0x6\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"0x12\",\"1\",\"0x5\",\"1\",\"0x5\",\"1x5\",\"0x3\",\"1\",\"0x6\",\"2x3\",\"0x6\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"0x12\",\"1\",\"0x5\",\"1\",\"0x5\",\"1x9\",\"0x6\",\"2x3\",\"0x6\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"1x5\",\"0x7\",\"1\",\"0x5\",\"1\",\"0x5\",\"1x9\",\"0x6\",\"2x3\",\"0x6\",\"1x9\",\"0x7\",\"1x9\",\"0x3\",\"2x3\",\"1x5\",\"0x7\",\"1\",\"0x5\",\"1\",\"0x7\",\"1x7\",\"0x6\",\"2x3\",\"0x8\",\"1x7\",\"0x19\",\"2x2\",\"0\",\"1x5\",\"0x7\",\"1\",\"0x5\",\"1\",\"0x7\",\"1x7\",\"0x6\",\"2x3\",\"0x8\",\"1x7\",\"0x19\",\"2x3\",\"1x5\",\"0x7\",\"1x7\",\"0x7\",\"1x7\",\"0x6\",\"2x3\",\"0x8\",\"1x7\",\"0x13\",\"1x6\",\"2x3\",\"1x5\",\"0x21\",\"1x7\",\"0x6\",\"2x3\",\"0x8\",\"1x7\",\"0x13\",\"1x6\",\"2x3\",\"0x26\",\"1x7\",\"0x6\",\"2x3\",\"0x8\",\"1x7\",\"0x8\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x39\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"0x30\",\"1x9\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"1x6\",\"0x24\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x23\",\"1x11\",\"2x3\",\"1x6\",\"0x24\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x23\",\"1x11\",\"2x2\",\"0\",\"1x11\",\"0x19\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x34\",\"2x3\",\"1x11\",\"0x19\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x34\",\"2x3\",\"1x11\",\"0x19\",\"1\",\"0x7\",\"1\",\"2x3\",\"0x34\",\"2x3\",\"1x11\",\"0x19\",\"1x9\",\"2x3\",\"0x6\",\"1x5\",\"0x4\",\"1x4\",\"0x4\",\"1x5\",\"0x6\",\"2x3\",\"1x11\",\"0x28\",\"2x3\",\"0x6\",\"1x5\",\"0x4\",\"1x4\",\"0x4\",\"1x5\",\"0x6\",\"2x3\",\"1x11\",\"0x28\",\"2x3\",\"0x6\",\"1x5\",\"0x4\",\"1x4\",\"0x4\",\"1x5\",\"0x6\",\"2x3\",\"1x11\",\"0x28\",\"2x3\",\"0x6\",\"1x5\",\"0x4\",\"1x4\",\"0x4\",\"1x5\",\"0x6\",\"2x3\",\"0x39\",\"2x3\",\"0x6\",\"1x5\",\"0x4\",\"1x4\",\"0x4\",\"1x5\",\"0x6\",\"2x3\",\"0x39\",\"2x3\",\"0x6\",\"2x2\",\"0\",\"2x7\",\"0\",\"2x8\",\"0\",\"2x11\",\"0x39\",\"2x3\",\"0x6\",\"2x31\",\"0x18\",\"2x24\",\"0x6\",\"2x31\",\"0x18\",\"2x24\",\"0x8\",\"1x13\",\"0x34\",\"2x24\",\"0x8\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1\",\"0x5\",\"1\",\"0x5\",\"1\",\"0x66\",\"1x13\",\"0x27\",\"5x54\",\"6\",\"7x7\",\"6\",\"5x70\",\"6\",\"4x7\",\"6\",\"5x70\",\"6\",\"7x7\",\"6\",\"5x70\",\"6\",\"7x7\",\"6\",\"5x70\",\"6x9\",\"5x840\",\"6x13\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x4\",\"3x4\",\"5x58\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x58\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x58\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x58\",\"6x13\",\"5x4\",\"3x4\",\"5x76\",\"8\",\"5x162\",\"9\",\"5x41\",\"3x4\",\"5x19\",\"6x7\",\"5x6\",\"3x4\",\"5x38\",\"3x9\",\"5x3\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x6\",\"3\",\"1x2\",\"3\",\"5x38\",\"3x9\",\"10\",\"5x2\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x6\",\"3\",\"1x2\",\"3\",\"5x38\",\"3x9\",\"5x3\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x6\",\"3\",\"1x2\",\"3\",\"5x39\",\"3x4\",\"5x7\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x6\",\"3x4\",\"5x50\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x60\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x18\",\"3x5\",\"5x36\",\"11\",\"3x7\",\"5x5\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x18\",\"3x5\",\"5x36\",\"11\",\"3x7\",\"5x5\",\"6x7\",\"5x9\",\"3x6\",\"5x2\",\"11\",\"3x5\",\"5x36\",\"11\",\"3x7\",\"5x21\",\"3\",\"12x4\",\"3\",\"5x3\",\"3x5\",\"5x37\",\"3x7\",\"5x16\",\"3x6\",\"12x4\",\"3\",\"5x3\",\"3x5\",\"5x60\",\"3\",\"12x9\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x26\",\"0x7\",\"5x4\",\"3x5\",\"5x11\",\"0x7\",\"5x8\",\"3\",\"12x9\",\"3\",\"5x26\",\"0x7\",\"5x4\",\"3\",\"1x3\",\"3\",\"10\",\"5x10\",\"0x7\",\"5x8\",\"3x11\",\"5x3\",\"3x5\",\"5x18\",\"0x7\",\"5x4\",\"3\",\"1x3\",\"3\",\"5x11\",\"0x7\",\"5x21\",\"11\",\"3\",\"1x3\",\"3\",\"5x18\",\"0x7\",\"5x4\",\"3x5\",\"5x11\",\"0\",\"1x2\",\"0x4\",\"5x22\",\"3\",\"1x3\",\"3\",\"5x18\",\"0x4\",\"3\",\"0x2\",\"5x20\",\"0\",\"1x3\",\"3\",\"0x2\",\"5x22\",\"3x5\",\"5x6\",\"3x8\",\"5x2\",\"3x9\",\"5x18\",\"3x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"3\",\"12x7\",\"3\",\"5x18\",\"3\",\"12x7\",\"3\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x18\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x18\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x18\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"3x9\",\"5x8\",\"3x6\",\"5x4\",\"3x9\",\"5x8\",\"3x9\",\"5x16\",\"8\",\"5x11\",\"14\",\"5x14\",\"3x6\",\"5x6\",\"14\",\"5x15\",\"8\",\"5x50\",\"3x2\",\"4x2\",\"3x2\",\"5x61\",\"15\",\"5x11\",\"3x2\",\"4x2\",\"3x2\",\"5x6\",\"15\",\"5x14\",\"9\",\"5x25\",\"6x7\",\"5x5\",\"3x9\",\"5x5\",\"3x6\",\"5x4\",\"3x9\",\"5x7\",\"3x9\",\"5x18\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x5\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x5\",\"3x6\",\"5x4\",\"3\",\"12x7\",\"3\",\"5x7\",\"3x9\",\"5x18\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x5\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x15\",\"3\",\"12x7\",\"3\",\"5x7\",\"3x9\",\"5x18\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x5\",\"3\",\"12x4\",\"13x3\",\"3\",\"5x9\",\"16\",\"5x5\",\"3\",\"12x7\",\"3\",\"5x7\",\"3x9\",\"5x2\",\"16\",\"5x15\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x5\",\"3\",\"12x7\",\"3\",\"5x5\",\"16\",\"5x9\",\"3\",\"12x7\",\"3\",\"5x7\",\"3x9\",\"5x6\",\"3x5\",\"5x7\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x5\",\"3x9\",\"5x15\",\"3x3\",\"12x5\",\"3\",\"5x7\",\"3x9\",\"5x6\",\"3x5\",\"5x7\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x7\",\"0x4\",\"3\",\"0x2\",\"5x17\",\"3\",\"12x5\",\"3\",\"5x21\",\"11\",\"3x5\",\"5x7\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x7\",\"0x7\",\"5x17\",\"3\",\"12x5\",\"3\",\"5x22\",\"3x5\",\"5x7\",\"6x7\",\"5x7\",\"0x7\",\"5x9\",\"16\",\"5x7\",\"3\",\"12x5\",\"3\",\"5x13\",\"3x6\",\"5x3\",\"3x5\",\"5x21\",\"0x7\",\"5x5\",\"16\",\"5x11\",\"3\",\"12x5\",\"3\",\"5x13\",\"3\",\"12x4\",\"3\",\"5x29\",\"0x7\",\"5x17\",\"3x7\",\"5x8\",\"3x6\",\"12x4\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x68\",\"3\",\"12x9\",\"3\",\"5x33\",\"6x9\",\"5x26\",\"3\",\"12x9\",\"3\",\"5x3\",\"3x6\",\"5x24\",\"6\",\"7x7\",\"6\",\"5x3\",\"16\",\"5x22\",\"3\",\"12x9\",\"3\",\"5x3\",\"3\",\"12x4\",\"3\",\"5x24\",\"6\",\"7x7\",\"6\",\"5x26\",\"3x11\",\"5x2\",\"17\",\"3\",\"12x4\",\"3x6\",\"5x19\",\"6\",\"4x7\",\"6\",\"5x40\",\"3\",\"12x9\",\"3\",\"5x19\",\"6\",\"7x7\",\"6\",\"5x40\",\"3\",\"12x9\",\"3\",\"5x19\",\"6\",\"7x7\",\"6\",\"5x40\",\"3\",\"12x9\",\"3\",\"5x19\",\"6x9\",\"5x3\",\"16\",\"5x5\",\"3x5\",\"5x4\",\"3x4\",\"5x4\",\"3x5\",\"5x9\",\"3\",\"12x9\",\"3\",\"5x37\",\"3x5\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x4\",\"3x5\",\"5x9\",\"3\",\"12x9\",\"3\",\"5x37\",\"3x5\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x4\",\"3x5\",\"5x9\",\"3x11\",\"5x37\",\"3x5\",\"5x4\",\"3\",\"1x2\",\"3\",\"5x4\",\"3x5\",\"5x57\",\"3x5\",\"5x4\",\"3x4\",\"5x4\",\"3x5\",\"5x59\",\"8\",\"5x7\",\"8\",\"5x8\",\"8\",\"5x219\",\"6x13\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"7x2\",\"4\",\"7x2\",\"6\",\"5x66\",\"6x13\",\"5x82\",\"18\",\"19\",\"18\",\"19\",\"20\",\"21\",\"18\",\"5x151\",\"22\",\"23x2\",\"24\",\"25x3\",\"5x72\",\"25x2\",\"24x2\",\"22\",\"26\",\"25\",\"5x1000\",\"27\",\"28\",\"5\",\"29\",\"30\",\"5\",\"18\",\"21\",\"5\",\"25x2\",\"5x68\",\"28\",\"27\",\"5\",\"31\",\"30\",\"5\",\"19x2\",\"5\",\"25\",\"23\",\"5x68\",\"27x2\",\"5\",\"32x2\",\"5\",\"19\",\"33\",\"5\",\"34\",\"25\",\"5x68\",\"28x2\",\"5\",\"29\",\"31\",\"5\",\"18\",\"21\",\"5\",\"34\",\"25\",\"5x5\",\"6\",\"12x2\",\"6\",\"5x59\",\"27x2\",\"5\",\"35\",\"29\",\"5\",\"19\",\"21\",\"5\",\"25\",\"24\",\"5x5\",\"12\",\"5x2\",\"12\",\"5x59\",\"28\",\"36\",\"5\",\"31x2\",\"5\",\"33\",\"20\",\"5\",\"34\",\"23\",\"5x5\",\"12\",\"5x2\",\"12\",\"5x59\",\"28\",\"36\",\"5\",\"35\",\"29\",\"5\",\"37\",\"19\",\"5\",\"25x2\",\"5x5\",\"12\",\"5x2\",\"12\",\"5x75\",\"6\",\"38\",\"12\",\"6\",\"5x281\",\"3x7\",\"5x29\",\"6\",\"39\",\"12\",\"6\",\"5x38\",\"3x3\",\"10\",\"5x4\",\"3\",\"5x3\",\"6\",\"12x5\",\"6\",\"5x6\",\"32\",\"35\",\"5\",\"32\",\"31\",\"5x7\",\"12\",\"5x2\",\"12\",\"5x38\",\"3x2\",\"10\",\"5x5\",\"40\",\"5x3\",\"12\",\"5x3\",\"14\",\"12x2\",\"5x6\",\"32\",\"35\",\"5\",\"35x2\",\"5x7\",\"12\",\"5x2\",\"12\",\"5x38\",\"3x3\",\"10\",\"5\",\"41\",\"5x2\",\"3\",\"5x3\",\"12\",\"5x3\",\"16\",\"17\",\"12\",\"5x6\",\"35x2\",\"5\",\"35\",\"30\",\"5x7\",\"12\",\"16\",\"5\",\"12\",\"5x39\",\"3x7\",\"5x4\",\"6\",\"5\",\"12\",\"5x3\",\"12\",\"5x6\",\"31\",\"29\",\"5\",\"30\",\"31\",\"5x7\",\"6\",\"12x2\",\"6\",\"5x53\",\"12\",\"5x2\",\"12\",\"5x6\",\"42\",\"35\",\"5\",\"32x2\",\"5x61\",\"16\",\"5x2\",\"12\",\"5\",\"43\",\"12\",\"5x6\",\"30\",\"35\",\"5\",\"30\",\"35\",\"5x19\",\"3\",\"12x3\",\"3\",\"5x40\",\"3x4\",\"5x6\",\"35\",\"30\",\"5\",\"35\",\"32\",\"5x19\",\"12\",\"5x3\",\"12\",\"5x41\",\"3\",\"44\",\"3\",\"5x21\",\"3x6\",\"5x7\",\"12\",\"5x38\",\"13\",\"5x2\",\"3\",\"44\",\"3\",\"5x21\",\"3\",\"5x4\",\"3\",\"5x3\",\"12\",\"5x3\",\"12\",\"5x37\",\"16\",\"5x3\",\"3x3\",\"5x16\",\"3x6\",\"5x4\",\"40\",\"5x3\",\"3\",\"12x3\",\"3\",\"5x60\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x26\",\"16x7\",\"5x4\",\"6\",\"12x3\",\"6\",\"5x11\",\"16x7\",\"5x8\",\"3\",\"5x9\",\"3\",\"5x26\",\"16\",\"5x5\",\"16\",\"5x4\",\"12\",\"16\",\"5x2\",\"40\",\"5x11\",\"16\",\"5x5\",\"16\",\"5x8\",\"3x11\",\"5x3\",\"6\",\"12x3\",\"6\",\"5x18\",\"16\",\"5x5\",\"16\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x11\",\"16\",\"5x5\",\"16\",\"5x22\",\"45\",\"5x3\",\"12\",\"5x18\",\"16\",\"5x5\",\"16\",\"5x4\",\"6\",\"12x3\",\"6\",\"5x11\",\"16\",\"5x5\",\"16\",\"5x22\",\"12\",\"5x3\",\"12\",\"5x18\",\"16\",\"5x5\",\"16\",\"5x20\",\"16\",\"5x5\",\"16\",\"5x22\",\"6\",\"12x3\",\"6\",\"5x6\",\"3x8\",\"5x2\",\"3x6\",\"38\",\"3x2\",\"5x18\",\"3x6\",\"38\",\"3x2\",\"5x8\",\"3x9\",\"5x18\",\"14x4\",\"12\",\"3\",\"5x2\",\"3\",\"12\",\"14\",\"5x5\",\"3\",\"5x18\",\"3\",\"12\",\"14\",\"5x5\",\"3\",\"5x8\",\"3\",\"5x2\",\"14x4\",\"12\",\"3\",\"5x19\",\"16\",\"5\",\"16\",\"17\",\"3\",\"5x2\",\"3\",\"46\",\"16\",\"5x5\",\"3\",\"5x18\",\"3\",\"46\",\"16\",\"5x5\",\"3\",\"5x8\",\"3\",\"5x3\",\"16\",\"5\",\"16\",\"17\",\"3\",\"5x23\",\"3\",\"5x2\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x18\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x8\",\"3\",\"5x7\",\"3\",\"5x22\",\"47\",\"3\",\"5x2\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x18\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x8\",\"3\",\"5x6\",\"47\",\"3\",\"5x16\",\"38\",\"3x7\",\"5x2\",\"3x2\",\"38\",\"3x6\",\"5x18\",\"3x2\",\"38\",\"3x6\",\"5x8\",\"3\",\"38\",\"3x7\",\"5x44\",\"3x4\",\"5x75\",\"3\",\"5x2\",\"3\",\"5x75\",\"3\",\"5x2\",\"3\",\"5x60\",\"3x2\",\"39\",\"3x6\",\"5x6\",\"3x4\",\"5x5\",\"3x2\",\"39\",\"3x6\",\"5x7\",\"3\",\"39\",\"3x7\",\"5x19\",\"25\",\"24\",\"5\",\"34\",\"25\",\"5x6\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x15\",\"3\",\"5x7\",\"3\",\"5x7\",\"3\",\"5x6\",\"47\",\"3\",\"5x19\",\"26\",\"34\",\"5\",\"26\",\"34\",\"5x6\",\"3\",\"5x5\",\"13\",\"5\",\"3\",\"5x15\",\"3\",\"5x7\",\"3\",\"5x7\",\"3\",\"5x7\",\"3\",\"5x19\",\"25x2\",\"5\",\"25x2\",\"5x6\",\"3\",\"46\",\"16\",\"5x5\",\"3\",\"5x9\",\"16\",\"5x5\",\"3\",\"5x7\",\"3\",\"5x7\",\"3\",\"5x3\",\"16\",\"5\",\"16\",\"17\",\"3\",\"5x2\",\"16\",\"5x16\",\"23x2\",\"5\",\"25x2\",\"5x6\",\"3\",\"12\",\"15\",\"5x5\",\"3\",\"5x5\",\"16\",\"5x9\",\"3\",\"5x7\",\"3\",\"5x7\",\"3\",\"5x2\",\"15x4\",\"12\",\"3\",\"5x6\",\"3\",\"12x3\",\"3\",\"5x8\",\"26\",\"25\",\"5\",\"25\",\"26\",\"5x6\",\"3x6\",\"39\",\"3x2\",\"5x15\",\"3x3\",\"5x5\",\"3\",\"5x7\",\"3x9\",\"5x6\",\"12\",\"5x3\",\"12\",\"5x8\",\"25x2\",\"5\",\"34\",\"23\",\"5x8\",\"16\",\"5x5\",\"16\",\"5x17\",\"3\",\"5x5\",\"3\",\"5x26\",\"12\",\"5x8\",\"23\",\"25\",\"5\",\"23\",\"25\",\"5x8\",\"16\",\"5x5\",\"16\",\"5x17\",\"3\",\"5x5\",\"3\",\"5x22\",\"12\",\"5x2\",\"48\",\"12\",\"5x21\",\"16\",\"5x5\",\"16\",\"5x9\",\"16\",\"5x7\",\"3\",\"5x5\",\"3\",\"5x13\",\"3x6\",\"5x3\",\"3\",\"12x3\",\"3\",\"5x21\",\"16\",\"5x5\",\"16\",\"5x5\",\"16\",\"5x11\",\"3\",\"5x5\",\"3\",\"5x13\",\"3\",\"5x4\",\"3\",\"5x29\",\"16x7\",\"5x17\",\"3x7\",\"5x8\",\"3x6\",\"5x4\",\"40\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x3\",\"3x6\",\"5x25\",\"34\",\"23\",\"24\",\"25x4\",\"5x4\",\"16\",\"5x22\",\"3\",\"5x9\",\"3\",\"5x3\",\"3\",\"5x4\",\"3\",\"5x25\",\"25\",\"23\",\"26\",\"25x4\",\"5x27\",\"3x11\",\"5x3\",\"45\",\"5x4\",\"3x6\",\"5x68\",\"3\",\"5x9\",\"3\",\"5x20\",\"23\",\"25x3\",\"26x2\",\"34\",\"5x41\",\"3\",\"5x9\",\"3\",\"5x20\",\"34\",\"25x2\",\"34\",\"25\",\"26\",\"25\",\"5x41\",\"3\",\"5x9\",\"3\",\"5x31\",\"16\",\"5x5\",\"3\",\"12x3\",\"3\",\"5x4\",\"6\",\"12x2\",\"6\",\"5x4\",\"3\",\"12x3\",\"3\",\"5x9\",\"3\",\"5x9\",\"3\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"16\",\"5\",\"12\",\"5x4\",\"12\",\"5x2\",\"49\",\"12\",\"5x9\",\"3\",\"5x9\",\"3\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x9\",\"3x11\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x57\",\"3\",\"12\",\"5\",\"12\",\"3\",\"5x4\",\"6\",\"38\",\"12\",\"6\",\"5x4\",\"3\",\"12\",\"5\",\"12\",\"3\",\"5x376\",\"22\",\"25\",\"5\",\"18\",\"21\",\"5\",\"30\",\"35\",\"5\",\"25x2\",\"5x68\",\"26x2\",\"5\",\"37x2\",\"5\",\"35\",\"32\",\"5\",\"34x2\",\"5x68\",\"23x2\",\"5\",\"21\",\"33\",\"5\",\"30\",\"31\",\"5\",\"25\",\"34\",\"5x68\",\"34\",\"25\",\"5\",\"37\",\"21\",\"5\",\"29\",\"35\",\"5\",\"25x2\",\"5x68\",\"25x2\",\"5\",\"21x2\",\"5\",\"35x2\",\"5\",\"23\",\"25\",\"5x68\",\"25\",\"34\",\"5\",\"21\",\"37\",\"5\",\"31\",\"30\",\"5\",\"24\",\"34\",\"5x68\",\"24\",\"25\",\"5\",\"33\",\"19\",\"5\",\"35x2\",\"5\",\"23\",\"24\",\"5x1659\",\"6\",\"12x2\",\"6\",\"5x75\",\"12\",\"5x2\",\"12\",\"5x75\",\"50\",\"5x2\",\"50\",\"5x75\",\"12\",\"5x2\",\"12\",\"5x75\",\"6\",\"51\",\"12\",\"6\",\"5x281\",\"3x5\",\"50\",\"3\",\"5x29\",\"6\",\"52\",\"12\",\"6\",\"5x38\",\"3\",\"8\",\"5x6\",\"3\",\"5x3\",\"6\",\"12\",\"50\",\"12\",\"50\",\"12\",\"6\",\"5x18\",\"12\",\"5x2\",\"12\",\"5x38\",\"3\",\"5x7\",\"52\",\"5x3\",\"12\",\"5x5\",\"12\",\"5x18\",\"50\",\"5x2\",\"50\",\"5x38\",\"3\",\"9\",\"5x3\",\"41\",\"5x2\",\"3\",\"5x3\",\"12\",\"5x3\",\"53\",\"5\",\"50\",\"5x18\",\"12\",\"53\",\"5\",\"12\",\"5x39\",\"3x5\",\"50\",\"3\",\"5x4\",\"6\",\"5\",\"12\",\"5x3\",\"12\",\"5x18\",\"6\",\"12x2\",\"6\",\"5x53\",\"12\",\"5x2\",\"50\",\"5x72\",\"16\",\"5x2\",\"12\",\"5x2\",\"12\",\"5x30\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x40\",\"54\",\"3x3\",\"5x30\",\"12\",\"5x3\",\"12\",\"5x43\",\"3\",\"5x21\",\"3\",\"6\",\"50x2\",\"6\",\"3\",\"5x7\",\"50\",\"5x43\",\"3\",\"5x21\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x3\",\"12\",\"5x37\",\"16\",\"5x3\",\"55x2\",\"3\",\"5x16\",\"3\",\"6\",\"50x2\",\"6\",\"12\",\"5x4\",\"52\",\"5x3\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x60\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"6\",\"5x68\",\"3\",\"5x9\",\"50\",\"5x68\",\"3\",\"5x9\",\"6\",\"5x37\",\"6\",\"12\",\"50\",\"12\",\"6\",\"5x26\",\"3\",\"5x9\",\"12\",\"5x37\",\"12\",\"53\",\"5x2\",\"52\",\"5x26\",\"3\",\"6\",\"50x2\",\"6\",\"12\",\"6\",\"50x2\",\"6\",\"3\",\"5x3\",\"6\",\"12\",\"50\",\"12\",\"6\",\"5x29\",\"12\",\"5x3\",\"12\",\"5x40\",\"51\",\"5x3\",\"12\",\"5x29\",\"6\",\"12\",\"50\",\"12\",\"6\",\"5x40\",\"12\",\"5x3\",\"12\",\"5x74\",\"6\",\"12\",\"50\",\"12\",\"6\",\"5x6\",\"12\",\"50x2\",\"12\",\"50x2\",\"12\",\"3\",\"5x2\",\"3\",\"12\",\"50x2\",\"12x2\",\"51\",\"12\",\"3\",\"5x18\",\"3\",\"12\",\"50x2\",\"12x2\",\"51\",\"12\",\"3\",\"5x8\",\"3\",\"12\",\"50x2\",\"12\",\"50x2\",\"12\",\"3\",\"5x23\",\"12\",\"5x2\",\"6\",\"5x7\",\"6\",\"5x18\",\"6\",\"5x7\",\"6\",\"5x8\",\"12\",\"5x7\",\"12\",\"5x19\",\"53\",\"5\",\"53\",\"5\",\"50\",\"5x2\",\"50\",\"5\",\"53\",\"5x5\",\"50\",\"5x18\",\"50\",\"5\",\"53\",\"5x5\",\"50\",\"5x8\",\"50\",\"5x3\",\"53\",\"5\",\"53\",\"5\",\"50\",\"5x23\",\"50\",\"5x2\",\"50\",\"5x7\",\"50\",\"5x18\",\"50\",\"5x7\",\"50\",\"5x8\",\"50\",\"5x7\",\"50\",\"5x23\",\"12\",\"5x2\",\"6\",\"5x7\",\"6\",\"5x18\",\"6\",\"5x7\",\"6\",\"5x8\",\"12\",\"5x7\",\"12\",\"5x16\",\"51\",\"12x2\",\"50x3\",\"12\",\"3\",\"5x2\",\"3\",\"12\",\"51\",\"12x2\",\"50\",\"12x2\",\"3\",\"5x18\",\"3\",\"12\",\"51\",\"12x2\",\"50\",\"12x2\",\"3\",\"5x8\",\"3\",\"51\",\"12x2\",\"50x3\",\"12\",\"3\",\"5x44\",\"16\",\"5x2\",\"16\",\"5x218\",\"3\",\"12\",\"52\",\"12x2\",\"50\",\"12x2\",\"3\",\"5x6\",\"16\",\"5x2\",\"16\",\"5x5\",\"3\",\"12\",\"52\",\"12\",\"6\",\"50\",\"6\",\"12\",\"3\",\"5x7\",\"3\",\"52\",\"12x2\",\"50x3\",\"12\",\"3\",\"5x30\",\"6\",\"5x7\",\"6\",\"5x15\",\"6\",\"5x7\",\"6\",\"5x7\",\"12\",\"5x7\",\"12\",\"5x30\",\"50\",\"5x7\",\"50\",\"5x15\",\"50\",\"5x7\",\"50\",\"5x7\",\"50\",\"5x7\",\"50\",\"5x30\",\"50\",\"5\",\"53\",\"5x5\",\"50\",\"5x9\",\"16\",\"5x5\",\"50\",\"5x7\",\"50\",\"5x7\",\"50\",\"5x3\",\"53\",\"5\",\"53\",\"5\",\"50\",\"5x2\",\"16\",\"5x27\",\"6\",\"5x7\",\"6\",\"5x5\",\"16\",\"5x9\",\"6\",\"5x7\",\"6\",\"5x7\",\"12\",\"5x7\",\"12\",\"5x6\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x19\",\"3\",\"12\",\"50x2\",\"12x2\",\"52\",\"12\",\"3\",\"5x15\",\"3\",\"12x2\",\"5x5\",\"12\",\"5x7\",\"3\",\"12\",\"50x2\",\"12\",\"50x2\",\"12\",\"3\",\"5x6\",\"12\",\"5x3\",\"12\",\"5x45\",\"6\",\"5x5\",\"6\",\"5x26\",\"50\",\"5x45\",\"50\",\"5x5\",\"50\",\"5x22\",\"12\",\"5x2\",\"48\",\"12\",\"5x37\",\"16\",\"5x7\",\"50\",\"5x5\",\"50\",\"5x13\",\"3\",\"6\",\"50x2\",\"6\",\"3\",\"5x3\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x33\",\"16\",\"5x11\",\"6\",\"5x5\",\"6\",\"5x13\",\"12\",\"5x4\",\"12\",\"5x53\",\"3x7\",\"5x8\",\"3\",\"6\",\"50x2\",\"6\",\"12\",\"5x4\",\"52\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"6\",\"5x68\",\"3\",\"5x9\",\"50\",\"5x68\",\"3\",\"5x9\",\"6\",\"5x3\",\"3\",\"6\",\"50x2\",\"6\",\"3\",\"5x36\",\"16\",\"5x22\",\"3\",\"5x9\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x59\",\"3\",\"6\",\"50x2\",\"6\",\"12\",\"6\",\"50x2\",\"6\",\"3\",\"5x3\",\"51\",\"5x4\",\"12\",\"6\",\"50x2\",\"6\",\"3\",\"5x68\",\"12\",\"5x9\",\"3\",\"5x68\",\"6\",\"5x9\",\"3\",\"5x68\",\"50\",\"5x9\",\"3\",\"5x31\",\"16\",\"5x5\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x4\",\"6\",\"12x2\",\"6\",\"5x4\",\"3\",\"12\",\"50\",\"12\",\"3\",\"5x9\",\"6\",\"5x9\",\"3\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"53\",\"5\",\"12\",\"5x4\",\"12\",\"5x2\",\"49\",\"12\",\"5x9\",\"12\",\"5x9\",\"3\",\"5x37\",\"50\",\"5x3\",\"50\",\"5x4\",\"50\",\"5x2\",\"50\",\"5x4\",\"50\",\"5x3\",\"50\",\"5x9\",\"3\",\"6\",\"50x2\",\"6\",\"12\",\"6\",\"50x2\",\"6\",\"3\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x57\",\"3\",\"12\",\"5\",\"12\",\"3\",\"5x4\",\"6\",\"51\",\"12\",\"6\",\"5x4\",\"3\",\"12\",\"5\",\"12\",\"3\",\"5x2520\",\"6\",\"12x2\",\"6\",\"5x75\",\"12\",\"5x2\",\"12\",\"5x75\",\"12\",\"5x2\",\"12\",\"5x75\",\"12\",\"5x2\",\"12\",\"5x75\",\"6\",\"12x2\",\"6\",\"5x281\",\"3\",\"50\",\"3x3\",\"50\",\"3\",\"5x29\",\"6\",\"12x2\",\"6\",\"5x38\",\"3\",\"5x7\",\"3\",\"5x3\",\"6\",\"12x5\",\"6\",\"5x18\",\"12\",\"5x2\",\"12\",\"5x38\",\"50\",\"5x7\",\"3\",\"5x3\",\"12\",\"5x5\",\"12\",\"5x18\",\"12\",\"5x2\",\"12\",\"5x38\",\"3\",\"5x4\",\"41\",\"5x2\",\"3\",\"5x3\",\"12\",\"5x5\",\"12\",\"5x18\",\"12\",\"5x2\",\"12\",\"5x39\",\"3\",\"50\",\"3x3\",\"50\",\"3\",\"5x4\",\"6\",\"12x2\",\"5x3\",\"12\",\"5x18\",\"6\",\"12x2\",\"6\",\"5x53\",\"12\",\"5x2\",\"12\",\"5x72\",\"16\",\"5x2\",\"12\",\"5x2\",\"12\",\"5x30\",\"3\",\"12x3\",\"3\",\"5x40\",\"54\",\"3x3\",\"5x30\",\"12\",\"5x3\",\"12\",\"5x41\",\"3x3\",\"5x20\",\"17\",\"3x6\",\"5x3\",\"12\",\"56\",\"5x2\",\"12\",\"5x41\",\"3x3\",\"5x16\",\"15x4\",\"12x2\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x3\",\"12\",\"5x37\",\"16\",\"5x3\",\"3x3\",\"5x16\",\"3x5\",\"12\",\"5x4\",\"12\",\"5x3\",\"3\",\"12x3\",\"3\",\"5x60\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x37\",\"6\",\"12x3\",\"6\",\"5x26\",\"3\",\"5x9\",\"12\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x26\",\"3x11\",\"5x3\",\"6\",\"12x3\",\"6\",\"5x29\",\"12\",\"5x3\",\"12\",\"5x40\",\"12\",\"5x3\",\"12\",\"5x29\",\"6\",\"12x3\",\"6\",\"5x40\",\"12\",\"5x3\",\"12\",\"5x16\",\"15x9\",\"5x18\",\"15x9\",\"5x22\",\"6\",\"12x3\",\"6\",\"5x6\",\"12x7\",\"3\",\"5x2\",\"3\",\"12x7\",\"3\",\"5x18\",\"3\",\"12x7\",\"3\",\"5x8\",\"3\",\"12x7\",\"3\",\"5x16\",\"57x7\",\"12\",\"5x2\",\"3\",\"5x5\",\"58\",\"5\",\"3\",\"5x18\",\"3\",\"5x5\",\"58\",\"5\",\"3\",\"5x8\",\"12\",\"57x7\",\"12\",\"5x23\",\"50\",\"5x2\",\"3\",\"5x7\",\"3\",\"5x18\",\"3\",\"5x7\",\"3\",\"5x8\",\"50\",\"5x7\",\"50\",\"5x23\",\"50\",\"5x2\",\"3\",\"5x7\",\"3\",\"5x18\",\"3\",\"5x7\",\"3\",\"5x8\",\"50\",\"5x7\",\"50\",\"5x23\",\"12\",\"5x2\",\"3\",\"5x7\",\"3\",\"5x18\",\"3\",\"5x7\",\"3\",\"5x8\",\"12\",\"5x7\",\"12\",\"5x16\",\"12x3\",\"50x3\",\"12\",\"3\",\"5x2\",\"3\",\"12x7\",\"3\",\"5x18\",\"3\",\"12x7\",\"3\",\"5x8\",\"3\",\"12x3\",\"50x3\",\"12\",\"3\",\"5x26\",\"14x9\",\"5x9\",\"16\",\"5x2\",\"16\",\"5x5\",\"14x9\",\"5x125\",\"15x9\",\"5x15\",\"15x9\",\"5x46\",\"3\",\"12x7\",\"3\",\"5x6\",\"16\",\"5x2\",\"16\",\"5x5\",\"3\",\"12x7\",\"3\",\"5x7\",\"3\",\"12x3\",\"50x3\",\"12\",\"3\",\"5x30\",\"3\",\"5\",\"58\",\"5x5\",\"3\",\"5x15\",\"3\",\"5\",\"58\",\"5x5\",\"3\",\"5x7\",\"12\",\"5x7\",\"12\",\"5x30\",\"3\",\"5x7\",\"3\",\"5x15\",\"3\",\"5x7\",\"3\",\"5x7\",\"50\",\"5x7\",\"50\",\"5x30\",\"3\",\"5x7\",\"3\",\"5x9\",\"59\",\"56\",\"5x4\",\"3\",\"5x7\",\"3\",\"5x7\",\"50\",\"5x7\",\"50\",\"5x2\",\"59\",\"5x27\",\"3\",\"5x7\",\"3\",\"5x5\",\"59\",\"56\",\"5x2\",\"58\",\"5x5\",\"3\",\"5x7\",\"3\",\"5x7\",\"12\",\"57x7\",\"12\",\"5x2\",\"58\",\"5x3\",\"3\",\"12x3\",\"3\",\"5x19\",\"3\",\"12x7\",\"3\",\"5x5\",\"58\",\"5x9\",\"3\",\"12x2\",\"5x5\",\"3\",\"5x7\",\"3\",\"12x7\",\"3\",\"5x6\",\"12\",\"5x3\",\"12\",\"5x19\",\"14x9\",\"5x15\",\"14\",\"12\",\"3\",\"5x5\",\"3\",\"5x22\",\"12\",\"56\",\"5x2\",\"12\",\"5x44\",\"17\",\"3\",\"5x5\",\"3\",\"5x22\",\"12\",\"5x2\",\"48\",\"12\",\"5x37\",\"59\",\"56\",\"5x5\",\"17\",\"3\",\"5x5\",\"3\",\"5x12\",\"17\",\"3x6\",\"5x3\",\"3\",\"12x3\",\"3\",\"5x33\",\"59\",\"56\",\"5x2\",\"58\",\"5x6\",\"17\",\"3\",\"5x5\",\"3\",\"5x8\",\"15x4\",\"12x2\",\"5x4\",\"12\",\"5x41\",\"58\",\"5x10\",\"17\",\"3x7\",\"5x8\",\"3x5\",\"12\",\"5x4\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x68\",\"3\",\"5x9\",\"12\",\"5x2\",\"17\",\"3x6\",\"46\",\"5x35\",\"59\",\"56\",\"5x21\",\"3\",\"5x9\",\"12\",\"5x2\",\"17\",\"12\",\"5x4\",\"12x2\",\"15x4\",\"5x31\",\"58\",\"5x22\",\"3x11\",\"5x2\",\"17\",\"12\",\"56\",\"5x3\",\"12\",\"3x5\",\"5x67\",\"17\",\"12\",\"5x9\",\"3\",\"5x67\",\"17\",\"12\",\"5x9\",\"3\",\"5x67\",\"17\",\"12\",\"5x9\",\"3\",\"5x31\",\"59\",\"56\",\"5x4\",\"3\",\"12x3\",\"3\",\"5x4\",\"6\",\"12x2\",\"6\",\"5x4\",\"3\",\"12x3\",\"3\",\"5x8\",\"17\",\"12\",\"5x9\",\"3\",\"5x31\",\"58\",\"5x5\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x2\",\"49\",\"12\",\"5x8\",\"17\",\"12\",\"5x9\",\"3\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x8\",\"17\",\"3x11\",\"5x37\",\"12\",\"5x3\",\"12\",\"5x4\",\"12\",\"5x2\",\"12\",\"5x4\",\"12\",\"5x3\",\"12\",\"5x57\",\"3\",\"12x3\",\"3\",\"5x4\",\"6\",\"12x2\",\"6\",\"5x4\",\"3\",\"12x3\",\"3\",\"5x2521\",\"6x2\",\"5x76\",\"6\",\"5x2\",\"6\",\"5x75\",\"6\",\"5x2\",\"6\",\"5x75\",\"6\",\"5x2\",\"6\",\"5x76\",\"6x2\",\"5x282\",\"3x8\",\"5x29\",\"6x2\",\"5x39\",\"3\",\"5\",\"58\",\"5\",\"3x5\",\"5x3\",\"6\",\"3x5\",\"6\",\"5x18\",\"6x4\",\"5x38\",\"3\",\"56\",\"5x2\",\"3x5\",\"5x3\",\"3x7\",\"5x18\",\"6x4\",\"5x38\",\"3\",\"5x3\",\"3\",\"41\",\"3x3\",\"5x3\",\"3x7\",\"5x18\",\"6x4\",\"5x39\",\"3x8\",\"5x3\",\"6\",\"3x6\",\"5x19\",\"6x2\",\"5x51\",\"3x7\",\"5x72\",\"3x7\",\"5x30\",\"6x5\",\"5x37\",\"3x7\",\"5x30\",\"6\",\"12x3\",\"6\",\"5x37\",\"3x7\",\"5x21\",\"17\",\"12x4\",\"46\",\"5x3\",\"6\",\"12x3\",\"6\",\"5x37\",\"3x7\",\"5x21\",\"17\",\"12\",\"5x2\",\"12\",\"46\",\"5x3\",\"6\",\"12x3\",\"6\",\"5x37\",\"3x7\",\"5x16\",\"15x5\",\"12x2\",\"5x2\",\"12\",\"46\",\"5x3\",\"6x5\",\"5x60\",\"12x7\",\"5x2\",\"12\",\"46\",\"5x68\",\"6\",\"5x8\",\"12\",\"46\",\"5x68\",\"50\",\"5x8\",\"12\",\"46\",\"5x68\",\"6\",\"5x8\",\"12\",\"46\",\"5x38\",\"6x3\",\"5x27\",\"12x10\",\"46\",\"5x37\",\"6x5\",\"5x26\",\"14x6\",\"12x4\",\"46\",\"5x4\",\"6x3\",\"5x30\",\"6x5\",\"5x40\",\"6\",\"5x3\",\"6\",\"5x30\",\"6x3\",\"5x41\",\"6\",\"5x3\",\"6\",\"5x75\",\"6x3\",\"5x7\",\"12x7\",\"3\",\"5x2\",\"15x9\",\"5x18\",\"15x9\",\"5x8\",\"3\",\"12x7\",\"3\",\"5x16\",\"12x8\",\"5x2\",\"12x9\",\"5x18\",\"12x9\",\"5x8\",\"12x9\",\"5x23\",\"12\",\"5x2\",\"12\",\"5x7\",\"12\",\"5x18\",\"12\",\"5x7\",\"12\",\"5x8\",\"12\",\"5x7\",\"12\",\"5x23\",\"12\",\"5x2\",\"12\",\"5x7\",\"12\",\"5x18\",\"12\",\"5x7\",\"12\",\"5x8\",\"12\",\"5x7\",\"12\",\"5x16\",\"12x8\",\"5x2\",\"12x9\",\"5x18\",\"12x9\",\"5x8\",\"12x9\",\"5x16\",\"12x7\",\"3\",\"5x2\",\"14x9\",\"5x18\",\"14x9\",\"5x8\",\"3\",\"12x7\",\"3\",\"5x44\",\"3x4\",\"5x75\",\"3x4\",\"5x75\",\"3x4\",\"5x60\",\"15x9\",\"5x6\",\"3x4\",\"5x5\",\"15x9\",\"5x7\",\"3\",\"12x7\",\"3\",\"5x30\",\"12x9\",\"5x15\",\"12x9\",\"5x7\",\"12x9\",\"5x30\",\"12\",\"5x7\",\"12\",\"5x15\",\"12\",\"5x6\",\"12x2\",\"5x7\",\"12\",\"5x7\",\"12\",\"5x30\",\"12\",\"5x7\",\"12\",\"5x15\",\"12\",\"5x6\",\"12x2\",\"5x7\",\"12\",\"5x7\",\"12\",\"5x30\",\"12x9\",\"5x15\",\"12x4\",\"5x3\",\"12x2\",\"5x7\",\"12x9\",\"5x6\",\"6x5\",\"5x19\",\"14x9\",\"5x15\",\"14x2\",\"12x2\",\"5x3\",\"12\",\"46\",\"5x7\",\"3\",\"12x7\",\"3\",\"5x6\",\"6\",\"12x3\",\"6\",\"5x45\",\"17\",\"12\",\"5x3\",\"12\",\"46\",\"5x22\",\"6\",\"12x3\",\"6\",\"5x45\",\"17\",\"12\",\"5x3\",\"12\",\"46\",\"5x22\",\"6\",\"12x2\",\"48\",\"6\",\"5x45\",\"17\",\"12\",\"5x3\",\"12\",\"46\",\"5x13\",\"17\",\"12x4\",\"46\",\"5x3\",\"6x5\",\"5x45\",\"17\",\"12\",\"5x3\",\"12\",\"46\",\"5x13\",\"17\",\"12\",\"5x2\",\"12\",\"46\",\"5x53\",\"17\",\"12\",\"6\",\"50\",\"6\",\"12\",\"46\",\"5x8\",\"15x5\",\"12x2\",\"5x2\",\"12\",\"46\",\"5x68\",\"12x7\",\"5x2\",\"12\",\"46\",\"5x68\",\"6\",\"5x8\",\"12\",\"46\",\"5x68\",\"50\",\"5x8\",\"12\",\"46\",\"5x68\",\"6\",\"5x8\",\"12\",\"46\",\"5x3\",\"17\",\"12x4\",\"46\",\"5x59\",\"12x10\",\"46\",\"5x3\",\"17\",\"12\",\"5x2\",\"12\",\"46\",\"5x59\",\"14x6\",\"12x4\",\"46\",\"5x3\",\"17\",\"12\",\"5x2\",\"12x2\",\"15x5\",\"5x68\",\"17\",\"12\",\"5x2\",\"12x7\",\"5x68\",\"17\",\"12\",\"5x8\",\"6\",\"5x68\",\"17\",\"12\",\"5x8\",\"50\",\"5x37\",\"6x5\",\"5x5\",\"6x2\",\"5x5\",\"6x5\",\"5x9\",\"17\",\"12\",\"5x8\",\"6\",\"5x37\",\"6\",\"12x3\",\"6\",\"5x4\",\"6\",\"5x2\",\"6\",\"5x4\",\"6\",\"12x2\",\"49\",\"6\",\"5x9\",\"17\",\"12x10\",\"5x37\",\"6\",\"12x3\",\"6\",\"5x4\",\"6\",\"5x2\",\"6\",\"5x4\",\"6\",\"12x3\",\"6\",\"5x9\",\"17\",\"12x4\",\"14x6\",\"5x37\",\"6\",\"12x3\",\"6\",\"5x4\",\"6\",\"5x2\",\"6\",\"5x4\",\"6\",\"12x3\",\"6\",\"5x57\",\"6x5\",\"5x5\",\"6x2\",\"5x5\",\"6x5\",\"5x2600\",\"6x2\",\"5x77\",\"6x2\",\"5x77\",\"6x2\",\"5x365\",\"3x3\",\"5x72\",\"3x4\",\"5x3\",\"3\",\"5x3\",\"60x7\",\"5x61\",\"3x4\",\"5x3\",\"3\",\"5x3\",\"60\",\"5x5\",\"60\",\"5x61\",\"3x4\",\"41\",\"5x2\",\"3\",\"5x3\",\"60\",\"5x5\",\"60\",\"5x65\",\"3x3\",\"5x4\",\"60\",\"5x5\",\"60\",\"5x72\",\"60\",\"5x5\",\"60\",\"5x72\",\"60\",\"5x5\",\"60\",\"5x72\",\"60\",\"5x5\",\"60\",\"5x72\",\"60\",\"5x5\",\"60\",\"5x22\",\"17\",\"12x2\",\"46\",\"5x46\",\"60\",\"5x5\",\"60\",\"5x22\",\"17\",\"12x2\",\"46\",\"5x46\",\"60x7\",\"5x22\",\"17\",\"12x2\",\"46\",\"5x69\",\"15x6\",\"12x3\",\"46\",\"5x69\",\"12x9\",\"46\",\"5x69\",\"12\",\"5x6\",\"12x2\",\"46\",\"5x69\",\"12x9\",\"46\",\"5x69\",\"14x6\",\"12x3\",\"46\",\"5x75\",\"17\",\"12x2\",\"46\",\"5x84\",\"6x3\",\"5x76\",\"6x3\",\"5x7\",\"15x8\",\"5x46\",\"15x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"15x9\",\"5x18\",\"15x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"12x9\",\"5x18\",\"12x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"12x9\",\"5x18\",\"12x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"14x9\",\"5x18\",\"14x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"14x8\",\"5x46\",\"14x9\",\"5x148\",\"15x9\",\"5x70\",\"3x9\",\"5x30\",\"15x9\",\"5x15\",\"15x9\",\"5x7\",\"3x9\",\"5x30\",\"12x9\",\"5x15\",\"12x9\",\"5x7\",\"3x9\",\"5x30\",\"12x9\",\"5x15\",\"12x9\",\"5x7\",\"3x9\",\"5x30\",\"14x9\",\"5x15\",\"14x3\",\"12x2\",\"5\",\"12x2\",\"14\",\"5x7\",\"3x9\",\"5x6\",\"16x5\",\"5x46\",\"17\",\"12\",\"5\",\"12\",\"46\",\"5x8\",\"3x9\",\"5x6\",\"16\",\"5x3\",\"16\",\"5x46\",\"17\",\"12\",\"5\",\"12\",\"46\",\"5x8\",\"14x9\",\"5x6\",\"16\",\"5x3\",\"16\",\"5x46\",\"17\",\"12\",\"5\",\"12\",\"46\",\"5x23\",\"16\",\"5x3\",\"16\",\"5x46\",\"17\",\"12\",\"5\",\"12\",\"46\",\"5x15\",\"17\",\"12x2\",\"46\",\"5x4\",\"16x5\",\"5x46\",\"17\",\"12\",\"5\",\"12\",\"46\",\"5x15\",\"17\",\"12x2\",\"46\",\"5x55\",\"17\",\"12x3\",\"46\",\"5x15\",\"17\",\"12x2\",\"46\",\"5x69\",\"15x6\",\"12x3\",\"46\",\"5x69\",\"12x9\",\"46\",\"5x69\",\"12\",\"5x6\",\"12x2\",\"46\",\"5x69\",\"12x9\",\"46\",\"5x5\",\"17\",\"12x2\",\"46\",\"5x60\",\"14x6\",\"12x3\",\"46\",\"5x5\",\"17\",\"12x2\",\"46\",\"5x66\",\"17\",\"12x2\",\"46\",\"5x5\",\"17\",\"12x2\",\"46\",\"5x75\",\"17\",\"12x3\",\"15x6\",\"5x69\",\"17\",\"12x9\",\"5x69\",\"17\",\"12x2\",\"5x6\",\"12\",\"5x54\",\"16x5\",\"5x10\",\"17\",\"12x9\",\"5x47\",\"6x2\",\"5x5\",\"16\",\"5x3\",\"16\",\"5x10\",\"17\",\"12x3\",\"14x6\",\"5x47\",\"6x2\",\"5x5\",\"16\",\"5x3\",\"16\",\"5x10\",\"17\",\"12x2\",\"46\",\"5x53\",\"6x2\",\"5x5\",\"16\",\"5x3\",\"16\",\"5x74\",\"16x5\",\"5x3125\",\"3\",\"50\",\"3\",\"5x75\",\"3\",\"5x3\",\"3\",\"5x74\",\"50\",\"5x3\",\"50\",\"5x74\",\"3\",\"41\",\"5x2\",\"3\",\"5x75\",\"3\",\"50\",\"3\",\"5x350\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x70\",\"15x7\",\"12\",\"46\",\"5x70\",\"12x8\",\"46\",\"5x70\",\"14x7\",\"12\",\"46\",\"5x77\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x253\",\"15x8\",\"5x46\",\"15x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"15x9\",\"5x18\",\"15x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x2\",\"14x9\",\"5x18\",\"14x9\",\"5x8\",\"3x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"14x8\",\"5x46\",\"14x9\",\"5x306\",\"15x9\",\"5x70\",\"3x9\",\"5x30\",\"15x9\",\"5x15\",\"15x9\",\"5x7\",\"3x9\",\"5x30\",\"14x9\",\"5x15\",\"14x4\",\"12x3\",\"14x2\",\"5x7\",\"3x9\",\"5x58\",\"17\",\"12\",\"46\",\"5x9\",\"3x9\",\"5x58\",\"17\",\"12\",\"46\",\"5x9\",\"14x9\",\"5x58\",\"17\",\"12\",\"46\",\"5x76\",\"17\",\"12\",\"46\",\"5x76\",\"17\",\"12\",\"46\",\"5x17\",\"17\",\"46\",\"5x57\",\"17\",\"12\",\"46\",\"5x17\",\"17\",\"46\",\"5x57\",\"17\",\"12\",\"46\",\"5x17\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x70\",\"15x7\",\"12\",\"46\",\"5x70\",\"12x8\",\"46\",\"5x70\",\"14x7\",\"12\",\"46\",\"5x7\",\"17\",\"46\",\"5x68\",\"17\",\"46\",\"5x7\",\"17\",\"46\",\"5x68\",\"17\",\"46\",\"5x7\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x77\",\"17\",\"12\",\"15x7\",\"5x70\",\"17\",\"12x8\",\"5x70\",\"17\",\"12\",\"14x7\",\"5x70\",\"17\",\"46\",\"5x77\",\"17\",\"46\",\"5x3270\",\"3\",\"50\",\"3\",\"5x75\",\"3\",\"5x3\",\"3\",\"5x74\",\"50\",\"5x3\",\"50\",\"5x74\",\"3\",\"41\",\"5x2\",\"3\",\"5x75\",\"3\",\"50\",\"3\",\"5x1316\",\"15x8\",\"5x46\",\"15x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"3x8\",\"5x46\",\"3x9\",\"5x16\",\"14x8\",\"5x46\",\"14x9\",\"5x464\",\"15x9\",\"5x70\",\"3x9\",\"5x70\",\"3x9\",\"5x70\",\"14x9\",\"5x4702\",\"3x3\",\"5x75\",\"3\",\"5x3\",\"3\",\"5x74\",\"3\",\"5x3\",\"3\",\"5x74\",\"3\",\"41\",\"5x2\",\"3\",\"5x75\",\"3x3\",\"5x1395\",\"15x8\",\"5x46\",\"15x9\",\"5x16\",\"14x8\",\"5x46\",\"14x9\",\"5x622\",\"15x9\",\"5x70\",\"14x9\",\"5x4780\",\"3x5\",\"5x74\",\"3x5\",\"5x74\",\"3x5\",\"5x74\",\"3\",\"41\",\"3x3\",\"5x74\",\"3x5\",\"5x7027\",\"3x3\",\"5x75\",\"3\",\"5x3\",\"3\",\"5x74\",\"3\",\"5x3\",\"3\",\"5x74\",\"3\",\"5x3\",\"3\",\"5x75\",\"3x3\",\"5x7029\",\"3\",\"5x155\",\"3\",\"5x3\",\"3\",\"5x155\",\"3\",\"5x4872\"],\"Block Data\":[{\"minecraft:grass:0\":0},{\"minecraft:dirt:0\":1},{\"minecraft:grass_path:0\":2},{\"minecraft:cobblestone:0\":3},{\"minecraft:water:0\":4},{\"minecraft:air:0\":5},{\"minecraft:log:0\":6},{\"minecraft:farmland:7\":7},{\"minecraft:stone_stairs:1\":8},{\"minecraft:stone_stairs:0\":9},{\"minecraft:stone_stairs:3\":10},{\"minecraft:stone_stairs:2\":11},{\"minecraft:planks:0\":12},{\"minecraft:double_stone_slab:0\":13},{\"minecraft:oak_stairs:1\":14},{\"minecraft:oak_stairs:0\":15},{\"minecraft:fence:0\":16},{\"minecraft:oak_stairs:2\":17},{\"minecraft:carrots:3\":18},{\"minecraft:carrots:4\":19},{\"minecraft:carrots:2\":20},{\"minecraft:carrots:7\":21},{\"minecraft:wheat:2\":22},{\"minecraft:wheat:4\":23},{\"minecraft:wheat:3\":24},{\"minecraft:wheat:7\":25},{\"minecraft:wheat:6\":26},{\"minecraft:beetroots:3\":27},{\"minecraft:beetroots:2\":28},{\"minecraft:potatoes:4\":29},{\"minecraft:potatoes:5\":30},{\"minecraft:potatoes:6\":31},{\"minecraft:potatoes:3\":32},{\"minecraft:carrots:5\":33},{\"minecraft:wheat:5\":34},{\"minecraft:potatoes:7\":35},{\"minecraft:beetroots:1\":36},{\"minecraft:carrots:6\":37},{\"minecraft:wooden_door:2\":38},{\"minecraft:wooden_door:0\":39},{\"minecraft:wooden_door:3\":40},{\"minecraft:ladder:4\":41},{\"minecraft:potatoes:2\":42},{\"minecraft:chest:2\":43},{\"minecraft:lava:0\":44},{\"minecraft:wooden_door:1\":45},{\"minecraft:oak_stairs:3\":46},{\"minecraft:crafting_table:0\":47},{\"minecraft:ladder:2\":48},{\"minecraft:ladder:5\":49},{\"minecraft:glass_pane:0\":50},{\"minecraft:wooden_door:9\":51},{\"minecraft:wooden_door:8\":52},{\"minecraft:wooden_pressure_plate:0\":53},{\"minecraft:furnace:2\":54},{\"minecraft:iron_bars:0\":55},{\"minecraft:torch:3\":56},{\"minecraft:bookshelf:0\":57},{\"minecraft:torch:1\":58},{\"minecraft:wool:15\":59},{\"minecraft:stone_slab:0\":60}],\"TileEntities\":[{\"{x:-1567,y:5,z:-455,Items:[0:{Slot:0b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},1:{Slot:1b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},2:{Slot:2b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},3:{Slot:3b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},4:{Slot:4b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},5:{Slot:5b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},6:{Slot:6b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},7:{Slot:7b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},8:{Slot:8b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},9:{Slot:9b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},10:{Slot:10b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},11:{Slot:11b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},12:{Slot:12b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},13:{Slot:13b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},14:{Slot:14b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},15:{Slot:15b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},16:{Slot:16b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},17:{Slot:17b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},18:{Slot:18b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},19:{Slot:19b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},20:{Slot:20b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},21:{Slot:21b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},22:{Slot:22b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s},23:{Slot:23b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},24:{Slot:24b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},25:{Slot:25b,id:\\\"minecraft:apple\\\",Count:1b,Damage:0s},26:{Slot:26b,id:\\\"minecraft:iron_ingot\\\",Count:1b,Damage:0s}],id:\\\"Chest\\\",Lock:\\\"\\\"}\":[17337]},{\"{CookTime:0,x:-1566,BurnTime:0,y:6,z:-457,Items:[],id:\\\"Furnace\\\",CookTimeTotal:0,Lock:\\\"\\\"}\":[24761]},{\"{CookTime:0,x:-1566,BurnTime:0,y:7,z:-457,Items:[],id:\\\"Furnace\\\",CookTimeTotal:0,Lock:\\\"\\\"}\":[32108]}],\"Schematic Data\":{\"xSize\":93,\"ySize\":13,\"zSize\":79}}"), 0, -1, 0, 0.1f, false, false, false, 0))));
        INSTANCE.registerReward(new BioDomeReward());
        INSTANCE.registerReward(new TNTSlingReward());
        INSTANCE.registerReward(new ThrowablesReward());
        INSTANCE.registerReward(new OrePillarReward());
        INSTANCE.registerReward(new ChunkReverserReward());
        INSTANCE.registerReward(new FloorIsLavaReward());
        INSTANCE.registerReward(new ChunkFlipReward());
        INSTANCE.registerReward(new OreSphereReward());
        INSTANCE.registerReward(new PotionsReward());
        INSTANCE.registerReward(new FluidSphereReward());
        INSTANCE.registerReward(new MixedFluidSphereReward());
        INSTANCE.registerReward(new FireworkShowReward());
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Giant Chance Cube Rewards", true, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        }
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward o = this.nameToReward.remove(name);
        if (o != null) {
            return this.sortedRewards.remove(o);
        }
        return false;
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    @Override
    public void triggerRandomReward(World world, BlockPos pos, EntityPlayer player, int chance) {
        if (pos == null) {
            return;
        }
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with the Giant Chance Cubes and no reward was able to be given");
            return;
        }
        int pick = world.field_73012_v.nextInt(this.sortedRewards.size());
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + this.sortedRewards.get(pick).getName());
        this.sortedRewards.get(pick).trigger(world, pos, player);
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        Collections.sort(this.sortedRewards, new Comparator<IChanceCubeReward>(){

            @Override
            public int compare(IChanceCubeReward o1, IChanceCubeReward o2) {
                return o1.getChanceValue() - o2.getChanceValue();
            }
        });
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
    }
}

