/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OffsetBlock {
    public static String[] elements = new String[]{"XOffSet:I", "YOffSet:I", "ZOffSet:I", "Block:S", "Falling:B", "delay:I", "RelativeToPlayer:B", "removeUnbreakableBlocks:B"};
    protected boolean relativeToPlayer = false;
    public int xOff;
    public int yOff;
    public int zOff;
    protected IBlockState state = null;
    protected boolean falling;
    protected int delay = 0;
    protected boolean causeUpdate = false;
    private boolean removeUnbreakableBlocks = false;
    protected Block block;

    public OffsetBlock(int x, int y, int z, Block b, boolean falling) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        this.block = b;
        this.falling = falling;
        this.state = b.func_176223_P();
    }

    public OffsetBlock(int x, int y, int z, Block b, boolean falling, int delay) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        this.block = b;
        this.falling = falling;
        this.delay = delay;
        this.state = b.func_176223_P();
    }

    public void spawnInWorld(final World world, final int x, final int y, final int z) {
        if (!this.falling) {
            Scheduler.scheduleTask(new Task("Delayed_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                @Override
                public void callback() {
                    OffsetBlock.this.placeInWorld(world, x, y, z, true);
                }
            });
        } else {
            Scheduler.scheduleTask(new Task("Falling_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                @Override
                public void callback() {
                    OffsetBlock.this.spawnFallingBlock(world, x, y, z);
                }
            });
        }
    }

    protected void spawnFallingBlock(World world, int x, int y, int z) {
        double yy = (double)(y + this.yOff + CCubesSettings.dropHeight) + 0.5 >= 256.0 ? 255.0 : (double)(y + this.yOff + CCubesSettings.dropHeight) + 0.5;
        for (int yyy = (int)yy; yyy >= y + this.yOff; --yyy) {
            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, new BlockPos(x + this.xOff, yyy, z + this.zOff), this.removeUnbreakableBlocks);
        }
        BlockFallingCustom entityfallingblock = new BlockFallingCustom(world, (double)(x + this.xOff) + 0.5, yy, (double)(z + this.zOff) + 0.5, this.state, y + this.yOff, this);
        world.func_72838_d((Entity)entityfallingblock);
    }

    public Block getBlock() {
        return this.block;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public OffsetBlock setBlockState(IBlockState state) {
        this.state = state;
        return this;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public OffsetBlock setRelativeToPlayer(boolean relative) {
        this.relativeToPlayer = relative;
        return this;
    }

    public boolean isRelativeToPlayer() {
        return this.relativeToPlayer;
    }

    public int getDelay() {
        return this.delay;
    }

    public OffsetBlock setCausesBlockUpdate(boolean flag) {
        this.causeUpdate = flag;
        return this;
    }

    public boolean isFalling() {
        return this.falling;
    }

    public void setFalling(boolean falling) {
        this.falling = falling;
    }

    public void setRemoveUnbreakableBlocks(boolean remove) {
        this.removeUnbreakableBlocks = remove;
    }

    public boolean doesRemoveUnbreakableBlocks() {
        return this.removeUnbreakableBlocks;
    }

    public void placeInWorld(World world, int x, int y, int z, boolean offset) {
        int xx = x;
        int yy = y;
        int zz = z;
        if (offset) {
            xx += this.xOff;
            yy += this.yOff;
            zz += this.zOff;
        }
        RewardsUtil.placeBlock(this.state == null ? this.block.func_176223_P() : this.state, world, new BlockPos(xx, yy, zz), this.causeUpdate ? 3 : 2, this.removeUnbreakableBlocks);
        BlockPos surfacefPos = new BlockPos(xx, yy - 1, zz);
        Block bSurface = world.func_180495_p(surfacefPos).func_177230_c();
        SoundType sound = bSurface.getSoundType(world.func_180495_p(surfacefPos), world, surfacefPos, null);
        world.func_184148_a(null, (double)((float)xx + 0.5f), (double)((float)yy + 0.5f), (double)((float)zz + 0.5f), sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185843_a() * 0.5f);
    }

    public void placeInWorld(World world, BlockPos position, boolean offset) {
        this.placeInWorld(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), offset);
    }
}

