/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.HMPotions;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereEventHandler;
import com.raz.howlingmoon.WereLevelCommand;
import com.raz.howlingmoon.WerewolfCapability;
import com.raz.howlingmoon.WerewolfClientEventHandler;
import com.raz.howlingmoon.WerewolfCommand;
import com.raz.howlingmoon.WerewolfStorage;
import com.raz.howlingmoon.WorldGenWolf;
import com.raz.howlingmoon.blocks.HMBlocks;
import com.raz.howlingmoon.client.CustomWerewolfResourcePack;
import com.raz.howlingmoon.client.CustomWerewolfTextures;
import com.raz.howlingmoon.client.FXScent;
import com.raz.howlingmoon.client.FXSparkle;
import com.raz.howlingmoon.client.KeyBindings;
import com.raz.howlingmoon.client.KeyHandler;
import com.raz.howlingmoon.client.ParticleHandler;
import com.raz.howlingmoon.client.RenderHunter;
import com.raz.howlingmoon.client.RenderStun;
import com.raz.howlingmoon.client.RenderWerewolf;
import com.raz.howlingmoon.client.gui.GuiBeastPulse;
import com.raz.howlingmoon.entities.EntityCarry;
import com.raz.howlingmoon.entities.EntityHunter;
import com.raz.howlingmoon.entities.EntityStun;
import com.raz.howlingmoon.entities.EntityWerewolf;
import com.raz.howlingmoon.handler.ConfigHandler;
import com.raz.howlingmoon.handler.GuiHandler;
import com.raz.howlingmoon.handler.WerewolfTick;
import com.raz.howlingmoon.items.HMItems;
import com.raz.howlingmoon.packets.PacketDispatcher;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="howlingmoon", name="Howling Moon Rising", version="0.6.1", guiFactory="com.raz.howlingmoon.client.GuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class HowlingMoon {
    @Mod.Instance(value="howlingmoon")
    public static HowlingMoon instance;
    @SidedProxy
    public static CommonProxy proxy;
    public static SoundEvent howl;
    public static final int GUI = 0;
    public static final int GUISKILL = 1;
    public static final int GUISCENT = 2;
    public static final int GUIBOOK = 3;
    public static final int GUITAME = 4;
    public static final int GUIWMERCHANT = 5;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        HMBlocks.registerBlocks();
        HMItems.registerItems();
        HMPotions.registerPotions();
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)new ItemStack((Block)HMBlocks.silverOre));
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)new ItemStack((Item)HMItems.silverIngot));
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWolf(), (int)5);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1), (PotionType)PotionTypes.field_185233_e), (ItemStack)new ItemStack((Block)HMBlocks.wolfsbane, 1), (ItemStack)new ItemStack((Item)HMItems.potionWolfsbane));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)HMItems.silverSword), (Object[])new Object[]{"I", "I", "S", Character.valueOf('I'), HMItems.silverIngot, Character.valueOf('S'), Items.field_151055_y});
        GameRegistry.addSmelting((Block)HMBlocks.silverOre, (ItemStack)new ItemStack((Item)HMItems.silverIngot), (float)1.0f);
        ShapedOreRecipe oreSword = new ShapedOreRecipe(new ItemStack((Item)HMItems.silverSword), new Object[]{"I", "I", "W", Character.valueOf('I'), "ingotSilver", Character.valueOf('W'), HMBlocks.wolfsbane});
        GameRegistry.addRecipe((IRecipe)oreSword);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        Biome[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        Biome.SpawnListEntry werewolfSpawn = new Biome.SpawnListEntry(EntityWerewolf.class, 20, 1, 2);
        Biome.SpawnListEntry hunterSpawn = new Biome.SpawnListEntry(EntityHunter.class, 10, 1, 2);
        Biome.SpawnListEntry hunterSpawnDay = new Biome.SpawnListEntry(EntityHunter.class, 2, 1, 3);
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i].func_76747_a(EnumCreatureType.MONSTER).add(werewolfSpawn);
            biomes[i].func_76747_a(EnumCreatureType.MONSTER).add(hunterSpawn);
            biomes[i].func_76747_a(EnumCreatureType.CREATURE).add(hunterSpawnDay);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new WerewolfCommand());
        event.registerServerCommand((ICommand)new WereLevelCommand());
    }

    public static class ServerProxy
    extends CommonProxy {
    }

    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            super.preInit(event);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)HMBlocks.silverOre), (int)0, (ModelResourceLocation)new ModelResourceLocation(HMBlocks.silverOre.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)HMBlocks.wolfsbane), (int)0, (ModelResourceLocation)new ModelResourceLocation("howlingmoon:" + HMBlocks.wolfsbane.getName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)HMItems.silverIngot, (int)0, (ModelResourceLocation)new ModelResourceLocation(HMItems.silverIngot.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)HMItems.silverSword, (int)0, (ModelResourceLocation)new ModelResourceLocation(HMItems.silverSword.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)HMItems.moonstone, (int)0, (ModelResourceLocation)new ModelResourceLocation(HMItems.moonstone.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)HMItems.potionWolfsbane, (int)0, (ModelResourceLocation)new ModelResourceLocation(HMItems.potionWolfsbane.getRegistryName(), "inventory"));
            CustomWerewolfTextures.setCacheFile(new File(Minecraft.func_71410_x().field_71412_D, "config/HowlingMoonTextures"));
            MinecraftForge.EVENT_BUS.register((Object)new WerewolfClientEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new GuiBeastPulse(Minecraft.func_71410_x()));
            RenderingRegistry.registerEntityRenderingHandler(EntityWerewolf.class, (IRenderFactory)new IRenderFactory<EntityWerewolf>(){

                public Render<? super EntityWerewolf> createRenderFor(RenderManager manager) {
                    return new RenderWerewolf(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityHunter.class, (IRenderFactory)new IRenderFactory<EntityHunter>(){

                public Render<? super EntityHunter> createRenderFor(RenderManager manager) {
                    return new RenderHunter(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityStun.class, (IRenderFactory)new IRenderFactory<EntityStun>(){

                public Render<? super EntityStun> createRenderFor(RenderManager manager) {
                    return new RenderStun(manager);
                }
            });
        }

        @Override
        public void init(FMLInitializationEvent event) {
            super.init(event);
            List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
            defaultResourcePacks.add(new CustomWerewolfResourcePack());
            MinecraftForge.EVENT_BUS.register((Object)new KeyHandler());
            MinecraftForge.EVENT_BUS.register(ParticleHandler.class);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.menu);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.transform);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.ability1);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.ability2);
        }

        @Override
        public void postInit(FMLPostInitializationEvent event) {
        }

        @Override
        public World getClientWorld() {
            return FMLClientHandler.instance().getClient().field_71441_e;
        }

        @Override
        public EntityPlayer getPlayerEntity(MessageContext ctx) {
            return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
        }

        @Override
        public void generateScentParticles(Entity theEntity, int color) {
            float r = color >> 16 & 0xFF;
            float g = color >> 8 & 0xFF;
            float b = color >> 0 & 0xFF;
            this.generateScentParticles(theEntity, r / 255.0f, g / 255.0f, b / 255.0f);
        }

        @Override
        public void generateScentParticles(Entity theEntity, float red, float green, float blue) {
            double motionX = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double motionY = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double motionZ = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            FXScent scent = new FXScent(theEntity.field_70170_p, theEntity.field_70165_t + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70130_N * 2.0f) - (double)theEntity.field_70130_N, theEntity.field_70163_u + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70131_O), theEntity.field_70161_v + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70130_N * 2.0f) - (double)theEntity.field_70130_N, red, green, blue, motionX, motionY, motionZ);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)scent);
        }

        @Override
        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, int maxAge) {
            FXSparkle wisp = new FXSparkle((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, r, g, b, maxAge);
            wisp.setSpeed(motionx, motiony, motionz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)wisp);
        }
    }

    public static class CommonProxy {
        public void registerRenderers() {
        }

        public EntityPlayer getPlayerEntity(MessageContext ctx) {
            return ctx.getServerHandler().field_147369_b;
        }

        public void preInit(FMLPreInitializationEvent event) {
            MinecraftForge.EVENT_BUS.register((Object)new WereEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new WerewolfTick());
            ConfigHandler.init(event.getSuggestedConfigurationFile());
            MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
            this.registerEntities();
            howl = CommonProxy.registerSound("howl");
            PacketDispatcher.registerPackets();
        }

        public void init(FMLInitializationEvent event) {
            CapabilityManager.INSTANCE.register(IWerewolfCapability.class, (Capability.IStorage)new WerewolfStorage(), WerewolfCapability.class);
        }

        public void postInit(FMLPostInitializationEvent event) {
        }

        public void registerEntities() {
            EntityRegistry.registerModEntity(EntityWerewolf.class, (String)"werewolf", (int)0, (Object)instance, (int)80, (int)3, (boolean)true, (int)0xE2E2E2, (int)10420283);
            EntityRegistry.registerModEntity(EntityHunter.class, (String)"hunter", (int)1, (Object)instance, (int)80, (int)3, (boolean)true, (int)0xE2E2E2, (int)10420283);
            EntityRegistry.registerModEntity(EntityCarry.class, (String)"carry", (int)3, (Object)instance, (int)80, (int)3, (boolean)true);
            EntityRegistry.registerModEntity(EntityStun.class, (String)"stun", (int)4, (Object)instance, (int)80, (int)3, (boolean)true);
        }

        public static SoundEvent registerSound(String soundName) {
            ResourceLocation soundID = new ResourceLocation("howlingmoon", soundName);
            return (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(soundID).setRegistryName(soundID));
        }

        public World getClientWorld() {
            return null;
        }

        public void generateScentParticles(Entity theEntity, int color) {
        }

        public void generateScentParticles(Entity theEntity, float red, float green, float blue) {
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size) {
            this.generateMoonPearlParticles(x, y, z, r, g, b, size, 5);
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, int maxAge) {
            this.generateMoonPearlParticles(x, y, z, r, g, b, size, 0.0f, 0.0f, 0.0f, maxAge);
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, int maxAge) {
        }
    }
}

