/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereAbility;
import com.raz.howlingmoon.WereAttribute;
import com.raz.howlingmoon.WereBasic;
import com.raz.howlingmoon.WereList;
import com.raz.howlingmoon.handler.ConfigHandler;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SyncTransformMessage;
import com.raz.howlingmoon.packets.SyncWereCapsMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;

public class WerewolfCapability
implements IWerewolfCapability {
    private boolean isWerewolf = false;
    private boolean isTransformed = false;
    private boolean isSprintKey = false;
    private int infected = 0;
    private boolean displayRage = false;
    private int tick = 0;
    private int cdExhil = 150;
    private int level = 0;
    private int exp = 0;
    private int questsDone = 0;
    private int usedAttributePoints;
    private int usedAbilityPoints;
    private HashMap<String, Boolean> basicTree = new HashMap<String, Boolean>(){
        {
            for (WereBasic basic : WereList.BASIC) {
                this.put(basic.getKey(), false);
            }
        }
    };
    private HashMap<String, Integer> attributeTree = new HashMap<String, Integer>(){
        {
            for (WereAttribute attribute : WereList.ATTRIBUTES) {
                this.put(attribute.getKey(), 0);
            }
        }
    };
    private HashMap<String, Boolean> abilityTree = new HashMap<String, Boolean>(){
        {
            for (WereAbility ability : WereList.ABILITIES) {
                this.put(ability.getKey(), false);
            }
        }
    };
    private HashMap<Class<? extends Entity>, Integer> scentColors = new HashMap<Class<? extends Entity>, Integer>(){
        {
            Set set = Sets.filter(EntityList.field_75626_c.keySet(), (Predicate)Predicates.assignableFrom(EntityLiving.class));
            for (Class entity : set) {
                this.put(entity, 0);
            }
            this.put(EntityAnimal.class, -16711936);
            this.put(EntityCreature.class, -256);
            this.put(EntityMob.class, -65536);
            this.put(EntityLiving.class, -16776961);
        }
    };
    private AttributeModifier t2Modifier = new AttributeModifier(UUID.fromString("fc1af77f-2c52-4ba6-b722-7d3097162cf9"), "Tenacity", 1.0, 0);
    private Multimap<String, AttributeModifier> attributes = HashMultimap.create();
    private boolean t2Knockback;
    private boolean climb;
    private boolean nightVision;
    private boolean leap;
    private boolean scentTracking;
    private int sprintClimb;
    private int sneakJump;
    private int sprintJump;
    private int sprintRam;
    private int leapState;
    private int pawSlot;
    private WereAbility abilitySlot1;
    private WereAbility abilitySlot2;
    private int texture;
    private int model;

    public WerewolfCapability() {
        this.attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.t2Modifier);
        this.sprintClimb = 0;
        this.sneakJump = 2;
        this.sprintJump = 2;
        this.sprintRam = 1;
        this.leapState = 0;
        this.pawSlot = -1;
        this.texture = 0;
        this.model = 0;
    }

    @Override
    public void copy(IWerewolfCapability cap) {
        this.isWerewolf = cap.isWerewolf();
        this.isTransformed = false;
        this.infected = cap.getInfected();
        this.level = cap.getLevel();
        this.exp = cap.getExp();
        this.questsDone = cap.getQuestsDone();
        this.texture = cap.getTexture();
        this.model = cap.getModel();
        this.abilitySlot1 = cap.getAbilitySlot1();
        this.abilitySlot2 = cap.getAbilitySlot2();
        this.t2Knockback = cap.getKnockbackResist();
        this.basicTree = cap.getBasicTree();
        this.attributeTree = cap.getAttributeTree();
        this.abilityTree = cap.getAbilityTree();
        this.scentColors = cap.getScentTree();
        this.usedAttributePoints = cap.getUsedAttributePoints();
        this.usedAbilityPoints = cap.getUsedAbilityPoints();
        this.pawSlot = cap.getPawSlot();
        this.nightVision = cap.getNightVision();
        this.scentTracking = cap.getScentTracking();
        this.leapState = cap.getLeapState();
        this.sprintClimb = cap.getSprintClimb();
        this.sneakJump = cap.getSneakJump();
        this.sprintJump = cap.getSprintJump();
        this.sprintRam = cap.getSprintRam();
    }

    @Override
    public boolean isWerewolf() {
        return this.isWerewolf;
    }

    @Override
    public boolean isTransformed() {
        return this.isTransformed;
    }

    @Override
    public boolean isSprintKey() {
        return this.isSprintKey;
    }

    @Override
    public void setSprintKey(boolean isSprintKey) {
        this.isSprintKey = isSprintKey;
    }

    @Override
    public void setTransformed(boolean isTransformed) {
        this.isTransformed = isTransformed;
    }

    @Override
    public void setWerewolf(boolean state) {
        this.isWerewolf = state;
        this.basicTree.put("WEREWOLF", state);
        this.basicTree.put("EMPTYPAW", state);
        if (this.level < 1) {
            this.setLevel(1);
        }
    }

    @Override
    public void setWerewolf(boolean state, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.isWerewolf != state) {
            this.isWerewolf = state;
            this.basicTree.put("WEREWOLF", state);
            this.basicTree.put("EMPTYPAW", state);
            if (state) {
                if (this.level < 1) {
                    this.setLevel(1);
                }
                this.infected = 2;
            } else {
                this.resetAttributePoints();
                this.resetAbilityPoints();
                this.setTransformedServer(false, player);
                this.infected = 0;
                this.exp = 0;
                this.level /= 2;
            }
            PacketDispatcher.sendTo(new SyncWereCapsMessage(player), (EntityPlayerMP)player);
        }
    }

    @Override
    public void tryTransform(EntityPlayer player) {
        if (player.field_70170_p.func_130001_d() != 1.0f || player.field_70170_p.func_72935_r()) {
            int duration;
            if (this.isTransformed) {
                duration = 1200;
                if ((duration -= this.getAttributeTreeAbility(WereList.CLARITY.getKey()) * 400) > 0) {
                    player.func_71020_j((float)(duration / 200));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration, 0, false, false));
                }
                this.isTransformed = false;
                PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            } else {
                duration = 0;
                if ((duration += this.getAttributeTreeAbility(WereList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                    player.func_71024_bL().func_75122_a(1, (float)(duration * 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, duration * 400, 0, false, false));
                    this.resetCDExhil();
                }
                this.isTransformed = true;
                PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            }
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.exitmoon", new Object[0]));
        }
    }

    @Override
    public void setTransformed(boolean state, Side side, EntityPlayer player) {
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        if (side.isServer()) {
            int duration;
            PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            if (!state && temp) {
                duration = 1200;
                if ((duration -= this.getAttributeTreeAbility(WereList.CLARITY.getKey()) * 400) > 0) {
                    player.func_71020_j((float)(duration / 200));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration, 0, false, false));
                }
            } else if (state && !temp) {
                duration = 0;
                if ((duration += this.getAttributeTreeAbility(WereList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                    player.func_71024_bL().func_75122_a(1, (float)(duration * 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, duration * 400, 0, false, false));
                    this.resetCDExhil();
                }
            }
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public void setTransformedServer(boolean state, EntityPlayer player) {
        int duration;
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
        if (!state && temp) {
            duration = 1200;
            if ((duration -= this.getAttributeTreeAbility(WereList.CLARITY.getKey()) * 400) > 0) {
                player.func_71020_j((float)(duration / 200));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration, 0, false, false));
            }
        } else if (state && !temp) {
            duration = 0;
            if ((duration += this.getAttributeTreeAbility(WereList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                player.func_71024_bL().func_75122_a(1, (float)(duration * 3));
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, duration * 400, 0, false, false));
                this.resetCDExhil();
            }
        }
        Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
        PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
    }

    @Override
    public HashMap<String, Boolean> getBasicTree() {
        return this.basicTree;
    }

    @Override
    public void setBasicTree(HashMap array) {
        this.basicTree = array;
    }

    @Override
    public boolean getBasicTreeAbility(String key) {
        if (this.basicTree.get(key) != null) {
            return this.basicTree.get(key);
        }
        return false;
    }

    @Override
    public void setBasicTreeAbility(String key, boolean value) {
        this.basicTree.put(key, value);
    }

    @Override
    public HashMap<String, Integer> getAttributeTree() {
        return this.attributeTree;
    }

    @Override
    public void setAttributeTree(HashMap array) {
        this.attributeTree = array;
    }

    @Override
    public int getAttributeTreeAbility(String key) {
        if (this.attributeTree.get(key) != null) {
            return this.attributeTree.get(key);
        }
        return 0;
    }

    @Override
    public void setAttributeTreeAbility(String key, int value) {
        if (value < 0) {
            value = 0;
        }
        this.attributeTree.put(key, value);
        if (this.attributeTree.get(key) > WereList.getAttributeFromKey(key).getCap()) {
            this.attributeTree.put(key, WereList.getAttributeFromKey(key).getCap());
        }
    }

    @Override
    public void addAttributeTreeAbility(WereAttribute ability) {
        String key = ability.getKey();
        if (!this.isAttributeCapped(key) && this.getUsuableAttributePoints() > 0) {
            this.attributeTree.put(key, this.attributeTree.get(key) + 1);
            this.setUsedAttributePoints(this.getUsedAttributePoints() + 1);
        }
    }

    @Override
    public boolean isAttributeCapped(String key) {
        return this.attributeTree.get(key) >= WereList.getAttributeFromKey(key).getCap();
    }

    @Override
    public void resetAttributeTree() {
        for (String key : this.attributeTree.keySet()) {
            this.attributeTree.put(key, 0);
        }
    }

    @Override
    public HashMap<String, Boolean> getAbilityTree() {
        return this.abilityTree;
    }

    @Override
    public void seAbilityTree(HashMap array) {
        this.abilityTree = array;
    }

    @Override
    public boolean getAbilityTreeAbility(String key) {
        if (this.abilityTree.get(key) != null) {
            return this.abilityTree.get(key);
        }
        return false;
    }

    @Override
    public void setAbilityTreeAbility(String key, boolean value) {
        this.abilityTree.put(key, value);
    }

    @Override
    public void addAbilityTreeAbility(WereAbility ability) {
        String key = ability.getKey();
        if (!this.getAbilityTreeAbility(ability.getKey()) && this.getUsuableAbilityPoints() > 0) {
            this.abilityTree.put(key, true);
            this.setUsedAbilityPoints(this.getUsedAbilityPoints() + 1);
        }
    }

    @Override
    public void resetAbilityTree() {
        for (String key : this.abilityTree.keySet()) {
            this.abilityTree.put(key, false);
        }
    }

    @Override
    public HashMap<Class<? extends Entity>, Integer> getScentTree() {
        return this.scentColors;
    }

    @Override
    public int getScentColor(Class<? extends Entity> entityClass) {
        if (this.scentColors.get(entityClass) != null) {
            return this.scentColors.get(entityClass);
        }
        return -1;
    }

    @Override
    public void setScentColor(Class<? extends Entity> entityClass, int color) {
        if (this.scentColors.get(entityClass) != null) {
            this.scentColors.put(entityClass, color);
        }
    }

    @Override
    public int getLevelCap() {
        return ConfigHandler.setLevelCap;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
        if (this.level > this.getLevelCap()) {
            this.level = this.getLevelCap();
        }
        this.setExp(0);
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void setExp(int exp) {
        this.exp = exp;
        this.expLevel();
    }

    @Override
    public void addExp(int amount) {
        this.exp += amount;
        this.expLevel();
    }

    private void expLevel() {
        if (!this.levelCapped()) {
            if (this.exp >= this.expNeededLevel()) {
                this.setLevel(this.getLevel() + 1);
            }
        } else if (this.exp > 0) {
            this.exp = 0;
        }
    }

    @Override
    public int expNeededLevel() {
        return this.getLevel() * 25;
    }

    private boolean levelCapped() {
        return this.level >= ConfigHandler.setLevelCap;
    }

    @Override
    public int getQuestsDone() {
        return this.questsDone;
    }

    @Override
    public void setQuestsDone(int questsDone) {
        this.questsDone = questsDone > 6 ? 6 : questsDone;
    }

    @Override
    public int getAttributePoints() {
        return this.level * 2;
    }

    @Override
    public int getUsedAttributePoints() {
        return this.usedAttributePoints;
    }

    @Override
    public void setUsedAttributePoints(int usedAttributePoints) {
        this.usedAttributePoints = usedAttributePoints;
    }

    @Override
    public int getUsuableAttributePoints() {
        return this.getAttributePoints() - this.usedAttributePoints;
    }

    @Override
    public void resetAttributePoints() {
        this.setUsedAttributePoints(0);
        this.resetAttributeTree();
    }

    @Override
    public int getAbilityPoints() {
        return 1 + (int)Math.floor(this.level / 3);
    }

    @Override
    public int getUsedAbilityPoints() {
        return this.usedAbilityPoints;
    }

    @Override
    public void setUsedAbilityPoints(int usedAbilityPoints) {
        this.usedAbilityPoints = usedAbilityPoints;
    }

    @Override
    public int getUsuableAbilityPoints() {
        return this.getAbilityPoints() - this.usedAbilityPoints;
    }

    @Override
    public void resetAbilityPoints() {
        this.setUsedAbilityPoints(0);
        this.resetAbilityTree();
    }

    @Override
    public int getTexture() {
        return this.texture;
    }

    @Override
    public String getTextureName() {
        switch (this.texture) {
            case 0: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.white", (Object[])new Object[0]);
            }
            case 1: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.black", (Object[])new Object[0]);
            }
            case 2: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.timber", (Object[])new Object[0]);
            }
            case 3: {
                return "Killerwolf";
            }
        }
        return I18n.func_135052_a((String)"werewolf.menu.texture.custom", (Object[])new Object[0]) + (this.texture - 3);
    }

    @Override
    public void setTexture(int i) {
        this.texture = i;
    }

    @Override
    public void setTexture(int i, Side side, EntityPlayer player) {
        this.texture = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public int getModel() {
        return this.model;
    }

    @Override
    public String getModelName() {
        if (this.model == 0) {
            return I18n.func_135052_a((String)"werewolf.menu.werewolf", (Object[])new Object[0]);
        }
        if (this.model == 1) {
            return I18n.func_135052_a((String)"werewolf.menu.model.wolf", (Object[])new Object[0]);
        }
        if (this.model == 2) {
            return I18n.func_135052_a((String)"werewolf.menu.model.beast", (Object[])new Object[0]);
        }
        return "Error";
    }

    @Override
    public void setModel(int i) {
        this.model = i;
    }

    @Override
    public void setModel(int i, Side side, EntityPlayer player) {
        this.model = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public int getInfected() {
        return this.infected;
    }

    @Override
    public void setInfected(int i) {
        this.infected = i;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public void incTick() {
        ++this.tick;
    }

    @Override
    public void resetTick() {
        this.tick = 0;
    }

    @Override
    public int getCDExhil() {
        return this.cdExhil;
    }

    @Override
    public void deincCDExhil() {
        if (this.cdExhil > 0) {
            --this.cdExhil;
        }
    }

    @Override
    public void resetCDExhil() {
        this.cdExhil = 300;
    }

    @Override
    public boolean getDisplayRage() {
        return this.displayRage;
    }

    @Override
    public void setDisplayRage(boolean state) {
        this.displayRage = state;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeKBResist() {
        HashMultimap multimap = HashMultimap.create();
        UUID uuid = UUID.fromString("fc1af77f-2c52-4ba6-b722-7d3097162cf9");
        float amount = (float)this.getAttributeTreeAbility(WereList.KNOCKRESIST.getKey()) / 2.0f;
        multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Tenacity", (double)amount, 0));
        return multimap;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeMod() {
        return this.attributes;
    }

    @Override
    public boolean getKnockbackResist() {
        return this.t2Knockback;
    }

    @Override
    public void setKnockbackResist(boolean state) {
        this.t2Knockback = state;
    }

    @Override
    public boolean getClimb() {
        return this.climb;
    }

    @Override
    public void setClimb(boolean set) {
        this.climb = set;
    }

    @Override
    public boolean getLeap() {
        return this.leap;
    }

    @Override
    public void setLeap(boolean set) {
        this.leap = set;
    }

    @Override
    public boolean getNightVision() {
        return this.nightVision;
    }

    @Override
    public void setNightVision(boolean set) {
        this.nightVision = set;
    }

    @Override
    public boolean getScentTracking() {
        return this.scentTracking;
    }

    @Override
    public void setScentTracking(boolean set) {
        this.scentTracking = set;
    }

    @Override
    public int getSprintClimb() {
        return this.sprintClimb;
    }

    @Override
    public void setSprintClimb(int state) {
        this.sprintClimb = state;
    }

    @Override
    public int getLeapState() {
        return this.leapState;
    }

    @Override
    public void setLeapState(int state) {
        this.leapState = state;
    }

    @Override
    public int getSneakJump() {
        return this.sneakJump;
    }

    @Override
    public void setSneakJump(int state) {
        this.sneakJump = state;
    }

    @Override
    public int getSprintJump() {
        return this.sprintJump;
    }

    @Override
    public void setSprintJump(int state) {
        this.sprintJump = state;
    }

    @Override
    public int getSprintRam() {
        return this.sprintRam;
    }

    @Override
    public void setSprintRam(int state) {
        this.sprintRam = state;
    }

    @Override
    public WereAbility getAbilitySlot1() {
        return this.abilitySlot1;
    }

    @Override
    public WereAbility getAbilitySlot2() {
        return this.abilitySlot2;
    }

    @Override
    public void setAbilitySlot1(WereAbility ability) {
        this.abilitySlot1 = ability;
    }

    @Override
    public void setAbilitySlot2(WereAbility ability) {
        this.abilitySlot2 = ability;
    }

    @Override
    public int getPawSlot() {
        return this.pawSlot;
    }

    @Override
    public void setPawSlot(int slot) {
        this.pawSlot = slot;
    }

    @Override
    public float getModelHeight() {
        if (this.isTransformed) {
            switch (this.model) {
                case 0: {
                    return 1.8f;
                }
                case 1: {
                    return 0.85f;
                }
                case 2: {
                    return 2.8f;
                }
            }
            return 1.8f;
        }
        return 1.8f;
    }
}

