/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import java.util.Iterator;
import java.util.Map;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeAwakeBlade
extends ShapedOreRecipe {
    ItemStack requiredStateBlade = null;

    public RecipeAwakeBlade(ItemStack result, ItemStack requiredStateBlade, Object ... recipe) {
        super(result, recipe);
        this.requiredStateBlade = requiredStateBlade;
    }

    int tagValueCompare(TagPropertyAccessor access, NBTTagCompound reqTag, NBTTagCompound srcTag) {
        return access.get(reqTag).compareTo(access.get(srcTag));
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        boolean result = super.func_77569_a(inv, world);
        if (result && this.requiredStateBlade != null) {
            for (int idx = 0; idx < inv.func_70302_i_(); ++idx) {
                ItemStack curIs = inv.func_70301_a(idx);
                if (curIs == null || !(curIs.func_77973_b() instanceof ItemSlashBlade) || !curIs.func_77942_o()) continue;
                Map oldItemEnchants = EnchantmentHelper.func_82781_a((ItemStack)this.requiredStateBlade);
                for (Map.Entry enchant : oldItemEnchants.entrySet()) {
                    int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)enchant.getKey()), (ItemStack)curIs);
                    if (level >= (Integer)enchant.getValue()) continue;
                    return false;
                }
                NBTTagCompound reqTag = ItemSlashBlade.getItemTagCompound(this.requiredStateBlade);
                NBTTagCompound srcTag = ItemSlashBlade.getItemTagCompound(curIs);
                if (!curIs.func_77977_a().equals(this.requiredStateBlade.func_77977_a())) {
                    return false;
                }
                if (0 < this.tagValueCompare(ItemSlashBlade.ProudSoul, reqTag, srcTag)) {
                    return false;
                }
                if (0 < this.tagValueCompare(ItemSlashBlade.KillCount, reqTag, srcTag)) {
                    return false;
                }
                if (0 >= this.tagValueCompare(ItemSlashBlade.RepairCount, reqTag, srcTag)) break;
                return false;
            }
        }
        return result;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        ItemStack result = super.func_77572_b(var1);
        for (int idx = 0; idx < var1.func_70302_i_(); ++idx) {
            String key;
            ItemStack tmp;
            ItemStack curIs = var1.func_70301_a(idx);
            if (curIs == null || !(curIs.func_77973_b() instanceof ItemSlashBlade) || !curIs.func_77942_o()) continue;
            NBTTagCompound oldTag = curIs.func_77978_p();
            oldTag = oldTag.func_74737_b();
            NBTTagCompound newTag = ItemSlashBlade.getItemTagCompound(result);
            if (ItemSlashBladeNamed.CurrentItemName.exists(newTag) && (tmp = SlashBlade.getCustomBlade(key = ItemSlashBladeNamed.CurrentItemName.get(newTag))) != null) {
                result = tmp;
            }
            newTag = ItemSlashBlade.getItemTagCompound(result);
            ItemSlashBlade.KillCount.set(newTag, ItemSlashBlade.KillCount.get(oldTag));
            ItemSlashBlade.ProudSoul.set(newTag, ItemSlashBlade.ProudSoul.get(oldTag));
            ItemSlashBlade.RepairCount.set(newTag, ItemSlashBlade.RepairCount.get(oldTag));
            if (oldTag.func_186855_b("Owner")) {
                newTag.func_186854_a("Owner", oldTag.func_186857_a("Owner"));
            }
            if (oldTag.func_74764_b("adjustX")) {
                newTag.func_74776_a("adjustX", oldTag.func_74760_g("adjustX"));
            }
            if (oldTag.func_74764_b("adjustY")) {
                newTag.func_74776_a("adjustY", oldTag.func_74760_g("adjustY"));
            }
            if (oldTag.func_74764_b("adjustZ")) {
                newTag.func_74776_a("adjustZ", oldTag.func_74760_g("adjustZ"));
            }
            Map newItemEnchants = EnchantmentHelper.func_82781_a((ItemStack)result);
            Map oldItemEnchants = EnchantmentHelper.func_82781_a((ItemStack)curIs);
            Iterator iterator = oldItemEnchants.keySet().iterator();
            while (iterator.hasNext()) {
                Enchantment enchantIndex;
                Enchantment enchantment = enchantIndex = (Enchantment)iterator.next();
                int destLevel = newItemEnchants.containsKey(enchantIndex) ? (Integer)newItemEnchants.get(enchantIndex) : 0;
                int srcLevel = (Integer)oldItemEnchants.get(enchantIndex);
                srcLevel = Math.max(srcLevel, destLevel);
                srcLevel = Math.min(srcLevel, enchantment.func_77325_b());
                boolean canApplyFlag = enchantment.func_92089_a(result);
                if (!canApplyFlag) continue;
                for (Enchantment curEnchantIndex : newItemEnchants.keySet()) {
                    if (curEnchantIndex == enchantIndex || enchantment.func_77326_a(curEnchantIndex)) continue;
                    canApplyFlag = false;
                    break;
                }
                if (!canApplyFlag) continue;
                newItemEnchants.put(enchantIndex, srcLevel);
            }
            EnchantmentHelper.func_82782_a((Map)newItemEnchants, (ItemStack)result);
        }
        return result;
    }
}

