/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import net.minecraft.nbt.NBTTagCompound;

public abstract class TagPropertyAccessor<T extends Comparable> {
    protected final String tagName;

    public TagPropertyAccessor(String tagName) {
        this.tagName = tagName;
    }

    public boolean exists(NBTTagCompound tag) {
        return tag.func_74764_b(this.tagName);
    }

    public void remove(NBTTagCompound tag) {
        if (this.exists(tag)) {
            tag.func_82580_o(this.tagName);
        }
    }

    public abstract T get(NBTTagCompound var1);

    public T get(NBTTagCompound tag, T defaultValue) {
        return this.exists(tag) ? this.get(tag) : defaultValue;
    }

    public abstract T set(NBTTagCompound var1, T var2);

    public static class TagPropertyFloat
    extends TagPropertyAccessor<Float> {
        public TagPropertyFloat(String tagName) {
            super(tagName);
        }

        @Override
        public Float get(NBTTagCompound tag) {
            return Float.valueOf(tag.func_74760_g(this.tagName));
        }

        @Override
        public Float set(NBTTagCompound tag, Float value) {
            tag.func_74776_a(this.tagName, value.floatValue());
            return value;
        }

        @Override
        public float get(NBTTagCompound tag, float defaultValue) {
            return tag.func_74764_b(this.tagName) ? tag.func_74760_g(this.tagName) : defaultValue;
        }
    }

    public static class TagPropertyIntegerWithRange
    extends TagPropertyInteger {
        private int min;
        private int max;

        public TagPropertyIntegerWithRange(String tagName, int min, int max) {
            super(tagName);
            this.min = min;
            this.max = max;
        }

        @Override
        public Integer set(NBTTagCompound tag, Integer value) {
            if (value < this.min) {
                value = this.min;
            } else if (this.max < value) {
                value = this.max;
            }
            return super.set(tag, value);
        }

        public boolean tryAdd(NBTTagCompound tag, Integer add, boolean forceAdd) {
            boolean doSet;
            int value = this.get(tag);
            boolean bl = doSet = forceAdd || this.min <= (value += add.intValue()) && value <= this.max;
            if (doSet) {
                this.set(tag, value);
            }
            return doSet;
        }
    }

    public static class TagPropertyInteger
    extends TagPropertyAccessor<Integer> {
        public TagPropertyInteger(String tagName) {
            super(tagName);
        }

        @Override
        public Integer get(NBTTagCompound tag) {
            return tag.func_74762_e(this.tagName);
        }

        @Override
        public Integer set(NBTTagCompound tag, Integer value) {
            tag.func_74768_a(this.tagName, value.intValue());
            return value;
        }

        public Integer add(NBTTagCompound tag, Integer value) {
            Integer result = this.get(tag) + value;
            return this.set(tag, result);
        }
    }

    public static class TagPropertyLong
    extends TagPropertyAccessor<Long> {
        public TagPropertyLong(String tagName) {
            super(tagName);
        }

        @Override
        public Long get(NBTTagCompound tag) {
            return tag.func_74763_f(this.tagName);
        }

        @Override
        public Long set(NBTTagCompound tag, Long value) {
            tag.func_74772_a(this.tagName, value.longValue());
            return value;
        }

        public Long add(NBTTagCompound tag, Long value) {
            Long result = this.get(tag) + value;
            return this.set(tag, result);
        }
    }

    public static class TagPropertyBoolean
    extends TagPropertyAccessor<Boolean> {
        public TagPropertyBoolean(String tagName) {
            super(tagName);
        }

        @Override
        public Boolean get(NBTTagCompound tag) {
            return tag.func_74767_n(this.tagName);
        }

        @Override
        public Boolean set(NBTTagCompound tag, Boolean value) {
            tag.func_74757_a(this.tagName, value.booleanValue());
            return value;
        }

        public Boolean invert(NBTTagCompound tag) {
            return this.set(tag, this.get(tag) == false);
        }
    }

    public static class TagPropertyString
    extends TagPropertyAccessor<String> {
        public TagPropertyString(String tagName) {
            super(tagName);
        }

        @Override
        public String get(NBTTagCompound tag) {
            return tag.func_74779_i(this.tagName);
        }

        @Override
        public String set(NBTTagCompound tag, String value) {
            tag.func_74778_a(this.tagName, value);
            return value;
        }
    }
}

