/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability.client;

import mods.flammpfeil.slashblade.ability.StylishRankManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class StylishRankRenderer {
    static ResourceLocation RankImg = new ResourceLocation("flammpfeil.slashblade", "textures/gui/rank.png");

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.field_71441_e;
        if (event.phase == TickEvent.Phase.START || !(Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
        long time = System.currentTimeMillis();
        if (player != null && mc.field_71415_G) {
            Minecraft _tmp2 = mc;
            if (Minecraft.func_71382_s()) {
                this.renderRankHud(Float.valueOf(event.renderTickTime), player, time);
            }
        }
    }

    private void renderRankHud(Float partialTicks, EntityPlayer player, long time) {
        Minecraft mc = Minecraft.func_71410_x();
        int rank = StylishRankManager.getStylishRank((Entity)player);
        if (rank <= 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)mc.field_71443_c, (double)mc.field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = mc.field_71443_c;
        int l = mc.field_71440_d;
        GL11.glTranslatef((float)(k * 2 / 3), (float)(l / 5), (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(RankImg);
        long lastUpdate = StylishRankManager.LastRankPointUpdate.get(player.getEntityData());
        long now = player.field_70170_p.func_82737_E();
        boolean showTextRank = false;
        if (now < lastUpdate + 60L) {
            showTextRank = true;
        }
        GL11.glPushMatrix();
        if (now < lastUpdate + 120L) {
            int rankOffset = 32 * (rank - 1);
            int textOffset = showTextRank ? 128 : 0;
            GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
            StylishRankRenderer.drawTexturedQuad(0, 0, textOffset, rankOffset, 128, 32, -90.0);
            StylishRankRenderer.drawTexturedQuad(0, 32, 0, 240, 64, 16, -90.0);
            StylishRankRenderer.drawTexturedQuad(16, 32, 16, 224, (int)(32.0f * StylishRankManager.getCurrentProgress((Entity)player)), 16, -95.0);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawTexturedQuad(int par1, int par2, int par3, int par4, int par5, int par6, double zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)(par1 + 0), (double)(par2 + par6), zLevel).func_187315_a(((double)par3 + 0.0) * (double)var7, (double)((float)(par4 + par6) * var8)).func_181675_d();
        wr.func_181662_b((double)(par1 + par5), (double)(par2 + par6), zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        wr.func_181662_b((double)(par1 + par5), (double)(par2 + 0), zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        wr.func_181662_b((double)(par1 + 0), (double)(par2 + 0), zLevel).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        tessellator.func_78381_a();
    }
}

