/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.model.obj;

import mods.flammpfeil.slashblade.client.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.model.obj.Vertex;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Face {
    public static boolean isSmoothShade = true;
    public static int defaultColor = -1;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setColor(int color) {
        defaultColor = color;
    }

    public static void resetColor() {
        defaultColor = -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(Tessellator tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(Tessellator tessellator, float textureOffset) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        VertexBuffer wr = tessellator.func_178180_c();
        for (int i = 0; i < this.vertices.length; ++i) {
            wr.func_181662_b((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z);
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                wr.func_187315_a((double)(this.textureCoordinates[i].u + offsetU), (double)(this.textureCoordinates[i].v + offsetV));
            } else {
                wr.func_187315_a(0.0, 0.0);
            }
            int r = defaultColor >> 16 & 0xFF;
            int g = defaultColor >> 8 & 0xFF;
            int b = defaultColor & 0xFF;
            int a = defaultColor >> 24 & 0xFF;
            wr.func_181669_b(r, g, b, a);
            if (isSmoothShade && this.vertexNormals != null) {
                Vertex normal = this.vertexNormals[i];
                float scale = -1.05f;
                wr.func_181663_c(normal.x * scale, normal.y * scale, normal.z * scale);
            } else {
                wr.func_181663_c(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            }
            wr.func_181675_d();
        }
    }

    public Vertex calculateFaceNormal() {
        Vec3d v1 = new Vec3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vec3d v2 = new Vec3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vec3d normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }
}

