/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.ProjectileBarrier;
import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.entity.layers.LayerSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class BladeFirstPersonRender {
    private static final ResourceLocation armoredCreeperTextures = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static WavefrontObject trailModel = null;
    public static ResourceLocation modelLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/trail.obj");
    public static ResourceLocation textureLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/trail.png");
    LayerSlashBlade.RingState ringStates = new LayerSlashBlade.RingState(){

        @Override
        public void transform() {
            super.transform();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)3.0f, (float)50.0f, (float)0.0f);
            float scale = 0.25f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            long ticks = Minecraft.func_71410_x().field_71441_e == null ? 0L : Minecraft.func_71410_x().field_71441_e.func_72820_D();
            float partialTicks = ReflectionAccessHelper.getPartialTicks();
            double rotate = (double)((float)(ticks % 1500L) + partialTicks) / 1500.0 * 180.0;
            GL11.glRotated((double)rotate, (double)0.0, (double)1.0, (double)0.0);
        }
    };

    private BladeFirstPersonRender() {
    }

    public static BladeFirstPersonRender getInstance() {
        return SingletonHolder.instance;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (event.isCanceled()) {
            return;
        }
        this.render();
    }

    public void render() {
        boolean flag;
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = flag = mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)mc.func_175606_aa()).func_70608_bn();
        if (mc.field_71474_y.field_74320_O != 0 || flag || mc.field_71474_y.field_74319_N || mc.field_71442_b.func_78747_a()) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade itemBlade = (ItemSlashBlade)stack.func_77973_b();
        EnumSet<ItemSlashBlade.SwordType> swordType = itemBlade.getSwordType(stack);
        GlStateManager.func_179123_a();
        int xOffset = MinecraftForgeClient.getRenderPass();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float f = 0.07f;
        if (mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(-(xOffset * 2 - 1)) * f), (float)0.0f, (float)0.0f);
        }
        Project.gluPerspective((float)70.0f, (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)32.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        if (mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(xOffset * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        float partialTicks = mc.func_184121_ak();
        if (swordType.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
            this.func_178110_a(player, partialTicks);
            float f1 = player.func_70678_g(partialTicks);
            this.func_178105_d(f1);
            this.transformFirstPersonItem(0.0f, f1);
            this.renderNakedBlade((EntityLivingBase)player, partialTicks);
        } else {
            this.func_178109_a((AbstractClientPlayer)player);
            GL11.glTranslatef((float)-0.35f, (float)-0.1f, (float)-0.8f);
            GL11.glRotatef((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Face.resetColor();
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            GL11.glRotatef((float)-25.0f, (float)0.9f, (float)0.1f, (float)0.0f);
            GL11.glScalef((float)1.2f, (float)1.0f, (float)1.0f);
            this.render((EntityLivingBase)player, partialTicks);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179099_b();
    }

    void renderNakedBlade(EntityLivingBase entity, float partialTicks) {
        ItemStack stack = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade itemBlade = (ItemSlashBlade)stack.func_77973_b();
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(stack));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(stack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
        EnumSet<ItemSlashBlade.SwordType> swordType = itemBlade.getSwordType(stack);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
        float scale = 0.015f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        String[] renderTargets = swordType.contains((Object)ItemSlashBlade.SwordType.Broken) ? new String[]{"blade_damaged"} : new String[]{"blade"};
        model.renderOnly(renderTargets);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (String renderTarget : renderTargets) {
            model.renderPart(renderTarget + "_luminous");
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void func_178109_a(AbstractClientPlayer clientPlayer) {
        int i = Minecraft.func_71410_x().field_71441_e.func_175626_b(new BlockPos(clientPlayer.field_70165_t, clientPlayer.field_70163_u + (double)clientPlayer.func_70047_e(), clientPlayer.field_70161_v), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
    }

    private void func_178110_a(EntityPlayerSP entityplayerspIn, float partialTicks) {
        float f = entityplayerspIn.field_71164_i + (entityplayerspIn.field_71155_g - entityplayerspIn.field_71164_i) * partialTicks;
        float f1 = entityplayerspIn.field_71163_h + (entityplayerspIn.field_71154_f - entityplayerspIn.field_71163_h) * partialTicks;
        GlStateManager.func_179114_b((float)((entityplayerspIn.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((entityplayerspIn.field_70177_z - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void func_178105_d(float p_178105_1_) {
        float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_178105_1_) * (float)Math.PI));
        float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_178105_1_) * (float)Math.PI * 2.0f));
        float f2 = -0.2f * MathHelper.func_76126_a((float)(p_178105_1_ * (float)Math.PI));
        GlStateManager.func_179109_b((float)f, (float)f1, (float)f2);
    }

    private void transformFirstPersonItem(float equipProgress, float swingProgress) {
        GlStateManager.func_179109_b((float)0.56f, (float)-0.52f, (float)-0.71999997f);
        GlStateManager.func_179109_b((float)0.0f, (float)(equipProgress * -0.6f), (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * -20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
    }

    void render(EntityLivingBase entity, float partialTicks) {
        String renderTarget;
        if (trailModel == null) {
            trailModel = new WavefrontObject(modelLocation);
        }
        boolean adjust = false;
        if (entity == null) {
            return;
        }
        ItemStack stack = entity.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offhand = entity.func_184586_b(EnumHand.OFF_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade itemBlade = (ItemSlashBlade)stack.func_77973_b();
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(stack));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(stack);
        EnumSet<ItemSlashBlade.SwordType> swordType = itemBlade.getSwordType(stack);
        boolean isEnchanted = swordType.contains((Object)ItemSlashBlade.SwordType.Enchanted);
        int charge = entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_184612_cw() : 0;
        boolean doProjectileBarrier = ProjectileBarrier.isAvailable(entity, stack, entity.func_184605_cv());
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        boolean isBroken = swordType.contains((Object)ItemSlashBlade.SwordType.Broken);
        ItemSlashBlade.ComboSequence combo = ItemSlashBlade.ComboSequence.None;
        int color = 0x3333FF;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            combo = ItemSlashBlade.getComboSequence(tag);
            if (adjust) {
                ax = tag.func_74760_g("adjustX") / 10.0f;
                ay = -tag.func_74760_g("adjustY") / 10.0f;
                az = -tag.func_74760_g("adjustZ") / 10.0f;
            }
            if (ItemSlashBlade.SummonedSwordColor.exists(tag) && (color = ItemSlashBlade.SummonedSwordColor.get(tag).intValue()) < 0) {
                color = -color;
            }
        }
        WavefrontObject offhandModel = null;
        ResourceLocation offHandResourceTexture = null;
        boolean offhandIsBroken = false;
        int offhandColor = 0x3333FF;
        if (offhand != null && offhand.func_77973_b() instanceof ItemSlashBlade) {
            NBTTagCompound tag;
            ItemSlashBlade offhandItemBlade = (ItemSlashBlade)offhand.func_77973_b();
            offhandModel = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(offhand));
            offHandResourceTexture = ItemSlashBlade.getModelTexture(offhand);
            EnumSet<ItemSlashBlade.SwordType> offHandSwordType = offhandItemBlade.getSwordType(offhand);
            offhandIsBroken = offHandSwordType.contains((Object)ItemSlashBlade.SwordType.Broken);
            if (offhand.func_77942_o() && ItemSlashBlade.SummonedSwordColor.exists(tag = offhand.func_77978_p()) && (offhandColor = ItemSlashBlade.SummonedSwordColor.get(tag).intValue()) < 0) {
                offhandColor = -offhandColor;
            }
        }
        float progress = entity.func_70678_g(partialTicks);
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && entity.field_70733_aJ == 0.0f) {
            progress = 1.0f;
        }
        if (1.0f < (progress = (float)((double)progress * 1.2))) {
            progress = 1.0f;
        }
        switch (combo) {
            case SIai: 
            case Iai: {
                progress = 1.0f - Math.abs(progress - 0.5f) * 2.0f;
                break;
            }
            case HiraTuki: 
            case Stinger: {
                progress = 1.0f;
                break;
            }
            default: {
                progress = 1.0f - progress;
                progress = 1.0f - (float)Math.pow(progress, 2.0);
            }
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)ax, (float)ay, (float)az);
        GL11.glTranslatef((float)0.25f, (float)0.4f, (float)-0.5f);
        float scale = 0.075f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float xoffset = 10.0f;
        float yoffset = 8.0f;
        GL11.glPushMatrix();
        boolean doOffhandRender = false;
        int handsLoop = 1;
        if (combo.mainHandCombo != null) {
            handsLoop = 2;
            if (offhand != null && offhand.func_77973_b() instanceof ItemSlashBlade) {
                doOffhandRender = true;
            }
        }
        float handsLoopProgressTmp = progress;
        ItemSlashBlade.ComboSequence comboSequenceTmp = combo;
        boolean tmpIsBroken = isBroken;
        ResourceLocation tmpResourceTexture = resourceTexture;
        WavefrontObject tmpModel = model;
        int tmpColor = color;
        ItemStack tmpStack = stack;
        for (int handsLoopIdx = 0; handsLoopIdx < handsLoop; ++handsLoopIdx) {
            GL11.glPushMatrix();
            if (doOffhandRender && handsLoopIdx == 0) {
                isBroken = offhandIsBroken;
                resourceTexture = offHandResourceTexture != null ? offHandResourceTexture : tmpResourceTexture;
                model = offhandModel != null ? offhandModel : tmpModel;
                color = offhandColor;
                stack = offhand;
            } else if (handsLoopIdx == 1) {
                combo = comboSequenceTmp.mainHandCombo;
                progress = 1.0f;
                isBroken = tmpIsBroken;
                resourceTexture = tmpResourceTexture;
                model = tmpModel;
                color = tmpColor;
                stack = tmpStack;
            }
            if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None)) {
                float tmp = progress;
                if (combo.swingAmplitude < 0.0f) {
                    progress = 1.0f - progress;
                }
                if (combo.equals((Object)ItemSlashBlade.ComboSequence.Stinger) || combo.equals((Object)ItemSlashBlade.ComboSequence.HiraTuki)) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-26.0f);
                }
                if (combo.equals((Object)ItemSlashBlade.ComboSequence.Kiriorosi)) {
                    GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-8.0f);
                    GL11.glRotatef((float)(90.0f - combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glRotatef((float)((1.0f - progress) * -90.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)((1.0f - progress) * -5.0f), (float)0.0f);
                    GL11.glTranslatef((float)((1.0f - progress) * 10.0f), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    progress = 1.0f;
                    if (0.0f < combo.swingAmplitude) {
                        GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    } else {
                        GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (combo.swingDirection < 0.0f) {
                    GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-12.0f);
                    GL11.glRotatef((float)(90.0f + combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glRotatef((float)((1.0f - progress) * -240.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    progress = 1.0f;
                    if (0.0f < combo.swingAmplitude) {
                        GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    } else {
                        GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    if (0.0f < combo.swingAmplitude) {
                        GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    } else {
                        GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                }
                progress = tmp;
            } else if (doProjectileBarrier) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)60.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)-14.0f, (float)0.0f, (float)0.0f);
                int span = 7;
                float rotParTicks = 51.42857f;
                GL11.glRotatef((float)(rotParTicks *= (float)(entity.field_70173_aa % 7) + partialTicks), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.0f, (float)-3.0f, (float)0.0f);
                progress = 0.5f;
            }
            renderTarget = isBroken ? "blade_damaged" : "blade";
            float scaleLocal = 0.095f;
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            model.renderPart(renderTarget);
            if (!combo.useScabbard) {
                model.renderPart(renderTarget + "_unsheathe");
            }
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart(renderTarget + "_luminous");
            if (!combo.useScabbard) {
                model.renderPart(renderTarget + "_unsheathe_luminous");
            }
            if (!combo.useScabbard && combo != ItemSlashBlade.ComboSequence.Noutou && combo != ItemSlashBlade.ComboSequence.HiraTuki && combo != ItemSlashBlade.ComboSequence.Stinger || doProjectileBarrier) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179132_a((boolean)false);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
                double alpha = Math.sin((double)progress * Math.PI);
                if (doProjectileBarrier) {
                    GlStateManager.func_179139_a((double)1.0, (double)0.8, (double)1.0);
                } else if (isBroken) {
                    GlStateManager.func_179139_a((double)0.4, (double)0.5, (double)1.0);
                } else {
                    GlStateManager.func_179139_a((double)1.0, (double)(alpha * 2.0), (double)1.0);
                }
                GlStateManager.func_179114_b((float)((float)(10.0 * (1.0 - alpha))), (float)0.0f, (float)0.0f, (float)1.0f);
                OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                GlStateManager.func_187398_d((int)32779);
                Face.setColor(0xFFFFFF - color | 0xFF000000 & (int)(1.711276032E9 * alpha));
                trailModel.renderAll();
                GlStateManager.func_187398_d((int)32774);
                Face.setColor(color | 0xFF000000 & (int)(-1.6777216E7 * alpha));
                trailModel.renderAll();
                Face.resetColor();
                GlStateManager.func_179132_a((boolean)true);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
                GlStateManager.func_179121_F();
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            this.ringStates.renderRing();
            if (stack.func_77962_s() && SlashBlade.RenderEnchantEffect) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                Face.setColor(-8372020);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                Face.resetColor();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        progress = handsLoopProgressTmp;
        combo = comboSequenceTmp;
        isBroken = tmpIsBroken;
        resourceTexture = tmpResourceTexture;
        model = tmpModel;
        color = tmpColor;
        stack = tmpStack;
        GL11.glPushMatrix();
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && combo.useScabbard) {
            if (combo.swingAmplitude < 0.0f) {
                progress = 1.0f - progress;
            }
            GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
            if (0.0f < combo.swingAmplitude) {
                GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            } else {
                GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
            GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        float scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        renderTarget = "sheath";
        model.renderPart(renderTarget);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (stack.func_77962_s() && SlashBlade.RenderEnchantEffect) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Face.resetColor();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        if (!isBroken && isEnchanted && (ItemSlashBlade.RequiredChargeTick < charge || combo.isCharged)) {
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            float f4 = 3.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)3.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("sheath");
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            float ff1 = (float)entity.field_70173_aa + partialTicks;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(armoredCreeperTextures);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f2 = ff1 * 0.03f;
            float f3 = ff1 * 0.02f;
            GL11.glTranslatef((float)f2, (float)(-f3), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)3042);
            f4 = 1.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("effect");
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static final class SingletonHolder {
        private static final BladeFirstPersonRender instance = new BladeFirstPersonRender();

        private SingletonHolder() {
        }
    }
}

