/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Map;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.GroupObject;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BladeStandRender
extends Render {
    public static WavefrontObject standModel = null;
    public static ResourceLocation modelLocation = new ResourceLocation("flammpfeil.slashblade", "model/stand/stand.obj");
    public static ResourceLocation textureLocation = new ResourceLocation("flammpfeil.slashblade", "model/stand/stand.png");
    public static Map<EntityBladeStand.StandType, String> nameMap = BladeStandRender.createNameMap();
    public static Map<EntityBladeStand.StandType, String> StandTypeName = BladeStandRender.createStandTypeNameMap();

    public BladeStandRender(RenderManager renderManager) {
        super(renderManager);
    }

    private TextureManager engine() {
        return this.field_76990_c.field_78724_e;
    }

    private static <K, V> Map<K, V> createNameMap() {
        nameMap = Maps.newHashMap();
        nameMap.put(EntityBladeStand.StandType.Dual, "A");
        nameMap.put(EntityBladeStand.StandType.Single, "B");
        nameMap.put(EntityBladeStand.StandType.Upright, "C");
        nameMap.put(EntityBladeStand.StandType.Wall, "D");
        return nameMap;
    }

    private static <K, V> Map<K, V> createStandTypeNameMap() {
        StandTypeName = Maps.newHashMap();
        StandTypeName.put(EntityBladeStand.StandType.Dual, "dual");
        StandTypeName.put(EntityBladeStand.StandType.Single, "single");
        StandTypeName.put(EntityBladeStand.StandType.Upright, "upright");
        StandTypeName.put(EntityBladeStand.StandType.Wall, "wall");
        return StandTypeName;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialRenderTick) {
        if (this.field_188301_f) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179142_g();
            float h = (float)(entity.field_70173_aa % 80) / 80.0f;
            GlStateManager.func_187431_e((int)Color.getHSBColor(h, 0.5f, 1.0f).getRGB());
        }
        this.renderModel(entity, x, y, z, yaw, partialRenderTick);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
            GlStateManager.func_179145_e();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
        if (entity.func_70027_ad()) {
            this.renderEntityOnFire(entity, x, y, z, partialRenderTick);
        }
    }

    public void renderModel(Entity entity, double x, double y, double z, float yaw, float partialRenderTick) {
        ItemStack blade;
        if (standModel == null) {
            standModel = new WavefrontObject(modelLocation);
        }
        this.func_180548_c(entity);
        EntityBladeStand e = (EntityBladeStand)entity;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float scale = 0.00675f;
        EntityBladeStand.StandType type = EntityBladeStand.getType(e);
        boolean HFlip = false;
        boolean VFlip = false;
        switch (e.getFlip()) {
            case 1: {
                HFlip = false;
                VFlip = true;
                break;
            }
            case 2: {
                HFlip = true;
                VFlip = false;
                break;
            }
            case 3: {
                VFlip = true;
                HFlip = true;
                break;
            }
            default: {
                HFlip = false;
                VFlip = false;
            }
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)-1.0f, (float)0.0f);
        if (type != EntityBladeStand.StandType.Naked) {
            GL11.glPushMatrix();
            if (type == EntityBladeStand.StandType.Wall) {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            String renderTarget = nameMap.get((Object)type);
            standModel.renderPart(renderTarget);
            GL11.glPopMatrix();
        }
        if ((blade = e.getBlade()) != null) {
            GL11.glPushMatrix();
            GL11.glShadeModel((int)7425);
            Item item = blade.func_77973_b();
            EnumSet<ItemSlashBlade.SwordType> types = ((ItemSlashBlade)item).getSwordType(blade);
            WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(blade));
            ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(blade);
            this.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            boolean isProcessed = false;
            if (model instanceof WavefrontObject) {
                WavefrontObject obj = model;
                StringBuilder sb = new StringBuilder();
                sb.append("stand_");
                sb.append(StandTypeName.get((Object)type));
                if (types.contains((Object)ItemSlashBlade.SwordType.Broken)) {
                    sb.append("_damaged");
                }
                if (types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                    sb.append("_ns");
                }
                String targetBase = sb.toString();
                sb.append(HFlip ? "_r" : "_l");
                sb.append(VFlip ? "_u" : "_d");
                String targetFull = sb.toString();
                String renderTarget = null;
                for (GroupObject go : obj.groupObjects) {
                    if (!go.name.toLowerCase().equals(targetBase) && !go.name.toLowerCase().equals(targetFull)) continue;
                    renderTarget = go.name;
                    break;
                }
                if (renderTarget != null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    model.renderPart(renderTarget);
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    float lastx = OpenGlHelper.lastBrightnessX;
                    float lasty = OpenGlHelper.lastBrightnessY;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                    GL11.glBlendFunc((int)770, (int)1);
                    model.renderPart(renderTarget + "_luminous");
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                    isProcessed = true;
                }
            }
            if (!(isProcessed || item instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(blade))) {
                GL11.glPushMatrix();
                float hFlipFactor = HFlip ? -1.0f : 1.0f;
                switch (type) {
                    case Naked: {
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        if (!types.contains((Object)ItemSlashBlade.SwordType.Broken)) {
                            GL11.glTranslatef((float)0.0f, (float)200.0f, (float)0.0f);
                        } else {
                            GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                        }
                        GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case Dual: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.125f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        if (!HFlip) break;
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case Wall: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
                    }
                    case Single: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        if (HFlip) {
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case Upright: {
                        if (VFlip) {
                            GL11.glRotatef((float)2.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
                        }
                        if (!HFlip) {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)-17.277f, (float)235.96f, (float)0.0f);
                            GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)27.597f, (float)-21.674f, (float)0.0f);
                            GL11.glRotatef((float)103.35f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        if (HFlip) {
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                String renderTarget = types.contains((Object)ItemSlashBlade.SwordType.Broken) ? "blade_damaged" : "blade";
                model.renderPart(renderTarget);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                float lastx = OpenGlHelper.lastBrightnessX;
                float lasty = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glBlendFunc((int)770, (int)1);
                model.renderPart(renderTarget + "_luminous");
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            if (!isProcessed && !types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                GL11.glPushMatrix();
                float hFlipFactor = HFlip ? -1.0f : 1.0f;
                float vFlipFactor = VFlip ? -1.0f : 1.0f;
                switch (type) {
                    case Naked: {
                        if (HFlip) {
                            GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
                        }
                        GL11.glTranslatef((float)1.5f, (float)-0.45f, (float)0.5f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        if (!HFlip) break;
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case Dual: {
                        GL11.glTranslatef((float)(1.1f * hFlipFactor), (float)-0.17722f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case Wall: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
                    }
                    case Single: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case Upright: {
                        if (VFlip) {
                            GL11.glRotatef((float)2.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
                        }
                        if (!HFlip) {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)-17.277f, (float)235.96f, (float)0.0f);
                            GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            break;
                        }
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glTranslatef((float)27.597f, (float)-21.674f, (float)0.0f);
                        GL11.glRotatef((float)103.35f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                if (HFlip) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (VFlip) {
                    GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                    GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                String renderTarget = "sheath";
                model.renderPart(renderTarget);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                float lastx = OpenGlHelper.lastBrightnessX;
                float lasty = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glBlendFunc((int)770, (int)1);
                model.renderPart(renderTarget + "_luminous");
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                GL11.glEnable((int)2896);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glPopMatrix();
            }
            GL11.glShadeModel((int)7424);
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return textureLocation;
    }

    private void renderEntityOnFire(Entity entity, double x, double y, double z, float partialTicks) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite textureatlassprite = texturemap.func_110572_b("minecraft:blocks/fire_layer_0");
        TextureAtlasSprite textureatlassprite1 = texturemap.func_110572_b("minecraft:blocks/fire_layer_1");
        int i = 0;
        for (int re = 0; re < 3; ++re) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            float f = entity.field_70130_N * 1.4f;
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            float f1 = 0.5f;
            float f2 = 0.0f;
            float f3 = entity.field_70131_O / f;
            float f4 = (float)(entity.field_70163_u - entity.func_174813_aQ().field_72338_b);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f3) * 0.02f - (float)re * 0.2f));
            if (0 < re) {
                float reScale = 1.0f / ((float)re + 0.25f);
                GlStateManager.func_179139_a((double)reScale, (double)0.75, (double)reScale);
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179131_c((float)0.1f, (float)0.0f, (float)1.0f, (float)1.0f);
            float f5 = 0.0f;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            while (f3 > 0.0f) {
                TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
                this.func_110776_a(TextureMap.field_110575_b);
                float f6 = textureatlassprite2.func_94209_e();
                float f7 = textureatlassprite2.func_94206_g();
                float f8 = textureatlassprite2.func_94212_f();
                float f9 = textureatlassprite2.func_94210_h();
                if (i / 2 % 2 == 0) {
                    float f10 = f8;
                    f8 = f6;
                    f6 = f10;
                }
                vertexbuffer.func_181662_b((double)(f1 - f2), (double)(0.0f - f4), (double)f5).func_187315_a((double)f8, (double)f9).func_181675_d();
                vertexbuffer.func_181662_b((double)(-f1 - f2), (double)(0.0f - f4), (double)f5).func_187315_a((double)f6, (double)f9).func_181675_d();
                vertexbuffer.func_181662_b((double)(-f1 - f2), (double)(1.4f - f4), (double)f5).func_187315_a((double)f6, (double)f7).func_181675_d();
                vertexbuffer.func_181662_b((double)(f1 - f2), (double)(1.4f - f4), (double)f5).func_187315_a((double)f8, (double)f7).func_181675_d();
                f3 -= 0.45f;
                f4 -= 0.45f;
                f1 *= 0.9f;
                f5 += 0.03f;
                ++i;
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
    }
}

