/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.GroupObject;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class LockonCircleRender {
    static final ResourceLocation modelLoc = new ResourceLocation("flammpfeil.slashblade", "model/util/lockon.obj");
    static final ResourceLocation textureLoc = new ResourceLocation("flammpfeil.slashblade", "model/util/lockon.png");

    @SubscribeEvent
    public void onRenderLiving(RenderWorldLastEvent event) {
        ResourceLocation resourceTexture;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        int entityId = ItemSlashBlade.TargetEntityId.get(tag);
        if (entityId == 0) {
            return;
        }
        Entity target = player.field_70170_p.func_73045_a(entityId);
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        if (!target.func_70089_S()) {
            return;
        }
        float health = 1.0f - ((EntityLivingBase)target).func_110143_aJ() / ((EntityLivingBase)target).func_110138_aP();
        float partialTicks = event.getPartialTicks();
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int color = 0x3333FF;
        if (ItemSlashBlade.SummonedSwordColor.exists(tag) && (color = ItemSlashBlade.SummonedSwordColor.get(tag).intValue()) < 0) {
            color = -color;
        }
        GL11.glPushMatrix();
        Vec3d pos = this.lerp(new Vec3d(target.field_70169_q, target.field_70167_r, target.field_70166_s), target.func_174791_d(), (double)partialTicks).func_72441_c(0.0, (double)target.field_70131_O / 2.0, 0.0).func_72441_c(-d3, -d4, -d5);
        GL11.glTranslated((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
        float scale = 0.00625f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        double rotYaw = this.lerp(entity.field_70126_B, entity.field_70177_z, partialTicks);
        double rotPitch = this.lerp(entity.field_70127_C, entity.field_70125_A, partialTicks);
        GL11.glRotated((double)(rotYaw + 180.0), (double)0.0, (double)-1.0, (double)0.0);
        GL11.glRotated((double)rotPitch, (double)-1.0, (double)0.0, (double)0.0);
        GlStateManager.func_179129_p();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)519, (float)0.05f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179103_j((int)7425);
        boolean useCustom = false;
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(stack));
        for (GroupObject group : model.groupObjects) {
            if (!group.name.equals("lockonBase")) continue;
            useCustom = true;
            break;
        }
        if (useCustom) {
            resourceTexture = ItemSlashBlade.getModelTexture(stack);
            color = 0xFFFFFF;
        } else {
            model = BladeModelManager.getInstance().getModel(modelLoc);
            resourceTexture = textureLoc;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
        Face.setColor(0xAA000000 | color);
        model.renderPart("lockonBase");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(health * 10.0f));
        Face.setColor(0);
        model.renderPart("lockonHealthMask");
        GL11.glPopMatrix();
        Face.setColor(0xAA000000 | color);
        GlStateManager.func_179143_c((int)515);
        model.renderPart("lockonHealth");
        Face.resetColor();
        GlStateManager.func_179092_a((int)518, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        GL11.glPopMatrix();
    }

    public double lerp(double a, double b, double amt) {
        return a * (1.0 - amt) + b * amt;
    }

    public float lerp(float a, float b, float amt) {
        return a * (1.0f - amt) + b * amt;
    }

    public Vec3d lerp(Vec3d a, Vec3d b, double amt) {
        return a.func_186678_a(1.0 - amt).func_178787_e(b.func_186678_a(amt));
    }
}

