/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import java.awt.Color;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.entity.EntitySlashDimension;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderSlashDimension
extends Render {
    public static WavefrontObject model = null;
    public static ResourceLocation modelLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/slashdim.obj");
    public static ResourceLocation textureLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/slashdim.png");

    public RenderSlashDimension(RenderManager renderManager) {
        super(renderManager);
    }

    private TextureManager engine() {
        return this.field_76990_c.field_78724_e;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialRenderTick) {
        if (this.field_188301_f) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179142_g();
            float cycleTicks = 40.0f;
            float b = Math.abs((float)entity.field_70173_aa % cycleTicks / cycleTicks - 0.5f) + 0.5f;
            GlStateManager.func_187431_e((int)Color.getHSBColor(0.0f, 0.0f, b).getRGB());
        }
        this.renderModel(entity, x, y, z, yaw, partialRenderTick);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
            GlStateManager.func_179145_e();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
    }

    public void renderModel(Entity entity, double x, double y, double z, float yaw, float partialRenderTick) {
        if (model == null) {
            model = new WavefrontObject(modelLocation);
        }
        this.func_180548_c(entity);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        int color = 0x5555FF;
        int lifetime = 20;
        if (entity instanceof EntitySlashDimension) {
            color = ((EntitySlashDimension)entity).getColor();
            lifetime = ((EntitySlashDimension)entity).getLifeTime();
        }
        boolean inverse = color < 0;
        double deathTime = lifetime;
        double baseAlpha = Math.sin(1.5707963267948966 * (Math.min(deathTime, (double)((float)(lifetime - entity.field_70173_aa) - partialRenderTick)) / deathTime));
        int seed = entity.getEntityData().func_74762_e("seed");
        int baseColor = color;
        Color col = new Color(baseColor);
        float[] hsb = Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
        baseColor = Color.getHSBColor(0.5f + hsb[0], hsb[1], 0.2f).getRGB() & 0xFFFFFF;
        baseColor |= (int)(102.0 * baseAlpha) << 24;
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float rotParTicks = 40.0f;
        float rot = (float)entity.field_70173_aa % rotParTicks / rotParTicks * 360.0f + partialRenderTick * (360.0f / rotParTicks);
        float scale = 0.01f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Face.setColor(baseColor);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_187398_d((int)32779);
        GL11.glPushMatrix();
        for (int i = 0; i < 5; ++i) {
            GL11.glScaled((double)0.95, (double)0.95, (double)0.95);
            model.renderPart("base");
        }
        GL11.glPopMatrix();
        int loop = 3;
        for (int i = 0; i < loop; ++i) {
            GL11.glPushMatrix();
            float ticks = 15.0f;
            float wave = ((float)entity.field_70173_aa + ticks / (float)loop * (float)i + partialRenderTick) % ticks;
            double waveScale = 1.0 + 0.03 * (double)wave;
            GL11.glScaled((double)waveScale, (double)waveScale, (double)waveScale);
            Face.setColor(baseColor & 0xFFFFFF | (int)(136.0f * ((ticks - wave) / ticks)) << 24);
            model.renderPart("base");
            GL11.glPopMatrix();
        }
        GlStateManager.func_187398_d((int)32774);
        int windCount = 5;
        for (int i = 0; i < windCount; ++i) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(360.0 / (double)windCount * (double)i), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)30.0, (double)0.0, (double)1.0, (double)0.0);
            double rotWind = 18.0;
            double offsetBase = 7.0;
            double offset = (double)i * offsetBase;
            double motionLen = offsetBase * (double)(windCount - 1);
            double ticks = (float)entity.field_70173_aa + partialRenderTick + (float)seed;
            double offsetTicks = ticks + offset;
            double progress = offsetTicks % motionLen / motionLen;
            double rad = Math.PI * 2;
            Face.setColor(color & 0xFFFFFF | (int)Math.min(0.0, 255.0 * Math.sin(rad *= progress)) << 24);
            double windScale = 0.4 + progress;
            GL11.glScaled((double)windScale, (double)windScale, (double)windScale);
            GL11.glRotated((double)(rotWind * offsetTicks), (double)0.0, (double)0.0, (double)1.0);
            model.renderPart("wind");
            GL11.glPopMatrix();
        }
        Face.resetColor();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return textureLocation;
    }
}

