/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.entity.EntityGrimGrip;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityGrimGripKey
extends Entity {
    EntityGrimGrip grip = null;
    int interval = 0;
    public int active = 0;
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntityGrimGripKey.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<BlockPos>> GRIM_GRIP_POS = EntityDataManager.func_187226_a(EntityGrimGripKey.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> INVISIBLE = EntityDataManager.func_187226_a(EntityGrimGripKey.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityGrimGripKey(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)60);
        this.func_184212_Q().func_187214_a(GRIM_GRIP_POS, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(INVISIBLE, (Object)false);
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public void setGrimGripPos(@Nullable BlockPos grimGripPos) {
        this.func_184212_Q().func_187227_b(GRIM_GRIP_POS, (Object)Optional.fromNullable((Object)grimGripPos));
    }

    public BlockPos getGrimGripPos() {
        BlockPos result = (BlockPos)((Optional)this.func_184212_Q().func_187225_a(GRIM_GRIP_POS)).orNull();
        if (result == null) {
            result = this.func_180425_c();
        }
        return result;
    }

    public boolean isHide() {
        return (Boolean)this.func_184212_Q().func_187225_a(INVISIBLE);
    }

    public void setHide(boolean hide) {
        this.func_184212_Q().func_187227_b(INVISIBLE, (Object)hide);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("GPX")) {
            int i = compound.func_74762_e("GPX");
            int j = compound.func_74762_e("GPY");
            int k = compound.func_74762_e("GPZ");
            this.setGrimGripPos(new BlockPos(i, j, k));
        } else {
            this.setGrimGripPos(null);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        BlockPos blockpos = this.getGrimGripPos();
        if (blockpos != null) {
            compound.func_74768_a("GPX", blockpos.func_177958_n());
            compound.func_74768_a("GPY", blockpos.func_177956_o());
            compound.func_74768_a("GPZ", blockpos.func_177952_p());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (0 < this.interval) {
            --this.interval;
        }
        if (0 < this.active) {
            --this.active;
        }
        if (this.grip != null && !this.grip.func_70089_S()) {
            this.removeGrip();
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184614_ca() == null && entityIn.func_70093_af() && !entityIn.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return true;
        }
        return super.func_85031_j(entityIn);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        this.summonGrimGrip((Entity)entityIn);
    }

    private void summonGrimGrip(Entity entityIn) {
        NBTTagCompound tag;
        ItemStack stack;
        this.active = 60;
        if (this.grip != null) {
            if (this.grip.func_70089_S()) {
                this.grip.field_70173_aa = 0;
            } else {
                this.removeGrip();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.grip == null && this.interval <= 0) {
            EntityGrimGrip newGrip = new EntityGrimGrip(this.field_70170_p);
            BlockPos pos = this.getGrimGripPos();
            newGrip.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, newGrip.field_70177_z, newGrip.field_70125_A);
            newGrip.setLifeTime(this.getLifeTime());
            newGrip.field_70173_aa = 0;
            newGrip.func_184195_f(true);
            if (this.field_70170_p.func_72838_d((Entity)newGrip)) {
                this.grip = newGrip;
            }
        }
        if (this.grip != null && entityIn instanceof EntityLivingBase && 0 < (entityIn.getEntityData().func_74771_c("SB.MCS") & 0x10) && (stack = ((EntityLivingBase)entityIn).func_184614_ca()) != null && stack.func_77973_b() instanceof ItemSlashBlade && ItemSlashBlade.TargetEntityId.get(tag = ItemSlashBlade.getItemTagCompound(stack)).intValue() != this.grip.func_145782_y()) {
            ItemSlashBlade.TargetEntityId.set(tag, this.grip.func_145782_y());
        }
    }

    private void removeGrip() {
        this.grip = null;
        this.interval = 10;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return this.active <= 0;
    }
}

