/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.TeleportCanceller;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySlashDimension
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = null;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected float AttackLevel = 0.0f;
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SINGLE_HIT = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLASH_DIMENSION = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> THROWER_ENTITY_ID = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INTERVAL = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySlashDimension.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySlashDimension(World par1World) {
        super(par1World);
        this.field_70173_aa = 0;
        this.getEntityData().func_74768_a("seed", this.field_70146_Z.nextInt(50));
    }

    public EntitySlashDimension(World par1World, EntityLivingBase entityLiving, float AttackLevel, boolean multiHit) {
        this(par1World, entityLiving, AttackLevel);
        this.setIsSingleHit(multiHit);
    }

    public EntitySlashDimension(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        this(par1World);
        this.AttackLevel = AttackLevel;
        this.thrower = entityLiving;
        this.blade = entityLiving.func_184614_ca();
        if (this.blade != null && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = null;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(4.0f, 4.0f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(SINGLE_HIT, (Object)false);
        this.func_184212_Q().func_187214_a(IS_SLASH_DIMENSION, (Object)false);
        this.func_184212_Q().func_187214_a(THROWER_ENTITY_ID, (Object)0);
        this.func_184212_Q().func_187214_a(INTERVAL, (Object)7);
        this.func_184212_Q().func_187214_a(COLOR, (Object)0x3333FF);
    }

    public boolean getIsSingleHit() {
        return (Boolean)this.func_184212_Q().func_187225_a(SINGLE_HIT);
    }

    public void setIsSingleHit(boolean isSingleHit) {
        this.func_184212_Q().func_187227_b(SINGLE_HIT, (Object)isSingleHit);
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public boolean getIsSlashDimension() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SLASH_DIMENSION);
    }

    public void setIsSlashDimension(boolean isSlashDimension) {
        this.func_184212_Q().func_187227_b(IS_SLASH_DIMENSION, (Object)isSlashDimension);
    }

    public int getInterval() {
        return (Integer)this.func_184212_Q().func_187225_a(INTERVAL);
    }

    public void setInterval(int value) {
        this.func_184212_Q().func_187227_b(INTERVAL, (Object)value);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int value) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)value);
    }

    public int getThrowerEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(THROWER_ENTITY_ID);
    }

    public void setThrowerEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(THROWER_ENTITY_ID, (Object)entityid);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa < 8 && this.field_70173_aa % 2 == 0) {
                this.func_184185_a(SoundEvents.field_187851_gB, 0.2f, 0.5f + 0.25f * this.field_70146_Z.nextFloat());
            }
            if (this.getThrower() != null) {
                AxisAlignedBB bb = this.func_174813_aQ();
                if (this.getThrower() instanceof EntityLivingBase) {
                    EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                    List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                    list.removeAll(this.alreadyHitEntity);
                    this.alreadyHitEntity.addAll(list);
                    for (Entity curEntity : list) {
                        boolean isDestruction = true;
                        if (curEntity instanceof EntityFireball) {
                            isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), this.AttackLevel);
                        } else if (curEntity instanceof EntityArrow) {
                            if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                                isDestruction = false;
                            }
                        } else if (curEntity instanceof IThrowableEntity) {
                            if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                                isDestruction = false;
                            }
                        } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                        if (!isDestruction) continue;
                        curEntity.field_70159_w = 0.0;
                        curEntity.field_70181_x = 0.0;
                        curEntity.field_70179_y = 0.0;
                        curEntity.func_70106_y();
                        for (int var1 = 0; var1 < 10; ++var1) {
                            Random rand = this.getRand();
                            double var2 = rand.nextGaussian() * 0.02;
                            double var4 = rand.nextGaussian() * 0.02;
                            double var6 = rand.nextGaussian() * 0.02;
                            double var8 = 10.0;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                        }
                        StylishRankManager.doAttack(this.thrower);
                    }
                }
                if (this.getIsSingleHit() || this.field_70173_aa % 2 == 0) {
                    List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                    list.removeAll(this.alreadyHitEntity);
                    if (this.getIsSingleHit()) {
                        this.alreadyHitEntity.addAll(list);
                    }
                    float magicDamage = Math.max(1.0f, this.AttackLevel);
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.SlashDimMagic);
                    for (Entity curEntity : list) {
                        float health;
                        if (this.getIsSlashDimension() && curEntity instanceof EntityLivingBase && 0.0f < (health = ((EntityLivingBase)curEntity).func_110143_aJ())) {
                            health = Math.max(1.0f, health - magicDamage);
                            ((EntityLivingBase)curEntity).func_70606_j(health);
                        }
                        Vec3d pos = curEntity.func_174791_d();
                        TeleportCanceller.setCancel(curEntity);
                        curEntity.field_70172_ad = 0;
                        DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p().func_76349_b();
                        if (this.blade != null && curEntity instanceof EntityLivingBase) {
                            ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
                        }
                        if (!curEntity.func_174791_d().equals((Object)pos)) {
                            curEntity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                        }
                        curEntity.field_70159_w = 0.0;
                        curEntity.field_70181_x = 0.0;
                        curEntity.field_70179_y = 0.0;
                        if (3 >= this.field_70173_aa || this.blade == null || !(curEntity instanceof EntityLivingBase)) continue;
                        if (this.getIsSlashDimension()) {
                            curEntity.func_70024_g(0.0, 0.5, 0.0);
                            continue;
                        }
                        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.blade);
                        if (0 < level) {
                            curEntity.func_70024_g(Math.sin(this.getThrower().field_70177_z * (float)Math.PI / 180.0f) * (double)level * 0.5, 0.2, -Math.cos(this.getThrower().field_70177_z * (float)Math.PI / 180.0f) * (double)level * 0.5);
                            continue;
                        }
                        curEntity.func_70024_g(-Math.sin(this.getThrower().field_70177_z * (float)Math.PI / 180.0f) * 0.5, 0.2, Math.cos(this.getThrower().field_70177_z * (float)Math.PI / 180.0f) * 0.5);
                    }
                }
            }
        }
        if (this.field_70173_aa >= this.getLifeTime()) {
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos pos) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.func_130014_f_().func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }
}

