/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntitySummonedSwordBase;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityStormSwords
extends EntitySummonedSwordBase {
    private static final DataParameter<Boolean> HAS_FIRED = EntityDataManager.func_187226_a(EntityStormSwords.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ROT_OFFSET = EntityDataManager.func_187226_a(EntityStormSwords.class, (DataSerializer)DataSerializers.field_187193_c);
    static final int waitTime = 7;
    int life = 2;

    public EntityStormSwords(World par1World) {
        super(par1World);
        this.setInterval(0);
    }

    public EntityStormSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntityStormSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll, float rotOffset, int targetEntityId) {
        super(par1World, entityLiving, AttackLevel, roll);
        this.setTargetEntityId(targetEntityId);
        this.setRotOffset(rotOffset);
        if (this.getTargetEntityId() != 0) {
            Entity target = par1World.func_73045_a(this.getTargetEntityId());
            this.mountEntity(target);
        }
        this.faceEntityStandby();
        this.setDriveVector(1.0f, true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HAS_FIRED, (Object)false);
        this.func_184212_Q().func_187214_a(ROT_OFFSET, (Object)Float.valueOf(0.0f));
    }

    public boolean hasFired() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_FIRED);
    }

    public void setHasFired(boolean hasFired) {
        this.func_184212_Q().func_187227_b(HAS_FIRED, (Object)hasFired);
    }

    public float getRotOffset() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_OFFSET)).floatValue();
    }

    public void setRotOffset(float rotOffset) {
        this.func_184212_Q().func_187227_b(ROT_OFFSET, (Object)Float.valueOf(rotOffset));
    }

    @Override
    public void func_70098_U() {
        if (this.hasFired()) {
            if (this.ridingEntity2.func_145782_y() == this.getTargetEntityId()) {
                this.ridingEntity2 = null;
            } else {
                super.func_70098_U();
            }
            return;
        }
        Entity ridingEntity = this.ridingEntity2;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.faceEntityStandby();
        if (ridingEntity.field_70128_L) {
            this.setInterval(this.field_70173_aa + 7);
            this.setLifeTime(this.field_70173_aa + 30);
            this.setHasFired(true);
            this.func_130014_f_().func_72866_a((Entity)this, true);
            return;
        }
        if (!this.func_130014_f_().field_72995_K && this.getInterval() < this.field_70173_aa) {
            this.setHasFired(true);
            this.func_130014_f_().func_72866_a((Entity)this, true);
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187524_aN, SoundCategory.NEUTRAL, 0.35f, 0.2f);
            return;
        }
        this.setMotionVector(1.0f, false);
        RayTraceResult movingobjectposition = this.getRayTraceResult();
        if (movingobjectposition != null && this.onImpact(movingobjectposition)) {
            return;
        }
        this.doTargeting();
    }

    @Override
    protected void initRotation() {
        super.initRotation();
        if (this.ridingEntity2 == null && !this.hasFired() && this.getTargetEntityId() != 0 && this.func_130014_f_().field_72995_K) {
            Entity target = this.func_130014_f_().func_73045_a(this.getTargetEntityId());
            this.mountEntity(target);
        }
    }

    @Override
    public void spawnParticle() {
        super.spawnParticle();
        if (this.hasFired()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
    }

    @Override
    protected boolean onImpact(RayTraceResult mop) {
        boolean result = false;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(EntitySelectorDestructable.getInstance())) {
                this.destructEntity(target);
                return true;
            }
            if (this.field_70173_aa < this.getInterval()) {
                return false;
            }
            if (mop.hitInfo.equals(EntitySelectorAttackable.getInstance())) {
                this.attackEntity(target);
            }
        } else {
            if (this.field_70173_aa < this.getInterval()) {
                return false;
            }
            if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                    ((EntityPlayer)this.getThrower()).func_71009_b((Entity)this);
                }
                this.func_70106_y();
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean doTargeting() {
        return false;
    }

    private void faceEntityStandby() {
        int ticks = this.field_70173_aa;
        if (this.getInterval() - 7 < ticks) {
            ticks = this.getInterval() - 7;
        }
        double rotParTick = 9.0;
        double offset = this.getRotOffset();
        double degYaw = (double)ticks * rotParTick + offset;
        double yaw = Math.toRadians(degYaw);
        Vec3d pos = new Vec3d(Math.sin(yaw), Math.sin(yaw + (double)ticks / 10.0) * (double)0.1f, Math.cos(yaw));
        pos = pos.func_186678_a(2.5);
        if (this.ridingEntity2 != null) {
            pos = pos.func_178787_e(this.ridingEntity2.func_174791_d());
            pos = pos.func_72441_c(0.0, (double)this.ridingEntity2.func_70047_e() / 3.0, 0.0);
        }
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.func_70101_b((float)(180.0 - degYaw), 0.0f);
    }

    public void setMotionVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.field_70177_z / 180.0f * (float)Math.PI;
        float fPitDtoR = this.field_70125_A / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    @Override
    protected void attackEntity(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.alreadyHitEntity.contains(target)) {
                return;
            }
            this.alreadyHitEntity.add(target);
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (this.blade != null && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.8, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
            if (--this.life <= 0) {
                this.func_70106_y();
            }
        }
    }
}

