/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DropEventHandler {
    public static final String header = "flammpfeil.slashblade.entitydrops.";
    public static Set<String> registerdEntityNames = Sets.newHashSet();
    public static Map<String, Multimap<Float, ItemStack>> dropData = Maps.newHashMap();

    public static void registerEntityDrop(String entityName, float rate, ItemStack item) {
        Multimap<Float, ItemStack> drops = null;
        if (!dropData.containsKey(entityName)) {
            drops = HashMultimap.create();
            dropData.put(entityName, drops);
        } else {
            drops = dropData.get(entityName);
        }
        drops.put((Object)Float.valueOf(rate), (Object)item);
    }

    @SubscribeEvent
    public void LivingDrops(LivingDropsEvent event) {
        String key = EntityList.func_75621_b((Entity)event.getEntityLiving());
        if (dropData.containsKey(key)) {
            Random rand = event.getEntityLiving().func_70681_au();
            Multimap<Float, ItemStack> drops = dropData.get(key);
            for (Map.Entry drop : drops.entries()) {
                NBTTagCompound tag;
                boolean forceDrop;
                boolean isDrop = false;
                float rate = Math.abs(((Float)drop.getKey()).floatValue());
                boolean requiredBlade = ((Float)drop.getKey()).floatValue() < 0.0f;
                isDrop = rate * (1.0f + 0.5f * (float)event.getLootingLevel()) > rand.nextFloat();
                boolean bl = forceDrop = rate > 1.1f;
                if (requiredBlade) {
                    EntityLivingBase target = event.getEntityLiving().func_70643_av();
                    if (target == null) {
                        return;
                    }
                    ItemStack attackItem = target.func_184586_b(EnumHand.MAIN_HAND);
                    if (attackItem == null) {
                        return;
                    }
                    if (!(attackItem.func_77973_b() instanceof ItemSlashBlade)) {
                        return;
                    }
                }
                if (!event.isRecentlyHit() && !forceDrop || !isDrop || drop.getValue() == null) continue;
                ItemStack dropitem = ((ItemStack)drop.getValue()).func_77946_l();
                dropitem.field_77994_a = Math.max(dropitem.func_77976_d(), Math.max(1, Math.round((float)dropitem.field_77994_a * rand.nextFloat())));
                if (dropitem.func_77973_b() instanceof ItemSlashBlade && !(tag = ItemSlashBlade.getItemTagCompound(dropitem)).func_74767_n("IsNoStandDrop")) {
                    EntityBladeStand e = new EntityBladeStand(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, dropitem);
                    e.func_184195_f(true);
                    event.getEntityLiving().field_70170_p.func_72838_d((Entity)e);
                    return;
                }
                if (dropitem.field_77994_a == 0) continue;
                event.getEntityLiving().func_70099_a(dropitem, 1.0f);
            }
        }
    }
}

