/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.ability.DefeatTheBoss;
import mods.flammpfeil.slashblade.ability.JustGuard;
import mods.flammpfeil.slashblade.ability.SoulEater;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.Taunt;
import mods.flammpfeil.slashblade.ability.UntouchableTime;
import mods.flammpfeil.slashblade.ability.UpthrustBlast;
import mods.flammpfeil.slashblade.capability.BladeCapabilityProvider;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntityHelmBrakerManager;
import mods.flammpfeil.slashblade.entity.EntityLumberManager;
import mods.flammpfeil.slashblade.entity.EntityRapidSlashManager;
import mods.flammpfeil.slashblade.entity.EntitySpinningSword;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStingerManager;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.entity.EntitySummonedBlade;
import mods.flammpfeil.slashblade.entity.EntitySummonedSwordBase;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.event.ScheduleEntitySpawner;
import mods.flammpfeil.slashblade.network.MessageRangeAttack;
import mods.flammpfeil.slashblade.network.MessageSpecialAction;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.specialattack.BlisteringWitherSwords;
import mods.flammpfeil.slashblade.specialattack.CircleSlash;
import mods.flammpfeil.slashblade.specialattack.Drive;
import mods.flammpfeil.slashblade.specialattack.IJustSpecialAttack;
import mods.flammpfeil.slashblade.specialattack.MaximumBet;
import mods.flammpfeil.slashblade.specialattack.SakuraEnd;
import mods.flammpfeil.slashblade.specialattack.SlashDimension;
import mods.flammpfeil.slashblade.specialattack.Spear;
import mods.flammpfeil.slashblade.specialattack.SpecialAttackBase;
import mods.flammpfeil.slashblade.specialattack.WaveEdge;
import mods.flammpfeil.slashblade.specialeffect.HFCustom;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.stats.AchievementList;
import mods.flammpfeil.slashblade.util.EnchantHelper;
import mods.flammpfeil.slashblade.util.InventoryUtility;
import mods.flammpfeil.slashblade.util.SilentUpdateItem;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class ItemSlashBlade
extends ItemSword {
    private static ResourceLocation texture = new ResourceLocation("flammpfeil.slashblade", "model/blade.png");
    public static Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    public static TagPropertyAccessor.TagPropertyString TextureName = new TagPropertyAccessor.TagPropertyString("TextureName");
    private ResourceLocation model = new ResourceLocation("flammpfeil.slashblade", "model/blade.obj");
    public static Map<String, ResourceLocation> modelMap = new HashMap<String, ResourceLocation>();
    public static TagPropertyAccessor.TagPropertyString ModelName = new TagPropertyAccessor.TagPropertyString("ModelName");
    public static final String adjustXStr = "adjustX";
    public static final String adjustYStr = "adjustY";
    public static final String adjustZStr = "adjustZ";
    public static final String comboSeqStr = "comboSeq";
    public static final String lastPosHashStr = "lastPosHash";
    public static final float RefineBase = 10.0f;
    public static TagPropertyAccessor.TagPropertyLong LastActionTime = new TagPropertyAccessor.TagPropertyLong("lastActionTime");
    public static TagPropertyAccessor.TagPropertyInteger SpecialAttackType = new TagPropertyAccessor.TagPropertyInteger("SpecialAttackType");
    public static TagPropertyAccessor.TagPropertyInteger StandbyRenderType = new TagPropertyAccessor.TagPropertyInteger("StandbyRenderType");
    public static TagPropertyAccessor.TagPropertyInteger TargetEntityId = new TagPropertyAccessor.TagPropertyInteger("TargetEntity");
    public static TagPropertyAccessor.TagPropertyBoolean IsBroken = new TagPropertyAccessor.TagPropertyBoolean("isBroken");
    public static TagPropertyAccessor.TagPropertyBoolean OnClick = new TagPropertyAccessor.TagPropertyBoolean("onClick");
    public static TagPropertyAccessor.TagPropertyBoolean OnJumpAttacked = new TagPropertyAccessor.TagPropertyBoolean("onJumpAttacked");
    public static TagPropertyAccessor.TagPropertyBoolean IsNoScabbard = new TagPropertyAccessor.TagPropertyBoolean("isNoScabbard");
    public static TagPropertyAccessor.TagPropertyBoolean IsSealed = new TagPropertyAccessor.TagPropertyBoolean("isSealed");
    public static TagPropertyAccessor.TagPropertyBoolean IsCharged = new TagPropertyAccessor.TagPropertyBoolean("isCharged");
    public static TagPropertyAccessor.TagPropertyBoolean IsDestructable = new TagPropertyAccessor.TagPropertyBoolean("isDestructable");
    public static TagPropertyAccessor.TagPropertyBoolean IsThrownOffhand = new TagPropertyAccessor.TagPropertyBoolean("isThrownOffhand");
    public static TagPropertyAccessor.TagPropertyBoolean IsThrownMainhand = new TagPropertyAccessor.TagPropertyBoolean("isThrownMainhand");
    public static TagPropertyAccessor.TagPropertyFloat AttackAmplifier = new TagPropertyAccessor.TagPropertyFloat("AttackAmplifier");
    public static TagPropertyAccessor.TagPropertyFloat BaseAttackModifier = new TagPropertyAccessor.TagPropertyFloat("baseAttackModifier");
    public static TagPropertyAccessor.TagPropertyInteger PrevExp = new TagPropertyAccessor.TagPropertyInteger("prevExp");
    public static TagPropertyAccessor.TagPropertyIntegerWithRange ProudSoul = new TagPropertyAccessor.TagPropertyIntegerWithRange("ProudSoul", 0, 999999999);
    public static TagPropertyAccessor.TagPropertyIntegerWithRange KillCount = new TagPropertyAccessor.TagPropertyIntegerWithRange("killCount", 0, 999999999);
    public static TagPropertyAccessor.TagPropertyIntegerWithRange RepairCount = new TagPropertyAccessor.TagPropertyIntegerWithRange("RepairCounter", 0, 999999999);
    public static TagPropertyAccessor.TagPropertyInteger SummonedSwordColor = new TagPropertyAccessor.TagPropertyInteger("SummonedSwordColor");
    public static int AnvilRepairBonus = 100;
    private static ArrayList<ComboSequence> Seqs = new ArrayList();
    public static int RequiredChargeTick = 15;
    public static int ComboInterval = 4;
    public float defaultBaseAttackModifier = 4.0f;
    Map<ComboSequence, ComboSequence> AerialRave = ItemSlashBlade.createAerialRaveMap();
    Map<ComboSequence, ComboSequence> ForceEdgeCombo = ItemSlashBlade.createForceEdgeComboMap();
    Map<ComboSequence, String> attackTypeMap = this.crateAttackTypeMap();
    private String[] repairMaterialOreDic = null;
    private ItemStack repairMaterial = null;
    static final String IsManagedDamage = "IsManagedDamage";
    public static Map<Integer, SpecialAttackBase> specialAttacks = ItemSlashBlade.createSpacialAttaksMap();
    public static SpecialAttackBase defaultSA;

    public ResourceLocation getModelTexture() {
        return texture;
    }

    public static ResourceLocation getModelTexture(ItemStack par1ItemStack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (TextureName.exists(tag)) {
            ResourceLocation loc;
            String textureName = TextureName.get(tag);
            if (!textureMap.containsKey(textureName)) {
                loc = new ResourceLocation("flammpfeil.slashblade", "model/" + textureName + ".png");
                textureMap.put(textureName, loc);
            } else {
                loc = textureMap.get(textureName);
            }
            return loc;
        }
        return ((ItemSlashBlade)par1ItemStack.func_77973_b()).getModelTexture();
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public static ResourceLocation getModelLocation(ItemStack par1ItemStack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (ModelName.exists(tag)) {
            ResourceLocation loc;
            String modelName = ModelName.get(tag);
            if (!modelMap.containsKey(modelName)) {
                loc = new ResourceLocation("flammpfeil.slashblade", "model/" + modelName + ".obj");
                modelMap.put(modelName, loc);
            } else {
                loc = modelMap.get(modelName);
            }
            return loc;
        }
        return ((ItemSlashBlade)par1ItemStack.func_77973_b()).getModel();
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.NONE;
    }

    public static void setComboSequence(NBTTagCompound tag, ComboSequence comboSeq) {
        tag.func_74768_a(comboSeqStr, comboSeq.ordinal());
        if (comboSeq == ComboSequence.None) {
            IsCharged.set(tag, false);
        }
    }

    public static ComboSequence getComboSequence(NBTTagCompound tag) {
        return ComboSequence.get(tag.func_74762_e(comboSeqStr));
    }

    public void dropItemDestructed(Entity entity, ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!entity.field_70170_p.field_72995_K) {
            int proudSouls = ProudSoul.get(tag);
            int count = 0;
            if (proudSouls > 1000) {
                count = (proudSouls - 800) / 100;
                count = Math.min(8, Math.max(0, count));
                proudSouls -= count * 100;
            } else {
                count = proudSouls / 100;
                proudSouls -= count * 100;
            }
            ProudSoul.set(tag, proudSouls);
            entity.func_70099_a(SlashBlade.findItemStack("flammpfeil.slashblade", "proudsoul", ++count), 0.0f);
            if (entity instanceof EntityPlayer) {
                AchievementList.triggerAchievement((EntityPlayer)entity, "proudSoul");
            }
            if (stack.func_77948_v() && entity instanceof EntityLivingBase) {
                int enchCount;
                ItemStack tinySoul = SlashBlade.findItemStack("flammpfeil.slashblade", "tiny_bladesoul", 1);
                int unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
                int lootingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack);
                Random rand = ((EntityLivingBase)entity).func_70681_au();
                boolean isRare = false;
                if (0 < unbreakingLevel && 0 < lootingLevel) {
                    isRare = true;
                } else {
                    for (int loop = 0; loop < unbreakingLevel; ++loop) {
                        boolean bl = isRare = (double)rand.nextFloat() < 0.3;
                        if (isRare) break;
                    }
                }
                if (isRare) {
                    tinySoul.func_77966_a(EnchantHelper.getEnchantmentRare(rand), 1);
                } else {
                    tinySoul.func_77966_a(EnchantHelper.getEnchantmentNormal(rand), 1);
                }
                entity.func_70099_a(tinySoul, 0.0f);
                if (entity instanceof EntityPlayer) {
                    AchievementList.triggerAchievement((EntityPlayer)entity, "enchantmentSoul");
                }
                if (5 < (enchCount = stack.func_77986_q().func_74745_c())) {
                    if (0 < unbreakingLevel) {
                        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                        if (unbreakingLevel == 1) {
                            enchantments.remove(Enchantments.field_185307_s);
                        } else {
                            enchantments.put(Enchantments.field_185307_s, unbreakingLevel - 1);
                        }
                        ItemStack rareTinySoul = SlashBlade.findItemStack("flammpfeil.slashblade", "tiny_bladesoul", 1);
                        rareTinySoul.func_77966_a(EnchantHelper.getEnchantmentRare(rand), 1);
                        entity.func_70099_a(rareTinySoul, 0.0f);
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    } else {
                        int targetTag = rand.nextInt(enchCount);
                        NBTTagCompound enchTag = stack.func_77986_q().func_150305_b(targetTag);
                        enchTag = enchTag.func_74737_b();
                        stack.func_77986_q().func_74744_a(targetTag);
                        ItemStack proudSoul = SlashBlade.findItemStack("flammpfeil.slashblade", "proudsoul", 1);
                        if (!proudSoul.func_77942_o()) {
                            proudSoul.func_77982_d(new NBTTagCompound());
                        }
                        if (!proudSoul.func_77978_p().func_150297_b("ench", 9)) {
                            proudSoul.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
                        }
                        NBTTagList nbttaglist = proudSoul.func_77978_p().func_150295_c("ench", 10);
                        nbttaglist.func_74742_a((NBTBase)enchTag);
                        entity.func_70099_a(proudSoul, 0.0f);
                    }
                }
            }
        }
    }

    public EntityLivingBase setDaunting(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 30, true, false));
        }
        StunManager.setStun(entity, 20L);
        return entity;
    }

    public static void updateKillCount(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!target.func_70089_S() && target.field_70725_aQ == 0) {
            int count = KillCount.add(tag, 1);
            ItemSlashBlade.incrementProudSoul(stack, target, player);
            SoulEater.entityKilled(stack, target, player);
            DefeatTheBoss.entityKilled(stack, target, player);
            if (player instanceof EntityPlayer) {
                switch (count) {
                    case 100: {
                        AchievementList.triggerAchievement((EntityPlayer)player, "hundredKill");
                        break;
                    }
                    case 1000: {
                        AchievementList.triggerAchievement((EntityPlayer)player, "thousandKill");
                        break;
                    }
                }
            }
        }
    }

    public void setArmorDrop(ItemStack stack, EntityLivingBase entity) {
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (!stack.func_77948_v()) {
            return;
        }
        int lv = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{};
        switch (lv) {
            case 0: {
                return;
            }
            case 1: {
                slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND};
                break;
            }
            default: {
                slots = EntityEquipmentSlot.values();
            }
        }
        for (EntityEquipmentSlot slot : slots) {
            try {
                ((EntityLiving)entity).func_184642_a(slot, 0.99f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setImpactEffect(ItemStack stack, EntityLivingBase target, EntityLivingBase user, ComboSequence comboSec) {
        if (SlashBladeHooks.onImpactEffectHooks(stack, target, user, comboSec)) {
            return;
        }
        switch (comboSec) {
            case RisingStar: {
                target.field_70122_E = false;
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.6, 0.0);
                this.setDaunting(target);
                break;
            }
            case Kiriage: {
                target.field_70122_E = false;
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.6, 0.0);
                this.setDaunting(target);
                break;
            }
            case Kiriorosi: {
                if (0.0 < target.field_70181_x) {
                    target.field_70181_x = 0.0;
                }
                target.field_70143_R += 4.0f;
                float knockbackFactor = 0.5f;
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f), -0.2, (double)(MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f));
                target.field_70172_ad = 0;
                break;
            }
            case Stinger: {
                this.setDaunting(target);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                break;
            }
            case HiraTuki: {
                this.setDaunting(target);
            }
            case ReturnEdge: 
            case Battou: {
                float knockbackFactor = 0.0f;
                if (target instanceof EntityLivingBase) {
                    knockbackFactor = EnchantmentHelper.func_77501_a((EntityLivingBase)user);
                }
                if (!(0.0f < knockbackFactor)) {
                    knockbackFactor = 1.5f;
                }
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackFactor * 0.5f));
                if (!user.field_70122_E) break;
                UpthrustBlast.setUpthrustBlastSword(stack, user, target);
                break;
            }
            case Force1: 
            case Force2: 
            case Force5: 
            case Force6: 
            case Calibur: 
            case RapidSlash: 
            case SlashEdge: 
            case SIai: 
            case SSlashEdge: 
            case SReturnEdge: 
            case SSlashBlade: 
            case Iai: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                if (!target.field_70122_E) {
                    int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)stack);
                    if (0 < level) {
                        target.func_70024_g(0.0, 0.3, 0.0);
                    } else {
                        target.func_70024_g(0.0, 0.2, 0.0);
                    }
                }
                this.setDaunting(target);
                break;
            }
            case ASlashEdge: 
            case AKiriorosi: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)stack);
                if (0 < level) {
                    target.func_70024_g(0.0, 0.3, 0.0);
                } else {
                    target.func_70024_g(0.0, 0.2, 0.0);
                }
                this.setDaunting(target);
                break;
            }
            case AKiriage: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.7, 0.0);
                this.setDaunting(target);
                break;
            }
            case AKiriorosiFinish: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.field_70143_R += 4.0f;
                target.func_70024_g(0.0, -0.8, 0.0);
                target.field_70172_ad = 0;
                StunManager.removeStun(target);
                break;
            }
            case HelmBraker: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.field_70143_R += 5.0f;
                target.func_70024_g(0.0, -1.0, 0.0);
                target.field_70172_ad = 0;
                StunManager.removeStun(target);
                break;
            }
            case Force3: 
            case Force4: 
            case Saya1: 
            case Saya2: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                this.setDaunting(target);
                this.setArmorDrop(stack, target);
                break;
            }
            case SlashDim: {
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                this.setDaunting(target);
                break;
            }
        }
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        ItemSlashBlade.updateKillCount(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
        ComboSequence comboSec = ItemSlashBlade.getComboSequence(tag);
        this.setImpactEffect(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase, comboSec);
        if (!comboSec.useScabbard && comboSec.mainHandCombo == null || IsNoScabbard.get(tag).booleanValue()) {
            ItemSlashBlade.damageItem(par1ItemStack, 1, par3EntityLivingBase);
            if (par1ItemStack.field_77994_a <= 0) {
                ItemSlashBlade blade = (ItemSlashBlade)par1ItemStack.func_77973_b();
                if (!this.isDestructable(par1ItemStack)) {
                    par1ItemStack.field_77994_a = 1;
                    IsBroken.set(tag, true);
                    if (blade instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.TrueItemName.exists(tag)) {
                        ((ItemSlashBladeWrapper)blade).removeWrapItem(par1ItemStack);
                    }
                    if (blade == SlashBlade.bladeWhiteSheath && par3EntityLivingBase instanceof EntityPlayer) {
                        AchievementList.triggerAchievement((EntityPlayer)par3EntityLivingBase, "brokenWhiteSheath");
                    }
                    blade.dropItemDestructed((Entity)par3EntityLivingBase, par1ItemStack);
                }
            }
        }
        StylishRankManager.doAttack((Entity)par3EntityLivingBase);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        NBTTagCompound tag;
        int id;
        Entity prevEntity;
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ItemSlashBlade.damageItem(stack, 1, entityLiving);
        }
        if (entityLiving instanceof EntityPlayer && blockIn.func_177230_c().isWood((IBlockAccess)worldIn, pos) && ((prevEntity = worldIn.func_73045_a(id = (tag = ItemSlashBlade.getItemTagCompound(stack)).func_74762_e("lumbmanager"))) == null || !(prevEntity instanceof EntityLumberManager)) && stack.func_77973_b() instanceof ItemSlashBlade) {
            ItemSlashBlade bladeItem = (ItemSlashBlade)stack.func_77973_b();
            ItemSlashBlade.setComboSequence(tag, ComboSequence.Battou);
            bladeItem.doSwingItem(stack, (EntityLivingBase)((EntityPlayer)entityLiving));
            if (!worldIn.field_72995_K) {
                EntityLumberManager manager = new EntityLumberManager(worldIn, blockIn.func_177230_c());
                manager.setOwner((EntityPlayer)entityLiving);
                manager.setLifeTime(600);
                manager.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                worldIn.func_72838_d((Entity)manager);
                tag.func_74768_a("lumbmanager", manager.func_145782_y());
            }
        }
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.defaultBaseAttackModifier, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public ItemSlashBlade(Item.ToolMaterial par2EnumToolMaterial, float defaultBaseAttackModifier) {
        super(par2EnumToolMaterial);
        this.func_77656_e(50);
        this.defaultBaseAttackModifier = defaultBaseAttackModifier;
    }

    public static NBTTagCompound getItemTagCompound(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
        } else {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    static Map<ComboSequence, ComboSequence> createAerialRaveMap() {
        HashMap result = Maps.newHashMap();
        result.put(ComboSequence.Iai, ComboSequence.Battou);
        result.put(ComboSequence.AerialRave, ComboSequence.ASlashEdge);
        result.put(ComboSequence.ASlashEdge, ComboSequence.AKiriorosi);
        result.put(ComboSequence.AKiriorosi, ComboSequence.Battou);
        result.put(ComboSequence.AKiriorosiB, ComboSequence.AKiriage);
        result.put(ComboSequence.AKiriage, ComboSequence.AKiriorosiFinish);
        return result;
    }

    static Map<ComboSequence, ComboSequence> createForceEdgeComboMap() {
        HashMap result = Maps.newHashMap();
        result.put(ComboSequence.Force1, ComboSequence.Force2);
        result.put(ComboSequence.Force2, ComboSequence.Force3);
        result.put(ComboSequence.Force3, ComboSequence.Force4);
        result.put(ComboSequence.Force4, ComboSequence.Force5);
        result.put(ComboSequence.Force5, ComboSequence.Force6);
        return result;
    }

    public static boolean hasOffhandSword(ItemStack mainBlade, EntityLivingBase owner) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(mainBlade);
        ItemStack offHand = owner.func_184592_cb();
        boolean hasOffhandSword = offHand != null && offHand.func_77973_b() instanceof ItemSlashBlade;
        return hasOffhandSword && IsThrownOffhand.get(tag) == false;
    }

    public ComboSequence getNextComboSeq(ItemStack itemStack, ComboSequence current, boolean isRightClick, EntityPlayer player) {
        ComboSequence result = ComboSequence.None;
        EnumSet<SwordType> types = this.getSwordType(itemStack);
        if (types.contains((Object)SwordType.NoScabbard)) {
            result = ComboSequence.None;
        } else if (!player.field_70122_E) {
            int rank = StylishRankManager.getStylishRank((Entity)player);
            int helmBrakerState = 17;
            long currentTime = player.func_130014_f_().func_82737_E();
            int caliburState = 17;
            long backKeyLastActiveTime = player.getEntityData().func_74763_f("SB.MCS.B");
            int TypeAheadBuffer = 7;
            if (currentTime - backKeyLastActiveTime <= 7L && caliburState == (player.getEntityData().func_74771_c("SB.MCS") & caliburState) && current != ComboSequence.Calibur && !OnJumpAttacked.get(ItemSlashBlade.getItemTagCompound(itemStack)).booleanValue()) {
                result = ComboSequence.Calibur;
                OnJumpAttacked.set(ItemSlashBlade.getItemTagCompound(itemStack), true);
            } else if (helmBrakerState == (player.getEntityData().func_74771_c("SB.MCS") & helmBrakerState) && current != ComboSequence.HelmBraker) {
                result = ComboSequence.HelmBraker;
            } else {
                switch (current) {
                    case AKiriorosi: {
                        long last = LastActionTime.get(ItemSlashBlade.getItemTagCompound(itemStack));
                        long now = player.field_70170_p.func_82737_E();
                        if (7L < now - last) {
                            current = ComboSequence.AKiriorosiB;
                        }
                        result = this.AerialRave.get((Object)current);
                        break;
                    }
                    default: {
                        result = this.AerialRave.get((Object)current);
                    }
                }
            }
            if (result == null) {
                result = isRightClick ? this.AerialRave.get((Object)ComboSequence.AerialRave) : ComboSequence.Iai;
            }
        } else if (isRightClick) {
            int upperSlashState = 18;
            int rapidSlashState = 17;
            if (rapidSlashState == (player.getEntityData().func_74771_c("SB.MCS") & rapidSlashState) && current != ComboSequence.RapidSlash && current != ComboSequence.RapidSlashEnd) {
                result = ItemSlashBlade.hasOffhandSword(itemStack, (EntityLivingBase)player) ? ComboSequence.Stinger : ComboSequence.RapidSlash;
            } else if (upperSlashState == (player.getEntityData().func_74771_c("SB.MCS") & upperSlashState) && current != ComboSequence.Kiriage) {
                result = ComboSequence.Kiriage;
            } else {
                switch (current) {
                    case RapidSlash: {
                        result = ComboSequence.RapidSlashEnd;
                        break;
                    }
                    case Saya1: {
                        result = ComboSequence.Saya2;
                        break;
                    }
                    case Saya2: {
                        int rank = StylishRankManager.getStylishRank((Entity)player);
                        long last = LastActionTime.get(ItemSlashBlade.getItemTagCompound(itemStack));
                        long now = player.field_70170_p.func_82737_E();
                        if (rank < 5 || (double)ComboSequence.Saya2.comboResetTicks * 0.4 < (double)(now - last)) {
                            result = ComboSequence.Battou;
                            break;
                        }
                        result = ComboSequence.SIai;
                        break;
                    }
                    case Kiriage: {
                        if (0 >= (player.getEntityData().func_74771_c("SB.MCS") & 0x10)) {
                            result = ComboSequence.Kiriorosi;
                            break;
                        }
                        result = ComboSequence.Saya1;
                        break;
                    }
                    case SIai: {
                        result = ComboSequence.SSlashEdge;
                        break;
                    }
                    case SSlashEdge: {
                        result = ComboSequence.SReturnEdge;
                        break;
                    }
                    case SReturnEdge: {
                        result = ComboSequence.SSlashBlade;
                        break;
                    }
                    default: {
                        boolean hasOffhandSword = ItemSlashBlade.hasOffhandSword(itemStack, (EntityLivingBase)player);
                        if (this.ForceEdgeCombo.containsKey((Object)current) && hasOffhandSword) {
                            result = this.ForceEdgeCombo.get((Object)current);
                            break;
                        }
                        if (hasOffhandSword) {
                            result = ComboSequence.Force1;
                            break;
                        }
                        result = ComboSequence.Saya1;
                        break;
                    }
                }
            }
        } else {
            switch (current) {
                case Kiriage: {
                    result = ComboSequence.Kiriorosi;
                    break;
                }
                default: {
                    result = ComboSequence.Kiriage;
                }
            }
        }
        return result;
    }

    public void setPlayerEffect(ItemStack itemStack, ComboSequence current, EntityPlayer player) {
        EnumSet<SwordType> swordType = this.getSwordType(itemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        switch (current) {
            case RapidSlash: {
                EntityRapidSlashManager mgr;
                double playerDist = 2.5;
                if (!player.field_70122_E) {
                    playerDist *= (double)0.35f;
                }
                player.field_70159_w = -Math.sin(Math.toRadians(player.field_70177_z)) * playerDist;
                player.field_70179_y = Math.cos(Math.toRadians(player.field_70177_z)) * playerDist;
                UntouchableTime.setUntouchableTime((Entity)player, 6, false);
                if (player.field_70170_p.field_72995_K || (mgr = new EntityRapidSlashManager(player.field_70170_p, (EntityLivingBase)player, false)) == null) break;
                mgr.setLifeTime(6);
                player.field_70170_p.func_72838_d((Entity)mgr);
                break;
            }
            case Stinger: {
                EntityStingerManager mgr;
                int id = tag.func_74762_e("stingerMgr");
                Entity prevEntity = player.field_70170_p.func_73045_a(id);
                if (prevEntity != null && prevEntity instanceof EntityStingerManager && prevEntity.func_70089_S() || player.field_70170_p.field_72995_K || (mgr = new EntityStingerManager(player.field_70170_p, (EntityLivingBase)player, true)) == null) break;
                mgr.setLifeTime(4);
                player.field_70170_p.func_72838_d((Entity)mgr);
                tag.func_74768_a("stingerMgr", mgr.func_145782_y());
                break;
            }
            case HelmBraker: {
                EntityHelmBrakerManager mgr;
                player.field_70143_R = 0.0f;
                UntouchableTime.setUntouchableTime((Entity)player, 6, false);
                if (player.field_70170_p.field_72995_K || (mgr = new EntityHelmBrakerManager(player.field_70170_p, (EntityLivingBase)player, false)) == null) break;
                mgr.setLifeTime(20);
                player.field_70170_p.func_72838_d((Entity)mgr);
                break;
            }
            case Calibur: {
                player.field_70143_R = 0.0f;
                double playerDist = 2.5;
                player.field_70159_w = -Math.sin(Math.toRadians(player.field_70177_z)) * playerDist;
                player.field_70179_y = Math.cos(Math.toRadians(player.field_70177_z)) * playerDist;
                player.field_70181_x = 0.0;
                UntouchableTime.setUntouchableTime((Entity)player, 6, false);
                if (!player.field_70170_p.field_72995_K) break;
                NetworkManager.INSTANCE.sendToServer((IMessage)new MessageSpecialAction(5));
                break;
            }
            case ASlashEdge: 
            case AKiriorosi: {
                int level;
                player.field_70143_R = 0.0f;
                if (OnJumpAttacked.get(tag).booleanValue() || (level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)itemStack)) != 0) break;
                player.field_70181_x = 0.0;
                player.func_70024_g(0.0, 0.3, 0.0);
                break;
            }
            case AKiriage: {
                player.field_70143_R = 0.0f;
                player.field_70181_x = 0.0;
                player.func_70024_g(0.0, 0.7, 0.0);
                break;
            }
            case AKiriorosiFinish: {
                player.field_70143_R = 0.0f;
                player.field_70181_x = 0.0;
                player.func_70024_g(0.0, 0.1, 0.0);
                break;
            }
            case Iai: {
                int level;
                if (player.field_70122_E) break;
                player.field_70143_R = 0.0f;
                if (OnJumpAttacked.get(tag).booleanValue() || (level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)itemStack)) != 0) break;
                player.field_70181_x = 0.0;
                player.func_70024_g(0.0, 0.3, 0.0);
                break;
            }
            case Battou: {
                if (!player.field_70122_E) {
                    player.field_70143_R = 0.0f;
                    if (!OnJumpAttacked.get(tag).booleanValue()) {
                        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)itemStack);
                        if (level == 0) {
                            player.field_70181_x = 0.0;
                            player.func_70024_g(0.0, 0.2, 0.0);
                        }
                        OnJumpAttacked.set(tag, true);
                    }
                }
                if (!swordType.containsAll(SwordType.BewitchedPerfect)) break;
                Random rand = player.func_70681_au();
                for (int spread = 0; spread < 12; ++spread) {
                    float xSp = rand.nextFloat() * 2.0f - 1.0f;
                    float zSp = rand.nextFloat() * 2.0f - 1.0f;
                    xSp = (float)((double)xSp + 0.2 * (double)Math.signum(xSp));
                    zSp = (float)((double)zSp + 0.2 * (double)Math.signum(zSp));
                    player.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, player.field_70165_t + (double)(3.0f * xSp), player.field_70163_u + 0.5, player.field_70161_v + (double)(3.0f * zSp), 1.0, 1.0, 1.0, new int[0]);
                }
                break;
            }
        }
        if (!current.useScabbard) {
            if (IsCharged.get(tag).booleanValue()) {
                IsCharged.set(tag, false);
                int rank = StylishRankManager.getStylishRank((Entity)player);
                if (4 <= rank && !IsBroken.get(tag).booleanValue() && swordType.contains((Object)SwordType.Bewitched) && player instanceof EntityPlayer) {
                    this.doAddAttack(itemStack, player, current);
                }
            }
            switch (current) {
                case Force5: {
                    int rank = StylishRankManager.getStylishRank((Entity)player);
                    if (rank <= 4) break;
                }
                case Force6: 
                case SSlashBlade: {
                    this.doSlashBladeAttack(itemStack, (EntityLivingBase)player, current);
                    break;
                }
            }
            double d0 = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
            player.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 1.0f);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!OnClick.get(tag).booleanValue() && entity.func_70075_an() && (!entity.func_85031_j((Entity)player) || entity instanceof EntityLivingBase)) {
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_70738_aO != 0 && ComboInterval + 2 > ((EntityLivingBase)entity).field_70738_aO - ((EntityLivingBase)entity).field_70737_aN) {
                player.field_110158_av = 0;
                player.field_70733_aJ = 0.0f;
                player.field_82175_bq = false;
                return true;
            }
            ComboSequence comboSec = ItemSlashBlade.getComboSequence(tag);
            comboSec = this.getNextComboSeq(stack, comboSec, false, player);
            this.setPlayerEffect(stack, comboSec, player);
            ItemSlashBlade.setComboSequence(tag, comboSec);
            LastActionTime.set(tag, player.field_70170_p.func_82737_E());
            this.updateStyleAttackType(stack, (EntityLivingBase)player);
        }
        entity.field_70172_ad = 0;
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        JustGuard.setJustGuardState((EntityLivingBase)playerIn);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStackIn);
        long prevAttackTime = LastActionTime.get(tag);
        long currentTime = playerIn.field_70170_p.func_82737_E();
        ComboSequence comboSeq = ItemSlashBlade.getComboSequence(tag);
        this.nextAttackSequence(itemStackIn, comboSeq, playerIn);
        SilentUpdateItem.silentUpdateItem(playerIn, hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public void nextAttackSequence(ItemStack stack, ComboSequence prevComboSeq, EntityPlayer player) {
        ComboSequence comboSeq = this.getNextComboSeq(stack, prevComboSeq, true, player);
        this.doAttack(stack, comboSeq, player);
    }

    public void doAttack(ItemStack stack, ComboSequence comboSeq, EntityPlayer player) {
        World world = player.func_130014_f_();
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        EnumSet<SwordType> swordType = this.getSwordType(stack);
        long currentTime = world.func_82737_E();
        LastActionTime.set(tag, currentTime);
        OnClick.set(tag, true);
        this.setPlayerEffect(stack, comboSeq, player);
        ItemSlashBlade.setComboSequence(tag, comboSeq);
        this.doSwingItem(stack, (EntityLivingBase)player);
        this.updateStyleAttackType(stack, (EntityLivingBase)player);
        AxisAlignedBB bb = this.getBBofCombo(stack, comboSeq, (EntityLivingBase)player);
        int rank = StylishRankManager.getStylishRank((Entity)player);
        List list = world.func_175674_a((Entity)player, bb, EntitySelectorAttackable.getInstance());
        block4: for (Entity curEntity : list) {
            switch (comboSeq) {
                case Force3: 
                case Force4: 
                case Saya1: 
                case Saya2: {
                    float attack = 4.0f;
                    if (rank < 3 || swordType.contains((Object)SwordType.Broken)) {
                        attack = 2.0f;
                    } else {
                        attack += Item.ToolMaterial.STONE.func_78000_c();
                        if (swordType.contains((Object)SwordType.FiercerEdge) && player instanceof EntityPlayer) {
                            attack += AttackAmplifier.get(tag).floatValue() * 0.5f;
                        }
                    }
                    if (curEntity instanceof EntityLivingBase) {
                        float var4 = 0.0f;
                        var4 = EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)((EntityLivingBase)curEntity).func_70668_bt());
                        if (var4 > 0.0f) {
                            attack += var4;
                        }
                    }
                    if (curEntity instanceof EntityLivingBase) {
                        attack = Math.min(attack, ((EntityLivingBase)curEntity).func_110143_aJ() - 1.0f);
                    }
                    curEntity.field_70172_ad = 0;
                    curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), attack);
                    if (!(curEntity instanceof EntityLivingBase)) continue block4;
                    this.func_77644_a(stack, (EntityLivingBase)curEntity, (EntityLivingBase)player);
                    continue block4;
                }
                case None: {
                    continue block4;
                }
            }
            this.attackTargetEntity(stack, curEntity, player, true);
            player.func_71009_b(curEntity);
        }
        OnClick.set(tag, false);
        if (swordType.containsAll(SwordType.BewitchedPerfect) && comboSeq.equals((Object)ComboSequence.Battou)) {
            ItemSlashBlade.damageItem(stack, 10, (EntityLivingBase)player);
        }
    }

    public void doAddAttack(ItemStack stack, EntityPlayer player, ComboSequence setCombo) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            EntityDrive entityDrive;
            int cost = -10;
            if (!ProudSoul.tryAdd(tag, -10, false)) {
                ItemSlashBlade.damageItem(stack, 5, (EntityLivingBase)player);
            }
            float baseModif = this.getBaseAttackModifiers(tag);
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            float magicDamage = baseModif;
            int rank = StylishRankManager.getStylishRank((Entity)player);
            if (5 <= rank) {
                magicDamage += AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
            }
            if ((entityDrive = new EntityDrive(world, (EntityLivingBase)player, magicDamage, false, 90.0f - setCombo.swingDirection)) != null) {
                entityDrive.setInitialSpeed(0.75f);
                entityDrive.setLifeTime(20);
                world.func_72838_d((Entity)entityDrive);
            }
            ItemSlashBlade.setComboSequence(tag, setCombo);
            return;
        }
    }

    public void doSlashBladeAttack(ItemStack stack, EntityLivingBase player, ComboSequence setCombo) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        World world = player.field_70170_p;
        player.func_184185_a(SoundEvents.field_187730_dW, 0.8f, 0.01f);
        if (!world.field_72995_K) {
            boolean disableMultiHit;
            EntityDrive entityDrive;
            float baseModif = this.getBaseAttackModifiers(tag);
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            float magicDamage = baseModif;
            int rank = StylishRankManager.getStylishRank((Entity)player);
            if (5 <= rank) {
                magicDamage += AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
            }
            if ((entityDrive = new EntityDrive(world, player, magicDamage, disableMultiHit = rank <= 5, 90.0f - Math.abs(setCombo.swingDirection))) != null) {
                entityDrive.setInitialSpeed(0.1f);
                entityDrive.setLifeTime(20);
                EnumSet<SwordType> type = this.getSwordType(stack);
                entityDrive.setIsSlashDimension(type.contains((Object)SwordType.FiercerEdge));
                world.func_72838_d((Entity)entityDrive);
            }
            ItemSlashBlade.setComboSequence(tag, setCombo);
            return;
        }
    }

    public void doChargeAttack(ItemStack stack, EntityPlayer par3EntityPlayer, boolean isJust) {
        AchievementList.triggerAchievement(par3EntityPlayer, "enchanted");
        SpecialAttackBase sa = this.getSpecialAttack(stack);
        if (isJust && sa instanceof IJustSpecialAttack) {
            ((IJustSpecialAttack)((Object)sa)).doJustSpacialAttack(stack, par3EntityPlayer);
        } else {
            sa.doSpacialAttack(stack, par3EntityPlayer);
        }
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        IsCharged.set(tag, true);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        EnumSet<SwordType> swordType = this.getSwordType(stack);
        int charge = this.func_77626_a(stack) - count;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (player.field_70170_p.field_72995_K && player.field_70122_E) {
            if (charge == 3 && ItemSlashBlade.getComboSequence(tag) == ComboSequence.Kiriage) {
                Method jump = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)player, (String[])new String[]{"jump", "func_70664_aZ"}, (Class[])new Class[0]);
                try {
                    if (jump != null) {
                        jump.invoke((Object)player, new Object[0]);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                player.func_70024_g(0.0, 0.2, 0.0);
            } else if (charge == 7 && ItemSlashBlade.getComboSequence(tag) == ComboSequence.RapidSlash) {
                if (player.field_70170_p.field_72995_K) {
                    Method jump = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)player, (String[])new String[]{"jump", "func_70664_aZ"}, (Class[])new Class[0]);
                    try {
                        if (jump != null) {
                            jump.invoke((Object)player, new Object[0]);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    player.func_70024_g(0.0, 0.2, 0.0);
                    NetworkManager.INSTANCE.sendToServer((IMessage)new MessageSpecialAction(4));
                }
                ItemSlashBlade.setComboSequence(tag, ComboSequence.RisingStar);
                this.doSwingItem(stack, player);
            }
        }
        if (player instanceof EntityPlayer && RequiredChargeTick == charge && swordType.contains((Object)SwordType.Enchanted) && !swordType.contains((Object)SwordType.Broken)) {
            ((EntityPlayer)player).func_71009_b((Entity)player);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        int var6 = this.func_77626_a(stack) - timeLeft;
        EnumSet<SwordType> swordType = this.getSwordType(stack);
        if (RequiredChargeTick < var6 && swordType.contains((Object)SwordType.Enchanted) && !swordType.contains((Object)SwordType.Broken)) {
            SilentUpdateItem.forceUpdate(stack, (Entity)entityLiving);
            this.doSwingItem(stack, entityLiving);
            boolean isJust = false;
            if (var6 < RequiredChargeTick + 4) {
                if (entityLiving instanceof EntityPlayer) {
                    ((EntityPlayer)entityLiving).func_71047_c((Entity)entityLiving);
                }
                isJust = true;
            }
            if (entityLiving instanceof EntityPlayer) {
                this.doChargeAttack(stack, (EntityPlayer)entityLiving, isJust);
            }
            LastActionTime.set(tag, entityLiving.field_70170_p.func_82737_E());
        }
        if (ItemSlashBlade.getComboSequence(tag) == ComboSequence.Kiriage && entityLiving.field_70170_p.field_72995_K && entityLiving.getEntityData().func_74764_b("SB.MCS.B")) {
            entityLiving.getEntityData().func_82580_o("SB.MCS.B");
        }
    }

    public NBTTagCompound getAttrTag(String attrName, AttributeModifier par0AttributeModifier, EntityEquipmentSlot slot) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("AttributeName", attrName);
        nbttagcompound.func_74778_a("Name", par0AttributeModifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", par0AttributeModifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", par0AttributeModifier.func_111169_c());
        nbttagcompound.func_186854_a("UUID", par0AttributeModifier.func_111167_a());
        nbttagcompound.func_74778_a("Slot", slot.func_188450_d());
        return nbttagcompound;
    }

    public AxisAlignedBB getBBofCombo(ItemStack itemStack, ComboSequence combo, EntityLivingBase user) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        EnumSet<SwordType> swordType = this.getSwordType(itemStack);
        AxisAlignedBB bb = user.func_174813_aQ();
        Vec3d vec = user.func_70040_Z();
        vec = new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c);
        vec = vec.func_72432_b();
        switch (combo) {
            case RisingStar: 
            case Stinger: 
            case ReturnEdge: 
            case Battou: 
            case Calibur: 
            case RapidSlash: 
            case SlashEdge: 
            case SSlashEdge: 
            case SReturnEdge: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                if (swordType.containsAll(SwordType.BewitchedPerfect)) {
                    bb = bb.func_72314_b(5.0, 0.75, 5.0);
                    break;
                }
                bb = bb.func_72314_b(2.0, 0.75, 2.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            case SSlashBlade: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b(3.0, 1.0, 3.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            case SIai: 
            case Iai: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b(2.0, 1.0, 2.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            case Saya1: 
            case Saya2: {
                bb = bb.func_72314_b((double)1.2f, 0.25, (double)1.2f);
                bb = bb.func_72317_d(vec.field_72450_a * 2.0, 0.0, vec.field_72449_c * 2.0);
                break;
            }
            case HelmBraker: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b(2.0, 2.5, 2.0);
                bb = bb.func_72317_d(vec.field_72450_a * 2.5, 0.0, vec.field_72449_c * 2.5);
                break;
            }
            default: {
                if (swordType.contains((Object)SwordType.Broken)) {
                    bb = bb.func_72314_b(1.0, 0.0, 1.0);
                    bb = bb.func_72317_d(vec.field_72450_a * 1.0, 0.0, vec.field_72449_c * 1.0);
                    break;
                }
                bb = bb.func_72314_b((double)1.2f, 1.25, (double)1.2f);
                bb = bb.func_72317_d(vec.field_72450_a * 2.0, 0.5, vec.field_72449_c * 2.0);
            }
        }
        return bb;
    }

    public EnumSet<SwordType> getSwordType(ItemStack itemStack) {
        EnumSet<SwordType> result = EnumSet.noneOf(SwordType.class);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(itemStack);
        if (IsSealed.get(tag).booleanValue()) {
            result.add(SwordType.Sealed);
        } else if (itemStack.func_77948_v()) {
            result.add(SwordType.Enchanted);
            if (itemStack.func_82837_s() || ItemSlashBladeNamed.IsDefaultBewitched.get(tag).booleanValue()) {
                result.add(SwordType.Bewitched);
            }
        }
        if (itemStack.func_77952_i() == 0 && !result.contains((Object)SwordType.Sealed)) {
            result.add(SwordType.Perfect);
        }
        if (IsBroken.get(tag).booleanValue()) {
            if (result.contains((Object)SwordType.Perfect)) {
                IsBroken.set(tag, false);
            } else {
                result.add(SwordType.Broken);
            }
        }
        if (1000 <= ProudSoul.get(tag)) {
            result.add(SwordType.SoulEeater);
        }
        if (1000 <= KillCount.get(tag)) {
            result.add(SwordType.FiercerEdge);
        }
        if (IsNoScabbard.get(tag).booleanValue()) {
            result.add(SwordType.NoScabbard);
        }
        return result;
    }

    public void updateAttackAmplifier(EnumSet<SwordType> swordType, NBTTagCompound tag, EntityLivingBase el, ItemStack sitem) {
        float tagAttackAmplifier = AttackAmplifier.get(tag).floatValue();
        float baseModif = this.getBaseAttackModifiers(tag);
        float attackAmplifier = 0.0f;
        int rank = StylishRankManager.getStylishRank((Entity)el);
        if (rank < 3 || swordType.contains((Object)SwordType.Broken) || swordType.contains((Object)SwordType.Sealed)) {
            attackAmplifier = 2.0f - baseModif;
        } else if (rank == 7 || 5 <= rank && swordType.contains((Object)SwordType.FiercerEdge)) {
            float level = el instanceof EntityPlayer ? (float)((EntityPlayer)el).field_71068_ca : el.func_110143_aJ();
            float max = 10.0f + (float)RepairCount.get(tag).intValue();
            attackAmplifier = Math.min(level, max);
        }
        if (tagAttackAmplifier != attackAmplifier) {
            AttackAmplifier.set(tag, Float.valueOf(attackAmplifier));
            NBTTagList attrTag = null;
            attrTag = new NBTTagList();
            tag.func_74782_a("AttributeModifiers", (NBTBase)attrTag);
            attrTag.func_74742_a((NBTBase)this.getAttrTag(SharedMonsterAttributes.field_111264_e.func_111108_a(), new AttributeModifier(field_111210_e, "Weapon modifier", (double)(attackAmplifier + baseModif), 0), EntityEquipmentSlot.MAINHAND));
            attrTag.func_74742_a((NBTBase)this.getAttrTag(SharedMonsterAttributes.field_188790_f.func_111108_a(), new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0), EntityEquipmentSlot.MAINHAND));
            el.func_110140_aT().func_111148_a(sitem.func_111283_C(EntityEquipmentSlot.MAINHAND));
            el.func_110140_aT().func_111147_b(sitem.func_111283_C(EntityEquipmentSlot.MAINHAND));
        }
    }

    public void func_77663_a(ItemStack sitem, World par2World, Entity par3Entity, int indexOfMainSlot, boolean isCurrent) {
        int cost;
        SilentUpdateItem.onUpdate(sitem, par3Entity, isCurrent);
        if (SlashBladeHooks.onUpdateHooks(sitem, par2World, par3Entity, indexOfMainSlot, isCurrent)) {
            return;
        }
        if (!(par3Entity instanceof EntityLivingBase)) {
            super.func_77663_a(sitem, par2World, par3Entity, indexOfMainSlot, isCurrent);
            return;
        }
        EntityLivingBase el = (EntityLivingBase)par3Entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(sitem);
        int curDamage = sitem.func_77952_i();
        EnumSet<SwordType> swordType = this.getSwordType(sitem);
        this.updateAttackAmplifier(swordType, tag, el, sitem);
        if (tag.func_186855_b("Owner")) {
            UUID ownerid = tag.func_186857_a("Owner");
            boolean isOwner = ownerid.equals(el.func_110124_au());
            if (isOwner && IsSealed.get(tag).booleanValue()) {
                IsSealed.set(tag, false);
            } else if (!isOwner) {
                IsSealed.set(tag, true);
            }
        }
        if ((cost = sitem.func_82838_A()) != 0) {
            Map map = EnchantmentHelper.func_82781_a((ItemStack)sitem);
            cost = map.size() + 1;
            ProudSoul.add(tag, cost *= AnvilRepairBonus);
            RepairCount.add(tag, 1);
            sitem.func_82841_c(0);
        }
        if (!isCurrent && !par2World.field_72995_K && el instanceof EntityPlayer && swordType.contains((Object)SwordType.Bewitched) && !swordType.contains((Object)SwordType.NoScabbard) && 0 < curDamage && par2World.func_82737_E() % 20L == 0L) {
            int idx = Arrays.asList(((EntityPlayer)el).field_71071_by.field_70462_a).indexOf(sitem);
            boolean doMaterialRepair = false;
            if (0 <= idx && idx < 9 && swordType.contains((Object)SwordType.Broken)) {
                ItemStack tinySoul = SlashBlade.findItemStack("flammpfeil.slashblade", "tiny_bladesoul", 1);
                ItemStack tinySoulHasEmptyTag = tinySoul.func_77946_l();
                tinySoulHasEmptyTag.func_77982_d(new NBTTagCompound());
                boolean bl = doMaterialRepair = InventoryUtility.consumeInventoryItem((IInventory)((EntityPlayer)el).field_71071_by, tinySoul, false) || InventoryUtility.consumeInventoryItem((IInventory)((EntityPlayer)el).field_71071_by, tinySoulHasEmptyTag, false);
            }
            if (0 <= idx && idx < 9 && 0 < ((EntityPlayer)el).field_71068_ca || doMaterialRepair) {
                int repair;
                int descExp = 0;
                int descLv = 0;
                int addProudSoul = 0;
                if (doMaterialRepair) {
                    repair = Math.max(1, (int)((double)sitem.func_77958_k() / 10.0));
                } else if (swordType.contains((Object)SwordType.Broken)) {
                    repair = Math.max(1, (int)((double)sitem.func_77958_k() / 10.0));
                    addProudSoul = 20;
                    descLv = 1;
                } else {
                    repair = 1;
                    descExp = 10;
                    addProudSoul = 10;
                }
                if (0 < curDamage) {
                    ((EntityPlayer)el).func_71020_j(0.025f);
                    sitem.func_77964_b(Math.max(0, curDamage - repair));
                }
                ProudSoul.add(tag, addProudSoul);
                if (0 < descExp) {
                    while (descExp > 0 && ((EntityPlayer)el).field_71068_ca > 0) {
                        ((EntityPlayer)el).func_71023_q(-1);
                        if (((EntityPlayer)el).field_71106_cc < 0.0f) {
                            if (((EntityPlayer)el).field_71068_ca <= 0) {
                                ((EntityPlayer)el).field_71106_cc = 0.0f;
                            } else {
                                ((EntityPlayer)el).func_82242_a(-1);
                                ((EntityPlayer)el).field_71106_cc = 1.0f - 0.9f / (float)((EntityPlayer)el).func_71050_bK();
                            }
                        }
                        --descExp;
                    }
                }
                if (0 < descLv) {
                    while (descLv > 0) {
                        if (0 < ((EntityPlayer)el).field_71068_ca) {
                            ((EntityPlayer)el).func_82242_a(-1);
                        }
                        --descLv;
                    }
                }
            }
        }
        if (el.field_70122_E && OnJumpAttacked.get(tag).booleanValue()) {
            OnJumpAttacked.set(tag, false);
        }
        ComboSequence comboSeq = ItemSlashBlade.getComboSequence(tag);
        long prevAttackTime = LastActionTime.get(tag);
        long currentTime = el.field_70170_p.func_82737_E();
        if (currentTime + 1000L < prevAttackTime) {
            prevAttackTime = 0L;
            LastActionTime.set(tag, 0L);
        }
        if (isCurrent) {
            if (comboSeq != ComboSequence.None && prevAttackTime + (long)(comboSeq.comboResetTicks - (el.field_70170_p.field_72995_K ? 1 : 0)) < currentTime + 1L && (comboSeq.useScabbard || !el.field_82175_bq)) {
                switch (comboSeq) {
                    case None: {
                        break;
                    }
                    case Noutou: {
                        if (tag.func_74762_e(lastPosHashStr) == (int)((el.field_70165_t + el.field_70161_v) * 10.0)) {
                            SoulEater.fire(sitem, el);
                            if (el.field_70122_E) {
                                Taunt.fire(sitem, el);
                            }
                            AxisAlignedBB bb = el.func_174813_aQ();
                            List list = par2World.func_175674_a((Entity)el, bb = bb.func_72314_b(10.0, 5.0, 10.0), EntitySelectorAttackable.getInstance());
                            if (0 < list.size()) {
                                StylishRankManager.addRankPoint((Entity)el, StylishRankManager.AttackTypes.Noutou);
                                if (el instanceof EntityPlayer) {
                                    ((EntityPlayer)el).func_71009_b((Entity)el);
                                }
                            }
                        }
                        StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
                        ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
                        break;
                    }
                    case SIai: 
                    case Iai: 
                    case SlashDim: {
                        StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
                        ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
                        SoulEater.fire(sitem, el);
                        break;
                    }
                    default: {
                        if (comboSeq.useScabbard || comboSeq.mainHandCombo != null && comboSeq.mainHandCombo.useScabbard) {
                            StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
                            ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
                            break;
                        }
                        tag.func_74768_a(lastPosHashStr, (int)((el.field_70165_t + el.field_70161_v) * 10.0));
                        LastActionTime.set(tag, currentTime + 5L);
                        ItemSlashBlade.setComboSequence(tag, ComboSequence.Noutou);
                        if (!el.field_70170_p.field_72995_K) {
                            el.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 5, 0, true, false));
                        }
                        UpthrustBlast.doBlast(sitem, el);
                        this.doSwingItem(sitem, el);
                    }
                }
            }
            if (!comboSeq.equals((Object)ComboSequence.None) && el.field_110158_av != 0 && currentTime < prevAttackTime + (long)comboSeq.comboResetTicks) {
                this.DestructEntity(el, sitem);
            }
        } else if (!comboSeq.equals((Object)ComboSequence.None) && prevAttackTime + (long)comboSeq.comboResetTicks < currentTime) {
            StylishRankManager.setNextAttackType((Entity)el, StylishRankManager.AttackTypes.None);
            ItemSlashBlade.setComboSequence(tag, ComboSequence.None);
        }
        if (sitem.equals(el.func_184586_b(EnumHand.MAIN_HAND))) {
            Entity target;
            if (!el.field_70170_p.field_72995_K) {
                int eId = TargetEntityId.get(tag);
                if (0 < (el.getEntityData().func_74771_c("SB.MCS") & 0x10)) {
                    if (eId == 0) {
                        Entity rayEntity = this.getRayTrace(el, 20.0);
                        if (rayEntity == null) {
                            rayEntity = this.getRayTrace(el, 10.0, 5.0f);
                        }
                        if (rayEntity != null) {
                            eId = rayEntity.func_145782_y();
                        } else {
                            AxisAlignedBB bb = el.func_174813_aQ();
                            bb = bb.func_72314_b(10.0, 5.0, 10.0);
                            float distance = 20.0f;
                            List list = par2World.func_175674_a((Entity)el, bb, EntitySelectorAttackable.getInstance());
                            for (Entity curEntity : list) {
                                float curDist;
                                if (!el.func_70685_l(curEntity) || !((curDist = curEntity.func_70032_d((Entity)el)) < distance)) continue;
                                eId = curEntity.func_145782_y();
                                distance = curDist;
                            }
                        }
                        TargetEntityId.set(tag, eId);
                    } else {
                        target = par2World.func_73045_a(eId);
                        if (target != null && !target.func_70089_S()) {
                            TargetEntityId.set(tag, 0);
                        }
                        if (3 <= EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)sitem) && (target = par2World.func_73045_a(eId)) != null && target instanceof EntityWither && 10.0f > el.func_70032_d(target) && (double)(((EntityWither)target).func_110143_aJ() / ((EntityWither)target).func_110138_aP()) > 0.5) {
                            Vec3d vec = el.func_70040_Z();
                            double y = -vec.field_72448_b * 2.0;
                            if (target.field_70163_u <= el.field_70163_u + 5.0) {
                                y = 0.0;
                            }
                            target.func_70024_g(vec.field_72450_a, y, vec.field_72449_c);
                        }
                    }
                } else if (eId != 0) {
                    TargetEntityId.set(tag, 0);
                }
            } else {
                int eId = TargetEntityId.get(tag);
                if (eId != 0) {
                    target = par2World.func_73045_a(eId);
                    if (target != null) {
                        this.faceEntity(el, target, 10.0f, 10.0f);
                    }
                } else {
                    byte camState = el.getEntityData().func_74771_c("camerareset");
                    if (0 < (el.getEntityData().func_74771_c("SB.MCS") & 0x20)) {
                        switch (camState) {
                            case 0: {
                                el.getEntityData().func_74774_a("camerareset", (byte)1);
                                break;
                            }
                            case 1: {
                                float par2 = 180.0f;
                                float par3 = 180.0f;
                                double d0 = el.field_70159_w;
                                double d1 = el.field_70179_y;
                                Vec3d vec3d = new Vec3d(d0, 0.0, d1);
                                if (vec3d.func_72433_c() < (double)0.05f) {
                                    el.getEntityData().func_74774_a("camerareset", (byte)2);
                                    break;
                                }
                                double d2 = el.field_70163_u + (double)el.func_70047_e() - (el.field_70163_u + (double)el.func_70047_e());
                                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                                float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
                                float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
                                el.field_70125_A = this.updateRotation(el.field_70125_A, f3, par3);
                                el.field_70125_A = Math.min(Math.max(el.field_70125_A, 0.0f), 60.0f);
                                el.field_70177_z = this.updateRotation(el.field_70177_z, f2, par2);
                                el.getEntityData().func_74774_a("camerareset", (byte)2);
                                break;
                            }
                        }
                    } else if (camState != 0) {
                        el.getEntityData().func_74774_a("camerareset", (byte)0);
                    }
                }
            }
        }
    }

    public Map crateAttackTypeMap() {
        this.attackTypeMap = Maps.newHashMap();
        this.attackTypeMap.put(ComboSequence.Kiriage, StylishRankManager.AttackTypes.Kiriage);
        this.attackTypeMap.put(ComboSequence.Kiriorosi, StylishRankManager.AttackTypes.Kiriorosi);
        this.attackTypeMap.put(ComboSequence.Iai, StylishRankManager.AttackTypes.Iai);
        this.attackTypeMap.put(ComboSequence.Saya1, StylishRankManager.AttackTypes.Saya1);
        this.attackTypeMap.put(ComboSequence.Saya2, StylishRankManager.AttackTypes.Saya2);
        this.attackTypeMap.put(ComboSequence.HiraTuki, StylishRankManager.AttackTypes.Kiriage);
        this.attackTypeMap.put(ComboSequence.SlashEdge, StylishRankManager.AttackTypes.SlashEdge);
        this.attackTypeMap.put(ComboSequence.ReturnEdge, StylishRankManager.AttackTypes.ReturnEdge);
        this.attackTypeMap.put(ComboSequence.SIai, StylishRankManager.AttackTypes.SIai);
        this.attackTypeMap.put(ComboSequence.SSlashEdge, StylishRankManager.AttackTypes.SSlashEdge);
        this.attackTypeMap.put(ComboSequence.SReturnEdge, StylishRankManager.AttackTypes.SReturnEdge);
        this.attackTypeMap.put(ComboSequence.SSlashBlade, StylishRankManager.AttackTypes.SSlashBlade);
        this.attackTypeMap.put(ComboSequence.ASlashEdge, StylishRankManager.AttackTypes.ASlashEdge);
        this.attackTypeMap.put(ComboSequence.AKiriorosi, StylishRankManager.AttackTypes.AKiriorosi);
        this.attackTypeMap.put(ComboSequence.AKiriage, StylishRankManager.AttackTypes.AKiriage);
        this.attackTypeMap.put(ComboSequence.AKiriorosiFinish, StylishRankManager.AttackTypes.AKiriorosiFinish);
        this.attackTypeMap.put(ComboSequence.HelmBraker, StylishRankManager.AttackTypes.HelmBraker);
        this.attackTypeMap.put(ComboSequence.Calibur, StylishRankManager.AttackTypes.Calibur);
        this.attackTypeMap.put(ComboSequence.RapidSlash, StylishRankManager.AttackTypes.RapidSlash);
        this.attackTypeMap.put(ComboSequence.RisingStar, StylishRankManager.AttackTypes.RisingStar);
        this.attackTypeMap.put(ComboSequence.Force1, StylishRankManager.AttackTypes.Force1);
        this.attackTypeMap.put(ComboSequence.Force2, StylishRankManager.AttackTypes.Force2);
        this.attackTypeMap.put(ComboSequence.Force3, StylishRankManager.AttackTypes.Force3);
        this.attackTypeMap.put(ComboSequence.Force4, StylishRankManager.AttackTypes.Force4);
        this.attackTypeMap.put(ComboSequence.Force5, StylishRankManager.AttackTypes.Force5);
        this.attackTypeMap.put(ComboSequence.Force6, StylishRankManager.AttackTypes.Force6);
        this.attackTypeMap.put(ComboSequence.Stinger, StylishRankManager.AttackTypes.RapidSlash);
        return this.attackTypeMap;
    }

    private void updateStyleAttackType(ItemStack stack, EntityLivingBase e) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        ComboSequence combo = ItemSlashBlade.getComboSequence(tag);
        String key = this.attackTypeMap.get((Object)combo);
        if (key == null) {
            switch (combo) {
                case Battou: {
                    EnumSet<SwordType> swordType = this.getSwordType(stack);
                    if (swordType.containsAll(SwordType.BewitchedPerfect)) {
                        if (e instanceof EntityPlayer) {
                            AchievementList.triggerAchievement((EntityPlayer)e, "bewitched");
                        }
                        key = StylishRankManager.AttackTypes.IaiBattou;
                        break;
                    }
                    if (e.field_70122_E) {
                        key = StylishRankManager.AttackTypes.Battou;
                        break;
                    }
                    key = StylishRankManager.AttackTypes.JumpBattou;
                    break;
                }
                default: {
                    key = StylishRankManager.AttackTypes.SimpleAttack;
                }
            }
        }
        StylishRankManager.setNextAttackType((Entity)e, key);
    }

    protected void dropXpOnBlockBreak(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.field_72995_K) {
            while (par5 > 0) {
                int i1 = EntityXPOrb.func_70527_a((int)par5);
                par5 -= i1;
                par1World.func_72838_d((Entity)new EntityXPOrb(par1World, (double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, i1));
            }
        }
    }

    public void faceEntity(EntityLivingBase owner, Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - owner.field_70165_t;
        double d1 = par1Entity.field_70161_v - owner.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)par1Entity;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (owner.field_70163_u + (double)owner.func_70047_e());
        } else {
            d2 = (par1Entity.func_174813_aQ().field_72338_b + par1Entity.func_174813_aQ().field_72337_e) / 2.0 - (owner.field_70163_u + (double)owner.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        owner.field_70125_A = this.updateRotation(owner.field_70125_A, f3, par3);
        owner.field_70125_A = Math.min(Math.max(owner.field_70125_A, 0.0f), 60.0f);
        owner.field_70177_z = this.updateRotation(owner.field_70177_z, f2, par2);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationOwner(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        UUID ownerid;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (tag.func_186855_b("Owner") && par2EntityPlayer != null && !(ownerid = tag.func_186857_a("Owner")).equals(par2EntityPlayer.func_110124_au())) {
            par3List.add(I18n.func_74838_a((String)"flammpfeil.swaepon.info.notowner.msg"));
            EntityPlayer owner = par2EntityPlayer.field_70170_p.func_152378_a(ownerid);
            if (owner != null) {
                par3List.add("owner:" + owner.func_70005_c_());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationSwordClass(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (swordType.contains((Object)SwordType.Enchanted)) {
            if (swordType.contains((Object)SwordType.Bewitched)) {
                if (tag.func_186855_b("Owner")) {
                    par3List.add(String.format("\u00a76%s", I18n.func_74838_a((String)"flammpfeil.swaepon.info.bewitched")));
                } else {
                    par3List.add(String.format("\u00a75%s", I18n.func_74838_a((String)"flammpfeil.swaepon.info.bewitched")));
                }
            } else {
                par3List.add(String.format("\u00a73%s", I18n.func_74838_a((String)"flammpfeil.swaepon.info.magic")));
            }
        } else {
            par3List.add(String.format("\u00a78%s", I18n.func_74838_a((String)"flammpfeil.swaepon.info.noname")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationKillCount(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        par3List.add(String.format("%sKillCount : %d", swordType.contains((Object)SwordType.FiercerEdge) ? "\u00a74" : "", KillCount.get(tag)));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationProudSoul(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        par3List.add(String.format("%sProudSoul : %d", swordType.contains((Object)SwordType.SoulEeater) ? "\u00a75" : "", ProudSoul.get(tag)));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationSpecialAttack(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (swordType.contains((Object)SwordType.Bewitched)) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
            String key = "flammpfeil.slashblade.specialattack." + this.getSpecialAttack(par1ItemStack).toString();
            par3List.add(String.format("SA:%s", I18n.func_74838_a((String)key)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationRangeAttack(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        if (swordType.contains((Object)SwordType.Bewitched) && 0 < EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)par1ItemStack)) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
            String key = "slashblade.rangeattack." + Boolean.toString(tag.func_74767_n("RangeAttackType")).toLowerCase();
            par3List.add(I18n.func_74838_a((String)key));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationRepairCount(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        int repair = RepairCount.get(tag);
        if (0 < repair) {
            par3List.add(String.format("Refine : %d", repair));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationMaxAttack(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        String template;
        String header;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        float repair = RepairCount.get(tag).intValue();
        EnumSet<SwordType> swordType = this.getSwordType(par1ItemStack);
        par3List.add("");
        par3List.add("\u00a74RankAttackDamage");
        if (swordType.contains((Object)SwordType.FiercerEdge)) {
            header = "\u00a76B-A\u00a7r/\u00a74S-SSS\u00a7r/\u00a75Limit";
            template = "\u00a76+%.1f\u00a7r/\u00a74+%.1f\u00a7r/\u00a75+%.1f";
        } else {
            header = "\u00a76B-SS\u00a7r/\u00a74SSS\u00a7r/\u00a75Limit";
            template = "\u00a76+%.1f\u00a7r/\u00a74+%.1f\u00a7r/\u00a75+%.1f";
        }
        float baseModif = this.getBaseAttackModifiers(tag);
        float maxBonus = 10.0f + repair;
        float level = par2EntityPlayer.field_71068_ca;
        float ba = baseModif;
        float sss = baseModif + Math.min(maxBonus, level);
        par3List.add(header);
        par3List.add(String.format(template, Float.valueOf(ba), Float.valueOf(sss), Float.valueOf(baseModif + maxBonus)));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationSpecialEffec(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        NBTTagCompound etag = ItemSlashBlade.getSpecialEffect(par1ItemStack);
        Set tagKeys = etag.func_150296_c();
        if (tagKeys.size() == 0) {
            return;
        }
        int playerLevel = par2EntityPlayer.field_71068_ca;
        par3List.add("");
        for (String key : tagKeys) {
            int reqiredLevel = etag.func_74762_e(key);
            par3List.add(I18n.func_74838_a((String)("slashblade.seffect.name." + key)) + "\u00a7r " + (reqiredLevel <= playerLevel ? "\u00a7c" : "\u00a78") + reqiredLevel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationEnergy(ItemStack stack, EntityPlayer player, List lines, boolean advanced) {
        if (!stack.hasCapability(BladeCapabilityProvider.ENERGY, null)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(BladeCapabilityProvider.ENERGY, null);
        if (storage == null) {
            return;
        }
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            lines.add("\u00a77" + I18n.func_74838_a((String)"flammpfeil.sweapon.info.hold") + " \u00a7e\u00a7o" + I18n.func_74838_a((String)"flammpfeil.sweapon.info.shift") + " \u00a7r\u00a77" + I18n.func_74838_a((String)"flammpfeil.sweapon.info.forDetails") + "\u00a7r");
        } else {
            lines.add(I18n.func_74838_a((String)"flammpfeil.sweapon.info.energy") + ":" + String.format("%,3.1fK/%,3.1fK", (double)storage.getEnergyStored() / 1000.0, (double)storage.getMaxEnergyStored() / 1000.0));
            int level = ItemSlashBlade.getSpecialEffect(stack).func_74762_e(SpecialEffects.HFCustom.getEffectKey());
            if (0 < level) {
                if (HFCustom.isEmpowered(stack)) {
                    lines.add(I18n.func_74838_a((String)"flammpfeil.sweapon.info.hfeffect.trunoff"));
                } else {
                    lines.add(I18n.func_74838_a((String)"flammpfeil.sweapon.info.hfeffect.trunon"));
                }
            }
        }
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationOwner(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationSwordClass(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationKillCount(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationProudSoul(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationSpecialAttack(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationRepairCount(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationRangeAttack(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationSpecialEffec(par1ItemStack, par2EntityPlayer, par3List, par4);
        this.addInformationMaxAttack(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(par1ItemStack);
        if (tag.func_74764_b(adjustXStr)) {
            float ax = tag.func_74760_g(adjustXStr);
            float ay = tag.func_74760_g(adjustYStr);
            float az = tag.func_74760_g(adjustZStr);
            par3List.add(String.format("adjust x:%.1f y:%.1f z:%.1f", Float.valueOf(ax), Float.valueOf(ay), Float.valueOf(az)));
        }
        this.addInformationEnergy(par1ItemStack, par2EntityPlayer, par3List, par4);
    }

    public Vec3d getEntityToEntityVec(Entity root, Entity target, float yawLimit, float pitchLimit) {
        double d2;
        double d0 = target.field_70165_t + target.field_70159_w - root.field_70165_t;
        double d1 = target.field_70161_v + target.field_70179_y - root.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d2 = entitylivingbase.field_70163_u + entitylivingbase.field_70181_x + (double)entitylivingbase.func_70047_e() - (root.field_70163_u + (double)root.func_70047_e());
        } else {
            d2 = (target.func_174813_aQ().field_72338_b + target.func_174813_aQ().field_72337_e) / 2.0 + target.field_70181_x - (root.field_70163_u + (double)root.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        double yaw = Math.atan2(d1, d0) - 1.5707963267948966;
        double pitch = Math.atan2(d2, d3);
        double y = Math.sin(pitch);
        double x = -Math.sin(yaw);
        double z = Math.cos(yaw);
        return new Vec3d(x, y, z).func_72432_b();
    }

    public void ReflectionProjecTile(Entity projecTile, EntityLivingBase player) {
        EntityLivingBase target = null;
        if (projecTile instanceof EntityFireball) {
            target = ((EntityFireball)projecTile).field_70235_a;
        } else if (projecTile instanceof EntityArrow) {
            target = ((EntityArrow)projecTile).field_70250_c;
        }
        if (target != null) {
            Vec3d vec = this.getEntityToEntityVec(projecTile, (Entity)target, 360.0f, 360.0f);
            this.InductionProjecTile(projecTile, player, vec);
        } else {
            Vec3d vec = new Vec3d(-projecTile.field_70159_w, -projecTile.field_70181_x, -projecTile.field_70179_y);
            vec = vec.func_72432_b();
            this.InductionProjecTile(projecTile, player, vec);
        }
    }

    public void InductionProjecTile(Entity projecTile, EntityLivingBase user) {
        this.InductionProjecTile(projecTile, user, user.func_70040_Z());
    }

    public void InductionProjecTile(Entity projecTile, EntityLivingBase user, Vec3d dir) {
        if (dir != null) {
            Vec3d vector = new Vec3d(projecTile.field_70159_w, projecTile.field_70181_x, projecTile.field_70179_y);
            projecTile.field_70159_w = dir.field_72450_a;
            projecTile.field_70181_x = dir.field_72448_b;
            projecTile.field_70179_y = dir.field_72449_c;
            if (projecTile instanceof EntityFireball) {
                ((EntityFireball)projecTile).field_70232_b = projecTile.field_70159_w * 0.1;
                ((EntityFireball)projecTile).field_70233_c = projecTile.field_70181_x * 0.1;
                ((EntityFireball)projecTile).field_70230_d = projecTile.field_70179_y * 0.1;
            }
            if (projecTile instanceof EntityArrow) {
                ((EntityArrow)projecTile).func_70243_d(true);
            }
            projecTile.field_70159_w *= 1.5;
            projecTile.field_70181_x *= 1.5;
            projecTile.field_70179_y *= 1.5;
        }
        if (user != null) {
            if (projecTile instanceof EntityFireball) {
                ((EntityFireball)projecTile).field_70235_a = user;
            } else if (projecTile instanceof EntityArrow) {
                ((EntityArrow)projecTile).field_70250_c = user;
            } else if (projecTile instanceof IThrowableEntity) {
                ((IThrowableEntity)projecTile).setThrower((Entity)user);
            } else if (projecTile instanceof EntityThrowable && user instanceof EntityPlayer) {
                NBTTagCompound tag = new NBTTagCompound();
                ((EntityThrowable)projecTile).func_70014_b(tag);
                tag.func_74778_a("ownerName", ((EntityPlayer)user).func_70005_c_());
                ((EntityThrowable)projecTile).func_70037_a(tag);
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    public void DestructEntity(EntityLivingBase entityLiving, ItemStack stack) {
        ComboSequence comboSeq = ItemSlashBlade.getComboSequence(ItemSlashBlade.getItemTagCompound(stack));
        if (!comboSeq.equals((Object)ComboSequence.None)) {
            int destructedCount = 0;
            AxisAlignedBB bb = this.getBBofCombo(stack, comboSeq, entityLiving);
            StylishRankManager.setNextAttackType((Entity)entityLiving, StylishRankManager.AttackTypes.DestructObject);
            List list = entityLiving.field_70170_p.func_175674_a((Entity)entityLiving, bb, EntitySelectorDestructable.getInstance());
            for (Entity curEntity : list) {
                boolean isDestruction = true;
                EnumSet<SwordType> swordType = this.getSwordType(stack);
                if (curEntity instanceof EntityFireball) {
                    if (((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    } else if (!swordType.contains((Object)SwordType.Bewitched)) {
                        boolean bl = isDestruction = !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), this.defaultBaseAttackModifier);
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof EntityArrow) {
                    if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            Entity tmp;
                            Entity target = null;
                            NBTTagCompound tag = stack.func_77978_p();
                            int eId = TargetEntityId.get(tag);
                            if (eId != 0 && (tmp = entityLiving.field_70170_p.func_73045_a(eId)) != null && tmp.func_70032_d((Entity)entityLiving) < 30.0f) {
                                target = tmp;
                            }
                            if (target != null && target instanceof EntityCreeper) {
                                this.InductionProjecTile(curEntity, null, entityLiving.func_70040_Z());
                            } else {
                                this.InductionProjecTile(curEntity, entityLiving);
                            }
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof IThrowableEntity) {
                    if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                } else if (curEntity instanceof EntityThrowable) {
                    if (((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (isDestruction && swordType.contains((Object)SwordType.Bewitched)) {
                        if (0 < EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack)) {
                            this.ReflectionProjecTile(curEntity, entityLiving);
                        } else {
                            this.InductionProjecTile(curEntity, entityLiving);
                        }
                        isDestruction = false;
                    }
                }
                if (!isDestruction) continue;
                curEntity.field_70159_w = 0.0;
                curEntity.field_70181_x = 0.0;
                curEntity.field_70179_y = 0.0;
                curEntity.func_70106_y();
                for (int var1 = 0; var1 < 10; ++var1) {
                    Random rand = entityLiving.func_70681_au();
                    double var2 = rand.nextGaussian() * 0.02;
                    double var4 = rand.nextGaussian() * 0.02;
                    double var6 = rand.nextGaussian() * 0.02;
                    double var8 = 10.0;
                    entityLiving.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                }
                ++destructedCount;
                StylishRankManager.doAttack((Entity)entityLiving);
            }
            if (0 < destructedCount) {
                ItemSlashBlade.damageItem(stack, 1, entityLiving);
            }
        }
    }

    public RayTraceResult rayTrace(EntityLivingBase owner, double par1, float par3) {
        Vec3d vec3 = this.getPosition(owner);
        Vec3d vec31 = owner.func_70676_i(par3);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        return owner.field_70170_p.func_147447_a(vec3, vec32, false, false, true);
    }

    public Vec3d getPosition(EntityLivingBase owner) {
        return new Vec3d(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v);
    }

    public Entity getRayTrace(EntityLivingBase owner, double reachMax) {
        return this.getRayTrace(owner, reachMax, 0.0f);
    }

    public Entity getRayTrace(EntityLivingBase owner, double reachMax, float expandBorder) {
        float par1 = 1.0f;
        RayTraceResult objectMouseOver = this.rayTrace(owner, reachMax, par1);
        double reachMin = reachMax;
        Vec3d entityPos = this.getPosition(owner);
        if (objectMouseOver != null) {
            reachMin = objectMouseOver.field_72307_f.func_72438_d(entityPos);
        }
        Vec3d lookVec = owner.func_70676_i(par1);
        Vec3d reachVec = entityPos.func_72441_c(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax);
        Entity pointedEntity = null;
        float expandFactor = 1.0f;
        List list = owner.field_70170_p.func_72839_b((Entity)owner, owner.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax).func_72314_b((double)expandFactor, (double)expandFactor, (double)expandFactor));
        double tmpDistance = reachMin;
        for (Entity entity : list) {
            double d3;
            if (entity == null || !entity.func_70067_L() || 0.01f < expandBorder && (!owner.func_70685_l(entity) || !EntitySelectorAttackable.getInstance().apply((Object)entity))) continue;
            float borderSize = entity.func_70111_Y() + expandBorder;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(entityPos, reachVec);
            if (axisalignedbb.func_72318_a(entityPos)) {
                if (!(0.0 < tmpDistance) && tmpDistance != 0.0) continue;
                pointedEntity = entity;
                tmpDistance = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = entityPos.func_72438_d(movingobjectposition.field_72307_f)) < tmpDistance) && tmpDistance != 0.0) continue;
            if (entity == owner.func_184187_bx() && !entity.canRiderInteract()) {
                if (tmpDistance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            tmpDistance = d3;
        }
        return pointedEntity;
    }

    public ItemSlashBlade setRepairMaterialOreDic(String ... material) {
        this.repairMaterialOreDic = material;
        return this;
    }

    public ItemSlashBlade setRepairMaterial(ItemStack item) {
        this.repairMaterial = item;
        return this;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        boolean result = false;
        if (par2ItemStack.func_77973_b() == SlashBlade.proudSoul) {
            result = true;
        }
        if (!result && this.repairMaterial != null) {
            result = par2ItemStack.func_77969_a(this.repairMaterial);
        }
        if (!result && this.repairMaterialOreDic != null) {
            for (String oreName : this.repairMaterialOreDic) {
                ItemStack curItem;
                List list = OreDictionary.getOres((String)oreName);
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !(result = (curItem = (ItemStack)iterator.next()).func_77952_i() == Short.MAX_VALUE ? curItem.func_77973_b() == par2ItemStack.func_77973_b() : curItem.func_77969_a(par2ItemStack))) {
                }
            }
        }
        return result;
    }

    public void doSwingItem(ItemStack stack, EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            entity.field_184622_au = EnumHand.MAIN_HAND;
            entity.field_82175_bq = true;
            entity.field_110158_av = 0;
        } else {
            entity.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    public static void setBaseAttackModifier(NBTTagCompound tag, float modif) {
        BaseAttackModifier.set(tag, Float.valueOf(modif));
        AttackAmplifier.set(tag, Float.valueOf(0.01f));
    }

    public float getBaseAttackModifiers(NBTTagCompound tag) {
        if (BaseAttackModifier.exists(tag)) {
            return BaseAttackModifier.get(tag).floatValue();
        }
        return this.defaultBaseAttackModifier;
    }

    public boolean isDestructable(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        return IsDestructable.get(tag);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage != Short.MAX_VALUE) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
            EnumSet<SwordType> types = this.getSwordType(stack);
            int maxDamage = stack.func_77958_k();
            if (damage <= 0 && !types.contains((Object)SwordType.Sealed)) {
                IsBroken.set(tag, false);
            } else if (maxDamage < damage && (IsBroken.get(tag).booleanValue() || !tag.func_74767_n(IsManagedDamage))) {
                damage = Math.min(damage, maxDamage);
            }
        }
        super.setDamage(stack, damage);
    }

    public static void damageItem(ItemStack stack, int damage, EntityLivingBase user) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        tag.func_74757_a(IsManagedDamage, true);
        stack.func_77972_a(damage, user);
        tag.func_74757_a(IsManagedDamage, false);
        if (stack.field_77994_a <= 0) {
            boolean setBroken = true;
            boolean doDrop = true;
            ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
            if (!blade.isDestructable(stack)) {
                stack.field_77994_a = 1;
                stack.func_77964_b(stack.func_77958_k());
                if (blade instanceof ItemSlashBladeWrapper) {
                    ItemSlashBladeWrapper cfr_ignored_0 = (ItemSlashBladeWrapper)blade;
                    doDrop = ItemSlashBladeWrapper.hasWrapedItem(stack);
                    if (!ItemSlashBladeWrapper.TrueItemName.exists(tag)) {
                        ((ItemSlashBladeWrapper)blade).removeWrapItem(stack);
                        setBroken = false;
                    }
                }
                if (blade == SlashBlade.bladeSilverBambooLight) {
                    AchievementList.triggerAchievement((EntityPlayer)user, "saya");
                    stack.func_150996_a((Item)SlashBlade.wrapBlade);
                    setBroken = false;
                    stack.func_77964_b(0);
                }
                if (blade == SlashBlade.bladeWhiteSheath && user instanceof EntityPlayer) {
                    AchievementList.triggerAchievement((EntityPlayer)user, "brokenWhiteSheath");
                }
            }
            if (doDrop && !IsBroken.get(tag).booleanValue()) {
                blade.dropItemDestructed((Entity)user, stack);
            }
            IsBroken.set(tag, setBroken);
        }
    }

    public void attackTargetEntity(ItemStack stack, Entity target, EntityPlayer player, Boolean isRightClick) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        OnClick.set(tag, isRightClick);
        ComboSequence combo = ItemSlashBlade.getComboSequence(tag);
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offhand = player.func_184586_b(EnumHand.OFF_HAND);
        NBTTagCompound offTag = null;
        if (offhand != null) {
            offTag = ItemSlashBlade.getItemTagCompound(offhand);
        }
        if (combo.mainHandCombo != null && offTag != null) {
            OnClick.set(offTag, true);
            player.func_184611_a(EnumHand.MAIN_HAND, offhand);
        }
        player.func_71059_n(target);
        if (combo.mainHandCombo != null && offTag != null) {
            ItemSlashBlade.damageItem(offhand, 1, (EntityLivingBase)player);
            if (target instanceof EntityLivingBase) {
                stack.func_77961_a((EntityLivingBase)target, player);
            }
            OnClick.set(offTag, false);
            if (offhand.field_77994_a <= 0) {
                player.func_184611_a(EnumHand.OFF_HAND, null);
            }
        }
        player.func_184611_a(EnumHand.MAIN_HAND, mainHand);
        OnClick.set(tag, false);
    }

    static Map<Integer, SpecialAttackBase> createSpacialAttaksMap() {
        HashMap saMap = Maps.newHashMap();
        defaultSA = new SlashDimension();
        saMap.put(0, defaultSA);
        saMap.put(1, new Drive("vdrive", 0.75f, 20, false, ComboSequence.Kiriage));
        saMap.put(2, new WaveEdge());
        saMap.put(3, new Drive(1.5f, 10, true, ComboSequence.Iai));
        saMap.put(4, new Spear());
        saMap.put(5, new CircleSlash());
        saMap.put(6, new BlisteringWitherSwords());
        saMap.put(7, new SakuraEnd());
        saMap.put(8, new MaximumBet());
        return saMap;
    }

    public SpecialAttackBase getSpecialAttack(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        int key = SpecialAttackType.get(tag);
        return specialAttacks.containsKey(key) ? specialAttacks.get(key) : defaultSA;
    }

    public void doRangeAttack(ItemStack item, EntityLivingBase entity, MessageRangeAttack.RangeAttackState mode) {
        World w = entity.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(item);
        EnumSet<SwordType> types = this.getSwordType(item);
        if (!types.contains((Object)SwordType.Bewitched)) {
            return;
        }
        if (types.contains((Object)SwordType.Broken)) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)item);
        if (level <= 0) {
            return;
        }
        if (w.field_72995_K) {
            NetworkManager.INSTANCE.sendToServer((IMessage)new MessageRangeAttack(mode));
            return;
        }
        int rank = StylishRankManager.getStylishRank((Entity)entity);
        switch (mode) {
            case UPKEY: {
                Entity tauntEntity;
                if (entity.getEntityData().func_74764_b("SB.BSHOLDLIMIT")) {
                    long holdLimit = entity.getEntityData().func_74763_f("SB.BSHOLDLIMIT");
                    long currentTime = entity.func_130014_f_().func_82737_E();
                    if (currentTime < holdLimit) {
                        entity.getEntityData().func_74772_a("SB.BSHOLDLIMIT", currentTime);
                        return;
                    }
                }
                if (!ProudSoul.tryAdd(tag, -1, false)) {
                    return;
                }
                if (rank < 3) {
                    level = Math.min(1, level);
                }
                float magicDamage = level;
                entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.35f, 1.0f);
                String tauntIdKey = "SB.TauntId";
                int tauntId = entity.getEntityData().func_74762_e("SB.TauntId");
                if (tauntId != 0 && ((tauntEntity = entity.func_130014_f_().func_73045_a(tauntId)) == null || tauntEntity.field_70128_L || !(tauntEntity instanceof EntitySpinningSword))) {
                    tauntId = 0;
                    entity.getEntityData().func_82580_o("SB.TauntId");
                }
                byte command = entity.getEntityData().func_74771_c("SB.MCS");
                if (tauntId == 0 && entity.field_70122_E && entity.field_70159_w == 0.0 && entity.field_70179_y == 0.0 && 0 < (command & 0x20)) {
                    EntitySpinningSword entityDrive = new EntitySpinningSword(w, entity);
                    if (entityDrive == null) break;
                    entityDrive.setLifeTime(40);
                    if (SummonedSwordColor.exists(tag)) {
                        entityDrive.setColor(SummonedSwordColor.get(tag));
                    }
                    ScheduleEntitySpawner.getInstance().offer(entityDrive);
                    entity.getEntityData().func_74768_a("SB.TauntId", entityDrive.func_145782_y());
                    break;
                }
                if (tag.func_74762_e("RangeAttackType") == 0) {
                    EntitySummonedSwordBase entityDrive = new EntitySummonedSwordBase(w, entity, magicDamage, 90.0f);
                    if (entityDrive == null) break;
                    entityDrive.setLifeTime(30);
                    int targetid = TargetEntityId.get(tag);
                    entityDrive.setTargetEntityId(targetid);
                    if (SummonedSwordColor.exists(tag)) {
                        entityDrive.setColor(SummonedSwordColor.get(tag));
                    }
                    ScheduleEntitySpawner.getInstance().offer(entityDrive);
                    if (!(entity instanceof EntityPlayer)) break;
                    AchievementList.triggerAchievement((EntityPlayer)entity, "phantomSword");
                    break;
                }
                EntitySummonedBlade summonedBlade = new EntitySummonedBlade(w, entity, magicDamage, 90.0f);
                if (summonedBlade == null) break;
                summonedBlade.setLifeTime(100);
                summonedBlade.setInterval(10);
                if (SummonedSwordColor.exists(tag)) {
                    summonedBlade.setColor(SummonedSwordColor.get(tag));
                }
                int targetid = TargetEntityId.get(tag);
                summonedBlade.setTargetEntityId(targetid);
                if (SummonedSwordColor.exists(tag)) {
                    summonedBlade.setColor(SummonedSwordColor.get(tag));
                }
                ScheduleEntitySpawner.getInstance().offer(summonedBlade);
                break;
            }
            case BLISTERING: {
                if (!ProudSoul.tryAdd(tag, -10, false)) {
                    return;
                }
                long currentTime = entity.func_130014_f_().func_82737_E();
                int holdLimit = 400;
                entity.getEntityData().func_74772_a("SB.BSHOLDLIMIT", currentTime + 400L);
                entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                int count = 4;
                if (3 < rank) {
                    count += 2;
                }
                if (5 <= rank) {
                    count += 2;
                }
                float magicDamage = level * 2;
                for (int i = 0; i < count; ++i) {
                    EntityBlisteringSwords summonedSword = new EntityBlisteringSwords(w, entity, magicDamage, 90.0f, i);
                    if (summonedSword == null) continue;
                    summonedSword.setLifeTime(30);
                    summonedSword.setIsJudgement(types.contains((Object)SwordType.FiercerEdge));
                    int targetid = TargetEntityId.get(tag);
                    summonedSword.setTargetEntityId(targetid);
                    if (SummonedSwordColor.exists(tag)) {
                        summonedSword.setColor(SummonedSwordColor.get(tag));
                    }
                    ScheduleEntitySpawner.getInstance().offer(summonedSword);
                }
                break;
            }
            case SPIRAL: {
                int currentTime = (int)entity.func_130014_f_().func_72820_D();
                int holdLimit = 200;
                if (entity.getEntityData().func_74764_b("SB.SPHOLDID") && currentTime < entity.getEntityData().func_74762_e("SB.SPHOLDID") + 200) {
                    entity.getEntityData().func_82580_o("SB.SPHOLDID");
                    return;
                }
                if (!ProudSoul.tryAdd(tag, -10, false)) {
                    return;
                }
                entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                int count = 6;
                if (rank < 3) {
                    level = Math.min(1, level);
                }
                float magicDamage = level;
                float arc = 360.0f / (float)count;
                entity.getEntityData().func_74768_a("SB.SPHOLDID", currentTime);
                for (int i = 0; i < count; ++i) {
                    float offset = (float)i * arc;
                    EntitySpiralSwords summonedSword = new EntitySpiralSwords(w, entity, magicDamage, 0.0f, offset);
                    if (summonedSword == null) continue;
                    summonedSword.setHoldId(currentTime);
                    summonedSword.setInterval(200);
                    summonedSword.setLifeTime(200);
                    if (SummonedSwordColor.exists(tag)) {
                        summonedSword.setColor(SummonedSwordColor.get(tag));
                    }
                    ScheduleEntitySpawner.getInstance().offer(summonedSword);
                }
                break;
            }
            case STORM: {
                int targetId = TargetEntityId.get(tag);
                if (targetId == 0) {
                    return;
                }
                if (!ProudSoul.tryAdd(tag, -10, false)) {
                    return;
                }
                entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                int count = 6;
                if (rank < 3) {
                    level = Math.min(1, level);
                }
                float magicDamage = (float)level / 2.0f;
                float arc = 360.0f / (float)count;
                int holdLimit = 40;
                for (int i = 0; i < count; ++i) {
                    float offset = (float)i * arc;
                    EntityStormSwords summonedSword = new EntityStormSwords(w, entity, magicDamage, 0.0f, offset, targetId);
                    if (summonedSword == null) continue;
                    summonedSword.setInterval(40);
                    summonedSword.setLifeTime(70);
                    if (SummonedSwordColor.exists(tag)) {
                        summonedSword.setColor(SummonedSwordColor.get(tag));
                    }
                    ScheduleEntitySpawner.getInstance().offer(summonedSword);
                }
                break;
            }
            case HEAVY_RAIN: {
                if (!ProudSoul.tryAdd(tag, -10, false)) {
                    return;
                }
                entity.field_70170_p.func_184148_a((EntityPlayer)null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                int count = 10;
                int multiplier = 2;
                if (5 <= rank) {
                    ++multiplier;
                }
                float magicDamage = 1.0f;
                int targetid = TargetEntityId.get(tag);
                for (int i = 0; i < count; ++i) {
                    for (int j = 0; j < multiplier; ++j) {
                        EntityHeavyRainSwords summonedSword = new EntityHeavyRainSwords(w, entity, magicDamage, entity.func_70681_au().nextFloat() * 360.0f, i, targetid);
                        if (summonedSword == null) continue;
                        summonedSword.setLifeTime(30 + i);
                        if (SummonedSwordColor.exists(tag)) {
                            summonedSword.setColor(SummonedSwordColor.get(tag));
                        }
                        ScheduleEntitySpawner.getInstance().offer(summonedSword);
                    }
                }
                break;
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (tag.func_74764_b("rarityType")) {
            byte type = tag.func_74771_c("rarityType");
            switch (type) {
                case 1: {
                    return EnumRarity.COMMON;
                }
                case 2: {
                    return EnumRarity.UNCOMMON;
                }
                case 3: {
                    return EnumRarity.RARE;
                }
                case 4: {
                    return EnumRarity.EPIC;
                }
            }
        }
        EnumSet<SwordType> types = this.getSwordType(stack);
        if (stack.func_77948_v()) {
            if (types.contains((Object)SwordType.Bewitched) || types.contains((Object)SwordType.FiercerEdge)) {
                if (tag.func_74767_n("isDefaultBewitched")) {
                    return EnumRarity.EPIC;
                }
                return EnumRarity.RARE;
            }
            return EnumRarity.UNCOMMON;
        }
        if (tag.func_74767_n("isDefaultBewitched")) {
            return EnumRarity.UNCOMMON;
        }
        return EnumRarity.COMMON;
    }

    public void func_77622_d(ItemStack p_77622_1_, World p_77622_2_, EntityPlayer p_77622_3_) {
        super.func_77622_d(p_77622_1_, p_77622_2_, p_77622_3_);
        AchievementList.triggerCraftingAchievement(p_77622_1_, p_77622_3_);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70170_p.field_72995_K) {
            if (entityItem.field_70118_ct == 0L && entityItem.field_70117_cu == 0L && entityItem.field_70116_cv == 0L) {
                entityItem.func_70106_y();
            }
            return false;
        }
        if (!SlashBlade.SafeDrop || entityItem.getEntityData().func_74767_n("noBladeStand")) {
            return false;
        }
        boolean forceDrop = entityItem.func_184216_O().contains("SB.DeathDrop");
        ItemStack stack = entityItem.func_92059_d();
        if (!forceDrop && stack.func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(stack)) {
            return false;
        }
        if (forceDrop || stack.func_77953_t() != EnumRarity.COMMON || stack.func_82837_s() || stack.func_77942_o() && (ItemSlashBladeNamed.TrueItemName.exists(stack.func_77978_p()) || ItemSlashBladeNamed.IsDefaultBewitched.get(stack.func_77978_p()).booleanValue())) {
            EntityBladeStand e = new EntityBladeStand(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, stack.func_77946_l());
            e.setFlip(e.getRand().nextInt(2));
            if (forceDrop) {
                e.func_184195_f(true);
            }
            e.func_70091_d(entityItem.field_70159_w * 2.0, entityItem.field_70181_x * 2.0, entityItem.field_70179_y * 2.0);
            if (!entityItem.field_70170_p.field_72995_K) {
                entityItem.field_70170_p.func_72838_d((Entity)e);
            }
            entityItem.func_70106_y();
            return true;
        }
        return false;
    }

    public static NBTTagCompound getSpecialEffect(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        NBTTagCompound result = tag.func_74775_l("SB.SEffect");
        if (!tag.func_74764_b("SB.SEffect")) {
            tag.func_74782_a("SB.SEffect", (NBTBase)result);
        }
        return result;
    }

    static void incrementProudSoul(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            Method getExperiencePoints = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)target, (String[])new String[]{"getExperiencePoints", "func_70693_a"}, (Class[])new Class[]{EntityPlayer.class});
            try {
                int exp = (Integer)getExperiencePoints.invoke((Object)target, (EntityPlayer)player);
                exp = ForgeEventFactory.getExperienceDrop((EntityLivingBase)target, (EntityPlayer)((EntityPlayer)player), (int)exp);
                float rank = StylishRankManager.getStylishRank((Entity)player);
                exp = (int)((double)exp * (1.0 + (double)rank * 0.1));
                NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
                PrevExp.set(tag, exp);
                ProudSoul.add(tag, exp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    boolean viewEnergyBar(ItemStack stack) {
        if (!stack.hasCapability(BladeCapabilityProvider.ENERGY, null)) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(BladeCapabilityProvider.ENERGY, null);
        if (storage == null) {
            return false;
        }
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.viewEnergyBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.viewEnergyBar(stack)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(BladeCapabilityProvider.ENERGY, null);
            return 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getMetadata(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (tag.func_74767_n("IsRender")) {
            tag.func_82580_o("IsRender");
            return 0;
        }
        return super.getMetadata(stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockFence) {
            return EnumActionResult.FAIL;
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BladeCapabilityProvider(stack, nbt);
    }

    public static enum SwordType {
        Broken,
        Perfect,
        Enchanted,
        Bewitched,
        SoulEeater,
        FiercerEdge,
        NoScabbard,
        Sealed;

        public static final EnumSet<SwordType> BewitchedSoulEater;
        public static final EnumSet<SwordType> BewitchedPerfect;

        static {
            BewitchedSoulEater = EnumSet.of(SoulEeater, Bewitched);
            BewitchedPerfect = EnumSet.of(Perfect, Bewitched);
        }
    }

    public static enum ComboSequence {
        None(true, 0.0f, 0.0f, false, 0),
        Saya1(true, 200.0f, 5.0f, false, 20),
        Saya2(true, -200.0f, 5.0f, false, 20),
        Battou(false, 240.0f, 0.0f, false, 12),
        Noutou(false, -210.0f, 10.0f, false, 5),
        Kiriage(false, 260.0f, 70.0f, false, 20),
        Kiriorosi(false, -260.0f, 90.0f, false, 12),
        SlashDim(false, -220.0f, 10.0f, true, 8),
        Iai(false, 240.0f, 0.0f, false, 20),
        HiraTuki(false, 180.0f, 180.0f, false, 20),
        SlashEdge(false, 240.0f, 20.0f, false, 12),
        ReturnEdge(false, 250.0f, -160.0f, false, 12),
        SIai(false, 240.0f, 0.0f, false, 12),
        SSlashEdge(false, 240.0f, 20.0f, false, 25),
        SReturnEdge(false, 250.0f, -160.0f, false, 25),
        SSlashBlade(false, 200.0f, -315.0f, false, 25),
        AerialRave(false, 240.0f, 20.0f, false, 25),
        ASlashEdge(false, 240.0f, 20.0f, false, 25),
        AKiriorosi(false, 200.0f, -240.0f, false, 25),
        AKiriorosiB(false, 200.0f, -280.0f, false, 25),
        AKiriage(false, 240.0f, -70.0f, false, 12),
        AKiriorosiFinish(false, 200.0f, -270.0f, false, 25),
        RapidSlash(false, 600.0f, -380.0f, false, 12),
        RapidSlashEnd(false, 240.0f, 20.0f, false, 12),
        RisingStar(false, 250.0f, -160.0f, false, 12),
        HelmBraker(false, 200.0f, -270.0f, false, 25),
        Calibur(false, 600.0f, -380.0f, false, 25),
        Force1(false, 300.0f, -230.0f, false, 25, None),
        Force2(false, 250.0f, -30.0f, false, 25, None),
        Force3(true, 200.0f, 5.0f, false, 20),
        Force4(true, -200.0f, 5.0f, false, 20),
        Force5(false, 240.0f, 0.0f, false, 12),
        Force6(false, 200.0f, -270.0f, false, 25, Force5),
        Stinger(false, 180.0f, 180.0f, false, 20, None);

        public boolean useScabbard;
        public float swingAmplitude;
        public float swingDirection;
        public boolean isCharged;
        public int comboResetTicks;
        public ComboSequence mainHandCombo;

        private ComboSequence(boolean useScabbard, float swingAmplitude, float swingDirection, boolean isCharged, int comboResetTicks) {
            this(useScabbard, swingAmplitude, swingDirection, isCharged, comboResetTicks, null);
        }

        private ComboSequence(boolean useScabbard, float swingAmplitude, float swingDirection, boolean isCharged, int comboResetTicks, ComboSequence mainHandCombo) {
            Seqs.add(this.ordinal(), this);
            this.useScabbard = useScabbard;
            this.swingAmplitude = swingAmplitude;
            this.swingDirection = swingDirection;
            this.isCharged = isCharged;
            this.comboResetTicks = comboResetTicks;
            this.mainHandCombo = mainHandCombo;
        }

        public static ComboSequence get(int ordinal) {
            return (ComboSequence)((Object)Seqs.get(ordinal));
        }
    }
}

