/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialeffect;

import java.util.Random;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.IRemovable;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.util.SlashBladeEvent;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlastEdge
implements ISpecialEffect,
IRemovable {
    private static final String EffectKey = "BlastEdge";

    private boolean useBlade(ItemSlashBlade.ComboSequence sequence) {
        if (sequence.useScabbard) {
            return false;
        }
        if (sequence == ItemSlashBlade.ComboSequence.None) {
            return false;
        }
        return sequence != ItemSlashBlade.ComboSequence.Noutou;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int currentLevel;
        EntityLivingBase target = event.getEntityLiving();
        PotionEffect effect = target.func_70660_b(MobEffects.field_76426_n);
        int n = currentLevel = effect != null ? effect.func_76458_c() : 0;
        if (!target.field_70170_p.field_72995_K && target.func_70026_G() && currentLevel < 0) {
            target.func_184589_d(MobEffects.field_76426_n);
            target.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (target.func_70681_au().nextFloat() - target.func_70681_au().nextFloat()) * 0.4f);
        }
        if (target.field_70170_p instanceof WorldServer && currentLevel < 0 && target.field_70173_aa % 20 == 0) {
            currentLevel = Math.abs(currentLevel);
            Random rand = target.func_70681_au();
            for (int i = 0; i < currentLevel; ++i) {
                double d0 = rand.nextGaussian() * 0.5;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.5;
                ((WorldServer)target.field_70170_p).func_180505_a(EnumParticleTypes.REDSTONE, false, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, currentLevel, d0, d1, d2, 0.0, new int[0]);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        int currentLevel;
        if (!event.getSource().func_76347_k()) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        PotionEffect effect = target.func_70660_b(MobEffects.field_76426_n);
        int n = currentLevel = effect != null ? effect.func_76458_c() : 0;
        if (currentLevel < 0) {
            target.func_184589_d(MobEffects.field_76426_n);
            target.field_70170_p.func_72876_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0f, false);
        }
    }

    @SubscribeEvent
    public void onImpactEffectEvent(SlashBladeEvent.ImpactEffectEvent event) {
        int currentLevel;
        if (event.user.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.useBlade(event.sequence)) {
            return;
        }
        if (!SpecialEffects.isPlayer((Entity)event.user)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.user;
        boolean effectLevel = false;
        switch (SpecialEffects.isEffective(player, event.blade, this)) {
            case None: {
                return;
            }
        }
        EntityLivingBase target = event.target;
        PotionEffect effect = target.func_70660_b(MobEffects.field_76426_n);
        int n = currentLevel = effect != null ? effect.func_76458_c() : 0;
        if (currentLevel <= -3) {
            target.func_184589_d(MobEffects.field_76426_n);
            Explosion blast = target.field_70170_p.func_72876_a((Entity)player, target.field_70165_t, target.field_70163_u + (double)player.func_70047_e() + (double)0.1f, target.field_70161_v, 0.5f, false);
            target.field_70172_ad = 0;
            int level = 1 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)event.blade);
            target.func_70097_a(DamageSource.func_94539_a((Explosion)blast), (float)level * 2.0f);
        } else {
            currentLevel = Math.min(0, currentLevel);
            target.func_184589_d(MobEffects.field_76426_n);
            target.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, currentLevel - 1, true, false));
        }
        player.func_71047_c((Entity)target);
        Random rand = target.func_70681_au();
        for (int i = 0; i < 3; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            target.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, target.field_70165_t + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, target.field_70163_u + 1.0 + (double)(rand.nextFloat() * target.field_70131_O), target.field_70161_v + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SubscribeEvent
    public void onUpdateItemSlashBlade(SlashBladeEvent.OnUpdateEvent event) {
        int currentLevel;
        int check;
        if (!SpecialEffects.isPlayer(event.entity)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(event.blade);
        if (!this.useBlade(ItemSlashBlade.getComboSequence(tag))) {
            return;
        }
        switch (SpecialEffects.isEffective(player, event.blade, this)) {
            case None: {
                return;
            }
            case NonEffective: {
                if (player.func_70681_au().nextInt(4) == 0) break;
                return;
            }
            case Effective: {
                return;
            }
        }
        PotionEffect haste = player.func_70660_b(MobEffects.field_76419_f);
        int n = haste != null ? (haste.func_76458_c() != 1 ? 3 : 4) : (check = 2);
        if (player.field_110158_av != check) {
            return;
        }
        PotionEffect effect = player.func_70660_b(MobEffects.field_76426_n);
        int n2 = currentLevel = effect != null ? effect.func_76458_c() : 0;
        if (currentLevel <= -5) {
            player.func_184589_d(MobEffects.field_76426_n);
            player.field_70170_p.func_72876_a(null, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() + (double)0.1f, player.field_70161_v, 1.0f, false);
        } else {
            currentLevel = Math.min(0, currentLevel);
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, -5, false, false));
        }
    }

    @Override
    public void register() {
        SlashBladeHooks.EventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getDefaultRequiredLevel() {
        return 5;
    }

    @Override
    public String getEffectKey() {
        return EffectKey;
    }

    @SubscribeEvent
    public void LivingDrops(LivingDropsEvent event) {
        NBTTagCompound tag;
        String key = EntityList.func_75621_b((Entity)event.getEntityLiving());
        if (key != null && key.equals("Creeper") && (tag = event.getEntityLiving().func_189511_e(new NBTTagCompound())).func_74767_n("powered")) {
            EntityLivingBase target = event.getEntityLiving().func_70643_av();
            if (target == null) {
                return;
            }
            ItemStack attackItem = target.func_184586_b(EnumHand.MAIN_HAND);
            if (attackItem == null) {
                return;
            }
            if (!(attackItem.func_77973_b() instanceof ItemSlashBlade)) {
                return;
            }
            ItemStack bladeSoulCrystal = SlashBlade.findItemStack("flammpfeil.slashblade", "crystal_bladesoul", 1);
            SpecialEffects.addEffect(bladeSoulCrystal, this);
            event.getEntityLiving().func_70099_a(bladeSoulCrystal, 1.0f);
        }
    }

    @Override
    public boolean canCopy(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canRemoval(ItemStack stack) {
        return true;
    }
}

