/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialeffect;

import com.google.common.collect.Maps;
import java.util.Map;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.BlastEdge;
import mods.flammpfeil.slashblade.specialeffect.CrystalHealing;
import mods.flammpfeil.slashblade.specialeffect.HFCustom;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.Limitter;
import mods.flammpfeil.slashblade.specialeffect.WitherEdge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SpecialEffects {
    private static Map<String, ISpecialEffect> effects = Maps.newHashMap();
    public static ISpecialEffect WitherEdge = SpecialEffects.register(new WitherEdge());
    public static ISpecialEffect CrystalHealing = SpecialEffects.register(new CrystalHealing());
    public static ISpecialEffect Limitter = SpecialEffects.register(new Limitter());
    public static ISpecialEffect BlastEdge = SpecialEffects.register(new BlastEdge());
    public static ISpecialEffect HFCustom = SpecialEffects.register(new HFCustom());

    public static ISpecialEffect register(ISpecialEffect effect) {
        effects.put(effect.getEffectKey(), effect);
        return effect;
    }

    public static ISpecialEffect getEffect(String key) {
        return effects.get(key);
    }

    public static void init() {
        for (ISpecialEffect effect : effects.values()) {
            effect.register();
        }
    }

    public static ItemStack addEffect(ItemStack blade, ISpecialEffect effect) {
        return SpecialEffects.addEffect(blade, effect.getEffectKey(), effect.getDefaultRequiredLevel());
    }

    public static ItemStack addEffect(ItemStack blade, String key, int requiredLevel) {
        NBTTagCompound etag = ItemSlashBlade.getSpecialEffect(blade);
        etag.func_74768_a(key, requiredLevel);
        return blade;
    }

    public static boolean isPlayer(Entity target) {
        if (target == null) {
            return false;
        }
        if (target.field_70170_p == null) {
            return false;
        }
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(target instanceof EntityPlayer)) {
            return false;
        }
        return target.func_70089_S();
    }

    public static boolean isBlade(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemSlashBlade;
    }

    public static State isEffective(EntityPlayer player, ItemStack blade, ISpecialEffect effect) {
        return SpecialEffects.isEffective(player, blade, effect.getEffectKey());
    }

    public static State isEffective(EntityPlayer player, ItemStack blade, String EffectKey) {
        NBTTagCompound tag = ItemSlashBlade.getSpecialEffect(blade);
        int requiredLevel = tag.func_74762_e(EffectKey);
        if (0 == requiredLevel) {
            return State.None;
        }
        if (requiredLevel <= player.field_71068_ca) {
            return State.Effective;
        }
        return State.NonEffective;
    }

    public static enum State {
        None,
        NonEffective,
        Effective;

    }
}

