/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.MLConfig;
import zairus.megaloot.MegaLoot;
import zairus.megaloot.item.MLItem;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootSet;
import zairus.megaloot.loot.LootWeaponEffect;

public class MLItemArmor
extends ItemArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    protected MLItemArmor(EntityEquipmentSlot equipmentSlot) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 3, equipmentSlot);
        this.func_77637_a(MegaLoot.creativeTabMain);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)field_96605_cw);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
                LootSet lootSet = LootSet.getById(lootSetId);
                if (lootSet != null) {
                    model = lootSet.itemModel;
                }
                return model;
            }
        });
    }

    public String func_77667_c(ItemStack stack) {
        String unlocalizedName = super.func_77667_c(stack);
        String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
        return unlocalizedName + (lootSetId.equals("") ? "" : "." + lootSetId);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        String lootSetId = LootItemHelper.getLootStringValue(itemStack, "loot_set");
        return LootSet.getArmorModel(LootSet.getById(lootSetId), MLItems.getItemType(itemStack.func_77973_b()));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
        String textureString = "megaloot:textures/models/armor/1.png";
        if (lootSetId != null && lootSetId.length() > 0) {
            textureString = "megaloot:textures/models/armor/" + lootSetId + ".png";
        }
        return textureString;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> modifiers = MLItem.modifiersForStack(slot, stack, (Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack));
        if (this.field_77881_a == slot) {
            modifiers.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, 0));
            modifiers.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)this.field_189415_e, 0));
            List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
            for (LootWeaponEffect effect : effects) {
                if (effect.getAttribute() == null) continue;
                modifiers.put((Object)effect.getAttribute().func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)LootWeaponEffect.getAmplifierFromStack(stack, effect.getId()), 0));
            }
        }
        return modifiers;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        BonusHelper helper = new BonusHelper();
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.FEET));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.LEGS));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.CHEST));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.HEAD));
        List<String> setIds = helper.getGreatherThan(MLConfig.armorPiecesForBonus);
        for (String setId : setIds) {
            player.func_70690_d(LootSet.getById((String)setId).bonusEffect.getPotionEffect(2, 0));
        }
    }

    private String getSetIdFromSlot(EntityPlayer player, EntityEquipmentSlot equipmentSlot) {
        String setId = "";
        ItemStack stack = player.func_184582_a(equipmentSlot);
        if (stack != null) {
            setId = LootItemHelper.getLootStringValue(stack, "loot_set");
        }
        return setId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add("");
        tooltip.add(TextFormatting.GRAY + "Armor set " + TextFormatting.BOLD + "" + LootItemHelper.getLootStringValue(stack, "loot_set"));
        tooltip.add("");
        LootItemHelper.addInformation(stack, tooltip, false);
    }

    private class BonusHelper {
        private final Map<String, Integer> sets = new HashMap<String, Integer>();

        private BonusHelper() {
        }

        public void add(String setId) {
            if (setId == "") {
                return;
            }
            if (!this.sets.containsKey(setId)) {
                this.sets.put(setId, 1);
            } else {
                int curValue = this.sets.get(setId);
                this.sets.put(setId, ++curValue);
            }
        }

        public List<String> getGreatherThan(int value) {
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : this.sets.keySet()) {
                if (this.sets.get(id) < value) continue;
                ids.add(id);
            }
            return ids;
        }
    }
}

