/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import zairus.megaloot.MegaLoot;
import zairus.megaloot.item.MLItem;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootSet;
import zairus.megaloot.loot.LootWeaponEffect;
import zairus.megaloot.sound.MLSoundEvents;

public class MLItemWeaponCase
extends MLItem {
    private final LootRarity case_rarity;

    protected MLItemWeaponCase(LootRarity rarity) {
        this.func_77637_a(MegaLoot.creativeTabMain);
        this.case_rarity = rarity;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        world.func_184133_a((EntityPlayer)null, player.func_180425_c(), MLSoundEvents.CASE_OPEN, SoundCategory.PLAYERS, 1.0f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
        for (int i = 0; i < 1; ++i) {
            ItemStack loot = LootItemHelper.getRandomLoot(field_77697_d);
            LootSet.LootSetType type = MLItems.getItemType(loot.func_77973_b());
            if (type == null) {
                type = LootSet.LootSetType.SWORD;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("HideFlags", 2);
            NBTTagCompound mlTag = new NBTTagCompound();
            int model = 1 + field_77697_d.nextInt(type.models);
            mlTag.func_74768_a("model", model);
            mlTag.func_74778_a("rarity", this.case_rarity.getId());
            mlTag.func_74768_a("damage", this.case_rarity.getDamage(field_77697_d));
            mlTag.func_74776_a("speed", this.case_rarity.getSpeed(field_77697_d));
            mlTag.func_74768_a("durability", this.case_rarity.getDurability(field_77697_d));
            mlTag.func_74776_a("drawspeed", this.case_rarity.getSpeed(field_77697_d) + 4.0f);
            mlTag.func_74776_a("power", 1.0f + (float)this.case_rarity.getDamage(field_77697_d) / 20.0f);
            int modifierCount = this.case_rarity.getModifierCount(field_77697_d);
            if (type == LootSet.LootSetType.RING && modifierCount == 0) {
                modifierCount = 1;
            }
            if (modifierCount > 0) {
                ArrayList<LootWeaponEffect> appliedEffects = new ArrayList<LootWeaponEffect>();
                NBTTagList effectList = new NBTTagList();
                for (int m = 0; m < modifierCount; ++m) {
                    LootWeaponEffect me = LootWeaponEffect.getRandomExcluding(field_77697_d, type, appliedEffects);
                    if (me == null) continue;
                    effectList.func_74742_a((NBTBase)me.getNBT(field_77697_d));
                    appliedEffects.add(me);
                }
                mlTag.func_74782_a("effectList", (NBTBase)effectList);
            }
            tag.func_74782_a("MegaLoot", (NBTBase)mlTag);
            loot.func_77982_d(tag);
            LootItemHelper.setLootStringValue(loot, "loot_set", LootSet.getRandom(field_77697_d).getId());
            String loot_name = LootSet.getNameForType(type, field_77697_d);
            if (loot_name.length() > 0) {
                loot.func_151001_c(this.case_rarity.getColor() + loot_name);
            }
            if (loot == null) continue;
            player.func_146097_a(loot, false, true);
            for (int j = 0; j < 5; ++j) {
                world.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)(1 - field_77697_d.nextInt(3)) * 0.6, (double)(1 - field_77697_d.nextInt(3)) * 0.6, (double)(1 - field_77697_d.nextInt(3)) * 0.6, new int[0]);
            }
        }
        --itemStack.field_77994_a;
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }
}

