/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import zairus.megaloot.MegaLoot;
import zairus.megaloot.item.MLItemArmor;
import zairus.megaloot.item.MLItemBauble;
import zairus.megaloot.item.MLItemToolAxe;
import zairus.megaloot.item.MLItemToolPickaxe;
import zairus.megaloot.item.MLItemToolShovel;
import zairus.megaloot.item.MLItemWeaponBow;
import zairus.megaloot.item.MLItemWeaponCase;
import zairus.megaloot.item.MLItemWeaponSword;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootSet;

public class MLItems {
    public static final Item WEAPONCASE_COMMON;
    public static final Item WEAPONCASE_RARE;
    public static final Item WEAPONCASE_EPIC;
    public static final Item WEAPONSWORD;
    public static final Item WEAPONBOW;
    public static final Item BAUBLERING;
    public static final Item ARMOR_BOOTS;
    public static final Item ARMOR_LEGGINGS;
    public static final Item ARMOR_CHESTPLATE;
    public static final Item ARMOR_HELMET;
    public static final Item TOOL_AXE;
    public static final Item TOOL_PICKAXE;
    public static final Item TOOL_SHOVEL;
    public static final Map<Item, LootSet.LootSetType> ITEMTYPEREGISTRY;

    @Nullable
    public static LootSet.LootSetType getItemType(Item item) {
        return ITEMTYPEREGISTRY.get(item);
    }

    public static Item initItem(Item item, String id) {
        item.setRegistryName(new ResourceLocation("megaloot", id));
        item.func_77655_b(id);
        return item;
    }

    public static final void register() {
        MegaLoot.proxy.registerItem(WEAPONCASE_COMMON, "weaponcase_common", 0, true);
        MegaLoot.proxy.registerItem(WEAPONCASE_RARE, "weaponcase_rare", 0, true);
        MegaLoot.proxy.registerItem(WEAPONCASE_EPIC, "weaponcase_epic", 0, true);
        MegaLoot.proxy.registerItem(WEAPONSWORD, "weaponsword", 0, true);
        MegaLoot.proxy.registerItem(WEAPONBOW, "weaponbow", 0, true);
        MegaLoot.proxy.registerItem(BAUBLERING, "baublering", 0, true);
        MegaLoot.proxy.registerItem(ARMOR_BOOTS, "armor_boots", 0, true);
        MegaLoot.proxy.registerItem(ARMOR_LEGGINGS, "armor_leggings", 0, true);
        MegaLoot.proxy.registerItem(ARMOR_CHESTPLATE, "armor_chestplate", 0, true);
        MegaLoot.proxy.registerItem(ARMOR_HELMET, "armor_helmet", 0, true);
        MegaLoot.proxy.registerItem(TOOL_AXE, "tool_axe", 0, true);
        MegaLoot.proxy.registerItem(TOOL_PICKAXE, "tool_pickaxe", 0, true);
        MegaLoot.proxy.registerItem(TOOL_SHOVEL, "tool_shovel", 0, true);
    }

    static {
        ITEMTYPEREGISTRY = new HashMap<Item, LootSet.LootSetType>();
        WEAPONCASE_COMMON = MLItems.initItem(new MLItemWeaponCase(LootRarity.COMMON), "weaponcase_common");
        WEAPONCASE_RARE = MLItems.initItem(new MLItemWeaponCase(LootRarity.RARE), "weaponcase_rare");
        WEAPONCASE_EPIC = MLItems.initItem(new MLItemWeaponCase(LootRarity.EPIC), "weaponcase_epic");
        WEAPONSWORD = MLItems.initItem((Item)new MLItemWeaponSword(), "weaponsword");
        WEAPONBOW = MLItems.initItem((Item)new MLItemWeaponBow(), "weaponbow");
        BAUBLERING = MLItems.initItem(new MLItemBauble(), "baublering");
        ARMOR_BOOTS = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.FEET), "armor_boots");
        ARMOR_LEGGINGS = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.LEGS), "armor_leggings");
        ARMOR_CHESTPLATE = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.CHEST), "armor_chestplate");
        ARMOR_HELMET = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.HEAD), "armor_helmet");
        TOOL_AXE = MLItems.initItem((Item)new MLItemToolAxe(), "tool_axe");
        TOOL_PICKAXE = MLItems.initItem((Item)new MLItemToolPickaxe(), "tool_pickaxe");
        TOOL_SHOVEL = MLItems.initItem((Item)new MLItemToolShovel(), "tool_shovel");
        ITEMTYPEREGISTRY.put(WEAPONSWORD, LootSet.LootSetType.SWORD);
        ITEMTYPEREGISTRY.put(WEAPONBOW, LootSet.LootSetType.BOW);
        ITEMTYPEREGISTRY.put(BAUBLERING, LootSet.LootSetType.RING);
        ITEMTYPEREGISTRY.put(ARMOR_BOOTS, LootSet.LootSetType.ARMOR_FEET);
        ITEMTYPEREGISTRY.put(ARMOR_LEGGINGS, LootSet.LootSetType.ARMOR_LEGS);
        ITEMTYPEREGISTRY.put(ARMOR_CHESTPLATE, LootSet.LootSetType.ARMOR_CHEST);
        ITEMTYPEREGISTRY.put(ARMOR_HELMET, LootSet.LootSetType.ARMOR_HEAD);
        ITEMTYPEREGISTRY.put(TOOL_AXE, LootSet.LootSetType.TOOL);
        ITEMTYPEREGISTRY.put(TOOL_PICKAXE, LootSet.LootSetType.TOOL);
        ITEMTYPEREGISTRY.put(TOOL_SHOVEL, LootSet.LootSetType.TOOL);
    }
}

