/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootWeaponEffect;

public class LootItemHelper {
    public static ItemStack getRandomLoot(Random rand) {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(MLItems.WEAPONSWORD);
        items.add(MLItems.WEAPONBOW);
        items.add(MLItems.BAUBLERING);
        items.add(MLItems.ARMOR_HELMET);
        items.add(MLItems.ARMOR_CHESTPLATE);
        items.add(MLItems.ARMOR_LEGGINGS);
        items.add(MLItems.ARMOR_BOOTS);
        items.add(MLItems.TOOL_AXE);
        items.add(MLItems.TOOL_PICKAXE);
        items.add(MLItems.TOOL_SHOVEL);
        ItemStack stack = new ItemStack((Item)items.get(rand.nextInt(items.size())));
        return stack;
    }

    public static NBTTagList getLootTagList(ItemStack stack, String key) {
        NBTTagList list = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            list = stack.func_77978_p().func_74775_l("MegaLoot").func_150295_c(key, 10);
        }
        return list;
    }

    public static int getLootIntValue(ItemStack stack, String key) {
        int value = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74762_e(key);
        }
        return value;
    }

    public static void setLootIntValue(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74768_a(key, value);
    }

    public static float getLootFloatValue(ItemStack stack, String key) {
        float value = 0.0f;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74760_g(key);
        }
        return value;
    }

    public static void setLootFlaotValue(ItemStack stack, String key, float value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74776_a(key, value);
    }

    public static String getLootStringValue(ItemStack stack, String key) {
        String value = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74779_i(key);
        }
        return value;
    }

    public static void setLootStringValue(ItemStack stack, String key, String value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74778_a(key, value);
    }

    public static int getMaxDamage(ItemStack stack) {
        int maxDamage = LootItemHelper.getLootIntValue(stack, "durability");
        if (maxDamage == 0) {
            maxDamage = 100;
        }
        return maxDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, List<String> tooltip) {
        LootItemHelper.addInformation(stack, tooltip, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, List<String> tooltip, boolean show_durability) {
        int kills;
        int durability = stack.func_77958_k();
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
        for (LootWeaponEffect effect : effects) {
            tooltip.add(TextFormatting.RESET + "" + TextFormatting.AQUA + I18n.func_74837_a((String)("weaponeffect." + effect.getId() + ".description"), (Object[])new Object[]{effect.getDurationString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId(), 1)}));
        }
        if (show_durability) {
            tooltip.add(durability + " Durability");
        }
        if ((kills = LootItemHelper.getLootIntValue(stack, "playerkills")) > 0) {
            tooltip.add(TextFormatting.RED + "" + kills + "player kills");
        }
        tooltip.add("");
    }
}

