/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.ModelBiped;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.client.model.MLModelArmorSets;
import zairus.megaloot.loot.LootWeaponEffect;

public class LootSet {
    public static final Map<String, LootSet> REGISTRY = new HashMap<String, LootSet>();
    public static final LootSet VIKING = LootSet.get("viking", LootWeaponEffect.STRENGTH);
    public static final LootSet DRAGON = LootSet.get("dragon", LootWeaponEffect.FIRE_RESISTANT);
    public static final LootSet KNIGHT = LootSet.get("knight", LootWeaponEffect.RESISTANCE);
    public static final LootSet SAMURAI = LootSet.get("samurai", LootWeaponEffect.SPEED);
    public final int itemModel;
    public final LootWeaponEffect bonusEffect;
    protected String id;
    public static final String[] SWORD_NAMES = new String[]{"Balance Sword", "The Crusader", "Butcher Blade", "Mageblade", "Long Sword", "The Shadow", "Jade", "Blaze Guard", "Heart Spike", "Torment", "Phantom", "Gladius", "Nat Blade", "Vine Sword", "Knight Blade", "Red", "Dog Bone", "Ice Blade", "Sabre", "Molten Sword", "Phase Blade", "Crystal Wing", "Wakizashi", "Wizard Spike"};
    public static final String[] BOW_NAMES = new String[]{"Long Bow", "Venom", "Nat Bow", "Black Widow", "Eagle", "Drawling", "Zach", "Slimestrike", "Thunderforce", "Ghost", "Angel", "Starshot"};
    public static final String[] RING_NAMES = new String[]{"The Pearl", "Fire Stone", "Burning Stone", "The Ruby", "The Ruby Eye", "Hope", "Purity Hope", "The Onyx", "Jordan", "Breeze", "Wind", "The Ocelot"};
    public static final String[] TOOL_NAMES = new String[]{"Balanced tool", "Crafter's aid", "Builder dream", "Inspiration", "Solid grip"};
    public static final Map<LootSetType, String[]> LOOT_ITEM_NAMES = new HashMap<LootSetType, String[]>();

    protected LootSet(int itemModel, LootWeaponEffect bonus) {
        this.itemModel = itemModel;
        this.bonusEffect = bonus;
    }

    protected static LootSet get(String name, LootWeaponEffect bonus) {
        LootSet set = new LootSet(REGISTRY.size() + 1, bonus);
        set.id = name;
        REGISTRY.put(name, set);
        return set;
    }

    public static LootSet getRandom(Random rand) {
        ArrayList<String> lootSetKeys = new ArrayList<String>(REGISTRY.keySet());
        String setId = (String)lootSetKeys.get(rand.nextInt(lootSetKeys.size()));
        return LootSet.getById(setId);
    }

    public static LootSet getById(String id) {
        LootSet lootSet = VIKING;
        if (id.length() > 0 && REGISTRY.containsKey(id)) {
            lootSet = REGISTRY.get(id);
        }
        return lootSet;
    }

    public String getId() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelBiped getArmorModel(LootSet set, LootSetType type) {
        HashMap armorByType = new HashMap();
        HashMap<LootSetType, ModelBiped> armorSet = new HashMap<LootSetType, ModelBiped>();
        armorSet.put(LootSetType.ARMOR_HEAD, MLModelArmorSets.ARMOR_VIKING_HELMET);
        armorSet.put(LootSetType.ARMOR_CHEST, MLModelArmorSets.ARMOR_VIKING_CHESTPLATE);
        armorSet.put(LootSetType.ARMOR_LEGS, MLModelArmorSets.ARMOR_VIKING_LEGGINGS);
        armorSet.put(LootSetType.ARMOR_FEET, MLModelArmorSets.ARMOR_VIKING_BOOTS);
        armorByType.put(VIKING, armorSet);
        armorSet = new HashMap();
        armorSet.put(LootSetType.ARMOR_HEAD, MLModelArmorSets.ARMOR_DRAGON_HELMET);
        armorSet.put(LootSetType.ARMOR_CHEST, MLModelArmorSets.ARMOR_DRAGON_CHESTPLATE);
        armorSet.put(LootSetType.ARMOR_LEGS, MLModelArmorSets.ARMOR_DRAGON_LEGGINGS);
        armorSet.put(LootSetType.ARMOR_FEET, MLModelArmorSets.ARMOR_DRAGON_BOOTS);
        armorByType.put(DRAGON, armorSet);
        armorSet = new HashMap();
        armorSet.put(LootSetType.ARMOR_HEAD, MLModelArmorSets.ARMOR_KNIGHT_HELMET);
        armorSet.put(LootSetType.ARMOR_CHEST, MLModelArmorSets.ARMOR_KNIGHT_CHESTPLATE);
        armorSet.put(LootSetType.ARMOR_LEGS, MLModelArmorSets.ARMOR_KNIGHT_LEGGINGS);
        armorSet.put(LootSetType.ARMOR_FEET, MLModelArmorSets.ARMOR_KNIGHT_BOOTS);
        armorByType.put(KNIGHT, armorSet);
        armorSet = new HashMap();
        armorSet.put(LootSetType.ARMOR_HEAD, MLModelArmorSets.ARMOR_SAMURAI_HELMET);
        armorSet.put(LootSetType.ARMOR_CHEST, MLModelArmorSets.ARMOR_SAMURAI_CHESTPLATE);
        armorSet.put(LootSetType.ARMOR_LEGS, MLModelArmorSets.ARMOR_SAMURAI_LEGGINGS);
        armorSet.put(LootSetType.ARMOR_FEET, MLModelArmorSets.ARMOR_SAMURAI_BOOTS);
        armorByType.put(SAMURAI, armorSet);
        return (ModelBiped)((Map)armorByType.get(set)).get((Object)type);
    }

    public static String getNameForType(LootSetType type, Random rand) {
        if (!LOOT_ITEM_NAMES.containsKey((Object)type)) {
            return "";
        }
        String[] names = LOOT_ITEM_NAMES.get((Object)type);
        return names[rand.nextInt(names.length)];
    }

    static {
        LOOT_ITEM_NAMES.put(LootSetType.SWORD, SWORD_NAMES);
        LOOT_ITEM_NAMES.put(LootSetType.BOW, BOW_NAMES);
        LOOT_ITEM_NAMES.put(LootSetType.RING, RING_NAMES);
        LOOT_ITEM_NAMES.put(LootSetType.TOOL, TOOL_NAMES);
    }

    public class LootSetElement {
        public String name;
        public LootSetType type;
    }

    public static enum LootSetType {
        SWORD(24),
        BOW(12),
        RING(13),
        ARMOR_FEET(4),
        ARMOR_LEGS(4),
        ARMOR_CHEST(4),
        ARMOR_HEAD(4),
        TOOL(12);

        public final int models;

        private LootSetType(int totalModels) {
            this.models = totalModels;
        }
    }
}

