/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootSet;

public class LootWeaponEffect {
    public static final Map<String, LootWeaponEffect> REGISTRY = new HashMap<String, LootWeaponEffect>();
    public static final LootWeaponEffect WITHERING = LootWeaponEffect.create("wither", MobEffects.field_82731_v).setDuration(1, 2).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect POISON = LootWeaponEffect.create("poison", MobEffects.field_76436_u).setDuration(1, 3).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect HUNGER = LootWeaponEffect.create("hunger", MobEffects.field_76438_s).setDuration(1, 10).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect LEVITATION = LootWeaponEffect.create("levitation", MobEffects.field_188424_y).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect WEAKNESS = LootWeaponEffect.create("weakness", MobEffects.field_76437_t).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect SLOWNESS = LootWeaponEffect.create("slowness", MobEffects.field_76421_d).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect BLINDNESS = LootWeaponEffect.create("blindness", MobEffects.field_76440_q).setDuration(1, 2).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect MULTISHOT = LootWeaponEffect.create("multishot").setAmplifier(2, 6).setItemTypes(LootSet.LootSetType.BOW);
    public static final LootWeaponEffect LEECHLIFE = LootWeaponEffect.create("leechlife").setAmplifier(1, 100).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect SPEED = LootWeaponEffect.create("speed", MobEffects.field_76424_c).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect STRENGTH = LootWeaponEffect.create("strength", MobEffects.field_76420_g).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect JUMP = LootWeaponEffect.create("jump", MobEffects.field_76430_j).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect RESISTANCE = LootWeaponEffect.create("resistance", MobEffects.field_76429_m).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect HASTE = LootWeaponEffect.create("haste", MobEffects.field_76422_e).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect FIRE_RESISTANT = LootWeaponEffect.create("fire_resistance", MobEffects.field_76426_n);
    public static final LootWeaponEffect HEALTH_BOOST = LootWeaponEffect.create("healthboost", SharedMonsterAttributes.field_111267_a).setAmplifier(1, 4).setItemTypes(LootSet.LootSetType.ARMOR_HEAD, LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS, LootSet.LootSetType.ARMOR_FEET);
    public static final LootWeaponEffect KNOCKBACK_RESISTANCE = LootWeaponEffect.create("knockbackresistance", SharedMonsterAttributes.field_111266_c).setAmplifier(1, 1).setItemTypes(LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS);
    public static final LootWeaponEffect LUCK = LootWeaponEffect.create("luck", SharedMonsterAttributes.field_188792_h).setAmplifier(1, 1024).setItemTypes(LootSet.LootSetType.ARMOR_HEAD);
    private String id;
    private Potion effect;
    private IAttribute attribute;
    private int durationMin = 100;
    private int durationMax = 300;
    private int amplifierMin = 0;
    private int amplifierMax = 0;
    private List<LootSet.LootSetType> applyToItems = new ArrayList<LootSet.LootSetType>();

    public boolean applyToItemType(LootSet.LootSetType type) {
        return this.applyToItems.contains((Object)type);
    }

    protected LootWeaponEffect setItemTypes(LootSet.LootSetType ... itemTypes) {
        for (LootSet.LootSetType itemType : itemTypes) {
            this.applyToItems.add(itemType);
        }
        return this;
    }

    @Nullable
    public static LootWeaponEffect getById(String id) {
        LootWeaponEffect weaponEffect = REGISTRY.get(id);
        return weaponEffect;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public static LootWeaponEffect getRandomExcluding(Random rand, LootSet.LootSetType type, List<LootWeaponEffect> exclude) {
        LootWeaponEffect weaponEffect = null;
        ArrayList<LootWeaponEffect> list = new ArrayList<LootWeaponEffect>();
        for (LootWeaponEffect e : REGISTRY.values()) {
            if (!e.applyToItemType(type)) continue;
            list.add(e);
        }
        list.removeAll(exclude);
        if (list.size() > 0) {
            weaponEffect = (LootWeaponEffect)list.get(rand.nextInt(list.size()));
        }
        return weaponEffect;
    }

    public NBTTagCompound getNBT(Random rand) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.getId());
        tag.func_74768_a("duration", this.getDuration(rand));
        tag.func_74768_a("amplifier", this.getAmplifier(rand));
        return tag;
    }

    public static int getDurationFromStack(ItemStack stack, String effectId) {
        int duration = 0;
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            duration = e.func_74762_e("duration");
        }
        return duration;
    }

    public static int getAmplifierFromStack(ItemStack stack, String effectId) {
        int amplifier = 0;
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            amplifier = e.func_74762_e("amplifier");
        }
        return amplifier;
    }

    public static List<LootWeaponEffect> getEffectList(ItemStack stack) {
        ArrayList<LootWeaponEffect> list = new ArrayList<LootWeaponEffect>();
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            list.add(LootWeaponEffect.getById(e.func_74779_i("id")));
        }
        return list;
    }

    protected static LootWeaponEffect create(String id) {
        return LootWeaponEffect.create(id, null, null);
    }

    protected static LootWeaponEffect create(String id, IAttribute attribute) {
        return LootWeaponEffect.create(id, null, attribute);
    }

    protected static LootWeaponEffect create(String id, Potion effect) {
        return LootWeaponEffect.create(id, effect, null);
    }

    protected static LootWeaponEffect create(String id, Potion effect, IAttribute attribute) {
        LootWeaponEffect weaponEffect = new LootWeaponEffect();
        weaponEffect.id = id;
        weaponEffect.effect = effect;
        weaponEffect.attribute = attribute;
        REGISTRY.put(id, weaponEffect);
        return weaponEffect;
    }

    protected LootWeaponEffect setDuration(int min, int max) {
        this.durationMin = min * 100;
        this.durationMax = max * 100;
        return this;
    }

    protected LootWeaponEffect setAmplifier(int min, int max) {
        this.amplifierMin = min;
        this.amplifierMax = max;
        return this;
    }

    private int getDuration(Random rand) {
        int duration = this.durationMin;
        if (duration < this.durationMax) {
            duration += rand.nextInt(this.durationMax - duration + 1);
        }
        return duration;
    }

    private int getAmplifier(Random rand) {
        int amplifier = this.amplifierMin;
        if (amplifier < this.amplifierMax) {
            amplifier += rand.nextInt(this.amplifierMax - amplifier + 1);
        }
        return amplifier;
    }

    @Nullable
    public IAttribute getAttribute() {
        return this.attribute;
    }

    @Nullable
    public PotionEffect getPotionEffect(int duration, int amplifier) {
        if (this.effect == null) {
            return null;
        }
        PotionEffect weaponEffect = new PotionEffect(this.effect, duration, amplifier, true, false);
        return weaponEffect;
    }

    public void onHit(int duration, int amplifier, EntityLivingBase target, EntityLivingBase attacker) {
        PotionEffect effect = this.getPotionEffect(duration, amplifier);
        if (effect != null) {
            target.func_70690_d(effect);
        }
    }

    public String getAmplifierString(ItemStack stack, String effectId) {
        return this.getAmplifierString(stack, effectId, 0);
    }

    public String getAmplifierString(ItemStack stack, String effectId, int add) {
        return TextFormatting.BOLD + "" + (LootWeaponEffect.getAmplifierFromStack(stack, effectId) + add) + "" + TextFormatting.RESET + "" + TextFormatting.AQUA + "";
    }

    public String getDurationString(ItemStack stack, String effectId) {
        return TextFormatting.BOLD + "" + LootWeaponEffect.getDurationFromStack(stack, effectId) / 100 + "" + TextFormatting.RESET + "" + TextFormatting.AQUA + "";
    }
}

