/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.util;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.item.MLItemWeaponBow;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootWeaponEffect;

@Mod.EventBusSubscriber
public class MLEventHandler {
    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack result = event.getItemResult();
        if (result.func_77973_b() == MLItems.WEAPONSWORD && result.func_82837_s()) {
            char colorChar = '\u00a7';
            String name = result.func_82833_r();
            char fChar = name.charAt(0);
            if (fChar != colorChar && (fChar == 'a' || fChar == 'b' || fChar == 'c' || fChar == 'd' || fChar == 'e' || fChar == 'f' || fChar == '0' || fChar == '1' || fChar == '2' || fChar == '3' || fChar == '4' || fChar == '5' || fChar == '6' || fChar == '7' || fChar == '8' || fChar == '9')) {
                result.func_151001_c(colorChar + name);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        ItemStack stack;
        List<LootWeaponEffect> effects;
        EntityPlayer player;
        Entity sourceEntity = event.getSource().func_76364_f();
        EntityLivingBase targetEntity = event.getEntityLiving();
        if (sourceEntity != null && targetEntity != null && !sourceEntity.field_70170_p.field_72995_K && sourceEntity instanceof EntityPlayer && targetEntity instanceof EntityPlayer && (player = (EntityPlayer)sourceEntity) != null && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() != null && player.func_184614_ca().func_77973_b() == MLItems.WEAPONSWORD && (effects = LootWeaponEffect.getEffectList(stack = player.func_184614_ca())).contains(LootWeaponEffect.getById("leechlife"))) {
            float damageInflicted = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
            int amplifier = LootWeaponEffect.getAmplifierFromStack(stack, "leechlife");
            float leech = damageInflicted * ((float)amplifier / 100.0f);
            player.func_70691_i(leech);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main;
        if ((event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186421_c) || event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186420_b) || event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i) || event.getName().equals((Object)LootTableList.field_186426_h) || event.getName().equals((Object)LootTableList.field_186423_e)) && (main = event.getTable().getPool("main")) != null) {
            this.addPoolEntry(main, MLItems.WEAPONCASE_COMMON, 10);
            this.addPoolEntry(main, MLItems.WEAPONCASE_RARE, 7);
            this.addPoolEntry(main, MLItems.WEAPONCASE_EPIC, 5);
        }
    }

    private void addPoolEntry(LootPool lootPool, Item item, int weight) {
        lootPool.addEntry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[0], new LootCondition[0], "megaloot:" + item.func_77658_a().substring(5)));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFOVUpdate(FOVUpdateEvent event) {
        MLItemWeaponBow item;
        if (!event.getEntity().func_184587_cr()) {
            return;
        }
        ItemStack stack = event.getEntity().func_184607_cu();
        if (stack != null && stack.func_77973_b() instanceof MLItemWeaponBow && (item = (MLItemWeaponBow)stack.func_77973_b()).updatesFOV()) {
            float newfov = event.getFov() / (event.getFov() + item.getFOVValue(stack) * this.getItemInUsePercentaje(event.getEntity(), item.getFOVSpeedFactor(stack)));
            event.setNewfov(newfov);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private float getItemInUsePercentaje(EntityPlayer player, float speedFactor) {
        if (player.func_184607_cu().func_77973_b() instanceof MLItemWeaponBow) {
            MLItemWeaponBow bow = (MLItemWeaponBow)player.func_184607_cu().func_77973_b();
            float maxUse = bow.getFOVDuration(player.func_184607_cu());
            float curUse = player.func_184605_cv();
            float percent = 0.0f;
            percent *= speedFactor * ((percent = maxUse - (maxUse - ((float)bow.func_77626_a(player.func_184607_cu()) - curUse))) > 100.0f ? 1.0f : percent / 100.0f);
            percent /= maxUse;
            percent *= 1.0f + percent;
            return percent > 1.0f ? 1.0f : percent;
        }
        return 1.0f;
    }
}

