/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom.component;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IItemStacksRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.OreDictItemStackRecipeComponent;

public class ItemStacksRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IItemStacksRecipeComponent {
    private final List<ItemStackRecipeComponent> itemStacks;

    public ItemStacksRecipeComponent(List<Object> itemStacks) {
        this.itemStacks = Lists.transform(itemStacks, (Function)new Function<Object, ItemStackRecipeComponent>(){

            @Nullable
            public ItemStackRecipeComponent apply(Object input) {
                return input instanceof String ? new OreDictItemStackRecipeComponent((String)input) : new ItemStackRecipeComponent((ItemStack)input);
            }
        });
    }

    public boolean equals(Object object) {
        if (!(object instanceof ItemStacksRecipeComponent)) {
            return false;
        }
        ItemStacksRecipeComponent that = (ItemStacksRecipeComponent)object;
        return this.equals(this.itemStacks, that.itemStacks);
    }

    protected boolean equals(List<ItemStackRecipeComponent> a, List<ItemStackRecipeComponent> b) {
        if (a.size() == b.size()) {
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i).equals(b.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 876;
        for (ItemStackRecipeComponent itemStack : this.itemStacks) {
            hash |= itemStack.hashCode();
        }
        return hash;
    }

    @Override
    public List<ItemStack> getItemStacks() {
        return Lists.transform(this.itemStacks, (Function)new Function<ItemStackRecipeComponent, ItemStack>(){

            @Nullable
            public ItemStack apply(@Nullable ItemStackRecipeComponent input) {
                return input.getItemStack();
            }
        });
    }

    public String toString() {
        return "ItemStacksRecipeComponent(itemStacks=" + this.getItemStacks() + ")";
    }
}

