/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.entity.EntitySeat;
import jds.bibliocraft.helpers.SeatHelper;
import jds.bibliocraft.items.ItemSeatBack;
import jds.bibliocraft.items.ItemSeatBack2;
import jds.bibliocraft.items.ItemSeatBack3;
import jds.bibliocraft.items.ItemSeatBack4;
import jds.bibliocraft.items.ItemSeatBack5;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntitySeat;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class BlockSeat
extends BiblioWoodBlock {
    public static final String name = "Seat";
    public static final BlockSeat instance = new BlockSeat();

    public BlockSeat() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof TileEntitySeat) {
            TileEntitySeat seatTile = (TileEntitySeat)tile;
            ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (playerStack != null) {
                int returnStackSize;
                Item playerItem;
                if (playerStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                    if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
                        int returnStackSize2 = seatTile.addSeatCover(playerStack);
                        if (returnStackSize2 != -1) {
                            if (returnStackSize2 == 0) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            } else {
                                playerStack.field_77994_a = returnStackSize2;
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                            }
                            return true;
                        }
                    } else {
                        int returnStackSize3 = seatTile.setCarpet(playerStack);
                        if (returnStackSize3 != -1) {
                            if (returnStackSize3 == 0) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            } else {
                                playerStack.field_77994_a = returnStackSize3;
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                            }
                        }
                        return true;
                    }
                }
                if (((playerItem = playerStack.func_77973_b()) instanceof ItemSeatBack || playerItem instanceof ItemSeatBack2 || playerItem instanceof ItemSeatBack3 || playerItem instanceof ItemSeatBack4 || playerItem instanceof ItemSeatBack5) && (returnStackSize = seatTile.addSeatBack(playerStack)) != -1) {
                    if (returnStackSize == 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        playerStack.field_77994_a = returnStackSize;
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                    }
                    return true;
                }
            }
            if (!seatTile.getHasSitter()) {
                this.sitDown(player, world, pos, seatTile);
                seatTile.setSitter(true);
            } else if (player.func_70093_af()) {
                seatTile.dismountEntity();
            }
        }
        return true;
    }

    public void sitDown(EntityPlayer player, World world, BlockPos pos, TileEntitySeat tile) {
        EntitySeat seatEntity = new EntitySeat(world, pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, pos.func_177952_p(), tile);
        world.func_72838_d((Entity)seatEntity);
        player.func_184220_m((Entity)seatEntity);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySeat();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        List<String> modelParts = new ArrayList<String>();
        modelParts.add("stool");
        modelParts.add("seat");
        if (tile instanceof TileEntitySeat) {
            TileEntitySeat seat = (TileEntitySeat)tile;
            if (!(seat.getSouthConnect() || seat.getNorthConnect() || seat.getEastConnect() || seat.getWestConnect())) {
                modelParts.add("leg1");
                modelParts.add("leg2");
                modelParts.add("leg3");
                modelParts.add("leg4");
                modelParts.add("brace1");
                modelParts.add("brace2");
                modelParts.add("brace3");
                modelParts.add("brace4");
            } else {
                modelParts = this.getSeatAndLegParts(seat, modelParts);
            }
            if (seat.getHasBack() > 0) {
                modelParts = this.getSeatBackParts(seat, modelParts);
            }
            if (seat.isCarpetFull()) {
                modelParts.add("carpet");
            }
        }
        return modelParts;
    }

    public List<String> getSeatBackParts(TileEntitySeat tile, List<String> parts) {
        SeatHelper adjust = new SeatHelper(tile.getSouthConnect(), tile.getWestConnect(), tile.getNorthConnect(), tile.getEastConnect(), tile.getAngle());
        boolean southConnect = adjust.getSouthConnect();
        boolean northConnect = adjust.getNorthConnect();
        boolean eastConnect = adjust.getEastConnect();
        boolean westConnect = adjust.getWestConnect();
        switch (tile.getHasBack()) {
            case 1: {
                parts.add("backSupport");
                parts.add("backCloth");
                break;
            }
            case 2: {
                parts.add("backWood2");
                parts.add("backCloth2");
                break;
            }
            case 3: {
                parts.add("backWood2");
                parts.add("backWood2Top");
                parts.add("backCloth2");
                break;
            }
            case 4: {
                parts.add("backSupport2");
                parts.add("backCloth003");
                break;
            }
            case 5: {
                parts.add("backWood2");
                parts.add("fancyBackWood");
                parts.add("backCloth2");
                break;
            }
        }
        if (southConnect) {
            switch (tile.getHasBack()) {
                case 1: {
                    parts.add("backCloth1connect1");
                    break;
                }
                case 4: {
                    parts.add("backCloth2connect1");
                    break;
                }
            }
        }
        if (northConnect) {
            switch (tile.getHasBack()) {
                case 1: {
                    parts.add("backCloth1connect3");
                    break;
                }
                case 4: {
                    parts.add("backCloth2connect3");
                    break;
                }
            }
        }
        return parts;
    }

    public List<String> getSeatAndLegParts(TileEntitySeat tile, List<String> parts) {
        SeatHelper adjust = new SeatHelper(tile.getSouthConnect(), tile.getWestConnect(), tile.getNorthConnect(), tile.getEastConnect(), tile.getAngle());
        boolean southConnect = adjust.getSouthConnect();
        boolean northConnect = adjust.getNorthConnect();
        boolean eastConnect = adjust.getEastConnect();
        boolean westConnect = adjust.getWestConnect();
        parts = this.getSeatParts(parts, southConnect, northConnect, eastConnect, westConnect);
        parts = this.getLegParts(parts, southConnect, northConnect, eastConnect, westConnect);
        return parts;
    }

    public List<String> getSeatParts(List<String> parts, boolean southConnect, boolean northConnect, boolean eastConnect, boolean westConnect) {
        if (southConnect) {
            parts.add("bench1");
        }
        if (eastConnect) {
            parts.add("bench2");
        }
        if (northConnect) {
            parts.add("bench3");
        }
        if (westConnect) {
            parts.add("bench4");
        }
        if (southConnect) {
            parts.add("benchSeat1");
        }
        if (eastConnect) {
            parts.add("benchSeat2");
        }
        if (northConnect) {
            parts.add("benchSeat3");
        }
        if (westConnect) {
            parts.add("benchSeat4");
        }
        return parts;
    }

    public List<String> getLegParts(List<String> parts, boolean southConnect, boolean northConnect, boolean eastConnect, boolean westConnect) {
        boolean leg1 = true;
        boolean leg2 = true;
        boolean leg3 = true;
        boolean leg4 = true;
        if (southConnect && northConnect || eastConnect && westConnect) {
            leg1 = false;
            leg2 = false;
            leg3 = false;
            leg4 = false;
        }
        if (southConnect && !northConnect && eastConnect && !westConnect) {
            leg2 = false;
        }
        if (southConnect && !northConnect && !eastConnect && westConnect) {
            leg1 = false;
        }
        if (!southConnect && northConnect && eastConnect && !westConnect) {
            leg3 = false;
        }
        if (!southConnect && northConnect && !eastConnect && westConnect) {
            leg4 = false;
        }
        if (southConnect && !northConnect && !eastConnect && !westConnect) {
            leg1 = false;
            leg2 = false;
        }
        if (!southConnect && northConnect && !eastConnect && !westConnect) {
            leg3 = false;
            leg4 = false;
        }
        if (!southConnect && !northConnect && eastConnect && !westConnect) {
            leg2 = false;
            leg3 = false;
        }
        if (!southConnect && !northConnect && !eastConnect && westConnect) {
            leg1 = false;
            leg4 = false;
        }
        if (leg1) {
            parts.add("leg1");
        }
        if (leg2) {
            parts.add("leg2");
        }
        if (leg3) {
            parts.add("leg3");
        }
        if (leg4) {
            parts.add("leg4");
        }
        if (leg1 && leg2) {
            parts.add("brace1");
        }
        if (leg2 && leg3) {
            parts.add("brace2");
        }
        if (leg3 && leg4) {
            parts.add("brace3");
        }
        if (leg1 && leg4) {
            parts.add("brace4");
        }
        return parts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(-0.0f, 0.0f, -0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getBlockBounds(0.16f, 0.0f, 0.16f, 0.84f, 0.74f, 0.84f);
    }

    @Override
    public TextureState addAdditionTextureStateInformation(BiblioTileEntity tile, TextureState state) {
        if (tile instanceof TileEntitySeat) {
            TileEntitySeat seat = (TileEntitySeat)tile;
            state.setColorOne(seat.getSeatColor());
            state.setColorTwo(seat.getCarpetColor());
            state.setAdditionalWood(seat.getBackWoodType());
            state.setAdditionalTextureString(seat.getCustomBackTexture());
            state.setFlag(seat.getHasBack() > 0);
            state.setFlag2(tile.func_145832_p() == BiblioWoodBlock.EnumWoodType.FRAME.getID());
        }
        return state;
    }

    public boolean func_149744_f(IBlockState state) {
        return Config.chairRedstone;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntitySeat seat;
        TileEntity tile = world.func_175625_s(pos);
        if (Config.chairRedstone && tile != null && tile instanceof TileEntitySeat && (seat = (TileEntitySeat)tile).getHasSitter()) {
            return 15;
        }
        return 0;
    }

    private void breakConnectsFix(World world, BlockPos pos, TileEntitySeat tileSeat) {
        TileEntitySeat adjTile;
        TileEntity tile;
        boolean northConnect = tileSeat.getNorthConnect();
        boolean southConnect = tileSeat.getSouthConnect();
        boolean eastConnect = tileSeat.getEastConnect();
        boolean westConnect = tileSeat.getWestConnect();
        if (northConnect && (tile = world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1))) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setSouthConnect(false);
        }
        if (southConnect && (tile = world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1))) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setNorthConnect(false);
        }
        if (eastConnect && (tile = world.func_175625_s(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()))) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setWestConnect(false);
        }
        if (westConnect && (tile = world.func_175625_s(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()))) != null && tile instanceof TileEntitySeat) {
            adjTile = (TileEntitySeat)tile;
            adjTile.setEastConnect(false);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntitySeat) {
            this.breakConnectsFix(world, pos, (TileEntitySeat)tile);
        }
        super.func_180663_b(world, pos, state);
    }
}

