/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.BlockLoader;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.blocks.BlockMarkerPole;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.TileEntityMarkerPole;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTapeMeasure
extends Item {
    public static final String name = "tapeMeasure";
    public static final ItemTapeMeasure instance = new ItemTapeMeasure();
    private int firstMeasurex = 0;
    private int firstMeasurey = 0;
    private int firstMeasurez = 0;
    private int oldx = 0;
    private int oldy = 0;
    private int oldz = 0;
    private EnumFacing oldface = EnumFacing.NORTH;
    private boolean markerPlaced = false;
    private int mode = 1;
    private int ticktime = 0;

    public ItemTapeMeasure() {
        this.func_77637_a(BlockLoader.biblioTab);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.setRegistryName(name);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            if (this.firstMeasurex != 0 || this.firstMeasurey != 0 || this.firstMeasurez != 0) {
                int xdist = Math.abs(this.firstMeasurex - pos.func_177958_n());
                int ydist = Math.abs(this.firstMeasurey - pos.func_177956_o());
                int zdist = Math.abs(this.firstMeasurez - pos.func_177952_p());
                ++xdist;
                ++zdist;
                if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
                    ++ydist;
                }
                int measurmentxz = (int)Math.sqrt(xdist * xdist + zdist * zdist);
                int measurmentxy = (int)Math.sqrt(xdist * xdist + ydist * ydist);
                int measurmentyz = (int)Math.sqrt(ydist * ydist + zdist * zdist);
                if (this.mode == 1) {
                    if (zdist != 1) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measurenorthsouth") + zdist));
                    }
                    if (xdist != 1) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measureeastwest") + xdist));
                    }
                    if (ydist != 0) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measureheight") + ydist));
                    }
                    if (xdist == 1 && zdist == 1 && ydist == 0) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.nomeasure")));
                    }
                }
                if (this.mode == 0) {
                    if (ydist == 0) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measure") + measurmentxz));
                    } else if (xdist == 0) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measure") + measurmentyz));
                    } else if (zdist == 0) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measure") + measurmentxy));
                    } else {
                        int euclideon = (int)Math.sqrt(xdist * xdist + ydist * ydist + zdist * zdist);
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.measure") + euclideon));
                    }
                }
                player.func_184185_a(CommonProxy.SOUND_TAPE_CLOSE, 1.0f, 1.0f);
                this.oldx = this.firstMeasurex;
                this.oldy = this.firstMeasurey;
                this.oldz = this.firstMeasurez;
                this.firstMeasurex = 0;
                this.firstMeasurey = 0;
                this.firstMeasurez = 0;
                this.sendPacket(false, this.oldx, this.oldy, this.oldz, this.oldface);
            } else {
                player.func_184185_a(CommonProxy.SOUND_TAPE_OPEN, 1.0f, 1.0f);
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.startmeasure")));
                this.firstMeasurex = pos.func_177958_n();
                this.firstMeasurey = pos.func_177956_o();
                this.firstMeasurez = pos.func_177952_p();
                this.oldface = side;
                this.sendPacket(true, this.firstMeasurex, this.firstMeasurey, this.firstMeasurez, side);
                this.placeBlock(world, this.firstMeasurex, this.firstMeasurey, this.firstMeasurez, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void sendPacket(boolean newOrOld, int i, int j, int k, EnumFacing direction) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            buffer.writeInt(i);
            buffer.writeInt(j);
            buffer.writeInt(k);
            buffer.writeBoolean(newOrOld);
            buffer.writeInt(direction.func_176745_a());
            BiblioCraft.ch_BiblioMeasure.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioMeasure"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void placeBlock(World world, int x, int y, int z, EnumFacing facing) {
        int xadj = 0;
        int yadj = 0;
        int zadj = 0;
        switch (facing) {
            case DOWN: {
                yadj = -1;
                break;
            }
            case UP: {
                yadj = 1;
                break;
            }
            case NORTH: {
                zadj = -1;
                break;
            }
            case SOUTH: {
                zadj = 1;
                break;
            }
            case WEST: {
                xadj = -1;
                break;
            }
            case EAST: {
                xadj = 1;
                break;
            }
            default: {
                xadj = 1;
            }
        }
        BlockPos pos = new BlockPos(x + xadj, y + yadj, z + zadj);
        IBlockState st = BlockMarkerPole.instance.func_176223_P();
        world.func_175656_a(pos, st);
        TileEntityMarkerPole poleTile = (TileEntityMarkerPole)world.func_175625_s(pos);
        if (poleTile != null) {
            poleTile.setAngle(EnumFacing.NORTH);
            if (facing == EnumFacing.UP) {
                poleTile.setVertPosition(EnumVertPosition.FLOOR);
            } else if (facing == EnumFacing.DOWN) {
                poleTile.setVertPosition(EnumVertPosition.CEILING);
            } else {
                switch (facing) {
                    case NORTH: {
                        facing = EnumFacing.WEST;
                        break;
                    }
                    case WEST: {
                        facing = EnumFacing.SOUTH;
                        break;
                    }
                    case SOUTH: {
                        facing = EnumFacing.EAST;
                        break;
                    }
                    case EAST: {
                        facing = EnumFacing.NORTH;
                        break;
                    }
                }
                poleTile.setAngle(facing);
                poleTile.setVertPosition(EnumVertPosition.WALL);
            }
            world.func_175704_b(pos, pos);
        }
    }

    public void setMeasurments(boolean newOrOld, int i, int j, int k) {
        if (newOrOld) {
            this.firstMeasurex = i;
            this.firstMeasurey = j;
            this.firstMeasurez = k;
        } else {
            this.oldx = i;
            this.oldy = j;
            this.oldz = k;
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            if (this.mode == 0) {
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.mode0")));
                this.mode = 1;
            } else if (this.mode == 1) {
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tape.mode1")));
                this.mode = 0;
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        if (this.ticktime > 19) {
            NBTTagCompound tapem = itemstack.func_77978_p();
            if (tapem == null) {
                tapem = new NBTTagCompound();
                tapem.func_74768_a("distance", 0);
            }
            if (this.firstMeasurex != 0 || this.firstMeasurey != 0 || this.firstMeasurez != 0) {
                int currentx = (int)entity.field_70165_t;
                int currenty = (int)entity.field_70163_u;
                int currentz = (int)entity.field_70161_v;
                if (currentx < 0) {
                    --currentx;
                }
                if (currentz < 0) {
                    --currentz;
                }
                int xdist = this.firstMeasurex > currentx ? Math.abs(this.firstMeasurex - currentx) : Math.abs(currentx - this.firstMeasurex);
                int ydist = this.firstMeasurey > currenty ? Math.abs(this.firstMeasurey - currenty) : Math.abs(currenty - this.firstMeasurey);
                int zdist = this.firstMeasurez > currentz ? Math.abs(this.firstMeasurez - currentz) : Math.abs(currentz - this.firstMeasurez);
                int euclideon = (int)Math.sqrt(++xdist * xdist + ydist * ydist + ++zdist * zdist);
                tapem.func_74768_a("distance", euclideon);
                itemstack.func_77982_d(tapem);
            } else {
                tapem.func_74768_a("distance", 0);
                itemstack.func_77982_d(tapem);
            }
            this.ticktime = 0;
        } else {
            ++this.ticktime;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean whatsthis) {
    }
}

