/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockMarkerPole;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.helpers.FileUtil;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.items.ItemStockroomCatalog;
import jds.bibliocraft.items.ItemWaypointCompass;
import jds.bibliocraft.tileentities.TileEntityClipboard;
import jds.bibliocraft.tileentities.TileEntityClock;
import jds.bibliocraft.tileentities.TileEntityDesk;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import jds.bibliocraft.tileentities.TileEntityMarkerPole;
import jds.bibliocraft.tileentities.TileEntityPaintPress;
import jds.bibliocraft.tileentities.TileEntityPainting;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class ServerPacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        FMLProxyPacket packet = event.getPacket();
        if (packet != null) {
            if (packet.channel().equals("BiblioType")) {
                this.handleBookNameUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioTypeFlag")) {
                this.handleBookFlagUpdate(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeDelete")) {
                this.handleBookDeletion(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeUpdate")) {
                this.handleTypsetUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioMCBEdit")) {
                this.handleBookEdit(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMCBPage")) {
                this.handleBookPageUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioUpdateInv")) {
                this.handleInventoryStackUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMeasure")) {
                this.handleMarkerPoles(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMapPin")) {
                this.handleMapWaypoints(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioRBook")) {
                this.handleRecipeBook(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioRBookLoad")) {
                this.handleRecipeLoad(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioSign")) {
                this.handleFancySignUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioClock")) {
                this.handleClockUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPaintPress")) {
                this.handlePaintPressUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPainting")) {
                this.handlePaintingUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPaintingC")) {
                this.handlePaintingCustomAspectsUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handleAtlasUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioAtlasSWP")) {
                this.handleAtlasSwapUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioAtlasWPT")) {
                this.handleAtlasTransferUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioPaneler")) {
                this.handlePanelerTextureStringUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioRecipeCraft")) {
                this.handleRecipeBookRecipeCraft(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioStockTitle")) {
                this.handleStockroomCatalogTitle(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioStockCompass")) {
                this.handleStockroomCatalogCompass(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioClipboard")) {
                this.handleClipboardBlockUpdate(packet.payload(), player);
            }
        }
    }

    private void handleClipboardBlockUpdate(ByteBuf packet, EntityPlayerMP player) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int updatePos = packet.readInt();
        TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityClipboard) {
            TileEntityClipboard clipboard = (TileEntityClipboard)tile;
            clipboard.updateClipboardFromPlayerSelection(updatePos);
        }
    }

    private void handleStockroomCatalogTitle(ByteBuf packet, EntityPlayerMP player) {
        String title = ByteBufUtils.readUTF8String((ByteBuf)packet);
        ItemStack stockroomcatalog = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stockroomcatalog != null && stockroomcatalog.func_77973_b() instanceof ItemStockroomCatalog) {
            NBTTagCompound tags = stockroomcatalog.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
            }
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", TextFormatting.WHITE + title);
            tags.func_74782_a("display", (NBTBase)display);
            stockroomcatalog.func_77982_d(tags);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stockroomcatalog);
        }
    }

    private void handleStockroomCatalogCompass(ByteBuf packet, EntityPlayerMP player) {
        ItemStack compass;
        int slotNumber = packet.readInt();
        String title = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int x = packet.readInt();
        int z = packet.readInt();
        if (slotNumber < player.field_71071_by.func_70302_i_() && (compass = player.field_71071_by.func_70301_a(slotNumber)) != null && compass.func_77973_b() instanceof ItemWaypointCompass) {
            NBTTagCompound tags = compass.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
            }
            tags.func_74768_a("XCoord", x);
            tags.func_74768_a("ZCoord", z);
            tags.func_74778_a("WaypointName", title);
            compass.func_77982_d(tags);
            player.field_71071_by.func_70299_a(slotNumber, compass);
        }
    }

    private void handleRecipeBookRecipeCraft(ByteBuf packet, EntityPlayerMP player) {
        ItemStack recipeBook = ByteBufUtils.readItemStack((ByteBuf)packet);
        int inventorySlot = packet.readInt();
        if (Config.enableRecipeBookCrafting) {
            if (recipeBook != null && recipeBook.func_77973_b() instanceof ItemRecipeBook) {
                ItemStack[] bookGrid = new ItemStack[9];
                ItemStack resultStack = null;
                NBTTagCompound nbt = recipeBook.func_77978_p();
                if (nbt != null) {
                    NBTTagList tagList = nbt.func_150295_c("grid", 10);
                    bookGrid = new ItemStack[9];
                    for (int i = 0; i < 9; ++i) {
                        ItemStack nbtStack;
                        NBTTagCompound tag = tagList.func_150305_b(i);
                        byte slot = tag.func_74771_c("Slot");
                        if (slot < 0 || slot >= 9 || (nbtStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                        bookGrid[slot] = nbtStack;
                    }
                    NBTTagCompound resultTag = nbt.func_74775_l("result");
                    if (resultTag != null) {
                        resultStack = ItemStack.func_77949_a((NBTTagCompound)resultTag);
                    }
                }
                if (resultStack != null) {
                    if (this.checkForValidRecipeIngredients(bookGrid, player, false)) {
                        Container contained = new Container(){

                            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                                return false;
                            }
                        };
                        InventoryCrafting playerCraftMatrix = new InventoryCrafting(contained, 3, 3);
                        for (int i = 0; i < bookGrid.length; ++i) {
                            playerCraftMatrix.func_70299_a(i, bookGrid[i]);
                        }
                        ItemStack result = CraftingManager.func_77594_a().func_82787_a(playerCraftMatrix, player.field_70170_p);
                        if (result != null) {
                            if (this.checkForValidRecipeIngredients(bookGrid, player, true)) {
                                if (!player.field_71071_by.func_70441_a(result)) {
                                    EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(result.func_77973_b(), result.field_77994_a, result.func_77952_i()));
                                    if (result.func_77942_o()) {
                                        entityItem.func_92059_d().func_77982_d(result.func_77978_p().func_74737_b());
                                    }
                                    entityItem.field_70159_w = 0.0;
                                    entityItem.field_70181_x = 0.0;
                                    entityItem.field_70179_y = 0.0;
                                    player.field_70170_p.func_72838_d((Entity)entityItem);
                                }
                                this.sendARecipeBookTextPacket(player, result.func_82833_r() + " " + I18n.func_74838_a((String)"gui.recipe.crafted"), inventorySlot);
                            } else {
                                this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.failed"), inventorySlot);
                            }
                            return;
                        }
                        this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.invalid"), inventorySlot);
                        return;
                    }
                    this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.missing"), inventorySlot);
                    return;
                }
                this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.invalid"), inventorySlot);
                return;
            }
            this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.wrong"), inventorySlot);
        } else {
            this.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.disabled"), inventorySlot);
        }
    }

    private boolean checkForValidRecipeIngredients(ItemStack[] ingredients, EntityPlayerMP player, boolean remove) {
        int i;
        if (player.field_71075_bZ.field_75098_d) {
            remove = false;
        }
        boolean[] passed = new boolean[]{false, false, false, false, false, false, false, false, false};
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        ItemStack[] playerInventory = (ItemStack[])inventory.clone();
        ItemStack[] playerIngredients = (ItemStack[])ingredients.clone();
        ItemStack[] countedIngredients = new ItemStack[9];
        for (i = 0; i < playerIngredients.length; ++i) {
            ItemStack thing = playerIngredients[i];
            if (thing == null) continue;
            int count = 0;
            for (int n = 0; n < playerIngredients.length; ++n) {
                ItemStack subThing = playerIngredients[n];
                if (subThing == null || !subThing.func_77977_a().equals(thing.func_77977_a())) continue;
                ++count;
                playerIngredients[n] = null;
            }
            thing.field_77994_a = count;
            countedIngredients[i] = thing;
        }
        block2: for (i = 0; i < countedIngredients.length; ++i) {
            ItemStack ingredientItem = countedIngredients[i];
            if (ingredientItem != null) {
                for (int n = 0; n < playerInventory.length; ++n) {
                    ItemStack inventoryItem = playerInventory[n];
                    if (inventoryItem == null || !inventoryItem.func_77977_a().equals(ingredientItem.func_77977_a())) continue;
                    if (inventoryItem.field_77994_a >= ingredientItem.field_77994_a) {
                        if (remove) {
                            inventoryItem.field_77994_a -= ingredientItem.field_77994_a;
                            inventory[n] = inventoryItem.field_77994_a <= 0 ? null : inventoryItem;
                        }
                        passed[i] = true;
                        continue block2;
                    }
                    ingredientItem.field_77994_a -= inventoryItem.field_77994_a;
                    countedIngredients[i] = ingredientItem;
                    if (!remove) continue;
                    inventory[n] = null;
                }
                continue;
            }
            passed[i] = true;
        }
        boolean hasIngredients = true;
        for (int m = 0; m < passed.length; ++m) {
            if (passed[m]) continue;
            hasIngredients = false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            hasIngredients = true;
        }
        return hasIngredients;
    }

    private void sendARecipeBookTextPacket(EntityPlayerMP player, String text, int slot) {
        ItemStack currentBook = player.field_71071_by.func_70301_a(slot);
        if (currentBook != null && currentBook.func_77973_b() instanceof ItemRecipeBook) {
            ByteBuf buffer = Unpooled.buffer();
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)text);
            buffer.writeInt(slot);
            BiblioCraft.ch_BiblioRecipeText.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioRecipeText"), player);
        }
    }

    private void handlePanelerTextureStringUpdate(ByteBuf packet, World world) {
        int k;
        int j;
        String texName = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int i = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(i, j = packet.readInt(), k = packet.readInt()));
        if (tile != null && tile instanceof TileEntityFurniturePaneler) {
            TileEntityFurniturePaneler paneler = (TileEntityFurniturePaneler)tile;
            paneler.setCustomCraftingTex(texName);
        }
    }

    private void handlePaintingCustomAspectsUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int aspectX = packet.readInt();
        int aspectY = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            painting.setPacketAspectsUpdate(aspectX, aspectY);
        }
    }

    private void handleAtlasTransferUpdate(ByteBuf packet, EntityPlayerMP player) {
        boolean toMapFrame = packet.readBoolean();
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        ItemStack atlasStack = ByteBufUtils.readItemStack((ByteBuf)packet);
        TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityMapFrame && atlasStack != null) {
            TileEntityMapFrame frameTile = (TileEntityMapFrame)tile;
            if (toMapFrame) {
                this.transferWaypointsToMapFrame(frameTile, atlasStack);
                frameTile.func_145831_w().func_184138_a(frameTile.func_174877_v(), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), 3);
            } else {
                this.transferWaypointsToAtlas(frameTile, atlasStack, player);
            }
        }
    }

    private void transferWaypointsToAtlas(TileEntityMapFrame frameTile, ItemStack atlasStack, EntityPlayerMP player) {
        InventoryBasic inv = this.getInventory(atlasStack);
        ItemStack newMap = frameTile.func_70301_a(0);
        NBTTagCompound tags = atlasStack.func_77978_p();
        if (inv != null && tags != null) {
            String newMapName = "Map_" + newMap.func_77952_i();
            boolean foundMapData = false;
            NBTTagList atlasMapsDatas = new NBTTagList();
            int hasCurrentMapDatas = -1;
            if (tags.func_74764_b("maps")) {
                atlasMapsDatas = tags.func_150295_c("maps", 10);
                for (int i = 0; i < atlasMapsDatas.func_74745_c(); ++i) {
                    String oldMap;
                    NBTTagCompound testTag = atlasMapsDatas.func_150305_b(i);
                    if (testTag == null || !testTag.func_74764_b("mapName") || !(oldMap = testTag.func_74779_i("mapName")).contentEquals(newMapName)) continue;
                    atlasMapsDatas.func_74744_a(i);
                    foundMapData = true;
                }
            }
            atlasMapsDatas.func_74742_a((NBTBase)this.getNewMapDataCompound(frameTile, newMapName));
            tags.func_74782_a("maps", (NBTBase)atlasMapsDatas);
            atlasStack.func_77982_d(tags);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlasStack);
        }
    }

    private void transferWaypointsToMapFrame(TileEntityMapFrame frameTile, ItemStack atlasStack) {
        InventoryBasic inv = this.getInventory(atlasStack);
        NBTTagCompound atlasTags = atlasStack.func_77978_p();
        ItemStack mapStack = this.getCurrentMapStack(atlasStack);
        if (atlasTags != null && inv != null && mapStack != null && atlasTags.func_74764_b("maps")) {
            NBTTagList maps = atlasTags.func_150295_c("maps", 10);
            NBTTagCompound mapTag = null;
            String mapName = "Map_" + mapStack.func_77952_i();
            for (int n = 0; n < maps.func_74745_c(); ++n) {
                mapTag = maps.func_150305_b(n);
                if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                frameTile.addMapPinDataFromAtlas(mapTag);
                for (int i = 0; i < frameTile.getRotation(); ++i) {
                    frameTile.rotateWaypoints();
                }
            }
        }
    }

    private NBTTagCompound getNewMapDataCompound(TileEntityMapFrame tile, String newMapName) {
        int mapRotation = tile.getRotation();
        NBTTagCompound newMapData = new NBTTagCompound();
        newMapData.func_74778_a("mapName", newMapName);
        newMapData.func_74768_a("xCenter", tile.mapXCenter);
        newMapData.func_74768_a("zCenter", tile.mapZCenter);
        newMapData.func_74768_a("mapScale", tile.mapScale);
        EnumFacing angle = tile.getAngle();
        EnumVertPosition vertAngle = tile.getVertPosition();
        int rotations = 0;
        switch (mapRotation) {
            case 1: {
                rotations = 3;
                break;
            }
            case 2: {
                rotations = 2;
                break;
            }
            case 3: {
                rotations = 1;
            }
        }
        ArrayList xPins = new ArrayList();
        xPins = (ArrayList)tile.xPin.clone();
        ArrayList yPins = new ArrayList();
        yPins = (ArrayList)tile.yPin.clone();
        for (int i = 0; i < rotations; ++i) {
            int n;
            ArrayList xCurrent = xPins;
            ArrayList yCurrent = yPins;
            if ((angle == EnumFacing.SOUTH || angle == EnumFacing.EAST) && vertAngle == EnumVertPosition.WALL || vertAngle == EnumVertPosition.CEILING) {
                xPins = yCurrent;
                yCurrent = yPins = xCurrent;
                for (n = 0; n < xCurrent.size(); ++n) {
                    yPins.set(n, Float.valueOf(1.0f - ((Float)yCurrent.get(n)).floatValue()));
                }
                continue;
            }
            xPins = yCurrent;
            yPins = xCurrent;
            xCurrent = xPins;
            for (n = 0; n < xCurrent.size(); ++n) {
                xPins.set(n, Float.valueOf(1.0f - ((Float)xCurrent.get(n)).floatValue()));
            }
        }
        NBTTagList mapXPins = new NBTTagList();
        for (int i = 0; i < xPins.size(); ++i) {
            float xpin = ((Float)xPins.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.WALL && (tile.getAngle() == EnumFacing.WEST || tile.getAngle() == EnumFacing.NORTH)) {
                xpin = 1.0f - xpin;
            }
            mapXPins.func_74742_a((NBTBase)new NBTTagFloat(xpin));
        }
        newMapData.func_74782_a("xMapWaypoints", (NBTBase)mapXPins);
        NBTTagList mapYPins = new NBTTagList();
        for (int i = 0; i < yPins.size(); ++i) {
            float ypin = ((Float)yPins.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.CEILING || tile.getVertPosition() == EnumVertPosition.WALL) {
                ypin = 1.0f - ypin;
            }
            mapYPins.func_74742_a((NBTBase)new NBTTagFloat(ypin));
        }
        newMapData.func_74782_a("yMapWaypoints", (NBTBase)mapYPins);
        NBTTagList mapPinNames = new NBTTagList();
        for (int i = 0; i < tile.pinStrings.size(); ++i) {
            mapPinNames.func_74742_a((NBTBase)new NBTTagString((String)tile.pinStrings.get(i)));
        }
        newMapData.func_74782_a("MapWaypointNames", (NBTBase)mapPinNames);
        NBTTagList mapPinColors = new NBTTagList();
        for (int i = 0; i < tile.pinColors.size(); ++i) {
            mapPinColors.func_74742_a((NBTBase)new NBTTagFloat(((Float)tile.pinColors.get(i)).floatValue()));
        }
        newMapData.func_74782_a("MapWaypointColors", (NBTBase)mapPinColors);
        return newMapData;
    }

    private InventoryBasic getInventory(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            return atlasInventory;
        }
        return null;
    }

    private ItemStack getCurrentMapStack(ItemStack stack) {
        ItemStack mapStack;
        int mapSlot;
        InventoryBasic inv = this.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        if (atlasTags != null && (mapSlot = atlasTags.func_74762_e("mapSlot")) != -1 && (mapStack = inv.func_70301_a(mapSlot)) != null && mapStack.func_77973_b() == Items.field_151098_aY) {
            return mapStack;
        }
        return null;
    }

    private void handleAtlasSwapUpdate(ByteBuf packet, EntityPlayerMP player) {
        this.handleInventoryStackUpdate(packet, player);
        player.func_71053_j();
        player.openGui((Object)BiblioCraft.instance, 100, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    private void handleAtlasUpdate(ByteBuf packet, EntityPlayerMP playermp) {
        final boolean autoCenter = packet.readBoolean();
        final boolean autoCreate = packet.readBoolean();
        final int zoomLevel = packet.readInt();
        final int slot = packet.readInt();
        final boolean changeGUI = packet.readBoolean();
        final EntityPlayerMP player = playermp;
        ItemStack atlas = playermp.func_184586_b(EnumHand.MAIN_HAND);
        if (atlas != null && atlas.func_77973_b() instanceof ItemAtlas) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ItemStack atlas = player.func_184586_b(EnumHand.MAIN_HAND);
                    NBTTagCompound tags = atlas.func_77978_p();
                    if (tags != null) {
                        tags.func_74757_a("autoCenter", autoCenter);
                        tags.func_74757_a("autoCreate", autoCreate);
                        tags.func_74768_a("zoomLevel", zoomLevel);
                        tags.func_74768_a("mapSlot", slot);
                        tags.func_74768_a("lastGUImode", 0);
                        atlas.func_77982_d(tags);
                        atlas.func_77964_b(ItemAtlas.setAtlasDamage(atlas, slot));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
                    }
                    if (changeGUI) {
                        ItemAtlas realAtlas = (ItemAtlas)atlas.func_77973_b();
                        realAtlas.getAtlasInventory(atlas, player.field_70170_p, (EntityPlayer)player, autoCreate, autoCenter, zoomLevel, slot);
                        player.func_71053_j();
                        player.field_70125_A = 50.0f;
                        ByteBuf buffer = Unpooled.buffer();
                        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)player.func_184586_b(EnumHand.MAIN_HAND));
                        BiblioCraft.ch_BiblioAtlasGUIswap.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioAtlasSWP"), player);
                    }
                }
            });
        }
    }

    private void handlePaintingUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int corner = packet.readInt();
        int scale = packet.readInt();
        int res = packet.readInt();
        int aspect = packet.readInt();
        int rotation = packet.readInt();
        int customAspectX = packet.readInt();
        int customAspectY = packet.readInt();
        boolean hideFrame = packet.readBoolean();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            painting.setHideFrame(hideFrame);
            painting.setPacketUpdate(corner, scale, res, aspect, rotation, customAspectX, customAspectY);
        }
    }

    private void handlePaintPressUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int artType = packet.readInt();
        String artName = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean applyToCanvas = packet.readBoolean();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityPaintPress) {
            TileEntityPaintPress press = (TileEntityPaintPress)tile;
            press.setSelectedPainting(artType, artName);
            if (applyToCanvas) {
                press.setCycle(true);
            }
        }
    }

    private void handleClockUpdate(ByteBuf packet, World world) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)packet);
        if (tags != null) {
            int k;
            int j;
            int[] chimes = tags.func_74759_k("chimes");
            int[] redstone = tags.func_74759_k("redstone");
            boolean tick = packet.readBoolean();
            boolean chime = packet.readBoolean();
            boolean rsout = packet.readBoolean();
            boolean rspulse = packet.readBoolean();
            int i = packet.readInt();
            TileEntity tile = world.func_175625_s(new BlockPos(i, j = packet.readInt(), k = packet.readInt()));
            if (tile != null && tile instanceof TileEntityClock) {
                TileEntityClock clock = (TileEntityClock)tile;
                clock.setSettingFromGui(chimes, redstone, tick, chime, rsout, rspulse);
            }
        }
    }

    private void handleFancySignUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        String[] text = new String[15];
        int[] textScales = new int[15];
        for (int n = 0; n < 15; ++n) {
            text[n] = ByteBufUtils.readUTF8String((ByteBuf)packet);
            textScales[n] = packet.readInt();
        }
        int numOfLines = packet.readInt();
        int s1Scale = packet.readInt();
        int s1Rot = packet.readInt();
        int s2Scale = packet.readInt();
        int s2Rot = packet.readInt();
        int s1x = packet.readInt();
        int s1y = packet.readInt();
        int s2x = packet.readInt();
        int s2y = packet.readInt();
        int x = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y = packet.readInt(), z = packet.readInt()));
        if (tile != null && tile instanceof TileEntityFancySign) {
            TileEntityFancySign sign = (TileEntityFancySign)tile;
            sign.updateFromPacket(text, textScales, numOfLines, s1Scale, s1Rot, s1x, s1y, s2Scale, s2Rot, s2x, s2y);
        }
    }

    private void handleRecipeLoad(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.loadInvToGridForRecipe(id);
        }
    }

    private void handleRecipeBook(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.setBookGrid(id);
        }
    }

    private void handleTypsetUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        int x = packet.readInt();
        TileEntity tile = world.func_175625_s(new BlockPos(x, y = packet.readInt(), z = packet.readInt()));
        if (tile != null && tile instanceof TileEntityTypeMachine) {
            TileEntityTypeMachine typeTile = (TileEntityTypeMachine)tile;
            typeTile.booklistset();
        }
    }

    private void handleBookNameUpdate(ByteBuf packet, EntityPlayerMP player) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        this.updateTypeMachine(x, y, z, bookname, player);
    }

    private void updateTypeMachine(int x, int y, int z, String book, EntityPlayerMP player) {
        World world = player.field_70170_p;
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null) {
            TileEntityTypeMachine typetile = (TileEntityTypeMachine)tile;
            typetile.setBookname(book);
        }
    }

    private void handleBookFlagUpdate(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean newFlag = packet.readBoolean();
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.updatePublicFlag(!isServer, bookname, newFlag)) {
            String fl = "private";
            if (newFlag) {
                fl = "public";
            }
        } else {
            FMLLog.warning((String)("Updating book flag for " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookDeletion(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.deleteBook(!isServer, bookname)) {
            FMLLog.info((String)(bookname + " has been deleted Forever!"), (Object[])new Object[0]);
        } else {
            FMLLog.warning((String)("Deletion of " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookEdit(ByteBuf packet, EntityPlayerMP player) {
        TileEntityDesk deskTile;
        ItemStack book = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        if (book != null && Config.testBookValidity(book) && (deskTile = (TileEntityDesk)player.field_70170_p.func_175625_s(new BlockPos(x, y, z))) != null) {
            deskTile.overwriteWrittenBook(book);
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleBookPageUpdate(ByteBuf packet, EntityPlayerMP player) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        TileEntityDesk deskTile = (TileEntityDesk)player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        if (deskTile != null) {
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleInventoryStackUpdate(ByteBuf packet, EntityPlayerMP player) {
        ItemStack currentPlayerSlot;
        ItemStack stackostuff = ByteBufUtils.readItemStack((ByteBuf)packet);
        if (stackostuff != null && (currentPlayerSlot = player.func_184586_b(EnumHand.MAIN_HAND)) != null && currentPlayerSlot.func_77977_a().equals(stackostuff.func_77977_a()) && this.checkIfValidPacketItem(currentPlayerSlot.func_77977_a())) {
            NBTTagCompound currentTags = currentPlayerSlot.func_77978_p();
            NBTTagCompound newTags = stackostuff.func_77978_p();
            if (!currentPlayerSlot.func_77977_a().contains("item.AtlasBook")) {
                if (currentTags != null && currentTags.func_74764_b("Inventory") && newTags != null) {
                    NBTTagList tagList = currentTags.func_150295_c("Inventory", 10);
                    newTags.func_74782_a("Inventory", (NBTBase)tagList);
                    stackostuff.func_77982_d(newTags);
                }
            } else if (currentTags.func_74764_b("atlasID") && newTags.func_74764_b("atlasID") && currentTags.func_74762_e("atlasID") != newTags.func_74762_e("atlasID")) {
                return;
            }
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stackostuff);
        }
    }

    private boolean checkIfValidPacketItem(String input) {
        String[] validPacketItems = new String[]{"item.AtlasBook", "item.BigBook", "item.RecipeBook", "item.BiblioClipboard", "item.BiblioRedBook", "item.SlottedBook", "item.compass"};
        for (int i = 0; i < validPacketItems.length; ++i) {
            if (!validPacketItems[i].equals(input)) continue;
            return true;
        }
        return false;
    }

    private void handleMarkerPoles(ByteBuf packet, EntityPlayerMP player) {
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        boolean newTest = packet.readBoolean();
        int direction = packet.readInt();
        EnumFacing facing = EnumFacing.func_82600_a((int)direction);
        World world = player.field_70170_p;
        int iadj = 0;
        int jadj = 0;
        int kadj = 0;
        switch (direction) {
            case 0: {
                jadj = -1;
                break;
            }
            case 1: {
                jadj = 1;
                break;
            }
            case 2: {
                kadj = -1;
                break;
            }
            case 3: {
                kadj = 1;
                break;
            }
            case 4: {
                iadj = -1;
                break;
            }
            case 5: {
                iadj = 1;
                break;
            }
            default: {
                iadj = 1;
            }
        }
        BlockPos pos = new BlockPos(i + iadj, j + jadj, k + kadj);
        if (newTest) {
            if (world.func_175623_d(pos)) {
                IBlockState st = BlockMarkerPole.instance.func_176223_P();
                world.func_175656_a(pos, st);
                TileEntityMarkerPole poleTile = (TileEntityMarkerPole)world.func_175625_s(pos);
                if (poleTile != null) {
                    poleTile.setAngle(EnumFacing.NORTH);
                    if (facing == EnumFacing.UP) {
                        poleTile.setVertPosition(EnumVertPosition.FLOOR);
                    } else if (facing == EnumFacing.DOWN) {
                        poleTile.setVertPosition(EnumVertPosition.CEILING);
                    } else {
                        switch (facing) {
                            case NORTH: {
                                facing = EnumFacing.WEST;
                                break;
                            }
                            case WEST: {
                                facing = EnumFacing.SOUTH;
                                break;
                            }
                            case SOUTH: {
                                facing = EnumFacing.EAST;
                                break;
                            }
                            case EAST: {
                                facing = EnumFacing.NORTH;
                                break;
                            }
                        }
                        poleTile.setAngle(facing);
                        poleTile.setVertPosition(EnumVertPosition.WALL);
                    }
                    world.func_175704_b(pos, pos);
                }
            }
        } else if (world.func_180495_p(pos).func_177230_c() == BlockMarkerPole.instance) {
            world.func_175655_b(pos, false);
        }
    }

    private void handleMapWaypoints(ByteBuf packet, EntityPlayerMP player) {
        World world = player.field_70170_p;
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        float xPin = packet.readFloat();
        float yPin = packet.readFloat();
        String name = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int color = packet.readInt();
        int pinNum = packet.readInt();
        boolean remove = packet.readBoolean();
        boolean edit = packet.readBoolean();
        TileEntity tile = world.func_175625_s(new BlockPos(i, j, k));
        if (tile != null && tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame mapFrame = (TileEntityMapFrame)tile;
            if (!remove) {
                if (!edit) {
                    mapFrame.addPinCoords(xPin, yPin, name, color);
                } else {
                    mapFrame.editPinData(name, color, pinNum);
                }
            } else {
                mapFrame.removePin(pinNum);
            }
        }
    }
}

