/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import java.util.ArrayList;
import jds.bibliocraft.helpers.BiblioEnums;
import jds.bibliocraft.helpers.PaintingUtil;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityPaintPress;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class TileEntityPaintPressRenderer
extends TileEntityBiblioRenderer {
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/paintpress.obj");
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private IBakedModel lid;
    private IBakedModel canvas;
    private ItemStack painting = null;
    private ItemStack prevPainting = null;
    public static final ResourceLocation PAINTINGCANVAS = new ResourceLocation("bibliocraft", "textures/paintings/canvas.png");
    public static final ResourceLocation PAINTINGSHEET = new ResourceLocation("textures/painting/paintings_kristoffer_zetterstrand.png");
    private String paintingTitle = "blank";
    private String paintingString = "bibliocraft:paintings/canvas";
    private boolean updatePainting = true;
    private IBlockState state;

    @Override
    public void render(BiblioTileEntity tile, double x, double y, double z, float tick) {
        TileEntityPaintPress press = (TileEntityPaintPress)tile;
        if (this.state == null) {
            this.state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        }
        this.paintingTitle = press.getPaintingTitle();
        this.painting = tile.func_70301_a(0);
        if (this.lid == null) {
            ArrayList<String> lidPart = new ArrayList<String>();
            lidPart.add("lid");
            this.lid = this.initModel(lidPart, this.modelLocation);
        }
        this.paintingString = "bibliocraft:paintings/canvas";
        if (this.painting != null) {
            if (press.getPaintingType() == 0) {
                for (int i = 0; i < this.biblioArtList.length; ++i) {
                    if (!this.paintingTitle.contentEquals(this.biblioArtList[i].title)) continue;
                    this.paintingString = this.biblioArtList[i].paintingTexturesStrings[0][0];
                }
            } else if (press.getPaintingType() == 2 && PaintingUtil.customArtNames != null && PaintingUtil.customArtNames.length > 0 && PaintingUtil.customArtResources != null) {
                for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
                    if (!this.paintingTitle.contentEquals(PaintingUtil.customArtNames[i])) continue;
                    this.paintingString = PaintingUtil.customArtResourceStrings[i];
                }
            }
        }
        ArrayList<String> canvasPart = new ArrayList<String>();
        canvasPart.add("painting");
        this.canvas = this.initModel(canvasPart, this.modelLocation);
        this.prevPainting = this.painting;
        this.func_147499_a(TextureMap.field_110575_b);
        this.renderPart(this.lid, 1.0, 0.42, 0.0, -press.lidAngle);
        if (this.painting != null) {
            if (press.getPaintingType() == 1) {
                this.func_147499_a(PAINTINGSHEET);
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                for (int i = 0; i < this.vanillaArtList.length; ++i) {
                    if (!this.paintingTitle.contentEquals(this.vanillaArtList[i].field_75702_A)) continue;
                    this.drawVanillaPainting(x, y, z, i);
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            } else if (press.getPaintingType() == 2) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
                    if (!this.paintingTitle.contentEquals(PaintingUtil.customArtNames[i])) continue;
                    this.func_147499_a(PaintingUtil.customArtResources[i]);
                    this.drawCustomPainting(x, y, z, i);
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            } else {
                this.renderPart(this.canvas, 1.0, 0.0, 0.0, 0.0f);
            }
        }
    }

    @Override
    public String getTextureString(ResourceLocation location) {
        String output = location.toString();
        if (output.contains("canvas")) {
            output = this.paintingString;
        }
        return output;
    }

    public void drawCustomPainting(double x, double y, double z, int e) {
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float x1 = 0.0f;
        float x2 = 1.0f;
        float y1 = 0.0f;
        float y2 = 1.0f;
        switch (this.getAngle()) {
            case SOUTH: {
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                break;
            }
            case WEST: {
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                break;
            }
            case NORTH: {
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                break;
            }
            case EAST: {
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 - 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 - 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(x + 0.5 + 0.4, y + 0.5 - 0.126, z + 0.5 + 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                break;
            }
        }
        this.tessellator.func_78381_a();
    }

    public void drawVanillaPainting(double i, double j, double k, int x) {
        float x1 = (float)this.vanillaArtList[x].field_75699_D / 256.0f;
        float x2 = (float)(this.vanillaArtList[x].field_75699_D + this.vanillaArtList[x].field_75703_B) / 256.0f;
        float y1 = (float)this.vanillaArtList[x].field_75700_E / 256.0f;
        float y2 = (float)(this.vanillaArtList[x].field_75700_E + this.vanillaArtList[x].field_75704_C) / 256.0f;
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        switch (this.getAngle()) {
            case SOUTH: {
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                break;
            }
            case WEST: {
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                break;
            }
            case NORTH: {
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                break;
            }
            case EAST: {
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x2, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 - 0.4).func_187315_a((double)x1, (double)y1).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 - 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x1, (double)y2).func_181675_d();
                this.worldRenderer.func_181662_b(i + 0.5 + 0.4, j + 0.5 - 0.126, k + 0.5 + 0.4).func_187315_a((double)x2, (double)y2).func_181675_d();
                break;
            }
        }
        this.tessellator.func_78381_a();
    }

    private void renderPart(IBakedModel model, double x, double y, double z, float rotation) {
        switch (this.getAngle()) {
            case SOUTH: {
                double tx = x;
                x = -z;
                z = tx;
                break;
            }
            case WEST: {
                x *= -1.0;
                z *= -1.0;
                break;
            }
            case NORTH: {
                double tx = x;
                x = z;
                z = -tx;
                break;
            }
            case EAST: {
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(this.globalX + (double)this.xshift + x), (double)(this.globalY + y), (double)(this.globalZ + (double)this.zshift + z));
        GlStateManager.func_179114_b((float)((float)this.degreeAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((VertexBuffer)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

