/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketMobCharmDamage;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.reference.Settings;

public class ItemMobCharm
extends ItemBase {
    private static final String TYPE_TAG = "type";
    private static final Field SET_ANGER_TARGET = ReflectionHelper.findField(EntityPigZombie.class, (String[])new String[]{"field_175459_bn", "angerTargetUUID"});

    public ItemMobCharm() {
        super("mob_charm");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(Settings.MobCharm.durability);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.canRepair = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String func_77667_c(ItemStack ist) {
        return "item.mob_charm_" + this.getType(ist);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> subItems) {
        for (byte i = 0; i < 14; i = (byte)(i + 1)) {
            ItemStack subItem = new ItemStack(item);
            this.setType(subItem, i);
            subItems.add(subItem);
        }
    }

    public byte getType(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.mobCharm || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(TYPE_TAG)) {
            return -1;
        }
        return stack.func_77978_p().func_74771_c(TYPE_TAG);
    }

    public void setType(ItemStack stack, byte type) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74774_a(TYPE_TAG, type);
        stack.func_77982_d(compound);
    }

    private byte getMobCharmTypeForEntity(Entity entity) {
        if (entity instanceof EntityGhast) {
            return 9;
        }
        if (entity instanceof EntityMagmaCube) {
            return 11;
        }
        if (entity instanceof EntitySlime) {
            return 10;
        }
        if (entity instanceof EntityPigZombie) {
            return 5;
        }
        if (entity instanceof EntityZombie) {
            return 0;
        }
        if (entity instanceof EntitySkeleton) {
            if (((EntitySkeleton)entity).func_189771_df() == SkeletonType.WITHER) {
                return 2;
            }
            return 1;
        }
        if (entity instanceof EntityCreeper) {
            return 3;
        }
        if (entity instanceof EntityWitch) {
            return 4;
        }
        if (entity instanceof EntityCaveSpider) {
            return 6;
        }
        if (entity instanceof EntitySpider) {
            return 7;
        }
        if (entity instanceof EntityEnderman) {
            return 8;
        }
        if (entity instanceof EntityBlaze) {
            return 12;
        }
        if (entity instanceof EntityGuardian && !((EntityGuardian)entity).func_175461_cl()) {
            return 13;
        }
        return -1;
    }

    @SubscribeEvent
    public void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        if (!(event.getTarget() instanceof EntityPlayer) || event.getTarget() instanceof FakePlayer) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getTarget();
        boolean resetTarget = false;
        EntityLiving entity = (EntityLiving)event.getEntity();
        if (entity instanceof EntityZombie && !(entity instanceof EntityPigZombie)) {
            resetTarget = this.isMobCharmPresent(player, (byte)0);
        } else if (entity instanceof EntitySkeleton) {
            resetTarget = ((EntitySkeleton)entity).func_189771_df() == SkeletonType.WITHER ? this.isMobCharmPresent(player, (byte)2) : this.isMobCharmPresent(player, (byte)1);
        } else if (entity instanceof EntityCreeper) {
            resetTarget = this.isMobCharmPresent(player, (byte)3);
        } else if (entity instanceof EntityWitch) {
            resetTarget = this.isMobCharmPresent(player, (byte)4);
        } else if (entity instanceof EntityCaveSpider) {
            resetTarget = this.isMobCharmPresent(player, (byte)6);
        } else if (entity instanceof EntitySpider) {
            resetTarget = this.isMobCharmPresent(player, (byte)7);
        } else if (entity instanceof EntityEnderman) {
            resetTarget = this.isMobCharmPresent(player, (byte)8);
        } else if (entity instanceof EntityBlaze) {
            resetTarget = this.isMobCharmPresent(player, (byte)12);
        } else if (entity instanceof EntityGhast) {
            resetTarget = this.isMobCharmPresent(player, (byte)9);
        } else if (entity instanceof EntityMagmaCube) {
            resetTarget = this.isMobCharmPresent(player, (byte)11);
        } else if (entity instanceof EntitySlime) {
            resetTarget = this.isMobCharmPresent(player, (byte)10);
        } else if (entity instanceof EntityGuardian && !((EntityGuardian)entity).func_175461_cl()) {
            resetTarget = this.isMobCharmPresent(player, (byte)13);
        }
        if (resetTarget) {
            entity.func_70624_b(null);
            entity.func_70604_c(null);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntity();
        if (entity.func_70638_az() == null || !(entity.func_70638_az() instanceof EntityPlayer) || entity.func_70638_az() instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity.func_70638_az();
        boolean resetTarget = false;
        if (entity instanceof EntityGhast) {
            resetTarget = this.isMobCharmPresent(player, (byte)9);
        } else if (entity instanceof EntityMagmaCube) {
            resetTarget = this.isMobCharmPresent(player, (byte)11);
        } else if (entity instanceof EntitySlime) {
            resetTarget = this.isMobCharmPresent(player, (byte)10);
        } else if (entity instanceof EntityEnderman) {
            resetTarget = this.isMobCharmPresent(player, (byte)8);
        } else if (entity instanceof EntityPigZombie) {
            resetTarget = this.isMobCharmPresent(player, (byte)5);
        }
        if (resetTarget) {
            entity.func_70624_b(null);
            entity.func_70604_c(null);
            if (entity instanceof EntityPigZombie) {
                for (EntityAITasks.EntityAITaskEntry aiTask : entity.field_70715_bh.field_75782_a) {
                    if (!(aiTask.field_75733_a instanceof EntityAIHurtByTarget)) continue;
                    aiTask.field_75733_a.func_75251_c();
                    break;
                }
                this.resetAngerTarget((EntityPigZombie)entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource() == null || event.getSource().func_76346_g() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        if (!this.damagePlayersMobCharm(player, event.getEntity())) {
            this.damageMobCharmInPedestal(player, event.getEntity());
        }
    }

    private void damageMobCharmInPedestal(EntityPlayer player, Entity entity) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_71093_bK, player.func_180425_c(), Settings.MobCharm.pedestalRange);
        byte mobCharmType = ModItems.mobCharm.getMobCharmTypeForEntity(entity);
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityPedestal)) continue;
            IBlockState blockState = world.func_180495_p(pos);
            TileEntityPedestal pedestal = (TileEntityPedestal)te;
            if (!((Boolean)blockState.func_177229_b((IProperty)BlockPedestal.ENABLED)).booleanValue()) continue;
            for (int slot = 0; slot < pedestal.func_70302_i_(); ++slot) {
                int damage;
                ItemStack slotStack = pedestal.func_70301_a(slot);
                if (slotStack == null) continue;
                if (slotStack.func_77973_b() == ModItems.mobCharm && ModItems.mobCharm.getType(slotStack) == mobCharmType) {
                    if (slotStack.func_77952_i() + Settings.MobCharm.damagePerKill > slotStack.func_77958_k()) {
                        ((TileEntityPedestal)te).func_70299_a(slot, null);
                    } else {
                        slotStack.func_77964_b(slotStack.func_77952_i() + Settings.MobCharm.damagePerKill);
                    }
                    return;
                }
                if (slotStack.func_77973_b() != ModItems.mobCharmBelt || (damage = ModItems.mobCharmBelt.damageCharmType(slotStack, mobCharmType)) <= -1) continue;
                return;
            }
        }
    }

    private boolean damagePlayersMobCharm(EntityPlayer player, Entity entity) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        byte mobCharmType = ModItems.mobCharm.getMobCharmTypeForEntity(entity);
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            ItemStack slotStack = player.field_71071_by.field_70462_a[slot];
            if (slotStack.func_77973_b() == ModItems.mobCharm && ModItems.mobCharm.getType(slotStack) == mobCharmType) {
                ItemStack playersMobCharm = player.field_71071_by.field_70462_a[slot];
                if (playersMobCharm.func_77952_i() + Settings.MobCharm.damagePerKill > playersMobCharm.func_77958_k()) {
                    player.field_71071_by.field_70462_a[slot] = null;
                    PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, ModItems.mobCharm.func_77612_l() + 1, slot), (EntityPlayerMP)player);
                } else {
                    playersMobCharm.func_77964_b(playersMobCharm.func_77952_i() + Settings.MobCharm.damagePerKill);
                    PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, playersMobCharm.func_77952_i(), slot), (EntityPlayerMP)player);
                }
                return true;
            }
            if (!this.damageMobCharmInBelt((EntityPlayerMP)player, mobCharmType, slotStack)) continue;
            return true;
        }
        if (Loader.isModLoaded((String)"Baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack == null || !this.damageMobCharmInBelt((EntityPlayerMP)player, mobCharmType, baubleStack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean damageMobCharmInBelt(EntityPlayerMP player, byte mobCharmType, ItemStack slotStack) {
        int damage;
        if (slotStack.func_77973_b() == ModItems.mobCharmBelt && (damage = ModItems.mobCharmBelt.damageCharmType(slotStack, mobCharmType)) > -1) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, damage, -mobCharmType), player);
            return true;
        }
        return false;
    }

    private void resetAngerTarget(EntityPigZombie zombiePigman) {
        try {
            SET_ANGER_TARGET.set(zombiePigman, null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean isMobCharmPresent(EntityPlayer player, byte type) {
        return this.playerHasMobCharm(player, type) || this.pedestalWithCharmInRange(player, type);
    }

    private boolean playerHasMobCharm(EntityPlayer player, byte type) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            ItemStack slotStack = player.field_71071_by.field_70462_a[slot];
            if (slotStack.func_77973_b() == ModItems.mobCharm && ModItems.mobCharm.getType(slotStack) == type) {
                return true;
            }
            if (slotStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(slotStack, type)) continue;
            return true;
        }
        if (Loader.isModLoaded((String)"Baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack == null || baubleStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(baubleStack, type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pedestalWithCharmInRange(EntityPlayer player, byte type) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_71093_bK, player.func_180425_c(), Settings.MobCharm.pedestalRange);
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityPedestal)) continue;
            IBlockState blockState = world.func_180495_p(pos);
            TileEntityPedestal pedestal = (TileEntityPedestal)te;
            if (!((Boolean)blockState.func_177229_b((IProperty)BlockPedestal.ENABLED)).booleanValue()) continue;
            for (int slot = 0; slot < pedestal.func_70302_i_(); ++slot) {
                ItemStack slotStack = pedestal.func_70301_a(slot);
                if (slotStack == null) continue;
                if (slotStack.func_77973_b() == ModItems.mobCharm && ModItems.mobCharm.getType(slotStack) == type) {
                    return true;
                }
                if (slotStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(slotStack, type)) continue;
                return true;
            }
        }
        return false;
    }
}

