/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemSojournerStaff
extends ItemToggleable {
    public ItemSojournerStaff() {
        super("sojourner_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist)) {
            this.scanForMatchingTorchesToFillInternalStorage(ist, player);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (entityLiving.func_70093_af()) {
            this.cycleTorchMode(ist);
            return true;
        }
        return false;
    }

    private void scanForMatchingTorchesToFillInternalStorage(ItemStack ist, EntityPlayer player) {
        List<String> torches = Settings.SojournerStaff.torches;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack vanillaTorch = new ItemStack(Blocks.field_150478_aa, 1, 0);
        items.add(vanillaTorch);
        torches.stream().filter(torch -> !items.contains(RegistryHelper.getItemFromName(torch))).forEach(torch -> items.add(new ItemStack(RegistryHelper.getItemFromName(torch))));
        items.stream().filter(item -> !this.isInternalStorageFullOfItem(ist, item.func_77973_b()) && InventoryHelper.consumeItem(item, player)).forEach(item -> this.addItemToInternalStorage(ist, item.func_77973_b()));
    }

    private void addItemToInternalStorage(ItemStack ist, Item item) {
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("Items") == null) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        boolean added = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            tagItemData.func_74768_a("Quantity", quantity + 1);
            added = true;
        }
        if (!added) {
            NBTTagCompound newTagData = new NBTTagCompound();
            newTagData.func_74778_a("Name", RegistryHelper.getItemRegistryName(item));
            newTagData.func_74768_a("Quantity", 1);
            tagList.func_74742_a((NBTBase)newTagData);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        NBTHelper.setTag(ist, tagCompound);
    }

    private boolean hasItemInInternalStorage(ItemStack ist, Item item, int cost) {
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_82582_d()) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            return false;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            return quantity >= cost;
        }
        return false;
    }

    private boolean isInternalStorageFullOfItem(ItemStack ist, Item item) {
        if (this.hasItemInInternalStorage(ist, item, 1)) {
            NBTTagCompound tagCompound = NBTHelper.getTag(ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
                int quantity = tagItemData.func_74762_e("Quantity");
                return quantity >= this.getTorchItemMaxCapacity();
            }
        }
        return false;
    }

    public String getTorchPlacementMode(ItemStack ist) {
        int quantity;
        String itemName;
        NBTTagCompound tagItemData;
        int i;
        if (NBTHelper.getTag(ist) == null) {
            return null;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        String torchToPlace = tagCompound.func_74779_i("Torch");
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (torchToPlace != null) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(torchToPlace) || (quantity = tagItemData.func_74762_e("Quantity")) > 0) continue;
                torchToPlace = null;
            }
        }
        if (torchToPlace == null || torchToPlace.isEmpty()) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) continue;
                tagCompound.func_74778_a("Torch", itemName);
                return itemName;
            }
        }
        return torchToPlace;
    }

    public int getTorchCount(ItemStack ist) {
        int quantity;
        String itemName;
        NBTTagCompound tagItemData;
        int i;
        if (NBTHelper.getTag(ist) == null) {
            return 0;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        String torchToPlace = tagCompound.func_74779_i("Torch");
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        if (torchToPlace != null) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(torchToPlace)) continue;
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) {
                    torchToPlace = null;
                    continue;
                }
                return quantity;
            }
        }
        if (torchToPlace == null || torchToPlace.isEmpty()) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tagItemData = tagList.func_150305_b(i);
                itemName = tagItemData.func_74779_i("Name");
                quantity = tagItemData.func_74762_e("Quantity");
                if (quantity <= 0) continue;
                tagCompound.func_74778_a("Torch", itemName);
                return quantity;
            }
        }
        return 0;
    }

    private void cycleTorchMode(ItemStack ist) {
        String mode = this.getTorchPlacementMode(ist);
        if (mode == null || mode.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        boolean itemFound = false;
        String firstItem = null;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            int quantity = tagItemData.func_74762_e("Quantity");
            if (quantity <= 0) continue;
            if (firstItem == null) {
                firstItem = itemName;
            }
            if (itemFound) {
                tagCompound.func_74778_a("Torch", itemName);
                return;
            }
            if (itemName.equals(mode)) {
                itemFound = true;
            }
            if (i != tagList.func_74745_c() - 1) continue;
            tagCompound.func_74778_a("Torch", firstItem);
        }
    }

    private int getTorchItemMaxCapacity() {
        return Settings.SojournerStaff.maxCapacityPerItemType;
    }

    public boolean removeItemFromInternalStorage(ItemStack ist, Item item, int cost, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.hasItemInInternalStorage(ist, item, cost)) {
            NBTTagCompound tagCompound = NBTHelper.getTag(ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            NBTTagList replacementTagList = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (itemName.equals(RegistryHelper.getItemRegistryName(item))) {
                    int quantity = tagItemData.func_74762_e("Quantity");
                    tagItemData.func_74768_a("Quantity", quantity - cost);
                }
                replacementTagList.func_74742_a((NBTBase)tagItemData);
            }
            tagCompound.func_74782_a("Items", (NBTBase)replacementTagList);
            NBTHelper.setTag(ist, tagCompound);
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List<String> list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        String phrase = "Nothing.";
        String placing = "Nothing.";
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = RegistryHelper.getItemFromName(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                phrase = String.format("%s%s", phrase.equals("Nothing.") ? "" : String.format("%s;", phrase), new ItemStack(containedItem, 1, 0).func_82833_r() + ": " + quantity);
            }
            Item placingItem = null;
            if (this.getTorchPlacementMode(ist) != null) {
                placingItem = RegistryHelper.getItemFromName(this.getTorchPlacementMode(ist));
            }
            if (placingItem != null) {
                placing = new ItemStack(placingItem, 1, 0).func_82833_r();
            }
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"placing", (Object)placing), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + this.func_77653_i(new ItemStack(Blocks.field_150478_aa)))), list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, list);
    }

    public EnumActionResult func_180614_a(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOff, float yOff, float zOff) {
        if (player.field_82175_bq) {
            return EnumActionResult.PASS;
        }
        player.func_184609_a(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos, side, ist)) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (this.getTorchPlacementMode(ist) == null) {
            return EnumActionResult.FAIL;
        }
        Block blockAttemptingPlacement = Block.func_149684_b((String)this.getTorchPlacementMode(ist));
        if (blockAttemptingPlacement == null) {
            return EnumActionResult.FAIL;
        }
        Block blockTargetted = world.func_180495_p(pos).func_177230_c();
        BlockPos placeBlockAt = pos;
        if (RegistryHelper.blocksEqual(blockTargetted, Blocks.field_150433_aE)) {
            side = EnumFacing.UP;
        } else if (!(RegistryHelper.blocksEqual(blockTargetted, Blocks.field_150395_bd) || RegistryHelper.blocksEqual(blockTargetted, (Block)Blocks.field_150329_H) || RegistryHelper.blocksEqual(blockTargetted, (Block)Blocks.field_150330_I) || blockTargetted != null && blockTargetted.func_176200_f((IBlockAccess)world, pos))) {
            placeBlockAt = pos.func_177972_a(side);
        }
        if (blockAttemptingPlacement.func_176196_c(world, placeBlockAt) && world.func_175716_a(blockAttemptingPlacement, placeBlockAt, false, side, (Entity)player, ist)) {
            IBlockState torchBlockState;
            if (!player.field_71075_bZ.field_75098_d) {
                int cost = 1;
                for (int distance = (int)player.func_70011_f((double)placeBlockAt.func_177958_n(), (double)placeBlockAt.func_177956_o(), (double)placeBlockAt.func_177952_p()); distance > Settings.SojournerStaff.tilePerCostMultiplier; distance -= Settings.SojournerStaff.tilePerCostMultiplier) {
                    ++cost;
                }
                if (!this.removeItemFromInternalStorage(ist, Item.func_150898_a((Block)blockAttemptingPlacement), cost, player)) {
                    return EnumActionResult.FAIL;
                }
            }
            if (this.placeBlockAt(ist, player, world, placeBlockAt, torchBlockState = this.attemptSide(world, placeBlockAt, side, blockAttemptingPlacement, player))) {
                blockAttemptingPlacement.func_176213_c(world, placeBlockAt, torchBlockState);
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)placeBlockAt.func_177958_n() + 0.5, (double)placeBlockAt.func_177956_o() + 0.5, (double)placeBlockAt.func_177952_p() + 0.5, gauss, gauss, 0.0, new int[0]);
                world.func_184133_a(null, placeBlockAt, blockAttemptingPlacement.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (blockAttemptingPlacement.func_185467_w().func_185843_a() + 1.0f) / 2.0f, blockAttemptingPlacement.func_185467_w().func_185847_b() * 0.8f);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private IBlockState attemptSide(World world, BlockPos pos, EnumFacing side, Block block, EntityPlayer player) {
        return block.func_180642_a(world, pos, side, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), 0, (EntityLivingBase)player);
    }

    public RayTraceResult getBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = Settings.SojournerStaff.maxRange;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult mop;
        if (!player.func_70093_af() && (mop = this.getBlockTarget(world, player)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            float xOff = (float)((double)mop.func_178782_a().func_177958_n() - player.field_70165_t);
            float yOff = (float)((double)mop.func_178782_a().func_177956_o() - player.field_70163_u);
            float zOff = (float)((double)mop.func_178782_a().func_177952_p() - player.field_70161_v);
            this.func_180614_a(ist, player, world, mop.func_178782_a(), hand, mop.field_178784_b, xOff, yOff, zOff);
        }
        return super.func_77659_a(ist, world, player, hand);
    }

    protected RayTraceResult func_77621_a(World world, EntityPlayer player, boolean weirdBucketBoolean) {
        float movementCoefficient = 1.0f;
        float pitchOff = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * movementCoefficient;
        float yawOff = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * movementCoefficient;
        double xOff = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)movementCoefficient;
        double yOff = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)movementCoefficient + (double)player.func_70047_e();
        double zOff = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)movementCoefficient;
        Vec3d playerVector = new Vec3d(xOff, yOff, zOff);
        float cosTraceYaw = MathHelper.func_76134_b((float)(-yawOff * ((float)Math.PI / 180) - (float)Math.PI));
        float sinTraceYaw = MathHelper.func_76126_a((float)(-yawOff * ((float)Math.PI / 180) - (float)Math.PI));
        float cosTracePitch = -MathHelper.func_76134_b((float)(-pitchOff * ((float)Math.PI / 180)));
        float sinTracePitch = MathHelper.func_76126_a((float)(-pitchOff * ((float)Math.PI / 180)));
        float pythagoraStuff = sinTraceYaw * cosTracePitch;
        float pythagoraStuff2 = cosTraceYaw * cosTracePitch;
        double distCoeff = 32.0;
        Vec3d rayTraceVector = playerVector.func_72441_c((double)pythagoraStuff * distCoeff, (double)sinTracePitch * distCoeff, (double)pythagoraStuff2 * distCoeff);
        return world.func_72901_a(playerVector, rayTraceVector, weirdBucketBoolean);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState torchBlockState) {
        if (!world.func_180501_a(pos, torchBlockState, 3)) {
            return false;
        }
        if (RegistryHelper.blocksEqual(torchBlockState.func_177230_c(), Blocks.field_150478_aa)) {
            Blocks.field_150478_aa.func_189540_a(torchBlockState, world, pos, torchBlockState.func_177230_c());
            Blocks.field_150478_aa.func_180633_a(world, pos, torchBlockState, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

