/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModCapabilities;
import xreliquary.items.util.handgun.IHandgunData;
import xreliquary.util.potions.XRPotionHelper;

public class PacketHandgunDataSync
implements IMessage,
IMessageHandler<PacketHandgunDataSync, IMessage> {
    private int playerSlotNumber;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private short bulletCount;
    private short bulletType;
    private boolean isInCooldown;
    private long cooldownTime;
    private List<PotionEffect> potionEffects;
    private static final int INVALID_SLOT = -1;

    public PacketHandgunDataSync() {
    }

    public PacketHandgunDataSync(int playerSlotNumber, short bulletCount, short bulletType, boolean isInCooldown, long cooldownTime, List<PotionEffect> potionEffects) {
        this.playerSlotNumber = playerSlotNumber;
        this.bulletCount = bulletCount;
        this.bulletType = bulletType;
        this.isInCooldown = isInCooldown;
        this.cooldownTime = cooldownTime;
        this.potionEffects = potionEffects;
    }

    public PacketHandgunDataSync(EnumHand hand, short bulletCount, short bulletType, boolean isInCooldown, long cooldownTime, List<PotionEffect> potionEffects) {
        this.hand = hand;
        this.isInCooldown = isInCooldown;
        this.cooldownTime = cooldownTime;
        this.playerSlotNumber = -1;
        this.bulletCount = bulletCount;
        this.bulletType = bulletType;
        this.potionEffects = potionEffects;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerSlotNumber = buf.readInt();
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.bulletCount = buf.readShort();
        this.bulletType = buf.readShort();
        this.isInCooldown = buf.readBoolean();
        this.cooldownTime = buf.readLong();
        if (buf.readBoolean()) {
            try {
                this.potionEffects = PotionUtils.func_185192_b((NBTTagCompound)CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
            }
            catch (IOException e) {
                throw new EncoderException((Throwable)e);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerSlotNumber);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        buf.writeShort((int)this.bulletCount);
        buf.writeShort((int)this.bulletType);
        buf.writeBoolean(this.isInCooldown);
        buf.writeLong(this.cooldownTime);
        buf.writeBoolean(this.potionEffects != null && this.potionEffects.size() > 0);
        if (this.potionEffects != null && this.potionEffects.size() > 0) {
            NBTTagCompound potionTag = new NBTTagCompound();
            XRPotionHelper.appendEffectsToNBT(potionTag, this.potionEffects);
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)potionTag, (DataOutput)new ByteBufOutputStream(buf));
            }
            catch (IOException e) {
                throw new EncoderException((Throwable)e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketHandgunDataSync message, MessageContext ctx) {
        IHandgunData data;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = message.playerSlotNumber > -1 ? player.field_71071_by.func_70301_a(message.playerSlotNumber) : player.func_184586_b(message.hand);
        if (stack != null && (data = (IHandgunData)stack.getCapability(ModCapabilities.HANDGUN_DATA_CAPABILITY, null)) != null) {
            data.setBulletCount(message.bulletCount);
            data.setBulletType(message.bulletType);
            data.setInCoolDown(message.isInCooldown);
            data.setCoolDownTime(message.cooldownTime);
            data.setPotionEffects(message.potionEffects);
        }
        return null;
    }
}

