/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xreliquary.api.IPedestal;
import xreliquary.client.render.RenderPedestalFishHook;

public class PacketPedestalFishHook
implements IMessage,
IMessageHandler<PacketPedestalFishHook, IMessage> {
    private BlockPos pedestalPos;
    private int itemIndex;
    private double hookX;
    private double hookY;
    private double hookZ;
    private float yawOffset;

    public PacketPedestalFishHook() {
    }

    public PacketPedestalFishHook(BlockPos pedestalPos, int itemIndex, double hookX, double hookY, double hookZ) {
        this.pedestalPos = pedestalPos;
        this.itemIndex = itemIndex;
        this.hookX = hookX;
        this.hookY = hookY;
        this.hookZ = hookZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.pedestalPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.itemIndex = buf.readInt();
        this.hookX = buf.readDouble();
        this.hookY = buf.readDouble();
        this.hookZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pedestalPos.func_177958_n());
        buf.writeInt(this.pedestalPos.func_177956_o());
        buf.writeInt(this.pedestalPos.func_177952_p());
        buf.writeInt(this.itemIndex);
        buf.writeDouble(this.hookX);
        buf.writeDouble(this.hookY);
        buf.writeDouble(this.hookZ);
        buf.writeFloat(this.yawOffset);
    }

    public IMessage onMessage(PacketPedestalFishHook message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        TileEntity te = world.func_175625_s(message.pedestalPos);
        if (te != null && te instanceof IPedestal) {
            IPedestal pedestal = (IPedestal)te;
            RenderPedestalFishHook.HookRenderingData data = null;
            if (message.hookY > 0.0) {
                data = new RenderPedestalFishHook.HookRenderingData(message.hookX, message.hookY, message.hookZ);
            }
            pedestal.setItemData(message.itemIndex, data);
        }
        return null;
    }
}

