/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.init.ModFluids;
import xreliquary.reference.Settings;

public class PedestalBucketWrapper
implements IPedestalActionItemWrapper {
    private static final int UNSUCCESSFUL_TRIES_TO_CLEAN_QUEUE = 5;
    private List<BlockPos> queueToDrain = new ArrayList<BlockPos>();
    private int unsuccessfulTries = 0;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int bucketRange;
        BlockPos pos = pedestal.getBlockPos();
        if (!this.milkCows(pedestal, pos, bucketRange = Settings.Pedestal.bucketWrapperRange, stack) && !this.drainLiquid(pedestal, pos, bucketRange)) {
            pedestal.setActionCoolDown(2 * Settings.Pedestal.bucketWrapperCooldown);
            return;
        }
        pedestal.setActionCoolDown(Settings.Pedestal.bucketWrapperCooldown);
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private boolean drainLiquid(IPedestal pedestal, BlockPos pos, int bucketRange) {
        World world = pedestal.getTheWorld();
        if (this.queueToDrain.isEmpty()) {
            this.updateQueueToDrain(world, pos, bucketRange);
        }
        if (this.queueToDrain.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> iterator = this.queueToDrain.iterator();
        while (iterator.hasNext()) {
            BlockPos blockToDrain = iterator.next();
            IBlockState blockState = world.func_180495_p(blockToDrain);
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
            if (fluid != null) {
                FluidStack fluidStack = this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, false);
                if (fluidStack != null) {
                    if (pedestal.fillConnectedTank(fluidStack, false) != fluidStack.amount) continue;
                    this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, true);
                    pedestal.fillConnectedTank(fluidStack);
                    iterator.remove();
                    return true;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        ++this.unsuccessfulTries;
        if (this.unsuccessfulTries >= 5) {
            this.queueToDrain.clear();
            this.unsuccessfulTries = 0;
        }
        return false;
    }

    private void updateQueueToDrain(World world, BlockPos pos, int bucketRange) {
        for (int y = pos.func_177956_o() + bucketRange; y >= pos.func_177956_o() - bucketRange; --y) {
            for (int x = pos.func_177958_n() - bucketRange; x <= pos.func_177958_n() + bucketRange; ++x) {
                for (int z = pos.func_177952_p() - bucketRange; z <= pos.func_177952_p() + bucketRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentBlockPos);
                    Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
                    if (fluid == null || !this.canDrainBlock(world, currentBlockPos, blockState.func_177230_c(), blockState, fluid)) continue;
                    this.queueToDrain.add(currentBlockPos);
                }
            }
        }
    }

    private boolean canDrainBlock(World world, BlockPos pos, Block block, IBlockState blockState, Fluid fluid) {
        return this.drainBlock(world, pos, block, blockState, fluid, false) != null;
    }

    private FluidStack drainBlock(World world, BlockPos pos, Block block, IBlockState blockState, Fluid fluid, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (!fluidBlock.canDrain(world, pos)) {
                return null;
            }
            return fluidBlock.drain(world, pos, doDrain);
        }
        if (block instanceof BlockLiquid) {
            int level = (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (level != 0) {
                return null;
            }
            if (doDrain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    private boolean milkCows(IPedestal pedestal, BlockPos pos, int bucketRange, ItemStack stack) {
        int fluidAdded;
        World world = pedestal.getTheWorld();
        List entities = world.func_72872_a(EntityCow.class, new AxisAlignedBB((double)(pos.func_177958_n() - bucketRange), (double)(pos.func_177956_o() - bucketRange), (double)(pos.func_177952_p() - bucketRange), (double)(pos.func_177958_n() + bucketRange), (double)(pos.func_177956_o() + bucketRange), (double)(pos.func_177952_p() + bucketRange)));
        if (entities.size() == 0) {
            return false;
        }
        EntityCow cow = (EntityCow)entities.get(world.field_73012_v.nextInt(entities.size()));
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        ItemStack bucketStack = new ItemStack(Items.field_151133_ar);
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, bucketStack);
        cow.func_184645_a((EntityPlayer)fakePlayer, EnumHand.MAIN_HAND, bucketStack);
        if (fakePlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151117_aB && (fluidAdded = pedestal.fillConnectedTank(new FluidStack(ModFluids.milk, 1000))) == 0) {
            if (stack.field_77994_a == 1) {
                pedestal.replaceCurrentItem(new ItemStack(Items.field_151117_aB));
                return true;
            }
            if (stack.field_77994_a > 1) {
                --stack.field_77994_a;
                EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, new ItemStack(Items.field_151117_aB));
                world.func_72838_d((Entity)entity);
            }
        }
        return true;
    }
}

