/*
 * Decompiled with CFR 0.152.
 */
package DragonRealm.Entities;

import DragonRealm.DragonRealmAchievements;
import DragonRealm.Items.ModItems;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class Dragonsmith
extends EntityVillager {
    private final Set<Item> Dragon_Pickaxes = Sets.newHashSet((Object[])new Item[]{ModItems.DragonPickaxe, ModItems.ScoutDragonPickaxe, ModItems.HunterDragonPickaxe, ModItems.AlphaDragonPickaxe});
    private final Set<Item> Dragon_Shovels = Sets.newHashSet((Object[])new Item[]{ModItems.DragonShovel, ModItems.ScoutDragonShovel, ModItems.HunterDragonShovel, ModItems.AlphaDragonShovel});
    private final Set<Item> Dragon_Axes = Sets.newHashSet((Object[])new Item[]{ModItems.DragonAxe, ModItems.ScoutDragonAxe, ModItems.HunterDragonAxe, ModItems.AlphaDragonAxe});
    private final Set<Item> Dragon_Swords = Sets.newHashSet((Object[])new Item[]{ModItems.DragonSword, ModItems.ScoutDragonSword, ModItems.HunterDragonSword, ModItems.AlphaDragonSword});
    private final Set<Item> Dragon_Helmets = Sets.newHashSet((Object[])new Item[]{ModItems.DragonHelmet, ModItems.ScoutDragonHelmet, ModItems.HunterDragonHelmet, ModItems.AlphaDragonHelmet});
    private final Set<Item> Dragon_Chestplates = Sets.newHashSet((Object[])new Item[]{ModItems.DragonChestplate, ModItems.ScoutDragonChestplate, ModItems.HunterDragonChestplate, ModItems.AlphaDragonChestplate});
    private final Set<Item> Dragon_Grieves = Sets.newHashSet((Object[])new Item[]{ModItems.DragonGrieves, ModItems.ScoutDragonGrieves, ModItems.HunterDragonGrieves, ModItems.AlphaDragonGrieves});
    private final Set<Item> Dragon_Boots = Sets.newHashSet((Object[])new Item[]{ModItems.DragonBoots, ModItems.ScoutDragonBoots, ModItems.HunterDragonBoots, ModItems.AlphaDragonBoots});
    private boolean isHappy;
    protected static final VillagerRegistry.VillagerProfession profession = new VillagerRegistry.VillagerProfession("Dragonsmith", "dragonrealm:textures/entity/villager/Dragonsmith.png", "minecraft:textures/entity/villager/zombie_villager.png");

    public Dragonsmith(World worldIn) {
        super(worldIn);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.playerHasAchievement(player)) {
                if (this.isPlayerHandEmpty(player, hand)) {
                    this.chatEmptyHand(player);
                    return true;
                }
                if (this.hasDragonIngot(player, hand)) {
                    this.repairAllItems(player);
                    return true;
                }
                if (this.Dragon_Pickaxes.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Shovels.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Axes.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Swords.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Helmets.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Chestplates.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Grieves.contains(player.func_184586_b(hand).func_77973_b()) || this.Dragon_Boots.contains(player.func_184586_b(hand).func_77973_b())) {
                    if (player.func_184586_b(hand).func_77973_b().isDamaged(stack)) {
                        if (this.isDragonsmithHappy()) {
                            this.repairSingleItem(player, stack);
                            return true;
                        }
                        this.chatNeedAnvil(player);
                        return true;
                    }
                    this.chatNoRepairNeeded(player);
                    return true;
                }
                this.chatNoDragonItem(player, stack);
                return true;
            }
            this.chatNoDragonKill(player);
            return true;
        }
        return true;
    }

    private void repairAllItems(EntityPlayer player) {
        int ingotCost = 100;
        int dragonIngotUsed = 0;
        boolean isAnvilNeededDisplayed = false;
        boolean isDamaged = false;
        List inv = player.field_71069_bz.func_75138_a();
        for (int x = 100; x > 0; --x) {
            for (ItemStack item : inv) {
                int numberIngots;
                int maxDamage;
                int itemDamage;
                if (ingotCost <= 0 || item == null) continue;
                if (this.Dragon_Helmets.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 5;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Chestplates.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 8;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Grieves.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 7;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Boots.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 4;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Pickaxes.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 3;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Shovels.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 1;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (this.Dragon_Axes.contains(item.func_77973_b()) && (itemDamage = item.func_77952_i()) > 0) {
                    isDamaged = true;
                    if (this.isDragonsmithHappy()) {
                        maxDamage = item.func_77958_k();
                        numberIngots = 3;
                        item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                        ++dragonIngotUsed;
                        ingotCost -= 3;
                    } else if (!isAnvilNeededDisplayed) {
                        isAnvilNeededDisplayed = true;
                        this.chatNeedAnvil(player);
                    }
                }
                if (!this.Dragon_Swords.contains(item.func_77973_b()) || (itemDamage = item.func_77952_i()) <= 0) continue;
                isDamaged = true;
                if (this.isDragonsmithHappy()) {
                    maxDamage = item.func_77958_k();
                    numberIngots = 2;
                    item.func_77964_b(itemDamage - (int)Math.round((double)(maxDamage / numberIngots) * 0.03));
                    ++dragonIngotUsed;
                    ingotCost -= 3;
                    continue;
                }
                if (isAnvilNeededDisplayed) continue;
                isAnvilNeededDisplayed = true;
                this.chatNeedAnvil(player);
            }
        }
        if (dragonIngotUsed > 0) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            World world = player.field_70170_p;
            double d = player.field_70165_t;
            double d2 = player.field_70163_u;
            double d3 = player.field_70161_v;
            player.func_184176_by();
            world.func_184148_a(null, d, d2, d3, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
            this.attemptDamageAnvil();
        }
        if (!isDamaged) {
            this.chatNoRepairNeeded(player);
        }
    }

    private void repairSingleItem(EntityPlayer player, ItemStack stack) {
        int itemDamage = stack.func_77952_i();
        boolean dragonIngot = false;
        Item dragonIngots = ModItems.DragonIngot;
        if (player.field_71071_by.func_70431_c(new ItemStack(ModItems.DragonIngot))) {
            dragonIngot = true;
        } else if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("I'll need Dragon Ingots to repair this item."));
        }
        if (dragonIngot) {
            int numberIngots;
            int maxDamage;
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonPickaxe || stack.func_77973_b() == ModItems.ScoutDragonPickaxe || stack.func_77973_b() == ModItems.HunterDragonPickaxe || stack.func_77973_b() == ModItems.AlphaDragonPickaxe)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 3;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d2 = player.field_70163_u;
                double d3 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d2, d3, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonShovel || stack.func_77973_b() == ModItems.ScoutDragonShovel || stack.func_77973_b() == ModItems.HunterDragonShovel || stack.func_77973_b() == ModItems.AlphaDragonShovel)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 1;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d4 = player.field_70163_u;
                double d5 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d4, d5, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonAxe || stack.func_77973_b() == ModItems.ScoutDragonAxe || stack.func_77973_b() == ModItems.HunterDragonAxe || stack.func_77973_b() == ModItems.AlphaDragonAxe)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 3;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d6 = player.field_70163_u;
                double d7 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d6, d7, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonSword || stack.func_77973_b() == ModItems.ScoutDragonSword || stack.func_77973_b() == ModItems.HunterDragonSword || stack.func_77973_b() == ModItems.AlphaDragonSword)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 2;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d8 = player.field_70163_u;
                double d9 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d8, d9, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonHelmet || stack.func_77973_b() == ModItems.ScoutDragonHelmet || stack.func_77973_b() == ModItems.HunterDragonHelmet || stack.func_77973_b() == ModItems.AlphaDragonHelmet)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 5;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d10 = player.field_70163_u;
                double d11 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d10, d11, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonChestplate || stack.func_77973_b() == ModItems.ScoutDragonChestplate || stack.func_77973_b() == ModItems.HunterDragonChestplate || stack.func_77973_b() == ModItems.AlphaDragonChestplate)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 8;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d12 = player.field_70163_u;
                double d13 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d12, d13, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonGrieves || stack.func_77973_b() == ModItems.ScoutDragonGrieves || stack.func_77973_b() == ModItems.HunterDragonGrieves || stack.func_77973_b() == ModItems.AlphaDragonGrieves)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 7;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d14 = player.field_70163_u;
                double d15 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d14, d15, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
            if (itemDamage > 0 && (stack.func_77973_b() == ModItems.DragonBoots || stack.func_77973_b() == ModItems.ScoutDragonBoots || stack.func_77973_b() == ModItems.HunterDragonBoots || stack.func_77973_b() == ModItems.AlphaDragonBoots)) {
                maxDamage = stack.func_77958_k();
                numberIngots = 4;
                stack.func_77964_b(itemDamage - Math.round(maxDamage / numberIngots));
                World world = player.field_70170_p;
                double d = player.field_70165_t;
                double d16 = player.field_70163_u;
                double d17 = player.field_70161_v;
                player.func_184176_by();
                world.func_184148_a(null, d, d16, d17, SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.5f, 1.0f);
                this.attemptDamageAnvil();
                player.field_71071_by.func_174925_a(dragonIngots, -1, 1, null);
            }
        }
    }

    private void attemptDamageAnvil() {
        AxisAlignedBB area = this.func_174813_aQ().func_186662_g(5.0);
        List blocks = this.field_70170_p.func_184144_a((Entity)this, area);
        for (AxisAlignedBB block : blocks) {
            Random random;
            int num;
            BlockPos pos = new BlockPos(block.field_72340_a, block.field_72338_b, block.field_72339_c);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150467_bQ || (num = (random = new Random()).nextInt(10) + 1) != 1) continue;
            this.field_70170_p.func_175698_g(pos);
        }
    }

    private void chatNoDragonKill(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Be gone!  My blacksmith services are only for those that have slain dragons."));
        }
    }

    private void chatNoDragonIngots(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("What do you expect me to use to repair this?!  Come back when you have Dragon Ingots."));
        }
    }

    private void chatNoDragonItem(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("I'm a Dragonsmith.  Take your " + stack.func_82833_r() + " elsewhere."));
        }
    }

    private void chatNoRepairNeeded(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Why would I waste my time fixing that which is not broken?"));
        }
    }

    private void chatEmptyHand(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Get your empty hands off me!"));
        }
    }

    private void chatNeedAnvil(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("I'm going to need an anvil for this one."));
        }
    }

    private boolean isDragonsmithHappy() {
        AxisAlignedBB area = this.func_174813_aQ().func_186662_g(5.0);
        List blocks = this.field_70170_p.func_184144_a((Entity)this, area);
        for (AxisAlignedBB block : blocks) {
            BlockPos pos = new BlockPos(block.field_72340_a, block.field_72338_b, block.field_72339_c);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150467_bQ) continue;
            return true;
        }
        return false;
    }

    private boolean playerHasAchievement(EntityPlayer player) {
        return player.func_189102_a(DragonRealmAchievements.DragonKill);
    }

    private boolean isPlayerHandEmpty(EntityPlayer player, EnumHand hand) {
        return player.func_184586_b(hand) == null;
    }

    private boolean hasDragonIngot(EntityPlayer player, EnumHand hand) {
        return player.func_184586_b(hand).func_77973_b() == ModItems.DragonIngot;
    }
}

