/*
 * Decompiled with CFR 0.152.
 */
package DragonRealm;

import DragonRealm.Configs;
import DragonRealm.DragonRealmAchievements;
import DragonRealm.Entities.AlphaDragon;
import DragonRealm.Entities.Dragonsmith;
import DragonRealm.Entities.HunterDragon;
import DragonRealm.Entities.ScoutDragon;
import DragonRealm.Items.DragonTalisman;
import DragonRealm.Items.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class Events {
    private boolean growl;
    private boolean wind;
    private boolean strike;
    private boolean breath;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        for (ClassInheritanceMultiMap l : event.getChunk().func_177429_s()) {
            for (Entity el : l) {
                if (!(el instanceof AlphaDragon) && !(el instanceof HunterDragon) && !(el instanceof ScoutDragon)) continue;
                el.func_70106_y();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        int alphaselect;
        int hunterselect;
        EntityLiving dragon;
        Block block;
        int posy;
        int posz;
        int posx;
        int scoutselect;
        if (Configs.ScoutSpawnChance != 0 && (scoutselect = (int)(1.0 + Math.random() * (double)(100000 / Configs.ScoutSpawnChance))) == 1 && !event.getWorld().field_72995_K) {
            DimensionType dimensionType = event.getWorld().field_73011_w.func_186058_p();
            event.getWorld().field_73011_w.func_186058_p();
            if (dimensionType == DimensionType.OVERWORLD) {
                posx = event.getChunk().func_76632_l().func_77273_a();
                posz = event.getChunk().func_76632_l().func_77274_b();
                posy = event.getWorld().func_72940_L() / 2;
                block = event.getWorld().func_180495_p(new BlockPos(posx, posy, posz)).func_177230_c();
                if (block != null && block == Blocks.field_150350_a) {
                    dragon = new ScoutDragon(event.getWorld());
                    dragon.func_70107_b(posx, posy, posz);
                    dragon.func_70624_b((EntityLivingBase)event.getWorld().func_72890_a((Entity)dragon, 30.0));
                    event.getWorld().func_72838_d((Entity)dragon);
                    System.out.println("Spawned Scout Dragon @ " + posx + ", " + posy + ", " + posz);
                }
            }
        }
        if (Configs.HunterSpawnChance != 0 && (hunterselect = (int)(1.0 + Math.random() * (double)(200000 / Configs.HunterSpawnChance))) == 1 && !event.getWorld().field_72995_K) {
            DimensionType dimensionType = event.getWorld().field_73011_w.func_186058_p();
            event.getWorld().field_73011_w.func_186058_p();
            if (dimensionType == DimensionType.OVERWORLD) {
                posx = event.getChunk().func_76632_l().func_77273_a();
                posz = event.getChunk().func_76632_l().func_77274_b();
                posy = event.getWorld().func_72940_L() / 2;
                block = event.getWorld().func_180495_p(new BlockPos(posx, posy, posz)).func_177230_c();
                if (block != null && block == Blocks.field_150350_a) {
                    dragon = new HunterDragon(event.getWorld());
                    dragon.func_70107_b(posx, posy, posz);
                    dragon.func_70624_b((EntityLivingBase)event.getWorld().func_72890_a((Entity)dragon, 30.0));
                    event.getWorld().func_72838_d((Entity)dragon);
                    System.out.println("Spawned Hunter Dragon @ " + posx + ", " + posy + ", " + posz);
                }
            }
        }
        if (Configs.AlphaSpawnChance != 0 && (alphaselect = (int)(1.0 + Math.random() * (double)(300000 / Configs.AlphaSpawnChance))) == 1 && !event.getWorld().field_72995_K) {
            DimensionType dimensionType = event.getWorld().field_73011_w.func_186058_p();
            event.getWorld().field_73011_w.func_186058_p();
            if (dimensionType == DimensionType.OVERWORLD) {
                posx = event.getChunk().func_76632_l().func_77273_a();
                posz = event.getChunk().func_76632_l().func_77274_b();
                posy = event.getWorld().func_72940_L() / 2;
                block = event.getWorld().func_180495_p(new BlockPos(posx, posy, posz)).func_177230_c();
                if (block != null && block == Blocks.field_150350_a) {
                    dragon = new AlphaDragon(event.getWorld());
                    dragon.func_70107_b(posx, posy, posz);
                    dragon.func_70624_b((EntityLivingBase)event.getWorld().func_72890_a((Entity)dragon, 30.0));
                    event.getWorld().func_72838_d((Entity)dragon);
                    System.out.println("Spawned Alpha Dragon @ " + posx + ", " + posy + ", " + posz);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onAchievement(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() == ModItems.DragonAxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonAxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonPickaxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonPickaxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonShovel) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonShovel, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonSword) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonSword, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.ScoutDragonAxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.ScoutDragonAxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.ScoutDragonPickaxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.ScoutDragonPickaxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.ScoutDragonShovel) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.ScoutDragonShovel, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.ScoutDragonSword) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.ScoutDragonSword, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.HunterDragonAxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.HunterDragonAxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.HunterDragonPickaxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.HunterDragonPickaxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.HunterDragonShovel) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.HunterDragonShovel, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.HunterDragonSword) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.HunterDragonSword, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.AlphaDragonAxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.AlphaDragonAxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.AlphaDragonPickaxe) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.AlphaDragonPickaxe, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.AlphaDragonShovel) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.AlphaDragonShovel, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.AlphaDragonSword) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.AlphaDragonSword, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonHelmet) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonHelmet, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonChestplate) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonChest, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonGrieves) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonGrieves, 1);
        }
        if (event.crafting.func_77973_b() == ModItems.DragonBoots) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonBoots, 1);
        }
        if (event.player.func_189102_a(DragonRealmAchievements.DragonAxe) && event.player.func_189102_a(DragonRealmAchievements.DragonPickaxe) && event.player.func_189102_a(DragonRealmAchievements.DragonShovel) && event.player.func_189102_a(DragonRealmAchievements.DragonSword)) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonToolComplete, 1);
        }
        if (event.player.func_189102_a(DragonRealmAchievements.ScoutDragonAxe) && event.player.func_189102_a(DragonRealmAchievements.ScoutDragonPickaxe) && event.player.func_189102_a(DragonRealmAchievements.ScoutDragonShovel) && event.player.func_189102_a(DragonRealmAchievements.ScoutDragonSword)) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.ScoutDragonToolComplete, 1);
        }
        if (event.player.func_189102_a(DragonRealmAchievements.HunterDragonAxe) && event.player.func_189102_a(DragonRealmAchievements.HunterDragonPickaxe) && event.player.func_189102_a(DragonRealmAchievements.HunterDragonShovel) && event.player.func_189102_a(DragonRealmAchievements.HunterDragonSword)) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.HunterDragonToolComplete, 1);
        }
        if (event.player.func_189102_a(DragonRealmAchievements.AlphaDragonAxe) && event.player.func_189102_a(DragonRealmAchievements.AlphaDragonPickaxe) && event.player.func_189102_a(DragonRealmAchievements.AlphaDragonShovel) && event.player.func_189102_a(DragonRealmAchievements.AlphaDragonSword)) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.AlphaDragonToolComplete, 1);
        }
        if (event.player.func_189102_a(DragonRealmAchievements.DragonHelmet) && event.player.func_189102_a(DragonRealmAchievements.DragonChest) && event.player.func_189102_a(DragonRealmAchievements.DragonGrieves) && event.player.func_189102_a(DragonRealmAchievements.DragonBoots)) {
            event.player.func_71064_a((StatBase)DragonRealmAchievements.DragonArmorComplete, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        ItemStack talisman = new ItemStack(ModItems.DragonTalisman);
        if (event.getEntityLiving().func_94060_bK() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving().func_94060_bK();
            if (player.field_71071_by.func_70431_c(talisman)) {
                AxisAlignedBB box = player.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0);
                List list = player.field_70170_p.func_72872_a(EntityMob.class, box);
                int selectstrike = (int)(1.0 + Math.random() * 10.0);
                int selectgrowl = (int)(1.0 + Math.random() * 10.0);
                int selectwind = (int)(1.0 + Math.random() * 10.0);
                int selectbreath = (int)(1.0 + Math.random() * 10.0);
                for (ItemStack item : player.field_71071_by.field_70462_a) {
                    if (item == null || !(item.func_77973_b() instanceof DragonTalisman)) continue;
                    this.growl = item.func_77978_p().func_74767_n("growl");
                    this.wind = item.func_77978_p().func_74767_n("wind");
                    this.strike = item.func_77978_p().func_74767_n("strike");
                    this.breath = item.func_77978_p().func_74767_n("breath");
                }
                if (selectstrike == 1 && this.strike && player.func_189102_a(DragonRealmAchievements.DragonStrike)) {
                    for (Entity entity : list) {
                        if (player.field_70170_p.field_72995_K) continue;
                        entity.func_70097_a(DamageSource.field_76377_j, 20.0f);
                    }
                }
                if (selectwind == 1 && this.wind && player.func_189102_a(DragonRealmAchievements.DragonWind)) {
                    for (Entity entity : list) {
                        if (player.field_70170_p.field_72995_K) continue;
                        EntityLivingBase base = (EntityLivingBase)entity;
                        base.func_70653_a((Entity)player, 7.0f, player.field_70165_t - entity.field_70165_t, player.field_70161_v - entity.field_70161_v);
                    }
                }
                if (selectbreath == 1 && this.breath && player.func_189102_a(DragonRealmAchievements.DragonBreath)) {
                    for (Entity entity : list) {
                        if (player.field_70170_p.field_72995_K) continue;
                        entity.func_70015_d(10);
                    }
                }
                if (selectgrowl == 1 && this.growl && player.func_189102_a(DragonRealmAchievements.DragonGrowl) && !player.field_70170_p.field_72995_K) {
                    World world = player.field_70170_p;
                    double d = player.field_70165_t;
                    double d2 = player.field_70163_u;
                    double d3 = player.field_70161_v;
                    player.func_184176_by();
                    world.func_184148_a(null, d, d2, d3, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 2.5f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.3f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void Table_Additives(LootTableLoadEvent event) {
        String name = event.getName().toString();
        try {
            if (name.matches("minecraft:chests/abandoned_mineshaft") || name.matches("minecraft:chests/desert_pyramid") || name.matches("minecraft:chests/igloo_chest") || name.matches("minecraft:chests/jungle_temple") || name.matches("minecraft:chests/simple_dungeon")) {
                event.getTable().addPool(this.getAdditive("dragonrealm:dragonrealm_loot_chest"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LootPool getAdditive(String entryName) {
        return new LootPool(new LootEntry[]{this.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "Additive_pool");
    }

    private LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "Additive_entry");
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && (event.getEntityLiving().func_94060_bK() instanceof ScoutDragon || event.getEntityLiving().func_94060_bK() instanceof HunterDragon || event.getEntityLiving().func_94060_bK() instanceof AlphaDragon)) {
            ((EntityPlayer)event.getEntity()).func_71064_a((StatBase)DragonRealmAchievements.ProteinBar, 1);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ((EntityPlayer)event.getEntity()).func_71064_a((StatBase)DragonRealmAchievements.Participation, 1);
        }
    }

    @SubscribeEvent
    public void onPickUpEvent(PlayerEvent.ItemPickupEvent event) {
        if (event.player instanceof EntityPlayer) {
            if (!event.player.func_189102_a(DragonRealmAchievements.DragonKill)) {
                if (event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonAxe || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonPickaxe || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonShovel || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonSword) {
                    event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this tool."));
                }
                if (event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonHelmet || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonChestplate || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonGrieves || event.pickedUp.func_92059_d().func_77973_b() == ModItems.DragonBoots) {
                    event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this armor."));
                }
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.ScoutKill1) || event.player.func_189102_a(DragonRealmAchievements.HunterKill1) || event.player.func_189102_a(DragonRealmAchievements.AlphaKill1) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonAxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonPickaxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonShovel && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonSword)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this tool."));
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.ScoutMaster) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonHelmet && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonChestplate && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonGrieves && event.pickedUp.func_92059_d().func_77973_b() != ModItems.ScoutDragonBoots)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this armor."));
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.HunterKill1) || event.player.func_189102_a(DragonRealmAchievements.AlphaKill1) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonAxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonPickaxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonShovel && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonSword)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this tool."));
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.HunterMaster) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonHelmet && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonChestplate && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonGrieves && event.pickedUp.func_92059_d().func_77973_b() != ModItems.HunterDragonBoots)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this armor."));
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.AlphaKill1) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonAxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonPickaxe && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonShovel && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonSword)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this tool."));
            }
            if (!(event.player.func_189102_a(DragonRealmAchievements.AlphaMaster) || event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonHelmet && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonChestplate && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonGrieves && event.pickedUp.func_92059_d().func_77973_b() != ModItems.AlphaDragonBoots)) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("You are not strong enough to bear the weight of this armor."));
            }
        }
    }

    @SubscribeEvent
    public void getVillageBlockId(PopulateChunkEvent event) {
        Random random;
        int ran;
        if (event.isHasVillageGenerated() && (ran = (random = new Random()).nextInt(40)) == 1) {
            int posx = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ()).func_76632_l().func_180334_c();
            int posz = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ()).func_76632_l().func_180333_d();
            BlockPos posy = event.getWorld().func_175672_r(new BlockPos(posx, 10, posz));
            Dragonsmith dragonsmith = new Dragonsmith(event.getWorld());
            dragonsmith.func_70107_b(posy.func_177958_n(), posy.func_177956_o(), posy.func_177952_p());
            event.getWorld().func_72838_d((Entity)dragonsmith);
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityVillager) {
            Entity villager = event.getEntity();
            Random random = new Random();
            int ran = random.nextInt(10);
            if (ran == 1 && ((EntityAgeable)villager).func_70874_b() < 0) {
                Dragonsmith dragonsmith = new Dragonsmith(event.getWorld());
                dragonsmith.func_70107_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v);
                event.getWorld().func_72900_e(villager);
                event.getWorld().func_72838_d((Entity)dragonsmith);
            }
        }
    }
}

