/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

public abstract class HudElement {
    public static final int COLOR_RED = 0xC10000;
    public static final int COLOR_PINK = 16738740;
    public static final int COLOR_BROWN = 9127187;
    public static final int COLOR_WHITE = 0xF2F2F2;
    public static final int COLOR_ORANGE = 16745472;
    public static final int COLOR_GREEN = 3916288;
    public static final int COLOR_PURPLE = 10748144;
    public static final int COLOR_BLUE = 23490;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0x292929;
    public static final int COLOR_GREY = 0x8A8A8A;
    public static final int COLOR_YELLOW = 0xEEEE00;
    public static final int[] COLOR_DEFAULT = new int[]{0x4C4C4C, 0x3D3D3D};
    protected static final ResourceLocation INTERFACE = new ResourceLocation("rpghud:textures/interface.png");
    public static final int OFFSET_PERCENT = 25;
    public static final int OFFSET_PREVIEW = 0x5A5A5A;
    protected int posX;
    protected int posY;
    protected final int defaultPosX;
    protected final int defaultPosY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean moveable;
    protected HudElementType type;
    protected Minecraft mc;
    protected ModRPGHud rpgHud;
    protected Settings settings;
    protected double scale;
    protected double scaleInverted;
    public HudElementType parent;

    public HudElement(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.defaultPosX = posX;
        this.defaultPosY = posY;
        this.elementWidth = width;
        this.elementHeight = height;
        this.moveable = moveable;
        this.mc = Minecraft.func_71410_x();
        this.rpgHud = ModRPGHud.instance;
        this.settings = this.rpgHud.settings;
        this.scale = 1.0;
        this.scaleInverted = 1.0 / this.scale;
        this.parent = type;
    }

    public void draw(Gui gui, float zLevel, float partialTicks) {
        GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)this.scale);
        this.drawElement(gui, zLevel, partialTicks);
        GlStateManager.func_179139_a((double)this.scaleInverted, (double)this.scaleInverted, (double)this.scaleInverted);
    }

    public abstract void drawElement(Gui var1, float var2, float var3);

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.elementWidth;
    }

    public int getHeight() {
        return this.elementHeight;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public HudElementType getType() {
        return this.type;
    }

    public boolean setPos(int posX, int posY) {
        boolean xValid = false;
        boolean yValid = false;
        if (posX >= 0 && posX < this.mc.field_71443_c - this.elementWidth) {
            xValid = true;
        }
        if (posY >= 0 && posY < this.mc.field_71440_d - this.elementHeight) {
            yValid = true;
        }
        if (xValid && yValid) {
            this.posX = posX;
            this.posY = posY;
        }
        return xValid && yValid;
    }

    public void setPositionToDefault() {
        this.posX = this.defaultPosX;
        this.posY = this.defaultPosY;
    }

    public boolean checkConditions() {
        return true;
    }

    public static void drawRect(int posX, int posY, int width, int height, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GameData.tryBlendFuncSeparate();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179097_i();
        GameData.beginVertex(7, DefaultVertexFormats.field_181705_e);
        GameData.addVertexPos(posX, (double)posY + (double)height, 0.0);
        GameData.addVertexPos((double)posX + (double)width, (double)posY + (double)height, 0.0);
        GameData.addVertexPos((double)posX + (double)width, posY, 0.0);
        GameData.addVertexPos(posX, posY, 0.0);
        GameData.drawVertex();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected static void drawOutline(int x, int y, int width, int height, int color) {
        HudElement.drawRect(x, y, width, 1, color);
        HudElement.drawRect(x, y, 1, height, color);
        HudElement.drawRect(x + width - 1, y, 1, height, color);
        HudElement.drawRect(x, y + height - 1, width, 1, color);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(x, y, width, height, value, COLOR_DEFAULT[0], COLOR_DEFAULT[1], colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, outlined, 0);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, int colorOutline) {
        HudElement.drawCustomBar(x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, colorOutline);
    }

    public static void drawCustomBar(int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined, int colorOutline) {
        if (value < 0.0) {
            value = 0.0;
        }
        int offset = 0;
        if (outlined) {
            offset = 1;
        }
        int filledWidth = width;
        filledWidth = width - offset * 2;
        if (filledWidth < 0) {
            filledWidth = 0;
        }
        int filledHeight = width;
        filledHeight = height - offset * 2;
        if (filledHeight < 0) {
            filledHeight = 0;
        }
        int percentFilled = (int)Math.round(value / 100.0 * (double)filledWidth);
        if (outlined) {
            HudElement.drawOutline(x, y, width, height, colorOutline);
        }
        int halfedFilledHeight = filledHeight / 2;
        HudElement.drawRect(x + offset, y + offset, percentFilled, halfedFilledHeight, colorBarLight);
        HudElement.drawRect(x + offset, y + offset + halfedFilledHeight, percentFilled, filledHeight - halfedFilledHeight, colorBarDark);
        if (filledWidth - percentFilled > 0) {
            HudElement.drawRect(x + offset + percentFilled, y + offset, filledWidth - percentFilled, halfedFilledHeight, colorGroundLight);
            HudElement.drawRect(x + offset + percentFilled, y + offset + halfedFilledHeight, filledWidth - percentFilled, filledHeight - halfedFilledHeight, colorGroundDark);
        }
    }

    public void drawTetragon(int posX1, int posX2, int posY1, int posY2, int width1, int width2, int height1, int height2, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GameData.tryBlendFuncSeparate();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179097_i();
        GameData.beginVertex(7, DefaultVertexFormats.field_181705_e);
        GameData.addVertexPos(posX1, (double)posY1 + (double)height1, 0.0);
        GameData.addVertexPos((double)posX2 + (double)width2, (double)posY2 + (double)height2, 0.0);
        GameData.addVertexPos((double)posX1 + (double)width1, posY2, 0.0);
        GameData.addVertexPos(posX2, posY1, 0.0);
        GameData.drawVertex();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int offsetColorPercent(int color, int offsetPercent) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart -= colorPart / (100 / offsetPercent)) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    public static int offsetColor(int color, int offset) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart += offset >> 16 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        if ((colorPart += offset >> 8 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        if ((colorPart += offset & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    protected void bind(ResourceLocation res) {
        this.mc.func_110434_K().func_110577_a(res);
    }

    protected static ResourceLocation getPlayerSkin(AbstractClientPlayer player) {
        return player.func_110306_p();
    }
}

