/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.extended;

import net.minecraft.client.gui.Gui;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementHealthExtended
extends HudElement {
    public HudElementHealthExtended() {
        super(HudElementType.HEALTH, 0, 0, 0, 0, true);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        String stringHealth;
        int health = GameData.getPlayerHealth();
        int absorption = GameData.getPlayerAbsorption();
        int healthMax = GameData.getPlayerMaxHealth();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("health_position")[0];
        int posY = (this.settings.getBoolValue("render_player_face") != false ? 9 : 5) + this.settings.getPositionValue("health_position")[1];
        if (absorption > 1) {
            HudElementHealthExtended.drawCustomBar(posX, posY, 110, 12, (double)(health + absorption) / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_absorption"), HudElementHealthExtended.offsetColorPercent(this.settings.getIntValue("color_absorption"), 25));
        }
        if (GameData.isPlayerPoisoned()) {
            HudElementHealthExtended.drawCustomBar(posX, posY, 110, 12, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_poison"), HudElementHealthExtended.offsetColorPercent(this.settings.getIntValue("color_poison"), 25));
        } else if (GameData.isPlayerWithering()) {
            HudElementHealthExtended.drawCustomBar(posX, posY, 110, 12, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_wither"), HudElementHealthExtended.offsetColorPercent(this.settings.getIntValue("color_wither"), 25));
        } else {
            HudElementHealthExtended.drawCustomBar(posX, posY, 110, 12, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_health"), HudElementHealthExtended.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
        }
        String string = stringHealth = this.settings.getBoolValue("health_percentage") != false ? (int)Math.floor((double)health / (double)healthMax * 100.0) + "%" : health + absorption + "/" + healthMax;
        if (this.settings.getBoolValue("show_numbers_health").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, posX + 55, posY + 2, -1);
        }
    }
}

