/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.texture;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementFoodTexture
extends HudElement {
    public HudElementFoodTexture() {
        super(HudElementType.FOOD, 0, 0, 0, 0, true);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        String staminaString;
        this.bind(INTERFACE);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int stamina = GameData.getPlayerFood();
        int staminaMax = GameData.getPlayerMaxFood();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("hunger_position")[0];
        int posY = (this.settings.getBoolValue("render_player_face") != false ? 22 : 18) + this.settings.getPositionValue("hunger_position")[1];
        ItemStack itemMain = GameData.getMainhand();
        ItemStack itemSec = GameData.getOffhand();
        if (GameData.doesPlayerNeedFood() && this.settings.getBoolValue("show_hunger_preview").booleanValue()) {
            float value = 0.0f;
            if (itemMain != GameData.nullStack() && itemMain.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemMain.func_77973_b()).func_150905_g(itemMain);
            } else if (itemSec != GameData.nullStack() && itemSec.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemSec.func_77973_b()).func_150905_g(itemSec);
            }
            if (value > 0.0f) {
                int bonusHunger = (int)(value + (float)stamina);
                if (bonusHunger > staminaMax) {
                    bonusHunger = staminaMax;
                }
                gui.func_73729_b(posX, posY, 141, 148, (int)(110.0 * ((double)bonusHunger / (double)staminaMax)), 12);
            }
        }
        if (GameData.isPlayerHungered()) {
            gui.func_73729_b(posX, posY, 141, 136, (int)(110.0 * ((double)stamina / (double)staminaMax)), 12);
        } else {
            gui.func_73729_b(posX, posY, 110, 100, (int)(110.0 * ((double)stamina / (double)staminaMax)), 12);
        }
        String string = staminaString = this.settings.getBoolValue("hunger_percentage") != false ? (int)Math.floor((double)stamina / (double)staminaMax * 100.0) + "%" : stamina + "/" + staminaMax;
        if (this.settings.getBoolValue("show_numbers_food").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), staminaString, posX + 55, posY + 2, -1);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GameData.bindIcons();
    }
}

