/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.texture;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementHealthTexture
extends HudElement {
    public HudElementHealthTexture() {
        super(HudElementType.HEALTH, 0, 0, 0, 0, false);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        String stringHealth;
        this.bind(INTERFACE);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int health = GameData.getPlayerHealth();
        int healthMax = GameData.getPlayerMaxHealth();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("health_position")[0];
        int posY = (this.settings.getBoolValue("render_player_face") != false ? 9 : 5) + this.settings.getPositionValue("health_position")[1];
        int absorption = GameData.getPlayerAbsorption();
        if (absorption > 1) {
            gui.func_73729_b(posX, posY, 0, 88, (int)(110.0 * ((double)(health + absorption) / (double)(healthMax + absorption))), 12);
        }
        if (GameData.isPlayerPoisoned()) {
            gui.func_73729_b(posX, posY, 141, 160, (int)(110.0 * ((double)health / (double)(healthMax + absorption))), 12);
        } else if (GameData.isPlayerWithering()) {
            gui.func_73729_b(posX, posY, 34, 244, (int)(110.0 * ((double)health / (double)(healthMax + absorption))), 12);
        } else {
            gui.func_73729_b(posX, posY, 0, 100, (int)(110.0 * ((double)health / (double)(healthMax + absorption))), 12);
        }
        String string = stringHealth = this.settings.getBoolValue("health_percentage") != false ? (int)Math.floor((double)health / (double)healthMax * 100.0) + "%" : health + absorption + "/" + healthMax;
        if (this.settings.getBoolValue("show_numbers_health").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, posX + 55, posY + 2, -1);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GameData.bindIcons();
    }
}

