/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.ResourceLocation;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementEntityInspectVanilla
extends HudElement {
    protected static final ResourceLocation DAMAGE_INDICATOR = new ResourceLocation("rpghud:textures/entityinspect.png");

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD() && this.settings.getBoolValue("enable_entity_inspect") != false;
    }

    public HudElementEntityInspectVanilla() {
        super(HudElementType.ENTITY_INSPECT, 0, 0, 0, 0, true);
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        EntityLiving focused = GameData.getFocusedEntity((Entity)GameData.getPlayer());
        if (focused != null) {
            ScaledResolution res = new ScaledResolution(this.mc);
            int posX = res.func_78326_a() / 2 + this.settings.getPositionValue("inspector_position")[0];
            int posY = this.settings.getPositionValue("inspector_position")[1];
            this.mc.func_110434_K().func_110577_a(DAMAGE_INDICATOR);
            gui.func_73729_b(posX - 62, 20 + posY, 0, 0, 128, 36);
            HudElementEntityInspectVanilla.drawCustomBar(posX - 25, 34 + posY, 89, 8, (double)focused.func_110143_aJ() / (double)focused.func_110138_aP() * 100.0, this.settings.getIntValue("color_health"), HudElementEntityInspectVanilla.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
            String stringHealth = (double)Math.round(focused.func_110143_aJ() * 10.0f) / 10.0 + "/" + (double)Math.round(focused.func_110138_aP() * 10.0f) / 10.0;
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, (posX - 27 + 44) * 2, (36 + posY) * 2, -1);
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
            int x = posX - 29 + 44 - GameData.getFontRenderer().func_78256_a(focused.func_70005_c_()) / 2;
            int y = 25 + posY;
            GameData.getFontRenderer().func_78276_b(focused.func_70005_c_(), x + 1, y, 0);
            GameData.getFontRenderer().func_78276_b(focused.func_70005_c_(), x - 1, y, 0);
            GameData.getFontRenderer().func_78276_b(focused.func_70005_c_(), x, y + 1, 0);
            GameData.getFontRenderer().func_78276_b(focused.func_70005_c_(), x, y - 1, 0);
            GameData.getFontRenderer().func_78276_b(focused.func_70005_c_(), x, y, -1);
            HudElementEntityInspectVanilla.drawEntityOnScreen(posX - 60 + 16, 49 + posY, (EntityLivingBase)focused);
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        int scale = 1;
        int s = (int)(22.0f / ent.field_70131_O);
        int s2 = (int)(22.0f / ent.field_70130_N);
        scale = s < s2 ? s : s2;
        int offset = 0;
        if (ent instanceof EntitySquid) {
            scale = 11;
            offset = -13;
        }
        GlStateManager.func_179109_b((float)posX, (float)(posY += offset), (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(0.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(2.5) * 20.0f;
        ent.field_70177_z = (float)Math.atan(0.625) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(0.0)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

