/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.notification;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.notification.Notification;
import net.spellcraftgaming.rpghud.notification.NotificationButton;
import net.spellcraftgaming.rpghud.settings.Settings;

public class NotificationOldSettings
extends Notification {
    private Settings settings;

    public NotificationOldSettings(Settings settings) {
        this.settings = settings;
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        this.buttons.add(new NotificationButton(0, screen.field_146294_l / 2 - 105, screen.field_146295_m / 2 + 70 - 24, "Convert Settings"));
        this.buttons.add(new NotificationButton(1, screen.field_146294_l / 2 + 5, screen.field_146295_m / 2 + 70 - 24, "Don't show again"));
    }

    @Override
    public void draw(GuiScreen screen) {
        super.draw(screen);
        FontRenderer font = GameData.getFontRenderer();
        screen.func_73732_a(font, "Old Settings", screen.field_146294_l / 2, screen.field_146295_m / 2 - 68, 16766720);
        screen.func_73731_b(font, "RPG-HUD has found the old settings files.", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 20, -1);
        screen.func_73731_b(font, "Do you want to convert them to the new", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 30, -1);
        screen.func_73731_b(font, "setting file system?", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 40, -1);
        screen.func_73731_b(font, "The files will be deleted in the process!", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 50, -1);
        screen.func_73731_b(font, "(You might want to make a backup of them)", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 60, -1);
        screen.func_73731_b(font, "Affected files:", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 75, -1);
        int offset = 0;
        if (new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings.txt").exists()) {
            screen.func_73731_b(font, "- RPGHud_settings.txt", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 85, -1);
            offset = 10;
        }
        if (new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings_Debug.txt").exists()) {
            screen.func_73731_b(font, "- RPGHud_settings_debug.txt", screen.field_146294_l / 2 - 115, screen.field_146295_m / 2 - 70 + 85 + offset, -1);
        }
    }

    @Override
    public void performAction(NotificationButton button) {
        super.performAction(button);
        if (button.id == 0) {
            this.processSettings();
            this.shouldDestroy = true;
        } else if (button.id == 1) {
            this.shouldDestroy = true;
            this.settings.setSetting("show_convert_notification", false);
        }
    }

    public void processSettings() {
        if (new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings.txt").exists()) {
            this.convertSettings();
            new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings.txt").delete();
        }
        if (new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings_debug.txt").exists()) {
            this.convertSettingsDebug();
            new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings_debug.txt").delete();
        }
        this.settings.saveSettings();
    }

    private void convertSettings() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings.txt")));
            String s = "";
            while ((s = reader.readLine()) != null) {
                try {
                    String[] string = s.split(":");
                    if (string[0].equals("button_tooltip_enabled")) {
                        this.settings.setSetting("enable_button_tooltip", string[1].equals("true"));
                    }
                    if (string[0].equals("color_health") && string[1].startsWith("#")) {
                        this.settings.setSetting("color_health", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_stamina") && string[1].startsWith("#")) {
                        this.settings.setSetting("color_food", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_air") && string[1].startsWith("#")) {
                        this.settings.setSetting("color_air", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_experience") && string[1].startsWith("#")) {
                        this.settings.setSetting("color_experience", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_jumpbar") && string[1].startsWith("#")) {
                        this.settings.setSetting("color_jump_bar", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_poison")) {
                        this.settings.setSetting("color_poison", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_hunger")) {
                        this.settings.setSetting("color_hunger", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_absorption")) {
                        this.settings.setSetting("color_absorption", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("color_wither")) {
                        this.settings.setSetting("color_wither", Integer.parseInt(string[1].replace("#", ""), 16));
                    }
                    if (string[0].equals("clock_time_format")) {
                        if (Integer.parseInt(string[1]) == 0) {
                            this.settings.setSetting("clock_time_format", "time.24");
                        } else {
                            this.settings.setSetting("clock_time_format", "time.12");
                        }
                    }
                    if (string[0].equals("hud_type")) {
                        this.settings.setSetting("hud_type", string[1]);
                    }
                    if (string[0].equals("show_armor")) {
                        this.settings.setSetting("show_armor", string[1].equals("true"));
                    }
                    if (string[0].equals("show_blockcount")) {
                        this.settings.setSetting("show_block_count", string[1].equals("true"));
                    }
                    if (string[0].equals("show_arrowcount")) {
                        this.settings.setSetting("show_arrow_count", string[1].equals("true"));
                    }
                    if (string[0].equals("show_itemdurability")) {
                        this.settings.setSetting("show_item_durability", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_clock")) {
                        this.settings.setSetting("enable_clock", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_clock_color")) {
                        this.settings.setSetting("enable_clock_color", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_immersive_clock")) {
                        this.settings.setSetting("enable_immersive_clock", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_compass")) {
                        this.settings.setSetting("enable_compass", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_compass_color")) {
                        this.settings.setSetting("enable_compass_color", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_immersive_compass")) {
                        this.settings.setSetting("enable_immersive_compass", string[1].equals("true"));
                    }
                    if (string[0].equals("render_player_face")) {
                        this.settings.setSetting("render_player_face", string[1].equals("true"));
                    }
                    if (string[0].equals("show_numbers_health")) {
                        this.settings.setSetting("show_numbers_health", string[1].equals("true"));
                    }
                    if (string[0].equals("show_numbers_stamina")) {
                        this.settings.setSetting("show_numbers_food", string[1].equals("true"));
                    }
                    if (string[0].equals("show_numbers_experience")) {
                        this.settings.setSetting("show_numbers_experience", string[1].equals("true"));
                    }
                    if (string[0].equals("show_hunger_preview")) {
                        this.settings.setSetting("show_hunger_preview", string[1].equals("true"));
                    }
                    if (string[0].equals("reduce_size")) {
                        this.settings.setSetting("reduce_size", string[1].equals("true"));
                    }
                    if (string[0].equals("limit_jumpbar")) {
                        this.settings.setSetting("limit_jump_bar", string[1].equals("true"));
                    }
                    if (string[0].equals("invert_compass")) {
                        this.settings.setSetting("invert_compass", string[1].equals("true"));
                    }
                    if (string[0].equals("enable_entity_inspect")) {
                        this.settings.setSetting("enable_entity_inspect", string[1].equals("true"));
                    }
                    if (!string[0].equals("enable_compass_coordinates")) continue;
                    this.settings.setSetting("enable_compass_coordinates", string[1].equals("true"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void convertSettingsDebug() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "RPGHud_settings_debug.txt")));
            String s = "";
            while ((s = reader.readLine()) != null) {
                try {
                    String[] string = s.split(":");
                    if (string[0].equals("forceRenderCrosshair")) {
                        this.settings.setSetting("force_render_crosshair", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaCrosshair")) {
                        this.settings.setSetting("render_vanilla_crosshair", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventCrosshair")) {
                        this.settings.setSetting("prevent_event_crosshair", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderCrosshair")) {
                        this.settings.setSetting("prevent_element_render_crosshair", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderArmor")) {
                        this.settings.setSetting("force_render_armor", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaArmor")) {
                        this.settings.setSetting("render_vanilla_armor", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventArmor")) {
                        this.settings.setSetting("prevent_event_armor", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderArmor")) {
                        this.settings.setSetting("prevent_element_render_armor", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderHotbar")) {
                        this.settings.setSetting("force_render_hotbar", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaHotbar")) {
                        this.settings.setSetting("render_vanilla_hotbar", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventHotbar")) {
                        this.settings.setSetting("prevent_event_hotbar", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderHotbar")) {
                        this.settings.setSetting("prevent_element_render_hotbar", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderAir")) {
                        this.settings.setSetting("force_render_air", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaAir")) {
                        this.settings.setSetting("render_vanilla_air", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventAir")) {
                        this.settings.setSetting("prevent_event_air", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderAir")) {
                        this.settings.setSetting("prevent_element_render_air", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderHealth")) {
                        this.settings.setSetting("force_render_health", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaHealth")) {
                        this.settings.setSetting("render_vanilla_health", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventHealth")) {
                        this.settings.setSetting("prevent_event_health", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderHealth")) {
                        this.settings.setSetting("prevent_element_render_health", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderFood")) {
                        this.settings.setSetting("force_render_food", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaFood")) {
                        this.settings.setSetting("render_vanilla_food", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventFood")) {
                        this.settings.setSetting("prevent_event_food", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderFood")) {
                        this.settings.setSetting("prevent_element_render_food", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderExp")) {
                        this.settings.setSetting("force_render_experience", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaExp")) {
                        this.settings.setSetting("render_vanilla_experience", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventExp")) {
                        this.settings.setSetting("prevent_event_experience", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderExp")) {
                        this.settings.setSetting("prevent_element_render_experience", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderExpLv")) {
                        this.settings.setSetting("force_render_level", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaExpLv")) {
                        this.settings.setSetting("render_vanilla_level", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventExpLv")) {
                        this.settings.setSetting("prevent_event_level", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderExpLv")) {
                        this.settings.setSetting("prevent_element_render_level", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderHealthMount")) {
                        this.settings.setSetting("force_render_health_mount", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaHealthMount")) {
                        this.settings.setSetting("render_vanilla_health_mount", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventHealthMount")) {
                        this.settings.setSetting("prevent_event_health_mount", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderHealthMount")) {
                        this.settings.setSetting("prevent_element_render_health_mount", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderJumpBar")) {
                        this.settings.setSetting("force_render_jump_bar", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaJumpBar")) {
                        this.settings.setSetting("render_vanilla_jump_bar", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventJumpBar")) {
                        this.settings.setSetting("prevent_event_jump_bar", string[1].equals("true"));
                    }
                    if (string[0].equals("preventElementRenderJumpBar")) {
                        this.settings.setSetting("prevent_element_render_jump_bar", string[1].equals("true"));
                    }
                    if (string[0].equals("forceRenderChat")) {
                        this.settings.setSetting("force_render_chat", string[1].equals("true"));
                    }
                    if (string[0].equals("renderVanillaChat")) {
                        this.settings.setSetting("render_vanilla_chat", string[1].equals("true"));
                    }
                    if (string[0].equals("preventEventChat")) {
                        this.settings.setSetting("prevent_event_chat", string[1].equals("true"));
                    }
                    if (!string[0].equals("preventElementRenderChat")) continue;
                    this.settings.setSetting("prevent_element_render_chat", string[1].equals("true"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

