/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBirdTameable;
import pavocado.exoticbirds.entity.EntityAIBirdFollowOwner;
import pavocado.exoticbirds.entity.EntityAIBirdSit;
import pavocado.exoticbirds.entity.EntityAILayEggInNest;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;

public class EntityParrot
extends EntityBirdTameable {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private EntityAITempt aiTempt;

    public EntityParrot(World worldIn) {
        super(worldIn, ExoticbirdsItems.parrot_egg, 4, true, false);
        this.func_70105_a(0.5f, 0.85f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.setTemptedItemString("seeds");
        this.setBreedItemString("seeds");
        this.setTameItemString("pumpkin_seeds");
    }

    protected void func_184651_r() {
        this.aiSit = new EntityAIBirdSit(this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 1.0, Items.field_151080_bb, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIBirdFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.9));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILayEggInNest(this, ExoticbirdsItems.parrot_egg));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.75f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151080_bb) {
            return false;
        }
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.isTamed()) {
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151080_bb && player.func_70068_e((Entity)this) < 9.0) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.setTamed(true);
                        this.setOwnerId(player.func_110124_au());
                        this.playTameEffect(true);
                        this.aiSit.setSitting(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.playTameEffect(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        } else if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            if (itemstack != null && itemstack.func_77973_b() == ExoticbirdsItems.falconry_glove) {
                if (!this.field_70170_p.field_72995_K) {
                    itemstack.func_77972_a(1, (EntityLivingBase)player);
                    ItemStack parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot_scarlet);
                    switch (this.getBirdType()) {
                        case 0: {
                            parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot_scarlet);
                            break;
                        }
                        case 1: {
                            parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot_blueyellow);
                            break;
                        }
                        case 2: {
                            parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot_military);
                            break;
                        }
                        case 3: {
                            parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot_hyacinth);
                        }
                    }
                    if (parrotstack.func_77978_p() == null || !parrotstack.func_77978_p().func_74764_b("parrotInfo")) {
                        parrotstack.func_77982_d(new NBTTagCompound());
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74768_a("birdType", this.getBirdType());
                        nbt.func_74776_a("birdHealth", this.func_110143_aJ());
                        nbt.func_74768_a("birdGrowingAge", this.func_70874_b());
                        if (this.func_145818_k_()) {
                            nbt.func_74778_a("birdName", this.func_95999_t());
                        } else {
                            nbt.func_74778_a("birdName", "");
                        }
                        if (this.getOwner() == null) {
                            nbt.func_74778_a("OwnerUUID", "");
                        } else {
                            nbt.func_74778_a("OwnerUUID", this.func_184753_b().toString());
                        }
                        parrotstack.func_77978_p().func_74782_a("parrotInfo", (NBTBase)nbt);
                    }
                    if (player.func_184582_a(EntityEquipmentSlot.HEAD) == null) {
                        player.func_184201_a(EntityEquipmentSlot.HEAD, parrotstack);
                        this.func_70106_y();
                    } else {
                        player.field_71071_by.func_70441_a(parrotstack);
                        this.func_70106_y();
                    }
                }
                return true;
            }
            if (itemstack == null && !this.field_70170_p.field_72995_K) {
                this.aiSit.setSitting(!this.isSitting());
                return true;
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityParrot entityparrot = new EntityParrot(this.field_70170_p);
        entityparrot.setBirdType(this.getBirdType());
        if (this.isTamed()) {
            entityparrot.setOwnerId(this.func_184753_b());
            entityparrot.setTamed(true);
        }
        return entityparrot;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityParrot)) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        EntityParrot entityparrot = (EntityParrot)otherAnimal;
        if (entityparrot.getBirdType() == this.getBirdType()) {
            return this.func_70880_s() && entityparrot.func_70880_s();
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_PARROT;
    }
}

